/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.Null;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CompareUtil {
    public static boolean compareObject(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (!(obj1 instanceof Map) || !(obj2 instanceof Map)) {
            return false;
        }
        Map value1 = null;
        Map value2 = null;
        if (((Map)obj1).size() < ((Map)obj2).size()) {
            value1 = (Map)obj2;
            value2 = (Map)obj1;
        } else {
            value1 = (Map)obj1;
            value2 = (Map)obj2;
        }
        try {
            for (Map.Entry e : value1.entrySet()) {
                boolean isEqual;
                Object key = e.getKey();
                Object value = e.getValue();
                if (!(value instanceof AbstractObjectCollection ? !(isEqual = ((AbstractObjectCollection)value).compareNewToOld()) : !(isEqual = CompareUtil.compareValue(value, value2.get(key))))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    public static boolean compareObject(CoreBaseInfo obj1, CoreBaseInfo obj2, List<String> fieldNames) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 != null && obj2 == null || obj1 == null && obj2 != null) {
            return false;
        }
        if (fieldNames == null) {
            return true;
        }
        for (String fieldName : fieldNames) {
            if (CompareUtil.compareValue(obj1.get(fieldName), obj2.get(fieldName))) continue;
            return false;
        }
        return true;
    }

    public static boolean compareValue(Object value1, Object value2) {
        if (value1 instanceof Boolean || value2 instanceof Boolean) {
            Boolean bool1 = value1 == null ? Boolean.FALSE : (Boolean)value1;
            Boolean bool2 = value2 == null ? Boolean.FALSE : (Boolean)value2;
            return bool1.booleanValue() == bool2.booleanValue();
        }
        if (CompareUtil.isEmptyObject(value1) && CompareUtil.isEmptyObject(value2)) {
            return true;
        }
        if (CompareUtil.isEmptyObject(value1) || CompareUtil.isEmptyObject(value2)) {
            return false;
        }
        if (value1 instanceof Byte) {
            return ((Byte)value1).compareTo((Byte)value2) == 0;
        }
        if (value1 instanceof Short) {
            return ((Short)value1).compareTo((Short)value2) == 0;
        }
        if (value1 instanceof Integer) {
            if (value2 instanceof String) {
                return ((Integer)value1).compareTo(Integer.valueOf((String)value2)) == 0;
            }
            return ((Integer)value1).compareTo((Integer)value2) == 0;
        }
        if (value1 instanceof Long) {
            return ((Long)value1).compareTo((Long)value2) == 0;
        }
        if (value1 instanceof Float) {
            return ((Float)value1).compareTo((Float)value2) == 0;
        }
        if (value1 instanceof Double) {
            if (value2 instanceof String) {
                value2 = Double.parseDouble(value2.toString());
            }
            return ((Double)value1).compareTo((Double)value2) == 0;
        }
        if (value1 instanceof BigDecimal) {
            return ((BigDecimal)value1).compareTo((BigDecimal)value2) == 0;
        }
        if (value1 instanceof String) {
            return ((String)value1).equals((String)value2);
        }
        if (value1 instanceof Date) {
            return CompareUtil.timeEquals((Date)value1, (Date)value2);
        }
        if (value1 instanceof Time) {
            return ((Time)value1).compareTo((Time)value2) == 0;
        }
        if (value1 instanceof Timestamp) {
            return CompareUtil.timeEquals((Date)value1, (Date)value2);
        }
        if (value1 instanceof Object[]) {
            Object[] arrValue1 = (Object[])value1;
            Object[] arrValue2 = (Object[])value2;
            if (arrValue1.length != arrValue2.length) {
                return false;
            }
            boolean retValue = true;
            for (int i = 0; i < arrValue1.length && retValue; ++i) {
                retValue = CompareUtil.compareValue(arrValue1[i], arrValue2[i]);
            }
            return retValue;
        }
        if (value1 instanceof AbstractObjectValue) {
            AbstractObjectValue objectValue1 = (AbstractObjectValue)value1;
            AbstractObjectValue objectValue2 = (AbstractObjectValue)value2;
            String pkField1 = objectValue1.getPKField();
            String pkField2 = objectValue1.getPKField();
            if (pkField1 != null && pkField2 != null) {
                if (pkField1.equals(pkField2)) {
                    return CompareUtil.compareValue(objectValue1.get(pkField1), objectValue2.get(pkField2));
                }
                return false;
            }
        }
        return value1.equals(value2);
    }

    private static boolean isEmptyObject(Object s) {
        if (s instanceof String) {
            return ((String)s).trim().length() == 0;
        }
        return s == null || s == Null.NULL;
    }

    public static boolean timeEquals(Date dt, Date dt1) {
        Calendar c = Calendar.getInstance();
        c.setTime(dt);
        int year = c.get(1);
        int date = c.get(6);
        int hour = c.get(11);
        int min = c.get(12);
        int sec = c.get(13);
        c.setTime(dt1);
        int year1 = c.get(1);
        int date1 = c.get(6);
        int hour1 = c.get(11);
        int min1 = c.get(12);
        int sec1 = c.get(13);
        return year == year1 && date == date1 && hour == hour1 && min == min1 && sec == sec1;
    }
}

