/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.DataBaseCustomInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.base.CompositionInfo;
import com.kingdee.eas.hr.base.EmpLaborRelationDomainFacadeFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFacadeFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmpPostExperienceHisFactory;
import com.kingdee.eas.hr.base.EmpPostExperienceHisInfo;
import com.kingdee.eas.hr.base.EntityFieldMappingCollection;
import com.kingdee.eas.hr.base.EntityFieldMappingInfo;
import com.kingdee.eas.hr.base.EntitySettingCollection;
import com.kingdee.eas.hr.base.EntitySettingInfo;
import com.kingdee.eas.hr.base.Expression;
import com.kingdee.eas.hr.base.ExpressionNode;
import com.kingdee.eas.hr.base.ExpressionValue;
import com.kingdee.eas.hr.base.FieldMappingException;
import com.kingdee.eas.hr.base.MappingSolutionCollection;
import com.kingdee.eas.hr.base.MappingSolutionFactory;
import com.kingdee.eas.hr.base.MappingSolutionInfo;
import com.kingdee.eas.hr.base.MetaInfo;
import com.kingdee.eas.hr.base.util.AffairBizExtendCustomerTool;
import com.kingdee.eas.hr.base.util.EntityReflectUtil;
import com.kingdee.eas.hr.base.util.MappingUtil;
import com.kingdee.eas.hr.emp.EmpPostRankInfo;
import com.kingdee.eas.hr.emp.EmpPostRankOptFacadeFactory;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.PersonCertifyCompetencyFactory;
import com.kingdee.eas.hr.emp.PersonCertifyCompetencyInfo;
import com.kingdee.eas.hr.emp.PersonDegreeFactory;
import com.kingdee.eas.hr.emp.PersonDegreeInfo;
import com.kingdee.eas.hr.emp.PersonOtherInfoCollection;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.emp.PersonPositionExtendInfo;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.PersonPositionOptFacadeFactory;
import com.kingdee.eas.hr.emp.PersonTechnicalPostFactory;
import com.kingdee.eas.hr.emp.PersonTechnicalPostInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MappingApplyUtil {
    private static String ENTITY_KEY = "entity";

    public static void mappingSubmit(Context ctx, IObjectValue model, String hrOrgID) throws Exception {
        if (model == null || ctx == null) {
            return;
        }
        String entity = EntityReflectUtil.getEntityByBosType(ctx, model.getBOSType());
        if (entity != null) {
            MappingSolutionCollection sCol = MappingApplyUtil.getMappingSolution(ctx, entity, hrOrgID);
            for (int j = 0; j < sCol.size(); ++j) {
                Set sumbmitObjs;
                MappingSolutionInfo sInfo = sCol.get(j);
                EntitySettingCollection esCol = sInfo.getEntitySetting();
                EntityFieldMappingCollection mCol = sInfo.getMapping();
                ArrayList createdObjs = new ArrayList();
                if (esCol != null) {
                    int esSize = esCol.size();
                    for (int i = 0; i < esSize; ++i) {
                        MappingApplyUtil.createObject(ctx, createdObjs, esCol.get(i), model, mCol);
                    }
                }
                if ((sumbmitObjs = MappingApplyUtil.getLastSubmitObjs(ctx, createdObjs)) == null) continue;
                Iterator ite = sumbmitObjs.iterator();
                IObjectValue obj = null;
                ICoreBase iBase = null;
                while (ite.hasNext()) {
                    IObjectPK iObjectPK;
                    PersonPositionExtendInfo ppe;
                    obj = (IObjectValue)ite.next();
                    iBase = EntityReflectUtil.getLocalInstance(ctx, obj.getString(ENTITY_KEY));
                    if (obj instanceof PersonPositionInfo) {
                        PersonPositionOptFacadeFactory.getLocalInstance((Context)ctx).updatePersonPosition((PersonPositionInfo)obj);
                        continue;
                    }
                    if (obj instanceof PersonPositionExtendInfo) {
                        ppe = (PersonPositionExtendInfo)obj;
                        if ((IObjectCollection)model.get("entrys") != null && ((IObjectCollection)model.get("entrys")).size() > 0) {
                            ppe.setEFFDT((java.util.Date)((Date)((IObjectCollection)model.get("entrys")).getObject(0).get("bizDate")));
                        }
                        ppe.setEntryType(BOSUuid.read((String)model.get("id").toString()).getType().toString());
                        AffairBizExtendCustomerTool.recordPersonPositionExtendMapping(ctx, ppe);
                        continue;
                    }
                    if (obj instanceof PersonOtherInfoInfo) {
                        ppe = (PersonOtherInfoInfo)obj;
                        AffairBizExtendCustomerTool.recordPersonOtherInfoMapping(ctx, (PersonOtherInfoInfo)ppe);
                        continue;
                    }
                    if (obj instanceof PersonInfo) {
                        PersonInfo personInfo = (PersonInfo)obj;
                        personInfo.put("IS_FROM_SHR_OPTAction", (Object)Boolean.TRUE);
                        IObjectPK pk = PersonFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)personInfo);
                        String oqlStr = "where person='" + personInfo.getId().toString() + "' order by effdt desc";
                        PersonOtherInfoCollection coll = PersonOtherInfoFactory.getLocalInstance((Context)ctx).getPersonOtherInfoCollection(oqlStr);
                        PersonOtherInfoInfo ppe2 = new PersonOtherInfoInfo();
                        if (coll.size() > 0) {
                            ppe2 = coll.get(0);
                        }
                        ppe2.setEFFDT(personInfo.getEFFDT());
                        AffairBizExtendCustomerTool.recordPersonOtherInfoMapping(ctx, ppe2);
                        continue;
                    }
                    if (obj instanceof EmpPostRankInfo) {
                        EmpPostRankOptFacadeFactory.getLocalInstance((Context)ctx).updateNewestEmpPostRank((EmpPostRankInfo)obj);
                        continue;
                    }
                    if (obj instanceof EmpLaborRelationInfo) {
                        EmpLaborRelationDomainFacadeFactory.getLocalInstance(ctx).updateLaborRelation((EmpLaborRelationInfo)obj);
                        continue;
                    }
                    if (obj instanceof EmpPostExperienceHisInfo) {
                        EmpPostExperienceHisFactory.getLocalInstance(ctx).updateNewestEmpPostExperienceHis((EmpPostExperienceHisInfo)obj);
                        continue;
                    }
                    if (obj instanceof EmpPosOrgRelationInfo) {
                        EmpPosOrgRelationFacadeFactory.getLocalInstance(ctx).updateNewestEmpPosOrgRelation((EmpPosOrgRelationInfo)obj);
                        continue;
                    }
                    if (obj instanceof PersonTechnicalPostInfo) {
                        PersonTechnicalPostInfo personTechnicalPostInfo = (PersonTechnicalPostInfo)obj;
                        if (personTechnicalPostInfo.containsKey("isHighTechnical") && personTechnicalPostInfo.containsKey("technicalpost")) {
                            iObjectPK = PersonTechnicalPostFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)personTechnicalPostInfo);
                        }
                        if (!personTechnicalPostInfo.containsKey("isHighTechnical") || !personTechnicalPostInfo.isIsHighTechnical() || personTechnicalPostInfo.containsKey("technicalpost")) continue;
                        throw new EmployeeException(EmployeeException.ISHIGHT_TECHNICAL_CAN_NOT_NULL);
                    }
                    if (obj instanceof PersonDegreeInfo) {
                        PersonDegreeInfo personDegreeInfo = (PersonDegreeInfo)obj;
                        if (personDegreeInfo.containsKey("isHighest") && personDegreeInfo.containsKey("diploma")) {
                            iObjectPK = PersonDegreeFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)personDegreeInfo);
                        }
                        if (!personDegreeInfo.containsKey("isHighest") || !personDegreeInfo.isIsHighest() || personDegreeInfo.containsKey("diploma")) continue;
                        throw new EmployeeException(EmployeeException.ISHIGHT_DIPLOMA_CAN_NOT_NULL);
                    }
                    if (obj instanceof PersonCertifyCompetencyInfo) {
                        PersonCertifyCompetencyInfo personCertifyCompetencyInfo = (PersonCertifyCompetencyInfo)obj;
                        if (personCertifyCompetencyInfo.containsKey("isHighest") && personCertifyCompetencyInfo.containsKey("certifiedCompetency")) {
                            iObjectPK = PersonCertifyCompetencyFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)personCertifyCompetencyInfo);
                        }
                        if (!personCertifyCompetencyInfo.containsKey("isHighest") || !personCertifyCompetencyInfo.isIsHighest() || personCertifyCompetencyInfo.containsKey("certifiedCompetency")) continue;
                        throw new EmployeeException(EmployeeException.ISHIGHT_CERTIFIED_CAN_NOT_NULL);
                    }
                    if (iBase == null || !(obj instanceof CoreBaseInfo)) continue;
                    iBase.save((CoreBaseInfo)obj);
                }
            }
        }
    }

    public static MappingSolutionCollection getMappingSolution(Context ctx, String entity, String hrOrgID) throws BOSException, EASBizException {
        String hrOrgFilter = null;
        hrOrgFilter = !StringUtils.isEmpty((String)hrOrgID) ? "hrOrg.id = '" + hrOrgID + "'" : "hrOrg.id is null";
        MappingSolutionCollection sCol = MappingSolutionFactory.getLocalInstance(ctx).getMappingSolutionCollection("select id,entitySetting.*,mapping.* where enable = 1 and entity = '" + entity + "' and " + hrOrgFilter);
        if (sCol == null || sCol.size() <= 0) {
            sCol = MappingSolutionFactory.getLocalInstance(ctx).getMappingSolutionCollection("select id,entitySetting.*,mapping.* where enable = 1 and entity = '" + entity + "' and isGroup = 1");
        }
        return sCol;
    }

    public static EntityFieldMappingCollection getFieldMappingCollection(Context ctx, IObjectValue model, String hrOrgID) throws BOSException, EASBizException {
        MappingSolutionCollection sCol;
        if (model == null) {
            return null;
        }
        String entity = EntityReflectUtil.getEntityByBosType(ctx, model.getBOSType());
        if (entity != null && (sCol = MappingApplyUtil.getMappingSolution(ctx, entity, hrOrgID)) != null && sCol.size() > 0) {
            MappingSolutionInfo sInfo = sCol.get(0);
            EntityFieldMappingCollection mCol = sInfo.getMapping();
            return mCol;
        }
        return null;
    }

    private static Set getLastSubmitObjs(Context ctx, List createdObjs) throws Exception {
        if (createdObjs != null) {
            IObjectValue obj = null;
            IObjectValue pObj = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            List comps = null;
            MetaInfo mInfo = null;
            HashSet<IObjectValue> result = new HashSet<IObjectValue>();
            String entity = null;
            String pEntity = null;
            HashMap<String, CompositionInfo> cache = new HashMap<String, CompositionInfo>();
            CompositionInfo cInfo = null;
            int size = createdObjs.size();
            for (int i = 0; i < size; ++i) {
                obj = (IObjectValue)createdObjs.get(i);
                entity = EntityReflectUtil.getEntityByBosType(ctx, obj.getBOSType());
                if (StringUtils.isEmpty((String)entity)) continue;
                if (cache.get(entity) == null) {
                    comps = MappingApplyUtil.getComposition(entity, loader, true);
                    if (comps != null && comps.size() > 0) {
                        mInfo = (MetaInfo)comps.get(0);
                        if (obj.get(mInfo.getName()) != null) continue;
                        IObjectValue hObj = null;
                        for (int j = 0; j < size; ++j) {
                            pObj = (IObjectValue)createdObjs.get(j);
                            pEntity = EntityReflectUtil.getEntityByBosType(ctx, pObj.getBOSType());
                            if (!mInfo.getValue().equals(pEntity)) continue;
                            hObj = pObj;
                            break;
                        }
                        if (hObj == null) {
                            hObj = MappingApplyUtil.createNewData(ctx, mInfo.getValue());
                        }
                        if (hObj == null) continue;
                        cInfo = new CompositionInfo(hObj, true);
                        cInfo.setClientPro(((RelationshipInfo)mInfo.getUserObject()).getClientProperty().getName());
                        cInfo.setSupplierPro(mInfo.getName());
                        cache.put(entity, cInfo);
                        result.add(hObj);
                        obj.put(cInfo.getSupplierPro(), (Object)cInfo.getObj());
                        ((IObjectCollection)cInfo.getPropValue()).addObject(obj);
                        continue;
                    }
                    result.add(obj);
                    continue;
                }
                cInfo = (CompositionInfo)cache.get(entity);
                obj.put(cInfo.getSupplierPro(), (Object)cInfo.getObj());
                ((IObjectCollection)cInfo.getPropValue()).addObject(obj);
            }
            return result;
        }
        return null;
    }

    public static void createObject(Context ctx, List objs, EntitySettingInfo setting, IObjectValue value, EntityFieldMappingCollection col) throws Exception {
        if (objs == null || setting == null || value == null || col == null || col.size() <= 0) {
            return;
        }
        String entity = setting.getEntity();
        String infoClass = EntityReflectUtil.getInfoByEntity(entity);
        String condition = setting.getCondition();
        boolean isNew = setting.isNewOnNotExist();
        if (!StringUtils.isEmpty((String)infoClass)) {
            if (condition != null) {
                ExpressionNode root = new ExpressionNode(condition);
                root.buildTree();
                Expression head = root.buildExpression();
                ExpressionValue vEx = null;
                String prefix = null;
                if (head != null) {
                    ArrayList<String> fields = null;
                    StringBuffer oql = new StringBuffer();
                    oql.append("where ");
                    String tOql = null;
                    for (Expression tEx = head; tEx != null; tEx = tEx.getNext()) {
                        vEx = tEx.getValue();
                        if (vEx.isEntityRef()) {
                            if (vEx.haveLevel()) {
                                if (prefix == null) {
                                    prefix = vEx.getFirstLevel();
                                }
                                if (fields == null) {
                                    fields = new ArrayList<String>();
                                }
                                fields.add(MappingUtil.removePrefix(prefix, vEx.getValue()));
                                oql.append(tEx.toOql());
                            } else {
                                tOql = tEx.toOql();
                                MappingApplyUtil.replaceWithObjInfo(ctx, tOql, value, vEx.getValue(), null);
                                oql.append(tOql);
                            }
                        } else {
                            oql.append(tEx.toOql());
                        }
                        if (tEx.getNext() == null) continue;
                        oql.append(tEx.getRelationWithNex());
                    }
                    if (prefix != null) {
                        IObjectCollection oCol = (IObjectCollection)value.get(prefix);
                        if (oCol != null) {
                            IObjectValue oValue = null;
                            String oOql = null;
                            int size = oCol.size();
                            for (int i = 0; i < size; ++i) {
                                oValue = oCol.getObject(i);
                                oOql = oql.toString();
                                if (fields != null) {
                                    int fSize = fields.size();
                                    for (int j = 0; j < fSize; ++j) {
                                        oOql = MappingApplyUtil.replaceWithObjInfo(ctx, oOql, oValue, (String)fields.get(j), prefix);
                                    }
                                }
                                MappingApplyUtil.addValueInfo(ctx, objs, entity, prefix, oOql, isNew, value, col, oValue);
                            }
                        }
                    } else {
                        MappingApplyUtil.addValueInfo(ctx, objs, entity, null, oql.toString(), isNew, value, col, null);
                    }
                }
            } else {
                MappingApplyUtil.addValueInfo(ctx, objs, entity, null, null, isNew, value, col, null);
            }
        }
    }

    private static void addValueInfo(Context ctx, List objs, String entity, String prefix, String oql, boolean isNew, IObjectValue value, EntityFieldMappingCollection mCol, IObjectValue oValue) throws Exception {
        if (ctx == null || objs == null || StringUtils.isEmpty((String)entity)) {
            return;
        }
        String infoClass = EntityReflectUtil.getInfoByEntity(entity);
        String factory = EntityReflectUtil.getFactoryByInfo(infoClass);
        CoreBaseCollection col = null;
        IObjectValue obj = null;
        if (!StringUtils.isEmpty((String)oql)) {
            col = EntityReflectUtil.getLocalInstance(ctx, entity).getCollection(oql);
        }
        if (col == null || col.size() <= 0) {
            if (isNew) {
                obj = MappingApplyUtil.createNewData(ctx, entity);
                MappingApplyUtil.disposeIObjectValue(ctx, obj, oql);
                MappingApplyUtil.setValue(ctx, objs, entity, obj, true, value, null, mCol);
            }
        } else {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                obj = col.getObject(i);
                obj.put(ENTITY_KEY, (Object)entity);
                if (oValue != null) {
                    obj.put("bizDate", oValue.get("bizDate"));
                }
                MappingApplyUtil.setValue(ctx, objs, entity, obj, false, value, null, mCol);
            }
        }
    }

    private static String replaceWithObjInfo(Context ctx, String oql, IObjectValue obj, String field, String prefix) throws FieldMappingException {
        Object value;
        if (StringUtils.isEmpty((String)oql) || obj == null || StringUtils.isEmpty((String)field)) {
            return null;
        }
        String fullName = field;
        if (!StringUtils.isEmpty((String)prefix)) {
            fullName = prefix + "." + field;
        }
        if ((value = obj.get(field)) != null) {
            oql = value instanceof IObjectValue ? StringUtils.replace((String)oql, (String)("$" + fullName + "$"), (String)("'" + ((IObjectValue)value).get("id").toString() + "'")) : (value instanceof String ? StringUtils.replace((String)oql, (String)("$" + fullName + "$"), (String)("'" + (String)value + "'")) : StringUtils.replace((String)oql, (String)("$" + fullName + "$"), (String)MappingApplyUtil.getValueStringOnly(value)));
        } else {
            EntityObjectInfo entityObject = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(obj.getBOSType());
            PropertyInfo property = entityObject.getPropertyByNameRuntime(field);
            String proAlias = field;
            if (property != null) {
                proAlias = property.getAlias();
            }
            throw new FieldMappingException(FieldMappingException.MAPPINGFIELDNULL, new String[]{proAlias});
        }
        return oql;
    }

    public static String getValueStringOnly(Object value) {
        StringBuffer sql = new StringBuffer();
        if (value instanceof Integer || value instanceof Short || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof BigDecimal) {
            sql.append(value.toString());
        } else if (value instanceof Boolean) {
            sql.append(value.toString().equalsIgnoreCase("true") ? "1" : "0");
        } else if (value instanceof Timestamp || value instanceof Date || value instanceof Time) {
            String val = null;
            if (value instanceof Timestamp) {
                val = DateTimeUtils.format((java.util.Date)((Timestamp)value), (String)"yyyy-MM-dd HH:mm:ss");
                sql.append("{ts ").append(MappingApplyUtil.appendQuotedConst(val)).append("}");
            } else if (value instanceof Date) {
                val = DateTimeUtils.format((java.util.Date)((Date)value), (String)"yyyy-MM-dd");
                sql.append("{d ").append(MappingApplyUtil.appendQuotedConst(val)).append("}");
            } else if (value instanceof Time) {
                val = DateTimeUtils.format((java.util.Date)((Time)value), (String)"HH:mm:ss");
                sql.append("{t ").append(MappingApplyUtil.appendQuotedConst(val)).append("}");
            }
        } else {
            sql.append(MappingApplyUtil.appendQuotedConst(value.toString()));
        }
        return sql.toString();
    }

    public static String appendQuotedConst(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append('\'').append(name).append('\'');
        return sb.toString();
    }

    private static void setValue(Context ctx, List objs, String toEntity, IObjectValue toSet, boolean isNew, IObjectValue set, String prefix, EntityFieldMappingCollection col) throws Exception {
        boolean isSet = false;
        if (toEntity == null || toSet == null || set == null || col == null) {
            return;
        }
        EntityFieldMappingInfo mInfo = null;
        String srcField = null;
        String tarField = null;
        String pre = null;
        Object v = null;
        HashSet<String> pres = new HashSet<String>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            mInfo = col.get(i);
            srcField = mInfo.getSourceFieldPath();
            pre = MappingApplyUtil.prefix(srcField = MappingUtil.removePrefix(prefix, srcField));
            if (StringUtils.isEmpty((String)pre)) {
                tarField = mInfo.getTargetFieldPath();
                if (!toEntity.equals(mInfo.getTargetEntity()) || (v = MappingApplyUtil.getValue(set.get(srcField))) == null) continue;
                toSet.put(tarField, v);
                toSet.put(tarField + "_" + ctx.getLocale(), v);
                isSet = true;
                continue;
            }
            pres.add(pre);
        }
        if (!pres.isEmpty()) {
            Iterator ite = pres.iterator();
            block1: while (ite.hasNext()) {
                pre = ite.next().toString();
                if (set.get(pre) == null) continue;
                String p = pre;
                if (!StringUtils.isEmpty((String)prefix)) {
                    p = prefix + "." + p;
                }
                if (set.get(pre) instanceof IObjectCollection) {
                    String infoClass = EntityReflectUtil.getInfoByEntity(toEntity);
                    IObjectCollection oCol = (IObjectCollection)set.get(pre);
                    IObjectValue obj = null;
                    int osize = oCol.size();
                    for (int j = 0; j < osize; ++j) {
                        if (!isNew) {
                            MappingApplyUtil.setValue(ctx, objs, toEntity, toSet, false, oCol.getObject(j), p, col);
                            continue block1;
                        }
                        obj = j == 0 ? toSet : MappingApplyUtil.createNewData(ctx, infoClass);
                        MappingApplyUtil.setValue(ctx, objs, toEntity, obj, true, oCol.getObject(j), p, col);
                    }
                    continue;
                }
                if (!(set.get(pre) instanceof IObjectValue)) continue;
                MappingApplyUtil.setValue(ctx, objs, toEntity, toSet, false, (IObjectValue)set.get(pre), p, col);
            }
        }
        if (isSet) {
            objs.add(toSet);
        }
    }

    private static void syncHistoryEffectDate(IObjectValue toSet, IObjectValue set) {
        if (set instanceof HRAffairBizBillEntryInfo) {
            HRAffairBizBillEntryInfo entryInfo = (HRAffairBizBillEntryInfo)set;
            toSet.put(HistoryConstant.EFFDT, (Object)DateTimeUtils.truncateDate((java.util.Date)entryInfo.getBizDate()));
        }
    }

    private static Object getValue(Object v) {
        Object value = null;
        if (v == null) {
            return value;
        }
        if (v instanceof Enum) {
            if (v instanceof IntEnum) {
                value = new Integer(((IntEnum)v).getValue());
            } else if (v instanceof StringEnum) {
                value = ((StringEnum)v).getValue();
            }
        } else {
            value = v;
        }
        return value;
    }

    private static String prefix(String field) {
        String[] s;
        if (!StringUtils.isEmpty((String)field) && (s = StringUtils.split((String)field, (String)".")).length > 1) {
            return s[0];
        }
        return null;
    }

    public static List getComposition(String entity, IMetaDataLoader loader, boolean isClient) {
        EntityObjectInfo bill;
        if (!StringUtils.isEmpty((String)entity) && loader != null && (bill = loader.getEntity((IMetaDataPK)new MetaDataPK(entity))) != null) {
            ArrayList<MetaInfo> list = null;
            PropertyCollection pCol = bill.getInheritedNoDuplicatedProperties();
            if (pCol != null && pCol.size() > 0) {
                PropertyInfo property = null;
                EntityObjectInfo entry = null;
                RelationshipInfo relation = null;
                MetaInfo mInfo = null;
                int size = pCol.size();
                for (int i = 0; i < size; ++i) {
                    property = pCol.get(i);
                    if (!(property instanceof LinkPropertyInfo) || !RelationshipType.COMPOSITION.equals((Object)(relation = ((LinkPropertyInfo)property).getRelationship()).getType())) continue;
                    entry = isClient ? relation.getClientObject() : relation.getSupplierObject();
                    if (list == null) {
                        list = new ArrayList<MetaInfo>();
                    }
                    mInfo = new MetaInfo();
                    mInfo.setName(property.getName());
                    mInfo.setValue(entry.getName());
                    mInfo.setUserObject(relation);
                    list.add(mInfo);
                }
            }
            return list;
        }
        return null;
    }

    public static IObjectValue createNewData(Context ctx, String entity) throws Exception {
        try {
            String infoClass = EntityReflectUtil.getInfoByEntity(entity);
            IObjectValue ov = (IObjectValue)Class.forName(infoClass).newInstance();
            ov.put(ENTITY_KEY, (Object)entity);
            return ov;
        }
        catch (Exception e) {
            IObjectValue info = null;
            ICoreBase bosObj = EntityReflectUtil.getLocalInstance(ctx, entity);
            Class clazz = EntityReflectUtil.getObjectValueClass(ctx, entity);
            if (clazz.getName().equals("com.kingdee.eas.hr.emp.EmpMultiInfoCustomInfo") || clazz.getName().equals("com.kingdee.eas.hr.emp.EmpSingleInfoCustomInfo")) {
                info = EntityReflectUtil.newInstance(clazz, entity);
                info.put(ENTITY_KEY, (Object)entity);
            } else {
                info = new DataBaseCustomInfo();
                ((DataBaseCustomInfo)info).setBOSType(bosObj.getType());
                info.put(ENTITY_KEY, (Object)entity);
            }
            return info;
        }
    }

    public static void setValueByMapping(Context ctx, IObjectValue tarObj, IObjectValue model, String hrOrgID) throws BOSException, EASBizException {
        MappingSolutionCollection sCol;
        if (tarObj == null || model == null) {
            return;
        }
        String entity = EntityReflectUtil.getEntityByInfo(model.getClass().getName());
        if (entity != null && (sCol = MappingApplyUtil.getMappingSolution(ctx, entity, hrOrgID)) != null && sCol.size() > 0) {
            MappingSolutionInfo sInfo = sCol.get(0);
            EntityFieldMappingCollection mCol = sInfo.getMapping();
            MappingApplyUtil.setValueByMapping(ctx, tarObj, model, null, mCol);
        }
    }

    public static void setValueByMapping(Context ctx, IObjectValue tarObj, IObjectValue model, String prefix, EntityFieldMappingCollection mCol) throws BOSException, EASBizException {
        String toEntity = EntityReflectUtil.getEntityByBosType(ctx, tarObj.getBOSType());
        if (toEntity == null || model == null || mCol == null || mCol.size() <= 0) {
            return;
        }
        EntityFieldMappingInfo mInfo = null;
        String srcField = null;
        String tarField = null;
        String pre = null;
        Object v = null;
        HashSet<String> pres = new HashSet<String>();
        int size = mCol.size();
        for (int i = 0; i < size; ++i) {
            mInfo = mCol.get(i);
            srcField = mInfo.getSourceFieldPath();
            pre = MappingApplyUtil.prefix(srcField = MappingUtil.removePrefix(prefix, srcField));
            if (StringUtils.isEmpty((String)pre)) {
                tarField = mInfo.getTargetFieldPath();
                if (!toEntity.equals(mInfo.getTargetEntity())) continue;
                v = MappingApplyUtil.getValue(model.get(srcField));
                tarObj.put(tarField, v);
                tarObj.put(tarField + "_" + ctx.getLocale(), v);
                continue;
            }
            pres.add(pre);
        }
        if (!pres.isEmpty()) {
            Iterator ite = pres.iterator();
            while (ite.hasNext()) {
                pre = ite.next().toString();
                if (model.get(pre) == null) continue;
                IObjectValue obj = null;
                if (model.get(pre) instanceof IObjectCollection) {
                    IObjectCollection oCol = (IObjectCollection)model.get(pre);
                    if (oCol.size() > 0) {
                        obj = oCol.getObject(0);
                    }
                } else if (model.get(pre) instanceof IObjectValue) {
                    obj = (IObjectValue)model.get(pre);
                }
                String p = pre;
                if (!StringUtils.isEmpty((String)prefix)) {
                    p = prefix + "." + p;
                }
                MappingApplyUtil.setValueByMapping(ctx, tarObj, obj, p, mCol);
            }
        }
    }

    private static void disposeIObjectValue(Context ctx, IObjectValue obj, String oql) {
        String tmpStr = null;
        try {
            if (StringUtils.isEmpty((String)oql)) {
                return;
            }
            if (oql.indexOf("person.id") == -1) {
                return;
            }
            tmpStr = oql.substring(oql.indexOf("person.id"));
            if (oql.indexOf("'") == -1) {
                return;
            }
            tmpStr = tmpStr.substring(tmpStr.indexOf("'") + 1);
            if (oql.indexOf("'") == -1) {
                return;
            }
            if (StringUtils.isEmpty((String)(tmpStr = tmpStr.substring(0, tmpStr.indexOf("'"))))) {
                return;
            }
            BOSObjectType bidType = BOSUuid.getBOSObjectType((String)tmpStr, (boolean)true);
            if (bidType != null && bidType.toString().equals("80EF7DED")) {
                obj.put("person", (Object)PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(tmpStr)));
            }
        }
        catch (Exception e) {
            return;
        }
    }
}

