/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XMLWriter {
    public static final String XML_ENCODING = "UTF-8";
    protected Document doc = null;

    public XMLWriter(Document doc) {
        this.doc = doc;
    }

    public void save(OutputStream os) throws BOSException {
        if (this.doc == null || os == null) {
            return;
        }
        try {
            this.getXMLOutputter().output(this.doc, os);
            os.close();
        }
        catch (IOException err) {
            throw new BOSException("Write stream error: " + err.getMessage());
        }
    }

    protected XMLOutputter getXMLOutputter() {
        XMLOutputter outter = new XMLOutputter();
        outter.setFormat(Format.getPrettyFormat());
        return outter;
    }

    public void save(Writer writer) throws BOSException {
        if (this.doc == null || writer == null) {
            return;
        }
        try {
            this.getXMLOutputter().output(this.doc, writer);
            writer.close();
        }
        catch (IOException err) {
            throw new BOSException("Write file error: " + err.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String fileName) throws BOSException {
        File file = new File(fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException err) {
                throw new BOSException("Create file error: " + err.getMessage());
            }
        }
        Writer writer = null;
        try {
            writer = this.getWriter(file);
            this.save(writer);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Writer getWriter(File file) throws BOSException {
        OutputStreamWriter writer = null;
        if (file == null) {
            return writer;
        }
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), XML_ENCODING);
        }
        catch (IOException err) {
            throw new BOSException("Write file [" + file.getName() + "] error, can not create FileWriter");
        }
        return writer;
    }
}

