/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util.personphoto;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.hr.emp.EmployeeAuditCollection;
import com.kingdee.eas.hr.emp.EmployeeAuditFactory;
import com.kingdee.eas.hr.emp.EmployeeAuditInfo;
import com.kingdee.eas.hr.emp.PersonPhotoInfo;
import com.kingdee.eas.util.BASE64Encoder;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class PersonPhotoAuditUtil {
    public static String personCategoryId = "9cQPCLb0Ta2JWqCP0tNySlPQjkk=";
    public static String PHOTOAUDITFLAG = "photo_extendInfoMap";

    public static Map<String, String> getPhoto(Context ctx, String auditId) throws BOSException, SQLException {
        HashMap<String, String> photoData = new HashMap<String, String>();
        BOSUuid parentID = null;
        try {
            parentID = BOSUuid.read((String)auditId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        String photo = null;
        String photoSql = "select FPreImageData,FImageData from T_HR_AuditPersonPhoto where FParentID ='" + parentID + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)photoSql);
        while (rowSet.next()) {
            BASE64Encoder encoder;
            byte[] convertToBytes;
            if (rowSet.getBlob(1) != null) {
                convertToBytes = PersonPhotoAuditUtil.convertToBytes(rowSet.getBlob(1).getBinaryStream());
                encoder = new BASE64Encoder();
                photo = encoder.encode(PersonPhotoAuditUtil.reducePhoto(convertToBytes));
                photoData.put("preImageData", photo);
            }
            if (rowSet.getBlob(2) == null) continue;
            convertToBytes = PersonPhotoAuditUtil.convertToBytes(rowSet.getBlob(2).getBinaryStream());
            encoder = new BASE64Encoder();
            photo = encoder.encode(PersonPhotoAuditUtil.reducePhoto(convertToBytes));
            photoData.put("imageData", photo);
        }
        return photoData;
    }

    public static byte[] getPersonPhoto(Context ctx, String personId) throws BOSException {
        byte[] convertToBytes = null;
        try {
            String photoSql = "select FPersonID, FImageData from t_hr_personphoto where FPersonID ='" + personId + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)photoSql);
            while (rowSet.next()) {
                if (rowSet.getBlob(2) == null) continue;
                convertToBytes = PersonPhotoAuditUtil.convertToBytes(rowSet.getBlob(2).getBinaryStream());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return convertToBytes;
    }

    public static void assembleAuditPhoto(Context ctx, EmployeeAuditInfo employeeAuditInfo, PersonPhotoInfo personPhotoInfo) {
        JSONObject extendInfoMap = new JSONObject();
        extendInfoMap.put("status", (Object)employeeAuditInfo.getStatus());
        if (StringUtils.isEmpty((String)employeeAuditInfo.getReason())) {
            extendInfoMap.put("reason", (Object)"");
        } else {
            extendInfoMap.put("reason", (Object)employeeAuditInfo.getReason());
        }
        extendInfoMap.put("operateType", (Object)employeeAuditInfo.getOperateType());
        if (employeeAuditInfo.getAuditor() != null) {
            extendInfoMap.put("auditor", (Object)employeeAuditInfo.getAuditor().getName());
        } else {
            extendInfoMap.put("auditor", (Object)"");
        }
        extendInfoMap.put("id", (Object)employeeAuditInfo.getId().toString());
        personPhotoInfo.put(PHOTOAUDITFLAG, (Object)extendInfoMap);
    }

    public static Map<String, Object> assembleAuditPhotoStatus(Context ctx, String personId) throws BOSException {
        EmployeeAuditCollection coll = PersonPhotoAuditUtil.getEmployeeAuditPersonPhoto(ctx, personId);
        HashMap<String, Object> extendInfoMap = new HashMap<String, Object>();
        if (!coll.isEmpty()) {
            EmployeeAuditInfo employeeAuditInfo = coll.get(0);
            extendInfoMap.put("status", employeeAuditInfo.getStatus());
            if (StringUtils.isEmpty((String)employeeAuditInfo.getReason())) {
                extendInfoMap.put("reason", "");
            } else {
                extendInfoMap.put("reason", employeeAuditInfo.getReason());
            }
            extendInfoMap.put("operateType", employeeAuditInfo.getOperateType());
            if (employeeAuditInfo.getAuditor() != null) {
                extendInfoMap.put("auditor", employeeAuditInfo.getAuditor().getName());
            } else {
                extendInfoMap.put("auditor", "");
            }
            extendInfoMap.put("id", employeeAuditInfo.getId().toString());
        }
        return extendInfoMap;
    }

    public static EmployeeAuditCollection getEmployeeAuditPersonPhoto(Context ctx, String personId) throws BOSException {
        EntityViewInfo audit = new EntityViewInfo();
        FilterInfo auditFilter = PersonPhotoAuditUtil.assembleAuditFilter(ctx, personId);
        SelectorItemCollection selectorItemCollection = PersonPhotoAuditUtil.getSelectors(ctx);
        audit.setFilter(auditFilter);
        audit.setSelector(selectorItemCollection);
        EmployeeAuditCollection coll = EmployeeAuditFactory.getLocalInstance((Context)ctx).getEmployeeAuditCollection(audit);
        return coll;
    }

    public static FilterInfo assembleAuditFilter(Context ctx, String personId) {
        FilterInfo auditFilter = new FilterInfo();
        FilterItemCollection filterItemColl = auditFilter.getFilterItems();
        filterItemColl.add(new FilterItemInfo("person", (Object)personId));
        filterItemColl.add(new FilterItemInfo("status", (Object)4));
        filterItemColl.add(new FilterItemInfo("status", (Object)3));
        filterItemColl.add(new FilterItemInfo("confirmStatus", (Object)false));
        filterItemColl.add(new FilterItemInfo("status", (Object)1));
        filterItemColl.add(new FilterItemInfo("category", (Object)personCategoryId));
        auditFilter.setMaskString("#0 and (#1 or (#2 and #3) or #4) and #5");
        return auditFilter;
    }

    public static SelectorItemCollection getSelectors(Context ctx) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("reason"));
        sic.add(new SelectorItemInfo("operateType"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.name"));
        return sic;
    }

    public static byte[] convertToBytes(InputStream in) {
        if (in == null) {
            return null;
        }
        byte[] block = new byte[1024];
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        int len = -1;
        do {
            try {
                len = in.read(block);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (len <= 0) continue;
            byteOut.write(block, 0, len);
        } while (len == 1024);
        return byteOut.toByteArray();
    }

    private static byte[] reducePhoto(byte[] imageData) throws BOSException {
        try {
            int nwidth = 100;
            int nheight = 120;
            BufferedImage read = ImageIO.read(new ByteArrayInputStream(imageData));
            Image scaledInstance = read.getScaledInstance(nwidth, nheight, 4);
            BufferedImage tag = new BufferedImage(nwidth, nheight, 1);
            tag.getGraphics().drawImage(scaledInstance, 0, 0, null);
            tag.getGraphics().dispose();
            tag.flush();
            read.flush();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)tag, "JPEG", output);
            byte[] byteArray = output.toByteArray();
            output.close();
            read = null;
            tag = null;
            System.gc();
            return byteArray;
        }
        catch (IOException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }
}

