/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base;

import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.hr.base.MetaInfo;
import com.kingdee.eas.hr.base.util.MappingUtil;
import java.io.Serializable;

public class FieldInfo
implements Serializable {
    private static final long serialVersionUID = -6600460626308981913L;
    private MetaInfo field = null;
    private String prefix = null;
    private PropertyInfo property = null;

    public MetaInfo getField() {
        if (this.field == null && this.property != null) {
            this.field = new MetaInfo();
            this.field.setName(this.property.getName());
            this.field.setValue(MappingUtil.getMDAlias(this.property));
            this.field.setUserObject(this.property);
        }
        return this.field;
    }

    public boolean isLinkProperty() {
        if (this.property instanceof OwnPropertyInfo) {
            return false;
        }
        return this.property instanceof LinkPropertyInfo;
    }

    public DataType getFieldType() {
        if (this.property != null && this.property instanceof OwnPropertyInfo) {
            return ((OwnPropertyInfo)this.property).getDataType();
        }
        return null;
    }

    public EntityObjectInfo getSupplierObject() {
        if (this.property != null && this.property instanceof LinkPropertyInfo) {
            return ((LinkPropertyInfo)this.property).getRelationship().getSupplierObject();
        }
        return null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public PropertyInfo getProperty() {
        return this.property;
    }

    public void setProperty(PropertyInfo property) {
        this.property = property;
        if (this.field != null) {
            if (this.property != null) {
                this.field.setName(this.property.getName());
                this.field.setValue(MappingUtil.getMDAlias(property));
                this.field.setUserObject(property);
            } else {
                this.field = null;
            }
        }
    }

    public boolean isSameType(FieldInfo other) {
        boolean isSame = false;
        if (other != null) {
            if (this.isLinkProperty() && other.isLinkProperty()) {
                isSame = this.getSupplierObject().equals((Object)other.getSupplierObject());
            }
            if (!this.isLinkProperty() && !other.isLinkProperty() && (isSame = this.getFieldType().equals((Object)other.getFieldType())) && DataType.ENUM.equals((Object)this.getFieldType())) {
                isSame = ((OwnPropertyInfo)this.property).getEnumType().equals((Object)((OwnPropertyInfo)other.getProperty()).getEnumType());
            }
        }
        return isSame;
    }

    public String getFullField() {
        if (this.field != null) {
            String name = this.field.getName();
            if (this.prefix != null) {
                name = this.prefix + "." + name;
            }
            return name;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof FieldInfo) {
            boolean isSame = true;
            FieldInfo f = (FieldInfo)obj;
            isSame = isSame && this.isObjectSame(this.field, f.getField()) && this.isObjectSame(this.prefix, f.getPrefix()) && this.isObjectSame(this.property, f.getProperty());
            return isSame;
        }
        return false;
    }

    protected boolean isObjectSame(Object obj1, Object obj2) {
        boolean isSame = true;
        if (obj1 != null) {
            if (!obj1.equals(obj2)) {
                isSame = false;
            }
        } else if (obj2 != null) {
            isSame = false;
        }
        return isSame;
    }

    public int hashCode() {
        return 42;
    }
}

