/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.BConfJobGradeTypeInfo;
import com.kingdee.eas.hr.base.app.AbstractBConfJobGradeTypeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BConfJobGradeTypeControllerBean
extends AbstractBConfJobGradeTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.BConfJobGradeTypeControllerBean");

    @Override
    protected void _saveBatch(Context ctx, IObjectCollection bconfJobGradeTypeCollection) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        HashSet<String> hroIdSet = new HashSet<String>();
        HashSet<String> hrBillConfigIdSet = new HashSet<String>();
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)this.getBOSType(), (Context)ctx, (Connection)conn);
            int size = bconfJobGradeTypeCollection.size();
            for (int i = 0; i < size; ++i) {
                BConfJobGradeTypeInfo info = (BConfJobGradeTypeInfo)bconfJobGradeTypeCollection.getObject(i);
                hroIdSet.add(info.getHrOrgUnit().getId().toString());
                hrBillConfigIdSet.add(info.getHrBillConfig().getId().toString());
                dao.addNewBatch((IObjectValue)info);
            }
            if (hrBillConfigIdSet.size() > 1) {
                throw new BOSException("To Many HrBillConfigIds!");
            }
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", hroIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("hrBillConfig.id", hrBillConfigIdSet, CompareType.INCLUDE));
            this._delete(ctx, filter);
            dao.executeBatch();
        }
        catch (BOSException e) {
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }
}

