/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.DynQuerySolutionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.CommonFilterGroupCollection;
import com.kingdee.eas.hr.base.CommonFilterGroupFactory;
import com.kingdee.eas.hr.base.CommonFilterGroupInfo;
import com.kingdee.eas.hr.base.CommonFilterQueryFieldCollection;
import com.kingdee.eas.hr.base.CommonFilterQueryFieldFactory;
import com.kingdee.eas.hr.base.CommonFilterQueryFieldInfo;
import com.kingdee.eas.hr.base.CommonFilterSchemeCollection;
import com.kingdee.eas.hr.base.CommonFilterSchemeException;
import com.kingdee.eas.hr.base.CommonFilterSchemeInfo;
import com.kingdee.eas.hr.base.CommonFilterSchemeStatusEnum;
import com.kingdee.eas.hr.base.ICommonFilterGroup;
import com.kingdee.eas.hr.base.ICommonFilterQueryField;
import com.kingdee.eas.hr.base.app.AbstractCommonFilterSchemeControllerBean;
import com.kingdee.eas.hr.base.app.SqlExportUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CommonFilterSchemeControllerBean
extends AbstractCommonFilterSchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.CommonFilterSchemeControllerBean");

    @Override
    public IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        CommonFilterSchemeInfo info = (CommonFilterSchemeInfo)super._getValue(ctx, pk, selector);
        ICommonFilterGroup igroup = CommonFilterGroupFactory.getLocalInstance(ctx);
        CommonFilterGroupCollection groupCol = igroup.getCommonFilterGroupCollection("where commonFilterScheme.id='" + pk + "'");
        HashMap<String, CommonFilterGroupInfo> groupMap = new HashMap<String, CommonFilterGroupInfo>();
        for (int i = 0; i < groupCol.size(); ++i) {
            CommonFilterGroupInfo commonFilterGroupInfo = groupCol.get(i);
            groupMap.put(commonFilterGroupInfo.getName(), commonFilterGroupInfo);
        }
        info.put("groupMap", groupMap);
        ICommonFilterQueryField ifield = CommonFilterQueryFieldFactory.getLocalInstance(ctx);
        CommonFilterQueryFieldCollection fieldCol = ifield.getCommonFilterQueryFieldCollection("select commonFilterGroup.*,* where commonFilterGroup.commonFilterScheme.id='" + pk + "'");
        HashMap<String, CommonFilterQueryFieldInfo> fieldMap = new HashMap<String, CommonFilterQueryFieldInfo>();
        for (int i = 0; i < fieldCol.size(); ++i) {
            CommonFilterQueryFieldInfo commonFilterQueryFieldInfo = fieldCol.get(i);
            if (!groupMap.containsKey(commonFilterQueryFieldInfo.getCommonFilterGroup().getName())) continue;
            fieldMap.put(commonFilterQueryFieldInfo.getNumber(), commonFilterQueryFieldInfo);
        }
        info.put("fieldMap", fieldMap);
        return info;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameBlank(ctx, model);
        this._checkNumberBlank(ctx, model);
        IObjectPK pk = super._addnew(ctx, model);
        CommonFilterSchemeInfo info = (CommonFilterSchemeInfo)model;
        Map groupMap = (Map)info.get("groupMap");
        Map fieldMap = (Map)info.get("fieldMap");
        this.addGroupAndField(ctx, pk, groupMap, fieldMap);
        return pk;
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return new FilterInfo();
    }

    private void deleteGroupAndField(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            ICommonFilterQueryField ifield = CommonFilterQueryFieldFactory.getLocalInstance(ctx);
            ifield.delete("where commonFilterGroup.commonFilterScheme.id='" + pk + "'");
            ICommonFilterGroup igroup = CommonFilterGroupFactory.getLocalInstance(ctx);
            igroup.delete("where commonFilterScheme.id='" + pk + "'");
        }
    }

    private void addGroupAndField(Context ctx, IObjectPK pk, Map groupMap, Map fieldMap) throws BOSException, EASBizException {
        if (groupMap == null || fieldMap == null) {
            return;
        }
        CommonFilterSchemeInfo scheme = new CommonFilterSchemeInfo();
        scheme.setId(BOSUuid.read((String)pk.toString()));
        IORMappingDAO idao = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            idao = ORMappingDAO.getInstance((BOSObjectType)new CommonFilterGroupInfo().getBOSType(), (Context)ctx, (Connection)conn);
            for (Map.Entry entry : groupMap.entrySet()) {
                CommonFilterGroupInfo commonFilterGroupInfo = (CommonFilterGroupInfo)entry.getValue();
                commonFilterGroupInfo.setCommonFilterScheme(scheme);
                commonFilterGroupInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                commonFilterGroupInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                idao.addNewBatch((IObjectValue)commonFilterGroupInfo);
            }
            idao.executeBatch();
            idao = ORMappingDAO.getInstance((BOSObjectType)new CommonFilterQueryFieldInfo().getBOSType(), (Context)ctx, (Connection)conn);
            for (Map.Entry entry : fieldMap.entrySet()) {
                CommonFilterQueryFieldInfo field = (CommonFilterQueryFieldInfo)entry.getValue();
                if (!groupMap.containsKey(field.getCommonFilterGroup().getName())) continue;
                field.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                field.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                idao.addNewBatch((IObjectValue)field);
            }
            idao.executeBatch();
        }
        catch (BOSException e) {
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameBlank(ctx, model);
        this._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
        CommonFilterSchemeInfo info = (CommonFilterSchemeInfo)model;
        Map groupMap = (Map)info.get("groupMap");
        Map fieldMap = (Map)info.get("fieldMap");
        if (fieldMap != null && groupMap != null) {
            this.deleteGroupAndField(ctx, pk);
            this.addGroupAndField(ctx, pk, groupMap, fieldMap);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CommonFilterSchemeInfo info = (CommonFilterSchemeInfo)this.getValue(ctx, pk);
        if (CommonFilterSchemeStatusEnum.enabled.equals((Object)info.getStatus())) {
            throw new CommonFilterSchemeException(CommonFilterSchemeException.NOREMOVE_ENABLED);
        }
        if (info.isIsSystem()) {
            throw new CommonFilterSchemeException(CommonFilterSchemeException.NOREMOVE_SYSTEM);
        }
        this.deleteGroupAndField(ctx, pk);
        super._delete(ctx, pk);
    }

    @Override
    protected void _copy(Context ctx, IObjectPK schemeId, IObjectPK dynQueryId, Map queryFieldMap) throws BOSException, EASBizException {
        CommonFilterSchemeInfo scheme = (CommonFilterSchemeInfo)this._getValue(ctx, schemeId, new SelectorItemCollection());
        scheme.setId(null);
        Map groupMap = (Map)scheme.get("groupMap");
        Map fieldMap = (Map)scheme.get("fieldMap");
        HashMap<String, BOSUuid> groupIdMap = new HashMap<String, BOSUuid>();
        for (Map.Entry entry : groupMap.entrySet()) {
            CommonFilterGroupInfo group = (CommonFilterGroupInfo)entry.getValue();
            BOSUuid newId = BOSUuid.create((BOSObjectType)group.getBOSType());
            BOSUuid oldId = group.getId();
            group.setId(newId);
            groupIdMap.put(oldId.toString(), newId);
        }
        ArrayList needRemoveFieldList = new ArrayList();
        for (Map.Entry entry : fieldMap.entrySet()) {
            CommonFilterQueryFieldInfo field = (CommonFilterQueryFieldInfo)entry.getValue();
            if (!queryFieldMap.containsKey(entry.getKey())) {
                needRemoveFieldList.add(entry.getKey());
                continue;
            }
            BOSUuid groupId = field.getCommonFilterGroup().getId();
            BOSUuid newId = (BOSUuid)groupIdMap.get(groupId.toString());
            if (newId != null) {
                field.getCommonFilterGroup().setId(newId);
            }
            field.setName((String)queryFieldMap.get(field.getNumber()));
            field.setId(null);
        }
        for (int i = 0; i < needRemoveFieldList.size(); ++i) {
            fieldMap.remove(needRemoveFieldList.get(i));
        }
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new BOSException();
        }
        scheme.setNumber(scheme.getNumber() + "_Copy" + random.nextInt(100));
        scheme.setName(scheme.getName() + "_Copy" + random.nextInt(100));
        scheme.setIsSystem(false);
        scheme.setStatus(CommonFilterSchemeStatusEnum.disabled);
        scheme.setDynQuerySolution(null);
        if (dynQueryId != null) {
            DynQuerySolutionInfo dynQuerySolutionInfo = new DynQuerySolutionInfo();
            dynQuerySolutionInfo.setId(BOSUuid.read((String)dynQueryId.toString()));
            scheme.setDynQuerySolution(dynQuerySolutionInfo);
        }
        this._addnew(ctx, (IObjectValue)scheme);
    }

    @Override
    protected void _disable(Context ctx, IObjectPK schemeId) throws BOSException, EASBizException {
        CommonFilterSchemeInfo info = (CommonFilterSchemeInfo)this.getValue(ctx, schemeId);
        info.setStatus(CommonFilterSchemeStatusEnum.disabled);
        this.update(ctx, schemeId, (CoreBaseInfo)info);
    }

    @Override
    protected void _enable(Context ctx, IObjectPK schemeId) throws BOSException, EASBizException {
        CommonFilterSchemeInfo info = (CommonFilterSchemeInfo)this.getValue(ctx, schemeId);
        info.setStatus(CommonFilterSchemeStatusEnum.enabled);
        this.update(ctx, schemeId, (CoreBaseInfo)info);
        StringBuffer oql = new StringBuffer();
        oql.append(" where id<>'" + schemeId + "' ");
        oql.append(" and status='1'");
        oql.append(" and query='" + info.getQuery() + "'");
        if (info.getUi() != null) {
            oql.append(" and ui='" + info.getUi() + "'");
        } else {
            oql.append(" and ui is null");
        }
        if (info.getDynQuerySolution() != null) {
            oql.append(" and dynQuerySolution.id='" + info.getDynQuerySolution().getId() + "'");
        } else {
            oql.append(" and dynQuerySolution.id is null");
        }
        CommonFilterSchemeCollection cols = this.getCommonFilterSchemeCollection(ctx, oql.toString());
        for (int i = 0; i < cols.size(); ++i) {
            cols.get(i).setStatus(CommonFilterSchemeStatusEnum.disabled);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(cols.get(i).getId()), (CoreBaseInfo)cols.get(i));
        }
    }

    @Override
    protected String _export_sql(Context ctx, IObjectPK schemeId, String sql) throws BOSException, EASBizException {
        String okStr = null;
        if (!StringUtils.isEmpty((String)sql)) {
            okStr = SqlExportUtil.gen_InsertScript(ctx, sql);
        } else {
            okStr = SqlExportUtil.gen_InsertScript(ctx, "select * from T_HR_CommonFilterScheme where fid='" + schemeId + "'");
            okStr = okStr + SqlExportUtil.gen_InsertScript(ctx, "select * from T_HR_CommonFilterGroup where FCommonFilterSchem='" + schemeId + "'");
            okStr = okStr + SqlExportUtil.gen_InsertScript(ctx, "select * from T_HR_CommonFilterQueryField where FCommonFilterGroup in (select fid from T_HR_CommonFilterGroup where FCommonFilterSchem='" + schemeId + "')");
        }
        return okStr;
    }
}

