/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.util.AffairUtil;
import com.kingdee.eas.hr.base.EmpJobGradeCollection;
import com.kingdee.eas.hr.base.EmpJobGradeInfo;
import com.kingdee.eas.hr.base.app.AbstractEmpJobGradeControllerBean;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import org.apache.log4j.Logger;

public class EmpJobGradeControllerBean
extends AbstractEmpJobGradeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.EmpJobGradeControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmpJobGradeInfo curEmpJobGradeInfo = (EmpJobGradeInfo)model;
        EmpJobGradeCollection empPreEmpJobGradeColl = this.getPreEmpRelaEmpJobGradeCollByDesc(ctx, curEmpJobGradeInfo);
        boolean needAdd = true;
        if (empPreEmpJobGradeColl.size() > 0) {
            EmpJobGradeInfo preEmpJobGradeInfo = empPreEmpJobGradeColl.get(0);
            if (AffairUtil.isObjectEquelsByPkValue((CoreBaseInfo)curEmpJobGradeInfo.getJobGrade(), (CoreBaseInfo)preEmpJobGradeInfo.getJobGrade())) {
                needAdd = false;
            }
        } else if (curEmpJobGradeInfo.getJobGrade() == null) {
            needAdd = false;
        }
        Object pk = null;
        if (needAdd) {
            this.doWithPreAndNextEmpRelationEmpJobGrade(ctx, curEmpJobGradeInfo);
            pk = super._addnew(ctx, model);
        } else {
            pk = empPreEmpJobGradeColl.size() > 0 ? new ObjectUuidPK(empPreEmpJobGradeColl.get(0).getId().toString()) : null;
        }
        return pk;
    }

    private void doWithPreAndNextEmpRelationEmpJobGrade(Context ctx, EmpJobGradeInfo curEmpJobGradeInfo) throws BOSException, EASBizException {
        EmpJobGradeCollection empNextEmpJobGradeColl;
        EmpJobGradeCollection empPreEmpJobGradeColl = this.getPreEmpRelaEmpJobGradeCollByDesc(ctx, curEmpJobGradeInfo);
        if (empPreEmpJobGradeColl.size() > 0) {
            EmpJobGradeInfo preEmpJobGradeInfo = empPreEmpJobGradeColl.get(0);
            preEmpJobGradeInfo.setEffectEndDate(DateUtil.getBeforeDay((Date)DateTimeUtils.truncateDate((Date)curEmpJobGradeInfo.getEffectStartDate())));
            this.updateEffectEndDate(ctx, preEmpJobGradeInfo);
        }
        if ((empNextEmpJobGradeColl = this.getNextEmpRelaEmpJobGradeCollByAsc(ctx, curEmpJobGradeInfo)).size() > 0) {
            EmpJobGradeInfo nextEmpJobGradeInfo = empNextEmpJobGradeColl.get(0);
            if (curEmpJobGradeInfo.getEffectEndDate() != null) {
                nextEmpJobGradeInfo.setEffectStartDate(DateUtil.getAfterDay((Date)DateTimeUtils.truncateDate((Date)curEmpJobGradeInfo.getEffectEndDate())));
                this.updateEffectStartDate(ctx, nextEmpJobGradeInfo);
            } else {
                curEmpJobGradeInfo.setEffectEndDate(DateUtil.getBeforeDay((Date)DateTimeUtils.truncateDate((Date)nextEmpJobGradeInfo.getEffectStartDate())));
            }
        }
        if (curEmpJobGradeInfo.getEffectEndDate() == null) {
            curEmpJobGradeInfo.setEffectEndDate(HRUtil.getMaxEndDate());
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        EmpJobGradeInfo curEmpJobGradeInfo = (EmpJobGradeInfo)model;
        if (curEmpJobGradeInfo.getJobGrade() != null) {
            Date curEffectEndDate = DateTimeUtils.truncateDate((Date)curEmpJobGradeInfo.getEffectEndDate());
            Date curEffectStartDate = DateTimeUtils.truncateDate((Date)curEmpJobGradeInfo.getEffectStartDate());
            EmpJobGradeCollection EmpJobGradeColl = this.getEmpRelationEmpJobGradeOfPerson(ctx, curEmpJobGradeInfo.getPerson().getId().toString());
            int size = EmpJobGradeColl.size();
            for (int i = 0; i < size; ++i) {
                EmpJobGradeInfo preEmpJobGradeInfo;
                if (!curEmpJobGradeInfo.getId().equals((Object)EmpJobGradeColl.get(i).getId())) continue;
                if (i == 0) {
                    if (size == 1) {
                        super._update(ctx, pk, (IObjectValue)curEmpJobGradeInfo);
                        continue;
                    }
                    EmpJobGradeInfo nextEmpJobGradeInfo = EmpJobGradeColl.get(i + 1);
                    if (curEffectEndDate != null) {
                        nextEmpJobGradeInfo.setEffectStartDate(DateUtil.getAfterDay((Date)curEffectEndDate));
                        this.updateEffectStartDate(ctx, nextEmpJobGradeInfo);
                    } else {
                        curEmpJobGradeInfo.setEffectEndDate(DateUtil.getBeforeDay((Date)DateTimeUtils.truncateDate((Date)nextEmpJobGradeInfo.getEffectStartDate())));
                    }
                    super._update(ctx, pk, (IObjectValue)curEmpJobGradeInfo);
                    continue;
                }
                if (i > 0 && i < size - 1) {
                    preEmpJobGradeInfo = EmpJobGradeColl.get(i - 1);
                    preEmpJobGradeInfo.setEffectEndDate(DateUtil.getBeforeDay((Date)curEffectStartDate));
                    this.updateEffectEndDate(ctx, preEmpJobGradeInfo);
                    EmpJobGradeInfo nextEmpJobGradeInfo = EmpJobGradeColl.get(i + 1);
                    if (curEffectEndDate != null) {
                        nextEmpJobGradeInfo.setEffectStartDate(DateUtil.getAfterDay((Date)curEffectEndDate));
                        this.updateEffectStartDate(ctx, nextEmpJobGradeInfo);
                    } else {
                        curEmpJobGradeInfo.setEffectEndDate(DateUtil.getBeforeDay((Date)DateTimeUtils.truncateDate((Date)nextEmpJobGradeInfo.getEffectStartDate())));
                    }
                    super._update(ctx, pk, (IObjectValue)curEmpJobGradeInfo);
                    continue;
                }
                if (i != size - 1) continue;
                preEmpJobGradeInfo = EmpJobGradeColl.get(i - 1);
                preEmpJobGradeInfo.setEffectEndDate(DateUtil.getBeforeDay((Date)curEffectStartDate));
                this.updateEffectEndDate(ctx, preEmpJobGradeInfo);
                super._update(ctx, pk, (IObjectValue)curEmpJobGradeInfo);
            }
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EmpJobGradeInfo empJobGradeInfo = this.getEmpJobGradeInfo(ctx, pk);
        EmpJobGradeCollection empJobGradeColl = this.getEmpRelationEmpJobGradeOfPerson(ctx, empJobGradeInfo.getPerson().getId().toString());
        int size = empJobGradeColl.size();
        for (int i = 0; i < size; ++i) {
            EmpJobGradeInfo preEmpJobGradeInfo;
            if (!empJobGradeInfo.getId().equals((Object)empJobGradeColl.get(i).getId())) continue;
            if (i == 0) {
                super._delete(ctx, pk);
                continue;
            }
            if (i > 0 && i < size - 1) {
                preEmpJobGradeInfo = empJobGradeColl.get(i - 1);
                EmpJobGradeInfo nextEmpJobGradeInfo = empJobGradeColl.get(i + 1);
                preEmpJobGradeInfo.setEffectEndDate(DateUtil.getBeforeDay((Date)DateTimeUtils.truncateDate((Date)nextEmpJobGradeInfo.getEffectStartDate())));
                this.updateEffectEndDate(ctx, preEmpJobGradeInfo);
                super._delete(ctx, pk);
                continue;
            }
            if (i != size - 1) continue;
            preEmpJobGradeInfo = empJobGradeColl.get(i - 1);
            preEmpJobGradeInfo.setEffectEndDate(HRUtil.getMaxEndDate());
            this.updateEffectEndDate(ctx, preEmpJobGradeInfo);
            super._delete(ctx, pk);
        }
    }

    private EmpJobGradeCollection getEmpRelationEmpJobGradeOfPerson(Context ctx, String personID) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("select id,effectStartDate,effectEndDate where ").append(" person.id='").append(personID).append("' order by effectStartDate asc ");
        EmpJobGradeCollection empJobGradeColl = this.getEmpJobGradeCollection(ctx, oql.toString());
        return empJobGradeColl;
    }

    private EmpJobGradeCollection getPreEmpRelaEmpJobGradeCollByDesc(Context ctx, EmpJobGradeInfo curEmpJobGradeInfo) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)curEmpJobGradeInfo.getPerson().getId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("effectStartDate", (Object)curEmpJobGradeInfo.getEffectStartDate(), CompareType.LESS_EQUALS));
        viewInfo.setFilter(filterInfo);
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo sortItem = new SorterItemInfo("effectStartDate");
        sortItem.setSortType(SortType.DESCEND);
        sortColl.add(sortItem);
        sortItem = new SorterItemInfo("effectEndDate");
        sortItem.setSortType(SortType.DESCEND);
        sortColl.add(sortItem);
        viewInfo.setSorter(sortColl);
        EmpJobGradeCollection empPreEmpJobGradeColl = this.getEmpJobGradeCollection(ctx, viewInfo);
        return empPreEmpJobGradeColl;
    }

    private EmpJobGradeCollection getNextEmpRelaEmpJobGradeCollByAsc(Context ctx, EmpJobGradeInfo curEmpJobGradeInfo) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)curEmpJobGradeInfo.getPerson().getId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("effectStartDate", (Object)curEmpJobGradeInfo.getEffectStartDate(), CompareType.GREATER));
        viewInfo.setFilter(filterInfo);
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo sortItem = new SorterItemInfo("effectStartDate");
        sortItem.setSortType(SortType.ASCEND);
        sortColl.add(sortItem);
        sortItem = new SorterItemInfo("effectEndDate");
        sortItem.setSortType(SortType.ASCEND);
        sortColl.add(sortItem);
        viewInfo.setSorter(sortColl);
        EmpJobGradeCollection empNextEmpJobGradeColl = this.getEmpJobGradeCollection(ctx, viewInfo);
        return empNextEmpJobGradeColl;
    }

    private void updateEffectEndDate(Context ctx, EmpJobGradeInfo relaInfo) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("effectEndDate"));
        this.updatePartial(ctx, relaInfo, selector);
    }

    private void updateEffectStartDate(Context ctx, EmpJobGradeInfo relaInfo) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("effectStartDate"));
        this.updatePartial(ctx, relaInfo, selector);
    }

    private void cleanInfo(EmpJobGradeInfo curEmpJobGradeInfo) {
        if (curEmpJobGradeInfo.getEffectEndDate() == null) {
            curEmpJobGradeInfo.setEffectEndDate(HRUtil.getMaxEndDate());
        } else {
            curEmpJobGradeInfo.setEffectEndDate(DateTimeUtils.truncateDate((Date)curEmpJobGradeInfo.getEffectEndDate()));
        }
        if (curEmpJobGradeInfo.getEffectStartDate() == null) {
            curEmpJobGradeInfo.setEffectStartDate(DateTimeUtils.truncateDate((Date)new Date()));
        } else {
            curEmpJobGradeInfo.setEffectStartDate(DateTimeUtils.truncateDate((Date)curEmpJobGradeInfo.getEffectStartDate()));
        }
    }

    @Override
    protected IObjectPK _addNewOnly(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.cleanInfo((EmpJobGradeInfo)model);
        return super._addnew(ctx, model);
    }
}

