/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonException;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonHisCollection;
import com.kingdee.eas.basedata.person.PersonHisFactory;
import com.kingdee.eas.basedata.person.PersonHisInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.AbstractEmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.AbstractHRBizDefineInfo;
import com.kingdee.eas.hr.base.AssignTypeEnum;
import com.kingdee.eas.hr.base.EmpAffairBizBillException;
import com.kingdee.eas.hr.base.EmpLaborRelationHisCollection;
import com.kingdee.eas.hr.base.EmpLaborRelationHisFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationHisInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationChangeInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmpPostExperienceHisCollection;
import com.kingdee.eas.hr.base.EmpPostExperienceHisFactory;
import com.kingdee.eas.hr.base.EmpPostExperienceHisInfo;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRBizData;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.HRBizDefineTypeEnum;
import com.kingdee.eas.hr.base.IEmpPostExperienceHis;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.base.app.his.HistoryVersionUtil;
import com.kingdee.eas.hr.base.app.util.HRBizDefineAppUtils;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.EmpPostRankCollection;
import com.kingdee.eas.hr.emp.EmpPostRankFactory;
import com.kingdee.eas.hr.emp.EmpPostRankInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.EmployeeTypeEnum;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.app.util.EmpPostRankUtil;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.PersonBURelationCollection;
import com.kingdee.shr.base.bizmanage.PersonBURelationFactory;
import com.kingdee.shr.base.bizmanage.PersonBURelationInfo;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EmpPostExperienceHisHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.EmpPostExperienceHisHelper");
    private static final HRBizDefineTypeEnum resignAction = HRBizDefineTypeEnum.RESIGN;
    private static final HRBizDefineTypeEnum retireAction = HRBizDefineTypeEnum.RETIRE;
    private static final HRBizDefineTypeEnum enrollAction = HRBizDefineTypeEnum.ENROLL;
    private static final HRBizDefineTypeEnum reinvitefireAction = HRBizDefineTypeEnum.REINVITEFIRE;
    public static final String KEY_PERSON = "person";
    public static final String KEY_PERSONHIS = "personHis";
    public static final String KEY_POSITIONHIS = "position";
    public static final String KEY_ADMINORGHIS = "adminOrg";
    public static final String KEY_COMPANY = "company";
    public static final String KEY_DEPARTMENT = "department";
    public static final String KEY_HRBIZDEFINE = "action";
    public static final String KEY_EMPTYPE = "empType";
    public static final String KEY_JOB = "job";
    public static final String KEY_JOBGRADE = "jobGrade";
    public static final String KEY_JOBLEVEL = "jobLevel";
    public static final String KEY_EMPORGRELATION = "empOrgRelation";

    public static void recoveryEmpPostExp(Context ctx, EmpPosOrgRelationInfo info, String flowType) throws EASBizException, BOSException {
        IEmpPostExperienceHis iEmpPostExperienceHis = EmpPostExperienceHisFactory.getLocalInstance(ctx);
        if ("IN_TYPE".equals(flowType)) {
            Date effdt = info.getEFFDT();
            StringBuffer oqlDelete = new StringBuffer();
            oqlDelete.append("where person='").append(info.getPerson().getId().toString()).append("'").append(" and position='").append(info.getPosition().getId().toString()).append("'").append(" and adminOrg='").append(info.getAdminOrg().getId().toString()).append("'").append(" and assignType=").append(info.getAssignType().getValue()).append(" and isinner=").append(1).append(" and startDateTime >= ").append(HistoryVersionUtil.getDateTimeTs(info.getStartDateTime()));
            iEmpPostExperienceHis.delete(oqlDelete.toString());
        } else if ("OUT_TYPE".equals(flowType)) {
            EmpPostExperienceHisInfo empPostExpHisBefore = null;
            StringBuffer beforeRecordoql = new StringBuffer();
            if (AssignTypeEnum.MAIN.equals((Object)info.getAssignType())) {
                beforeRecordoql.append("where person='").append(info.getPerson().getId().toString()).append("'").append(" and assignType=").append(info.getAssignType().getValue()).append(" and isinner=").append(1).append(" order by endDateTime desc");
            } else {
                beforeRecordoql.append("where person='").append(info.getPerson().getId().toString()).append("'").append(" and assignType=").append(info.getAssignType().getValue()).append(" and position= '").append(info.getPosition().getId().toString()).append("'").append(" and isinner=").append(1).append(" order by endDateTime desc");
            }
            EmpPostExperienceHisCollection empPostExperienceHisCollection = iEmpPostExperienceHis.getEmpPostExperienceHisCollection(beforeRecordoql.toString());
            if (empPostExperienceHisCollection.size() > 0) {
                empPostExpHisBefore = empPostExperienceHisCollection.get(0);
                empPostExpHisBefore.setLeffdt(HRUtil.getMaxEndDate());
                empPostExpHisBefore.setEndDateTime(HistoryVersionUtil.getMaxEndDate());
                HRBizDefineInfo action = info.getAction();
                if (EmpPostExperienceHisHelper.isPositionEndAction(action)) {
                    PersonPositionInfo personPositionInfo = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionInfo("where person = '" + info.getPerson().getId().toString() + "'");
                    if (empPostExpHisBefore.getEffdt() != null && personPositionInfo.getLeftCompanyDate() != null && DateTimeUtils.dayBefore((Date)empPostExpHisBefore.getEffdt(), (Date)personPositionInfo.getLeftCompanyDate())) {
                        empPostExpHisBefore.setPositionEndDate(personPositionInfo.getLeftCompanyDate());
                    }
                } else {
                    empPostExpHisBefore.setPositionEndDate(HRUtil.getMaxEndDate());
                }
                empPostExpHisBefore.setIsLatestInAday(true);
                empPostExpHisBefore.setCompany(info.getCompany());
                empPostExpHisBefore.setAdminOrg(info.getAdminOrg());
                empPostExpHisBefore.setPosition(info.getPosition());
                iEmpPostExperienceHis.update((IObjectPK)new ObjectUuidPK(empPostExpHisBefore.getId()), empPostExpHisBefore);
            }
        }
    }

    public static void positionTerminateToEndEmpPostExp(Context ctx, EmpPosOrgRelationChangeInfo changeInfo, EmpPosOrgRelationInfo empPosOrgInfo) throws EASBizException, BOSException {
        if (empPosOrgInfo.getAssignType() == null) {
            return;
        }
        HRBizData bizData = changeInfo.getHrBizData();
        HRBizDefineInfo action = changeInfo.getActionDef();
        if (bizData.isSupplementBill() && (HRBizDefineTypeEnum.EMPHIRE.equals((Object)action.getBizDefineType()) || HRBizDefineTypeEnum.FLUCTUACTION.equals((Object)action.getBizDefineType()) && HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)bizData.getOldPosition().getPositionInfo(), (CoreBaseInfo)bizData.getNewPosition().getPositionInfo()))) {
            return;
        }
        boolean isSameDatePersonChange = bizData.isSameDatePersonChange();
        String personId = empPosOrgInfo.getPerson().getId().toString();
        String positionId = empPosOrgInfo.getPosition().getId().toString();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("EmpPostExperienceHisHelper.positionTerminateToEndEmpPostExp#personId:" + personId + "_positionId:" + positionId + "_assignType:" + empPosOrgInfo.getAssignType().getValue()));
        }
        IEmpPostExperienceHis iEmpPostExperienceHis = EmpPostExperienceHisFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append("where person='").append(personId).append("'");
        oql.append(" and position = '").append(positionId).append("'");
        oql.append(" and leffdt =").append(HRUtil.getMaxEndDateTs());
        oql.append(" and assignType=").append(empPosOrgInfo.getAssignType().getValue());
        oql.append(" and isinner=").append(1);
        oql.append(" order by endDateTime desc");
        EmpPostExperienceHisCollection empPostExpHisCol = iEmpPostExperienceHis.getEmpPostExperienceHisCollection(oql.toString());
        if (empPosOrgInfo.getAssignType().equals((Object)AssignTypeEnum.MAIN)) {
            EmpPostExperienceHisInfo lastEmpPostExpHisInfo = empPostExpHisCol.get(0);
            if (lastEmpPostExpHisInfo != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                lastEmpPostExpHisInfo.setLeffdt(empPosOrgInfo.getLEFFDT());
                lastEmpPostExpHisInfo.setEndDateTime(empPosOrgInfo.getEndDateTime());
                if (EmpPostExperienceHisHelper.isEnrollAgainAction(action)) {
                    lastEmpPostExpHisInfo.setPositionEndDate(lastEmpPostExpHisInfo.getPositionEndDate());
                } else {
                    lastEmpPostExpHisInfo.setPositionEndDate(empPosOrgInfo.getLEFFDT());
                }
                if (isSameDatePersonChange) {
                    lastEmpPostExpHisInfo.setIsLatestInAday(false);
                }
                sic.add(new SelectorItemInfo(HistoryConstant.LEFFDT));
                sic.add(new SelectorItemInfo("endDateTime"));
                sic.add(new SelectorItemInfo("positionEndDate"));
                sic.add(new SelectorItemInfo("isLatestInAday"));
                iEmpPostExperienceHis.updatePartial(lastEmpPostExpHisInfo, sic);
            }
        } else if (empPosOrgInfo.getAssignType().equals((Object)AssignTypeEnum.PARTTIME)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            if (empPostExpHisCol.size() > 0) {
                EmpPostExperienceHisInfo lastEmpPostExpHisInfo = empPostExpHisCol.get(0);
                lastEmpPostExpHisInfo.setLeffdt(empPosOrgInfo.getLEFFDT());
                lastEmpPostExpHisInfo.setPositionEndDate(empPosOrgInfo.getLEFFDT());
                lastEmpPostExpHisInfo.setEndDateTime(empPosOrgInfo.getEndDateTime());
                sic.add(new SelectorItemInfo(HistoryConstant.LEFFDT));
                sic.add(new SelectorItemInfo("endDateTime"));
                sic.add(new SelectorItemInfo("positionEndDate"));
                sic.add(new SelectorItemInfo("isLatestInAday"));
                iEmpPostExperienceHis.updatePartial(lastEmpPostExpHisInfo, sic);
            }
        }
    }

    public static void updateEmpPostExp(Context ctx, EmpPosOrgRelationInfo oldInfo, EmpPosOrgRelationInfo info) throws EASBizException, BOSException {
        EmpPostExperienceHisInfo empPostExpHisInfo;
        IEmpPostExperienceHis iEmpPostExperienceHis = EmpPostExperienceHisFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        Date effect = oldInfo.getEFFDT();
        String effdt = HRUtilExtend.getDateStringWithoutMininuteTs(effect);
        oql.append(" where person='").append(oldInfo.getPerson().getId().toString()).append("'");
        oql.append(" and position='").append(oldInfo.getPosition().getId().toString()).append("'");
        oql.append(" and adminOrg='").append(oldInfo.getAdminOrg().getId().toString()).append("'");
        oql.append(" and effdt=").append(effdt);
        oql.append(" and isinner=").append(1);
        oql.append(" and assignType=").append(oldInfo.getAssignType().getValue());
        EmpPostExperienceHisCollection empPostExpHisCol = iEmpPostExperienceHis.getEmpPostExperienceHisCollection(oql.toString());
        if (empPostExpHisCol.size() > 1) {
            Object[] params = new Object[2];
            PersonInfo personInfo = oldInfo.getPerson();
            params[0] = personInfo.getName();
            params[1] = HRUtilExtend.getDateStringWithoutMininute(effect);
            throw new EmpAffairBizBillException(EmpAffairBizBillException.EXPRECORDERROR, params);
        }
        EmployeeTypeInfo oldEmptypeInfo = oldInfo.getLaborRelation().getLaborRelationState();
        oldEmptypeInfo = EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeInfo((IObjectPK)new ObjectUuidPK(oldEmptypeInfo.getId()));
        EmployeeTypeInfo newEmptypeInfo = info.getLaborRelation().getLaborRelationState();
        newEmptypeInfo = EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeInfo((IObjectPK)new ObjectUuidPK(newEmptypeInfo.getId()));
        if (!EmpPostExperienceHisHelper.empTypeInservice(oldEmptypeInfo) && EmpPostExperienceHisHelper.empTypeInservice(newEmptypeInfo)) {
            if (empPostExpHisCol.size() == 0) {
                EmpPostExperienceHisInfo addnewInfo = EmpPostExperienceHisHelper.prepareAddNewInfo(info);
                iEmpPostExperienceHis.addnew(addnewInfo);
            } else if (empPostExpHisCol.size() == 1) {
                EmpPostExperienceHisInfo empPostExpHisInfo2 = empPostExpHisCol.get(0);
                iEmpPostExperienceHis.delete((IObjectPK)new ObjectUuidPK(empPostExpHisInfo2.getId().toString()));
                EmpPostExperienceHisInfo addnewInfo = EmpPostExperienceHisHelper.prepareAddNewInfo(info);
                iEmpPostExperienceHis.addnew(addnewInfo);
            }
        } else if (EmpPostExperienceHisHelper.empTypeInservice(oldEmptypeInfo) && !EmpPostExperienceHisHelper.empTypeInservice(newEmptypeInfo)) {
            if (empPostExpHisCol.size() == 1) {
                EmpPostExperienceHisInfo empPostExpHisInfo3 = empPostExpHisCol.get(0);
                iEmpPostExperienceHis.delete((IObjectPK)new ObjectUuidPK(empPostExpHisInfo3.getId().toString()));
            }
        } else if (EmpPostExperienceHisHelper.empTypeInservice(oldEmptypeInfo) && EmpPostExperienceHisHelper.empTypeInservice(newEmptypeInfo) && empPostExpHisCol.size() == 1 && (empPostExpHisInfo = empPostExpHisCol.get(0)) != null) {
            empPostExpHisInfo.setEffdt(info.getEFFDT());
            empPostExpHisInfo.setStartDateTime(info.getEFFDT());
            empPostExpHisInfo.setAdminOrg(info.getAdminOrg());
            empPostExpHisInfo.setPosition(info.getPosition());
            empPostExpHisInfo.setHrOrgUnit(info.getHrOrgUnit());
            empPostExpHisInfo.setCompany(info.getCompany());
            iEmpPostExperienceHis.update((IObjectPK)new ObjectUuidPK(empPostExpHisInfo.getId().toString()), empPostExpHisInfo);
        }
    }

    private static boolean empTypeInservice(EmployeeTypeInfo emptypeInfo) {
        return 0 == emptypeInfo.getInService().getValue() || 1 == emptypeInfo.getInService().getValue() || 4 == emptypeInfo.getInService().getValue();
    }

    public static IObjectPK primaryPositionAddToAddEmpPostExp(Context ctx, EmpPosOrgRelationChangeInfo changeInfo, EmpPosOrgRelationInfo info) throws EASBizException, BOSException {
        HRBizData bizData = changeInfo.getHrBizData();
        HRBizDefineInfo action = bizData.getHrbizDefine();
        boolean isSameDatePersonChange = bizData.isSameDatePersonChange();
        EmployeeTypeInfo emptypeInfo = bizData.getNewPosition().getEmployeeType();
        emptypeInfo = EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeInfo((IObjectPK)new ObjectUuidPK(emptypeInfo.getId().toString()));
        IEmpPostExperienceHis iEmpPostExperienceHis = EmpPostExperienceHisFactory.getLocalInstance(ctx);
        String personId = info.getPerson().getId().toString();
        StringBuffer oql = new StringBuffer();
        oql.append("where person='").append(personId).append("'").append(" and assignType=").append(1).append(" and isinner =1 ").append(" order by endDateTime desc");
        EmpPostExperienceHisCollection empPostExpHisCol = iEmpPostExperienceHis.getEmpPostExperienceHisCollection(oql.toString());
        if (empPostExpHisCol.size() == 0) {
            if (EmpPostExperienceHisHelper.actionCanAddEmpPostExpHis(ctx, bizData)) {
                EmpPostExperienceHisInfo hisInfo = EmpPostExperienceHisHelper.prepareAddNewInfo(info);
                hisInfo.setIsLatestInAday(true);
                return iEmpPostExperienceHis.addnew(hisInfo);
            }
        } else if (empPostExpHisCol.size() > 0) {
            EmpPostExperienceHisInfo lastEmpPostExpHisInfo = empPostExpHisCol.get(0);
            if (info.getEFFDT().before(lastEmpPostExpHisInfo.getEffdt())) {
                return null;
            }
            if (EmpPostExperienceHisHelper.isPositionAndAdminOrgEquals(lastEmpPostExpHisInfo, info) && !EmpPostExperienceHisHelper.isEnrollAgainAction(action)) {
                if (EmpPostExperienceHisHelper.isPositionEndAction(action) || !EmpPostExperienceHisHelper.empTypeInservice(emptypeInfo)) {
                    if (isSameDatePersonChange) {
                        lastEmpPostExpHisInfo.setPositionEndDate(changeInfo.getStartDate());
                    } else {
                        lastEmpPostExpHisInfo.setPositionEndDate(HRUtil.getBeforeDate(info.getEFFDT()));
                    }
                } else {
                    lastEmpPostExpHisInfo.setPositionEndDate(HRUtil.getMaxEndDate());
                }
                lastEmpPostExpHisInfo.setLeffdt(info.getLEFFDT());
                lastEmpPostExpHisInfo.setEndDateTime(info.getEndDateTime());
                lastEmpPostExpHisInfo.setIsLatestInAday(true);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo(HistoryConstant.LEFFDT));
                sic.add(new SelectorItemInfo("endDateTime"));
                sic.add(new SelectorItemInfo("isLatestInAday"));
                sic.add(new SelectorItemInfo("positionEndDate"));
                iEmpPostExperienceHis.updatePartial(lastEmpPostExpHisInfo, sic);
                return new ObjectUuidPK(lastEmpPostExpHisInfo.getId().toString());
            }
            EmpPostExperienceHisInfo hisInfo = EmpPostExperienceHisHelper.prepareAddNewInfo(info);
            if (isSameDatePersonChange) {
                int oldVersion = lastEmpPostExpHisInfo.getVersion();
                hisInfo.setVersion(oldVersion + 1);
            }
            if (action.getBizDefineType().equals((Object)HRBizDefineTypeEnum.RESIGN) || action.getBizDefineType().equals((Object)HRBizDefineTypeEnum.RETIRE)) {
                hisInfo.setPositionEndDate(info.getEFFDT());
            }
            hisInfo.setIsLatestInAday(true);
            return iEmpPostExperienceHis.addnew(hisInfo);
        }
        return null;
    }

    public static IObjectPK partTimePositionAddToAddEmpPostExp(Context ctx, EmpPosOrgRelationChangeInfo changeInfo, EmpPosOrgRelationInfo info) throws EASBizException, BOSException {
        EmpPostExperienceHisInfo hisInfo = EmpPostExperienceHisHelper.prepareAddNewInfo(info);
        return EmpPostExperienceHisFactory.getLocalInstance(ctx).addnew(hisInfo);
    }

    private static boolean isEnrollAgainAction(HRBizDefineInfo action) {
        return action.getBizDefineType().equals((Object)HRBizDefineTypeEnum.REINVITE) || HRBizDefineTypeEnum.ENROLLAGAIN.equals((Object)action.getBizDefineType());
    }

    private static boolean isPositionEndAction(HRBizDefineInfo action) {
        return action.getBizDefineType() == resignAction || action.getBizDefineType() == retireAction || action.getBizDefineType() == reinvitefireAction || action.getId().toString().equals("DawAAAAqVQPmaL7Z") || action.getId().toString().equals("bk+DjtF3SqaTvEJPHNhLseZovtk=");
    }

    private static boolean isPositionAndAdminOrgEquals(EmpPostExperienceHisInfo lastEmpPostExpHisInfo, EmpPosOrgRelationInfo info) {
        boolean positionEquals = HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)info.getPosition(), (CoreBaseInfo)lastEmpPostExpHisInfo.getPosition());
        boolean adminOrgEquals = HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)info.getAdminOrg(), (CoreBaseInfo)lastEmpPostExpHisInfo.getAdminOrg());
        return positionEquals && adminOrgEquals;
    }

    public static EmpPostExperienceHisInfo prepareAddNewInfo(EmpPosOrgRelationInfo info) {
        EmpPostExperienceHisInfo empPostExpHisInfo = new EmpPostExperienceHisInfo();
        empPostExpHisInfo.setLeffdt(info.getLEFFDT());
        empPostExpHisInfo.setEffdt(info.getEFFDT());
        empPostExpHisInfo.setPerson(info.getPerson());
        empPostExpHisInfo.setPosition(info.getPosition());
        empPostExpHisInfo.setAdminOrg(info.getAdminOrg());
        empPostExpHisInfo.setAssignType(info.getAssignType());
        empPostExpHisInfo.setHrOrgUnit(info.getHrOrgUnit());
        empPostExpHisInfo.setCompany(info.getCompany());
        empPostExpHisInfo.setPositionEndDate(info.getLEFFDT());
        empPostExpHisInfo.setStartDateTime(info.getStartDateTime());
        empPostExpHisInfo.setEndDateTime(info.getEndDateTime());
        empPostExpHisInfo.setVersion(1);
        empPostExpHisInfo.setIsLatestInAday(true);
        empPostExpHisInfo.setIsSystem(info.isIsSystem());
        empPostExpHisInfo.setIsInner(info.isIsInner());
        empPostExpHisInfo.setAdminOrgTxt(info.getAdminOrgTxt());
        empPostExpHisInfo.setPositionTxt(info.getPositionTxt());
        return empPostExpHisInfo;
    }

    public static boolean _verifyEmpPostExperienceHis(Context ctx, String personId, String positionId, Date effect, AssignTypeEnum assignTypeEnum) throws BOSException, EASBizException {
        IEmpPostExperienceHis iEmpPostExperienceHis = EmpPostExperienceHisFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        String effdt = HRUtilExtend.getDateStringWithoutMininuteTs(effect);
        oql.append("select id where person='").append(personId).append("' and effdt>=").append(effdt);
        oql.append("and assignType=").append(assignTypeEnum.getValue());
        if (assignTypeEnum.getValue() != 1) {
            oql.append("and position='").append(positionId).append("'");
        }
        return iEmpPostExperienceHis.getCollection(oql.toString()).size() < 1;
    }

    public static EmpPostExperienceHisInfo getPointDateEmpPostExpHis(Context ctx, String personId, Date effect) throws BOSException {
        EmpPostExperienceHisInfo empPostExpHisInfo;
        IEmpPostExperienceHis iEmpPostExperienceHis = EmpPostExperienceHisFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        String effdt = HRUtilExtend.getDateStringWithoutMininuteTs(effect);
        oql.append("select id,adminOrg.number,adminOrg.name,adminOrg.displayName,");
        oql.append("position.id,position.name,position.number,");
        oql.append("company.id,company.number,company.name,company.displayName ");
        oql.append(" where person='").append(personId).append("'");
        oql.append(" and assignType=").append(1);
        oql.append(" and effdt<=").append(effdt).append(" and leffdt>=").append(effdt);
        oql.append(" and isinner=").append(1);
        oql.append(" order by endDateTime desc ");
        EmpPostExperienceHisCollection empPostExpHisCol = iEmpPostExperienceHis.getEmpPostExperienceHisCollection(oql.toString());
        if (empPostExpHisCol.size() > 0 && (empPostExpHisInfo = empPostExpHisCol.get(0)) != null) {
            return empPostExpHisInfo;
        }
        return null;
    }

    public static Map validateRelationTypeHisAndReturn(Context ctx, String personId, String actionId, Date effect) throws BOSException, EASBizException {
        EmpPostRankInfo lastedEmpPostRank;
        HRBizDefineInfo hrBizDefineInfo;
        HashMap<String, String> result = new HashMap<String, String>();
        EmpPostExperienceHisInfo pointEmpPostExpHis = EmpPostExperienceHisHelper.getPointDateEmpPostExpHis(ctx, personId, effect);
        Map personAllRelationsMap = EmpPostExperienceHisHelper.getPersonAllRelationHisMap(ctx, personId, effect);
        PersonInfo personInfo = null;
        PositionInfo position = null;
        AdminOrgUnitInfo adminOrg = null;
        AdminOrgUnitInfo company = null;
        AdminOrgUnitInfo department = null;
        JobInfo job = null;
        EmployeeTypeInfo employeeTypeInfo = null;
        JobGradeInfo jobGradeInfo = null;
        JobLevelInfo jobLevelInfo = null;
        AbstractHRBizDefineInfo hrbizDefineInfo = null;
        AbstractEmpPosOrgRelationInfo empPosOrgRelationInfo = null;
        EmpPostRankInfo empPostRankInfo = null;
        if (personAllRelationsMap.size() > 0) {
            personInfo = (PersonInfo)personAllRelationsMap.get(KEY_PERSON);
            position = (PositionInfo)personAllRelationsMap.get(KEY_POSITIONHIS);
            adminOrg = (AdminOrgUnitInfo)personAllRelationsMap.get(KEY_ADMINORGHIS);
            company = (AdminOrgUnitInfo)personAllRelationsMap.get(KEY_COMPANY);
            department = (AdminOrgUnitInfo)personAllRelationsMap.get(KEY_DEPARTMENT);
            job = (JobInfo)personAllRelationsMap.get(KEY_JOB);
            employeeTypeInfo = (EmployeeTypeInfo)personAllRelationsMap.get(KEY_EMPTYPE);
            jobGradeInfo = (JobGradeInfo)personAllRelationsMap.get(KEY_JOBGRADE);
            jobLevelInfo = (JobLevelInfo)personAllRelationsMap.get(KEY_JOBLEVEL);
            hrbizDefineInfo = (HRBizDefineInfo)personAllRelationsMap.get(KEY_HRBIZDEFINE);
            empPosOrgRelationInfo = (EmpPosOrgRelationInfo)personAllRelationsMap.get(KEY_EMPORGRELATION);
            empPostRankInfo = (EmpPostRankInfo)personAllRelationsMap.get("empPostRankInfo");
        }
        result.put("personName", personInfo == null ? "" : personInfo.getName());
        if (hrbizDefineInfo != null) {
            result.put(KEY_HRBIZDEFINE, hrbizDefineInfo.getName());
        }
        if (empPosOrgRelationInfo != null) {
            Object[] params;
            String warmingMsg;
            if (DateTimeUtils.dayEquals((Date)empPosOrgRelationInfo.getEFFDT(), (Date)effect) && DateTimeUtils.dayEquals((Date)empPosOrgRelationInfo.getLEFFDT(), (Date)HRUtil.getMaxEndDate())) {
                result.put("change", "nothingChange");
                result.put("hisSameDateChange", "canSameDateChange");
                warmingMsg = SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label133", (Context)ctx);
                params = new Object[]{personInfo.getName(), HRUtilExtend.getDateStringWithoutMininute(effect), hrbizDefineInfo == null ? "" : hrbizDefineInfo.getName()};
                result.put("warmingMsg", MessageFormat.format(warmingMsg, params));
            } else if (DateTimeUtils.dayEquals((Date)empPosOrgRelationInfo.getEFFDT(), (Date)effect) && !DateTimeUtils.dayEquals((Date)empPosOrgRelationInfo.getLEFFDT(), (Date)HRUtil.getMaxEndDate())) {
                result.put("change", "nothingChange");
                result.put("hisSameDateChange", "canNotInsertChangeInSameDate");
                warmingMsg = SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label113", (Context)ctx);
                params = new Object[]{personInfo.getName(), HRUtilExtend.getDateStringWithoutMininute(effect), hrbizDefineInfo == null ? "" : hrbizDefineInfo.getName()};
                result.put("warmingMsg", MessageFormat.format(warmingMsg, params));
            } else if (empPosOrgRelationInfo.getEFFDT().before(effect) && !DateTimeUtils.dayEquals((Date)empPosOrgRelationInfo.getLEFFDT(), (Date)HRUtil.getMaxEndDate())) {
                if (pointEmpPostExpHis != null && empPosOrgRelationInfo.getId() != null && pointEmpPostExpHis.getPosition() != null && empPosOrgRelationInfo.getPosition() != null && empPosOrgRelationInfo.getPosition().getId().toString().equals(pointEmpPostExpHis.getPosition().getId().toString()) && empPosOrgRelationInfo.getAdminOrg().getId().toString().equals(pointEmpPostExpHis.getAdminOrg().getId().toString())) {
                    result.put("change", "empTypeChange");
                } else {
                    result.put("change", "positionChange");
                }
                if (result.get("change") != null) {
                    EmpPosOrgRelationQueryHelper queryHelper = new EmpPosOrgRelationQueryHelper();
                    EmpPosOrgRelationCollection nextEmpPosInfoColl = queryHelper.getAppointDateAfterPrimaryPosition(ctx, personInfo.getId().toString(), effect);
                    EmpPosOrgRelationInfo nextEmpPosInfo = nextEmpPosInfoColl.get(0);
                    Object[] params2 = new Object[3];
                    params2[0] = personInfo.getName();
                    params2[1] = HRUtilExtend.getDateStringWithoutMininute(nextEmpPosInfo.getEFFDT());
                    HRBizDefineInfo nextAction = nextEmpPosInfo.getAction();
                    params2[2] = nextAction.getName();
                    if ("DawAAAApVj/maL7Z".equals(actionId) || "DawAAAApVhzmaL7Z".equals(actionId)) {
                        String warmingMsg2 = SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label168", (Context)ctx);
                        result.put("warmingMsg", MessageFormat.format(warmingMsg2, params2));
                    } else {
                        String errorMsg = SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label114", (Context)ctx);
                        result.put("errorMsg", MessageFormat.format(errorMsg, params2));
                    }
                }
            }
        }
        if (!(StringUtils.isEmpty((String)actionId) || HRBizDefineTypeEnum.RISE.equals((Object)(hrBizDefineInfo = HRBizDefineAppUtils.getHRBizDefineInfo(ctx, actionId)).getBizDefineType()) || (lastedEmpPostRank = EmpPostRankUtil.getLastedEmpPostRank((Context)ctx, (String)personId)) == null || DateTimeUtils.dayBefore((Date)lastedEmpPostRank.getEFFDT(), (Date)effect))) {
            Object[] params = new Object[]{personInfo != null ? personInfo.getName() : "", HRUtilExtend.getDateStringWithoutMininute(lastedEmpPostRank.getEFFDT())};
            String errorMsg = SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label167", (Context)ctx);
            result.put("empPostRankErrorMsg", MessageFormat.format(errorMsg, params));
            result.put("empPostRankchange", "empPostRankChange");
        }
        if (personAllRelationsMap.size() > 0 && empPosOrgRelationInfo != null && empPosOrgRelationInfo.getId() != null) {
            if (position != null) {
                result.put("positionName", position.getName());
                result.put("positionId", position.getId() != null ? position.getId().toString() : "");
                result.put("positionNumber", position.getNumber());
                if (job != null && job.getId() != null) {
                    result.put("positionJobId", job.getId().toString());
                    result.put("positionJobName", job.getName());
                }
            }
            if (adminOrg != null) {
                result.put("adminOrgDisplayName", adminOrg.getDisplayName());
                result.put("adminOrgName", adminOrg.getName());
                result.put("adminOrgNumber", adminOrg.getNumber());
                result.put("adminOrgId", adminOrg.getId() != null ? adminOrg.getId().toString() : "");
            }
            if (company != null && company.getId() != null) {
                result.put("companyDisplayName", company.getDisplayName());
                result.put("companyName", company.getName());
                result.put("companyNumber", company.getNumber());
                result.put("companyId", company.getId().toString());
            }
            if (department != null && department.getId() != null) {
                result.put("departmentDisplayName", department.getDisplayName());
                result.put("departmentName", department.getName());
                result.put("departmentNumber", department.getNumber());
                result.put("departmentId", department.getId().toString());
            }
            if (employeeTypeInfo != null) {
                result.put("empTypeId", employeeTypeInfo.getId().toString());
                result.put("empTypeName", employeeTypeInfo.getName());
            }
            if (jobGradeInfo != null && jobGradeInfo.getId() != null) {
                result.put("jobGradeId", jobGradeInfo.getId().toString());
                result.put("jobGradeName", jobGradeInfo.getName());
            }
            if (jobLevelInfo != null && jobLevelInfo.getId() != null) {
                result.put("jobLevelId", jobLevelInfo.getId().toString());
                result.put("jobLevelName", jobLevelInfo.getName());
            }
        }
        return result;
    }

    public static Map getPersonAllRelationHisMap(Context ctx, String personId, Date effect) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (effect == null) {
            effect = HRUtilExtend.getCurDateWithTruncated();
        }
        Map<String, Object> map = EmpPostExperienceHisHelper.getPersonPrimaryPositionHisQuerySQL(ctx, personId, effect);
        PersonInfo personInfo = null;
        PersonHisInfo personHisInfo = null;
        EmpPosOrgRelationInfo empOrgRelationInfo = null;
        PositionInfo positionInfo = null;
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        AdminOrgUnitInfo adminOrgCompany = null;
        AdminOrgUnitInfo department = null;
        HRBizDefineInfo actionInfo = null;
        JobLevelInfo jobLevelInfo = null;
        JobGradeInfo jobGradeInfo = null;
        JobInfo jobInfo = null;
        EmployeeTypeInfo employeeTypeInfo = null;
        if (map != null && map.size() > 0) {
            JobLevelInfo jobLevelInfo2;
            JobGradeInfo jobGrade;
            JobInfo jInfo;
            EmployeeTypeInfo employeeTypeInfo2;
            HRBizDefineInfo hrBizDefineInfo;
            AdminOrgUnitInfo departmentOrgUnit;
            AdminOrgUnitInfo company;
            AdminOrgUnitInfo adminOrgUnit;
            PositionInfo positionInfo2;
            PersonHisInfo personHisInfo2;
            PersonInfo pInfo = (PersonInfo)map.get("personInfo");
            if (pInfo == null) {
                throw new PersonException(PersonException.NO_PERSON);
            }
            personInfo = new PersonInfo();
            personInfo.setId(pInfo.getId());
            personInfo.setNumber(pInfo.getNumber());
            personInfo.setName(pInfo.getName());
            EmpPosOrgRelationInfo relationInfo = (EmpPosOrgRelationInfo)map.get("empPosOrgRelationInfo");
            if (relationInfo != null) {
                if (StringUtils.isEmpty((String)relationInfo.getId().toString())) {
                    Object[] params1 = new Object[]{personInfo.getName(), HRUtilExtend.getDateStringWithoutMininute(effect)};
                    throw new EmployeeException(EmployeeException.EMP_RELATIONS_NULL, params1);
                }
                empOrgRelationInfo = new EmpPosOrgRelationInfo();
                empOrgRelationInfo.setId(relationInfo.getId());
                empOrgRelationInfo.setEFFDT(relationInfo.getEFFDT());
                empOrgRelationInfo.setLEFFDT(relationInfo.getLEFFDT());
                empOrgRelationInfo.setAssignType(relationInfo.getAssignType());
                empOrgRelationInfo.setPosition(relationInfo.getPosition());
                empOrgRelationInfo.setAdminOrg(relationInfo.getAdminOrg());
            }
            if ((personHisInfo2 = (PersonHisInfo)map.get("personHisInfo")) != null && !StringUtils.isEmpty((String)personHisInfo2.getId().toString())) {
                personHisInfo = new PersonHisInfo();
                personHisInfo.setId(personHisInfo2.getId());
                personHisInfo.setNumber(personHisInfo2.getNumber());
                personHisInfo.setName(personHisInfo2.getName());
                personHisInfo.setCell(personHisInfo2.getCell());
                personHisInfo.setIdCardNO(personHisInfo2.getIdCardNO());
                personHisInfo.setPassportNO(personHisInfo2.getPassportNO());
            }
            if ((positionInfo2 = (PositionInfo)map.get(KEY_POSITIONHIS)) != null && !StringUtils.isEmpty((String)positionInfo2.getId().toString())) {
                positionInfo = new PositionInfo();
                positionInfo.setId(positionInfo2.getId());
                positionInfo.setNumber(positionInfo2.getNumber());
                positionInfo.setName(positionInfo2.getName());
            }
            if ((adminOrgUnit = (AdminOrgUnitInfo)map.get(KEY_ADMINORGHIS)) != null && !StringUtils.isEmpty((String)adminOrgUnit.getId().toString())) {
                adminOrgUnitInfo = new AdminOrgUnitInfo();
                adminOrgUnitInfo.setId(adminOrgUnit.getId());
                adminOrgUnitInfo.setNumber(adminOrgUnit.getNumber());
                adminOrgUnitInfo.setName(adminOrgUnit.getName());
                adminOrgUnitInfo.setLongNumber(adminOrgUnit.getLongNumber());
                adminOrgUnitInfo.setDisplayName(adminOrgUnit.getDisplayName());
            }
            if ((company = (AdminOrgUnitInfo)map.get(KEY_COMPANY)) != null && !StringUtils.isEmpty((String)company.getId().toString())) {
                adminOrgCompany = new AdminOrgUnitInfo();
                adminOrgCompany.setId(BOSUuid.read((String)company.getId().toString()));
                adminOrgCompany.setNumber(company.getNumber());
                adminOrgCompany.setName(company.getName());
                adminOrgCompany.setLongNumber(company.getLongNumber());
                adminOrgCompany.setDisplayName(company.getDisplayName());
            }
            if ((departmentOrgUnit = (AdminOrgUnitInfo)map.get(KEY_DEPARTMENT)) != null && !StringUtils.isEmpty((String)departmentOrgUnit.getId().toString())) {
                department = new AdminOrgUnitInfo();
                department.setId(BOSUuid.read((String)departmentOrgUnit.getId().toString()));
                department.setNumber(departmentOrgUnit.getNumber());
                department.setName(departmentOrgUnit.getName());
                department.setLongNumber(departmentOrgUnit.getLongNumber());
                department.setDisplayName(departmentOrgUnit.getDisplayName());
            }
            if ((hrBizDefineInfo = (HRBizDefineInfo)map.get("hrBizDefineInfo")) != null && !StringUtils.isEmpty((String)hrBizDefineInfo.getId().toString())) {
                actionInfo = new HRBizDefineInfo();
                actionInfo.setId(BOSUuid.read((String)hrBizDefineInfo.getId().toString()));
                actionInfo.setName(hrBizDefineInfo.getName());
                actionInfo.setNumber(hrBizDefineInfo.getNumber());
            }
            if ((employeeTypeInfo2 = (EmployeeTypeInfo)map.get("employeeTypeInfo")) != null && !StringUtils.isEmpty((String)employeeTypeInfo2.getId().toString())) {
                employeeTypeInfo = new EmployeeTypeInfo();
                employeeTypeInfo.setId(BOSUuid.read((String)employeeTypeInfo2.getId().toString()));
                employeeTypeInfo.setNumber(employeeTypeInfo2.getNumber());
                employeeTypeInfo.setName(employeeTypeInfo2.getName());
            }
            if ((jInfo = (JobInfo)map.get("oldJob")) != null && !StringUtils.isEmpty((String)jInfo.getId().toString())) {
                jobInfo = new JobInfo();
                jobInfo.setId(BOSUuid.read((String)jInfo.getId().toString()));
                jobInfo.setName(jInfo.getName());
                jobInfo.setNumber(jInfo.getNumber());
            }
            if ((jobGrade = (JobGradeInfo)map.get("oldJobGrade")) != null && !StringUtils.isEmpty((String)jobGrade.getId().toString())) {
                jobGradeInfo = new JobGradeInfo();
                jobGradeInfo.setId(BOSUuid.read((String)jobGrade.getId().toString()));
                jobGradeInfo.setName(jobGrade.getName());
            }
            if ((jobLevelInfo2 = (JobLevelInfo)map.get("oldJobLevel")) != null && !StringUtils.isEmpty((String)jobLevelInfo2.getId().toString())) {
                jobLevelInfo = new JobLevelInfo();
                jobLevelInfo.setId(BOSUuid.read((String)jobLevelInfo2.getId().toString()));
                jobLevelInfo.setName(jobLevelInfo2.getName());
            }
            result.put(KEY_PERSON, personInfo);
            result.put(KEY_PERSONHIS, personHisInfo);
            result.put(KEY_POSITIONHIS, positionInfo);
            result.put(KEY_ADMINORGHIS, adminOrgUnitInfo);
            result.put(KEY_COMPANY, adminOrgCompany);
            result.put(KEY_DEPARTMENT, department);
            result.put(KEY_EMPTYPE, employeeTypeInfo);
            result.put(KEY_HRBIZDEFINE, actionInfo);
            result.put(KEY_JOB, jobInfo);
            result.put(KEY_JOBGRADE, jobGradeInfo);
            result.put(KEY_JOBLEVEL, jobLevelInfo);
            result.put(KEY_EMPORGRELATION, empOrgRelationInfo);
        }
        if (personInfo == null) {
            throw new PersonException(PersonException.NO_PERSON);
        }
        return result;
    }

    public static void fillHistory(Context ctx, String personId, Date effect, CoreBaseInfo entryInfo) throws BOSException, EASBizException {
        PositionCollection posColl;
        Map map = null;
        PositionInfo positionInfo = null;
        AdminOrgUnitInfo adminOrgInfo = null;
        AdminOrgUnitInfo companyInfo = null;
        AdminOrgUnitInfo departmentInfo = null;
        EmployeeTypeInfo empTypeInfo = null;
        JobGradeInfo jobGradeInfo = null;
        JobLevelInfo jobLevelInfo = null;
        JobInfo jobInfo = null;
        map = EmpPostExperienceHisHelper.getPersonAllRelationHisMap(ctx, personId, effect);
        if (map == null) {
            return;
        }
        positionInfo = (PositionInfo)map.get(KEY_POSITIONHIS);
        adminOrgInfo = (AdminOrgUnitInfo)map.get(KEY_ADMINORGHIS);
        companyInfo = (AdminOrgUnitInfo)map.get(KEY_COMPANY);
        departmentInfo = (AdminOrgUnitInfo)map.get(KEY_DEPARTMENT);
        empTypeInfo = (EmployeeTypeInfo)map.get(KEY_EMPTYPE);
        jobGradeInfo = (JobGradeInfo)map.get(KEY_JOBGRADE);
        jobLevelInfo = (JobLevelInfo)map.get(KEY_JOBLEVEL);
        jobInfo = (JobInfo)map.get(KEY_JOB);
        adminOrgInfo.setDepartment(departmentInfo);
        positionInfo.setAdminOrgUnit(adminOrgInfo);
        Boolean isMainAssignTypeFlag = true;
        try {
            isMainAssignTypeFlag = EmpPostExperienceHisHelper.isMainAssignType(entryInfo.get("empPosOrgRelation"));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (ORMCoreException e) {
            e.printStackTrace();
        }
        if (isMainAssignTypeFlag.booleanValue()) {
            if (null == entryInfo.get("oldPosition")) {
                entryInfo.put("oldPosition", (Object)positionInfo);
            }
            if (null == entryInfo.get(KEY_POSITIONHIS)) {
                entryInfo.put(KEY_POSITIONHIS, (Object)positionInfo);
            }
            if (null == entryInfo.get("newPosition")) {
                entryInfo.put("newPosition", (Object)positionInfo);
            }
            if (null == entryInfo.get("oldAdminOrg")) {
                entryInfo.put("oldAdminOrg", (Object)adminOrgInfo);
            }
            if (null == entryInfo.get("oldAdmin")) {
                entryInfo.put("oldAdmin", (Object)adminOrgInfo);
            }
            if (null == entryInfo.get(KEY_ADMINORGHIS)) {
                entryInfo.put(KEY_ADMINORGHIS, (Object)adminOrgInfo);
            }
            if (null == entryInfo.get("newAdmin")) {
                entryInfo.put("newAdmin", (Object)adminOrgInfo);
            }
            if (null == entryInfo.get("oldCompany")) {
                entryInfo.put("oldCompany", (Object)companyInfo);
            }
            if (null == entryInfo.get(KEY_COMPANY)) {
                entryInfo.put(KEY_COMPANY, (Object)companyInfo);
            }
        }
        if (null == entryInfo.get("oldEmpType")) {
            entryInfo.put("oldEmpType", (Object)empTypeInfo);
        }
        if (null == entryInfo.get(KEY_EMPTYPE)) {
            entryInfo.put(KEY_EMPTYPE, (Object)empTypeInfo);
        }
        if (null == entryInfo.get("oldLaborRelState")) {
            entryInfo.put("oldLaborRelState", (Object)empTypeInfo);
        }
        if (null == entryInfo.get("newLaborRelState")) {
            entryInfo.put("newLaborRelState", (Object)empTypeInfo);
        }
        if (null == entryInfo.get("oldJob")) {
            entryInfo.put("oldJob", (Object)jobInfo);
        }
        if (null == entryInfo.get(KEY_JOB) && null != entryInfo.get(KEY_POSITIONHIS) && (posColl = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection("select job.id where id = '" + ((PositionInfo)entryInfo.get(KEY_POSITIONHIS)).getId().toString() + "'")).size() > 0) {
            entryInfo.put(KEY_JOB, (Object)posColl.get(0).getJob());
        }
        if (null == entryInfo.get("oldJobGrade")) {
            entryInfo.put("oldJobGrade", (Object)jobGradeInfo);
        }
        if (null == entryInfo.get(KEY_JOBGRADE)) {
            entryInfo.put(KEY_JOBGRADE, (Object)jobGradeInfo);
        }
        if (null == entryInfo.get("oldJobLevel")) {
            entryInfo.put("oldJobLevel", (Object)jobLevelInfo);
        }
        if (null == entryInfo.get(KEY_JOBLEVEL)) {
            entryInfo.put(KEY_JOBLEVEL, (Object)jobLevelInfo);
        }
        if (entryInfo.get("oldAdminOrg") != null) {
            AdminOrgUnitInfo oldAdminOrg = (AdminOrgUnitInfo)entryInfo.get("oldAdminOrg");
            oldAdminOrg.setDepartment(departmentInfo);
            EmpPostExperienceHisHelper.getOldDepartmentDispalyName(ctx, entryInfo);
        }
    }

    private static void getOldDepartmentDispalyName(Context ctx, CoreBaseInfo entryInfo) throws BOSException {
        AdminOrgUnitInfo oldAdminOrg = (AdminOrgUnitInfo)entryInfo.get("oldAdminOrg");
        if (oldAdminOrg.getDepartment() != null && oldAdminOrg.getDepartment().getId() != null) {
            String oldDepartmentId = oldAdminOrg.getDepartment().getId().toString();
            String l = LocaleUtils.getShortCode((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT adminExtend.FDEPDISPLAYNAME_").append(l).append(" DEPDISPLAYNAME ");
            sql.append("FROM T_HR_SHRAdminOrgUnitExtend adminExtend ");
            sql.append("where adminExtend.FADMINORGUNITID=").append("?");
            Object[] params = new Object[]{oldDepartmentId};
            String displayName = null;
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
                while (rs.next()) {
                    displayName = rs.getString("DEPDISPLAYNAME");
                }
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            entryInfo.put("old_department_display", (Object)displayName);
        }
    }

    private static boolean isMainAssignType(Object object) throws BOSException, EASBizException {
        if (object == null) {
            return true;
        }
        EmpPosOrgRelationInfo info = (EmpPosOrgRelationInfo)object;
        if (info.getId() == null) {
            return true;
        }
        String id = info.getId().toString();
        EmpPosOrgRelationInfo info2 = EmpPosOrgRelationFactory.getRemoteInstance().getEmpPosOrgRelationInfo((IObjectPK)new ObjectUuidPK(id));
        if (info2 == null) {
            return true;
        }
        return info2.getAssignType().equals((Object)AssignTypeEnum.MAIN);
    }

    @Deprecated
    public static String getPersonPrimaryPositionHisQuerySQL(Context ctx) {
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append(" select person.fname_" + l + " personName, person.fid personId,person.fnumber personNumber,").append("personHis.FHistoryRelateID as personHisId , personHis.fname_" + l + " as personHisName, personHis.fnumber as personHisNumber, personHis.fcell as personHisCell, ").append(" personHis.FGender as personHisgender , personHis.FIdCardNO as personHisIdCardNO,personHis.FPassportNO as personHisPassportNO,").append(" relation.fid relationId ,relation.FEFFDT relationEFFDT,relation.FLEFFDT relationLEFFDT,relation.FAssignType relationAssignType,").append(" action.fid actionId,action.fname_" + l + " actionName,action.fnumber actionNumber,").append(" positionHis.FHistoryRelateID as posId,positionHis.fnumber as posNumber,positionHis.fname_" + l + " as posName,").append(" adminOrgHis.FHistoryRelateID as adminOrgId , adminOrgHis.fname_" + l + " as adminOrgName, ").append(" adminOrgHis.FNUMBER as adminOrgNumber , adminOrgHis.FLongNumber as adminOrgLongNumber ,").append(" adminOrgHis.FDISPLAYNAME_" + l + " as adminDisplayName, ").append(" company.fid as companyId , company.fname_" + l + " as companyName, ").append(" company.FNUMBER as companyNumber , company.FLongNumber as companyLongNumber ,").append(" company.FDISPLAYNAME_" + l + " as companyDisplayName, ").append(" department.fid as departmentId , department.fname_" + l + " as departmentName, ").append(" department.FNUMBER as departmentNumber , department.FLongNumber as departmentLongNumber ,").append(" department.FDISPLAYNAME_" + l + " as departmentDisplayName, ").append(" hrOrgUnit.fid as hrOrgUnitId, hrOrgUnit.fname_" + l + " as hrOrgUnitName, ").append(" empType.fid as empTypeID, ").append(" empType.fnumber as empTypeNumber, ").append(" empType.fname_" + l + " as empTypeName, ").append(" oldJob.fid as jobId , oldJob.fname_" + l + " as jobName , oldJob.fnumber as jobNumber,").append(" oldJobGrade.fid as jobGradeId , oldJobGrade.fname_" + l + " as jobGradeName ,").append(" oldJobLevel.fid as jobLevelId , oldJobLevel.fname_" + l + " as jobLevelName ,").append(" laborRelationHis.FEmployerUnitID as employerUnitId, laborRelationHis.fplanFormalDate planFormalDate, ").append(" laborRelationHis.FTryoutMonth tryoutMonth,laborRelationHis.fenterDate enterDate ").append(" from T_BD_PERSON person").append(" left join t_hr_emporgrelation relation on person.fid = relation.fpersonid  ").append("  and relation.Fisinner=1 and relation.FAssignType= ").append(1).append("\tand  relation.FEFFDT<=").append("?").append("\tand  relation.FLEFFDT>=").append("?").append(" left join  T_BD_PersonHis personHis on personHis.FHistoryRelateID = person.fid ").append(" \tand personHis.FEFFDT<=").append("?").append(" \tand personHis.FLEFFDT<=").append("?").append(" left join T_HR_HRBIZDEFINE action on relation.FActionID = action.fid").append("\tleft join t_hr_emplaborRelationHis laborRelationHis on relation.FlaborRelationID = laborRelationHis.FHistoryRelateID and laborRelationHis.FStartDateTime <=relation.FEndDateTime and relation.FEndDateTime<=laborRelationHis.FEndDateTime").append("\tleft join t_org_positionhis positionHis on relation.FPositionID = positionHis.FHistoryRelateID and positionHis.FEFFDT<=relation.FLEFFDT and relation.FLEFFDT<=positionHis.FLEFFDT").append("\tleft join T_ORG_AdminHis adminOrgHis on relation.FADMINORGID =adminOrgHis.FHistoryRelateID and adminOrgHis.FEFFDT<=relation.FLEFFDT and relation.FLEFFDT<=adminOrgHis.FLEFFDT ").append("\tleft join T_ORG_Admin company on adminOrgHis.FCompanyID =company.fid").append("\tleft join T_ORG_Admin department on adminOrgHis.FDepartmentID =department.fid").append("\tleft join T_HR_PersonPositionHis ppHis on ppHis.fpersonid =relation.fpersonid and ppHis.FStartDateTime <=relation.FEndDateTime and relation.FEndDateTime<=ppHis.FEndDateTime").append("\tleft join T_HR_BDEmployeeType empType on empType.fid =laborRelationHis.FLaborRelationStateID").append("\tleft join T_ORG_Job oldJob on oldJob.fid =positionHis.FJobID").append("   left join T_HR_EmpPostRank empPostRank on empPostRank.fpersonId = relation.fpersonid and empPostRank.FEFFDT<=relation.FLEFFDT and relation.FLEFFDT<=empPostRank.FLEFFDT ").append("\tleft join T_HR_JobGrade oldJobGrade on oldJobGrade.fid = empPostRank.FJobGradeID ").append("   left join T_HR_JobLevel oldJobLevel on oldJobLevel.fid = empPostRank.FJobLevelID ").append("\tleft join T_HR_PersonBURelation personBURel on ( personBURel.FEmpOrgRelationID = relation.fid").append("\tand personBURel.FBizManageTypeID = '").append("SGuJm3nXW0GshQfKRXenomWJ1dE=").append("' and personBURel.Fstate=1)").append("\tleft join T_ORG_HRO hrOrgUnit on personBURel.FHrOrgUnitID = hrOrgUnit.fid").append("\twhere person.fid=").append("?").append("").append("\torder by relation.fisLatestInAday desc");
        return sql.toString();
    }

    private static Map<String, Object> getPersonPrimaryPositionHisQuerySQL(Context ctx, String personId, Date effect) throws BOSException, PersonException {
        AdminOrgUnitInfo adminOrgUnitInfo;
        PositionInfo positionInfo;
        HashMap<String, Object> map = new HashMap<String, Object>();
        PersonCollection pCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("select id,number,name where id ='" + personId + "'");
        if (pCollection.size() <= 0) {
            throw new PersonException(PersonException.NO_PERSON);
        }
        map.put("personInfo", pCollection.get(0));
        PersonHisCollection pHisCollection = PersonHisFactory.getLocalInstance((Context)ctx).getPersonHisCollection("select id,historyRelateID,number,name,cell,gender,idCardNO,passportNO where historyRelateID ='" + personId + "' and effdt<=" + HRUtilExtend.getDateStringWithoutMininuteTs(effect) + " and leffdt>=" + HRUtilExtend.getDateStringWithoutMininuteTs(effect));
        if (pHisCollection.size() > 0) {
            map.put("personHisInfo", pHisCollection.get(0));
        }
        StringBuilder relationOql = new StringBuilder("select id,effdt,leffdt,assignType,endDateTime,action.id,action.name,action.number,laborRelation.id,position.id,position.number,position.name,position.job.id,position.job.name,position.job.number,adminOrg.id,adminOrg.number,adminOrg.name,adminOrg.longNumber,adminOrg.displayName,adminOrg.company.id,adminOrg.company.name,adminOrg.company.number,adminOrg.company.longNumber,adminOrg.company.displayName,adminOrg.department.id,adminOrg.department.name,adminOrg.department.number,adminOrg.department.longNumber,adminOrg.department.displayName where person.id ='").append(personId).append("' and isinner = 1 and assignType =1").append(" and effdt<=").append(HRUtilExtend.getDateStringWithoutMininuteTs(effect)).append(" and leffdt>=").append(HRUtilExtend.getDateStringWithoutMininuteTs(effect)).append(" order by version desc");
        EmpPosOrgRelationInfo empPosOrgRelationInfo = null;
        EmpPosOrgRelationCollection empPosOrgRelationCollection = EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationCollection(relationOql.toString());
        if (empPosOrgRelationCollection.size() > 0) {
            empPosOrgRelationInfo = empPosOrgRelationCollection.get(0);
            map.put("empPosOrgRelationInfo", empPosOrgRelationInfo);
            if (empPosOrgRelationInfo.getAction() != null) {
                map.put("hrBizDefineInfo", empPosOrgRelationInfo.getAction());
            }
        }
        if (empPosOrgRelationInfo == null) {
            Object[] params1 = new Object[]{pCollection.get(0).getName(), HRUtilExtend.getDateStringWithoutMininute(effect)};
            throw new EmployeeException(EmployeeException.EMP_RELATIONS_NULL, params1);
        }
        StringBuilder laborHisOql = new StringBuilder("select id,employerUnit,planFormalDate,tryoutMonth,enterDate,laborRelationState.id,laborRelationState.number,laborRelationState.name where historyRelateID ='").append(empPosOrgRelationInfo.getLaborRelation().getId().toString()).append("' and startDateTime<=").append(HistoryVersionUtil.getDateTimeTs(empPosOrgRelationInfo.getEndDateTime())).append(" and endDateTime  >=").append(HistoryVersionUtil.getDateTimeTs(empPosOrgRelationInfo.getEndDateTime()));
        EmpLaborRelationHisInfo empLaborRelationHisInfo = null;
        EmpLaborRelationHisCollection empLaborRelationHisCollection = EmpLaborRelationHisFactory.getLocalInstance(ctx).getEmpLaborRelationHisCollection(laborHisOql.toString());
        if (empLaborRelationHisCollection.size() > 0) {
            empLaborRelationHisInfo = empLaborRelationHisCollection.get(0);
            map.put("empLaborRelationHisInfo", empLaborRelationHisInfo);
            if (empLaborRelationHisInfo.getLaborRelationState() != null) {
                map.put("employeeTypeInfo", empLaborRelationHisInfo.getLaborRelationState());
            }
        }
        if ((positionInfo = empPosOrgRelationInfo.getPosition()) != null) {
            map.put(KEY_POSITIONHIS, positionInfo);
            if (positionInfo.getJob() != null) {
                map.put("oldJob", positionInfo.getJob());
            }
        }
        if ((adminOrgUnitInfo = empPosOrgRelationInfo.getAdminOrg()) != null) {
            map.put(KEY_ADMINORGHIS, adminOrgUnitInfo);
            if (adminOrgUnitInfo.getCompany() != null) {
                map.put(KEY_COMPANY, adminOrgUnitInfo.getCompany());
            }
            if (adminOrgUnitInfo.getDepartment() != null) {
                map.put(KEY_DEPARTMENT, adminOrgUnitInfo.getDepartment());
            }
        }
        EmpPostRankInfo empPostRankInfo = null;
        StringBuilder empPostRankOql = new StringBuilder("select id,jobGrade.id,jobGrade.name,jobLevel.id,jobLevel.name where person.id ='").append(personId).append("' and effdt<=").append(HRUtilExtend.getDateStringWithoutMininuteTs(effect)).append(" and leffdt>=").append(HRUtilExtend.getDateStringWithoutMininuteTs(effect));
        EmpPostRankCollection empPostRankCollection = EmpPostRankFactory.getLocalInstance((Context)ctx).getEmpPostRankCollection(empPostRankOql.toString());
        if (empPostRankCollection.size() > 0) {
            empPostRankInfo = empPostRankCollection.get(0);
            map.put("empPostRank", empPostRankInfo);
            if (empPostRankInfo.getJobGrade() != null) {
                map.put("oldJobGrade", empPostRankInfo.getJobGrade());
            }
            if (empPostRankInfo.getJobLevel() != null) {
                map.put("oldJobLevel", empPostRankInfo.getJobLevel());
            }
        }
        PersonBURelationInfo personBURelationInfo = null;
        StringBuilder personBURelationOql = new StringBuilder("select id,hrOrgUnit.id,hrOrgUnit.name where empOrgRelation.id ='").append(empPosOrgRelationInfo.getId().toString()).append("' and BizManageType = 'SGuJm3nXW0GshQfKRXenomWJ1dE='").append(" and state>= 1");
        PersonBURelationCollection personBURelationCollection = PersonBURelationFactory.getLocalInstance((Context)ctx).getPersonBURelationCollection(personBURelationOql.toString());
        if (personBURelationCollection.size() > 0) {
            personBURelationInfo = personBURelationCollection.get(0);
            map.put("personBURel", personBURelationInfo);
            if (personBURelationInfo.getHrOrgUnit() != null) {
                map.put("hrOrgUnit", personBURelationInfo.getHrOrgUnit());
            }
        }
        return map;
    }

    private static boolean actionCanAddEmpPostExpHis(Context ctx, HRBizData bizData) throws EASBizException, BOSException {
        HRBizDefineInfo action = bizData.getHrbizDefine();
        if (bizData.getNewPosition() != null && bizData.getNewPosition().getEmployeeType() != null && !bizData.getNewPosition().getEmployeeType().containsKey("inService")) {
            EmployeeTypeInfo empType = bizData.getNewPosition().getEmployeeType();
            empType = EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeInfo((IObjectPK)new ObjectUuidPK(empType.getId()));
            bizData.getNewPosition().setEmployeeType(empType);
        }
        return !"P/OSDCPfQXqU0TB/LQoA6uZovtk=".equals(action.getId().toString()) || !EmployeeTypeEnum.DIMISSION.equals((Object)bizData.getNewPosition().getEmployeeType().getInService()) && !EmployeeTypeEnum.RETIRE.equals((Object)bizData.getNewPosition().getEmployeeType().getInService());
    }
}

