/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.base.EmployeeBaseException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmployeeFenLeiInfo;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRBizDefOutEmpTypeFactory;
import com.kingdee.eas.hr.base.HRBizDefOutEmpTypeInfo;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.WorkRelation;
import com.kingdee.eas.hr.base.app.AbstractEmployeeTypeControllerBean;
import com.kingdee.eas.hr.emp.EmployeeTypeEnum;

public class EmployeeTypeControllerBean
extends AbstractEmployeeTypeControllerBean {
    private static final String SHR24 = "P/OSDCPfQXqU0TB/LQoA6uZovtk=";

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        EmployeeTypeInfo employeeTypeInfo = (EmployeeTypeInfo)model;
        super._update(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmployeeTypeInfo employeeTypeInfo = (EmployeeTypeInfo)model;
        return super._addnew(ctx, (IObjectValue)employeeTypeInfo);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._checkIsSystemEmpType(pk);
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmployeeTypeInfo typeInfo = (EmployeeTypeInfo)model;
        if (WorkRelation.EMPLOYEE.equals((Object)typeInfo.getWorkRelation())) {
            typeInfo.setInService(EmployeeTypeEnum.WORK);
        } else if (WorkRelation.TEMPEMPLOY.equals((Object)typeInfo.getWorkRelation())) {
            typeInfo.setInService(EmployeeTypeEnum.RERETAIN);
        }
        return super._submit(ctx, model);
    }

    protected void _checkIsSystemEmpType(IObjectPK pk) throws EASBizException {
        if (pk == null) {
            return;
        }
        String pkId = pk.toString();
        if (pkId.equals("00000000-0000-0000-0000-000000000001A29E85B3") || pkId.equals("00000000-0000-0000-0000-000000000002A29E85B3")) {
            throw new EmployeeBaseException(EmployeeBaseException.SYSTEM_DATA_CANNOT_CHANGE);
        }
    }

    @Override
    protected String _batchSetEmployeeFenLei(Context ctx, IObjectCollection etColl, IObjectValue fenLeiInfo) throws BOSException, EASBizException {
        StringBuffer errStr = new StringBuffer();
        EmployeeTypeInfo etInfo = null;
        EmployeeTypeCollection etColls = (EmployeeTypeCollection)etColl;
        for (int i = 0; i < etColls.size(); ++i) {
            etInfo = etColls.get(i);
            if (etInfo.getEmployeeFenLei() == null) {
                etInfo.setEmployeeFenLei((EmployeeFenLeiInfo)fenLeiInfo);
                etInfo.put("FENLEI", (Object)Boolean.TRUE);
                this._update(ctx, (IObjectPK)new ObjectUuidPK(etInfo.getId()), (IObjectValue)etInfo);
                continue;
            }
            if (i != 0) {
                errStr.append(",");
                continue;
            }
            errStr.append(etInfo.getName());
        }
        return errStr.toString();
    }

    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizDefine", (Object)SHR24, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("empType", (Object)id, CompareType.EQUALS));
        if (!HRBizDefOutEmpTypeFactory.getLocalInstance(ctx).exists(filter)) {
            HRBizDefOutEmpTypeInfo hrBizDefOutEmpTypeInfo = new HRBizDefOutEmpTypeInfo();
            EmployeeTypeInfo employeeTypeInfo = new EmployeeTypeInfo();
            employeeTypeInfo.setId(BOSUuid.read((String)id));
            hrBizDefOutEmpTypeInfo.setEmpType(employeeTypeInfo);
            HRBizDefineInfo hrBizDefineInfo = new HRBizDefineInfo();
            hrBizDefineInfo.setId(BOSUuid.read((String)SHR24));
            hrBizDefOutEmpTypeInfo.setBizDefine(hrBizDefineInfo);
            HRBizDefOutEmpTypeFactory.getLocalInstance(ctx).addnew(hrBizDefOutEmpTypeInfo);
        }
        super._enable(ctx, id);
    }
}

