/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.base.EnrollSourceInfo;
import com.kingdee.eas.hr.base.app.AbstractEnrollSourceControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class EnrollSourceControllerBean
extends AbstractEnrollSourceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.EnrollSourceControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameBlank(ctx, model);
        this._checkNumberBlank(ctx, model);
        this.checkNumberDup(ctx, model);
        this.checkNameDup(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameBlank(ctx, model);
        this._checkNumberBlank(ctx, model);
        this.checkNumberDup(ctx, model);
        this.checkNameDup(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    @Override
    protected void _sort(Context ctx, String[] ids, int[] orders) throws BOSException, EASBizException {
        IMetaDataLoader metaData = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String tableName = metaData.getEntity(this.getBOSType()).getTable().getName();
        String sql = "UPDATE " + tableName + " SET FIndex=? WHERE FID=?";
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql);
            for (int i = 0; i < ids.length; ++i) {
                pstmt.setInt(1, orders[i]);
                pstmt.setString(2, ids[i]);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)con);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (pk == null || model == null) {
            return;
        }
        EnrollSourceInfo info = (EnrollSourceInfo)this.getValue(ctx, pk);
        info.setEnable(true);
        this._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (pk == null || model == null) {
            return;
        }
        EnrollSourceInfo info = (EnrollSourceInfo)this.getValue(ctx, pk);
        info.setEnable(false);
        this._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info);
    }
}

