/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.IServiceManager;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.app.AbstractHROrgContextManagerFacadeControllerBean;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.org.OrgHRCommonFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class HROrgContextManagerFacadeControllerBean
extends AbstractHROrgContextManagerFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.HROrgContextManagerFacadeControllerBean");

    @Override
    protected String _getPermissionItem(Context ctx, BOSObjectType metaType, IMetaDataPK boPK) throws BOSException, EASBizException {
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(ctx);
        ServiceBindItem[] bind = binder.getServiceBindings(metaType, boPK);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                String permItemName;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)(permItemName = bind[i].getName()))) continue;
                return permItemName;
            }
        }
        return null;
    }

    @Override
    protected String _getUIPermissiionItem(Context ctx, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        IServiceManager manager;
        IServiceBinder binder;
        ServiceBindItem[] bind;
        String permItemName = null;
        if (uiPK != null && actionPK != null && (bind = (binder = (manager = ServiceManagerFactory.getServiceManager()).getServiceBinder(ctx)).getServiceBindings(MetaDataTypeList.UIOBJECT, uiPK, actionPK)) != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)bind[i].getName())) continue;
                permItemName = bind[i].getName();
            }
        }
        return permItemName;
    }

    @Override
    protected AdminOrgUnitInfo _getAdminForHRandUserOrgRange(Context ctx, String userID, HashSet hrOrgIDs) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)userID)) {
            return null;
        }
        StringBuffer sql = new StringBuffer("SELECT T_ORG_Admin.fid,T_ORG_Admin.fname_");
        sql.append(ctx.getLocale());
        sql.append(",T_ORG_Admin.fdisplayName_");
        sql.append(ctx.getLocale());
        sql.append(",T_ORG_Admin.fnumber,T_ORG_Admin.FLongNumber,T_ORG_Admin.FAddressID ");
        sql.append(" FROM T_ORG_Admin ");
        sql.append(" INNER JOIN T_PM_OrgRange ON T_ORG_Admin.FID = T_PM_OrgRange.FOrgID ");
        if (hrOrgIDs != null && hrOrgIDs.size() > 0) {
            sql.append(" INNER JOIN T_ORG_UnitRelation ON T_ORG_UnitRelation.FFromUnitID = T_ORG_Admin.FID");
        }
        sql.append(" WHERE T_ORG_Admin.FIsSealUp = 0 and T_PM_OrgRange.FType = 20 AND T_PM_OrgRange.FUserID='");
        sql.append(userID);
        if (hrOrgIDs != null && hrOrgIDs.size() > 0) {
            sql.append("' AND T_ORG_UnitRelation.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5' AND T_ORG_UnitRelation.FToUnitID IN (");
            Iterator iter = hrOrgIDs.iterator();
            while (iter.hasNext()) {
                sql.append("'");
                sql.append(iter.next());
                if (!iter.hasNext()) continue;
                sql.append("',");
            }
            sql.append("') ORDER BY FLevel,FLongNumber ");
        } else {
            sql.append("' ORDER BY FLevel,FLongNumber ");
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
                adminInfo.setId(BOSUuid.read((String)rows.getString("fid")));
                adminInfo.setName(rows.getString("fname_" + ctx.getLocale()));
                adminInfo.setDisplayName(rows.getString("fdisplayName_" + ctx.getLocale()));
                adminInfo.setNumber(rows.getString("fnumber"));
                adminInfo.setLongNumber(rows.getString("flongnumber"));
                AddressInfo adInfo = new AddressInfo();
                if (!StringUtils.isEmpty((String)rows.getString("FAddressID"))) {
                    adInfo.setId(BOSUuid.read((String)rows.getString("FAddressID")));
                }
                return adminInfo;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected HROrgUnitInfo _getHROByAdminOrgUnitID(Context ctx, String orgID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgID)) {
            return null;
        }
        StringBuffer sql = new StringBuffer("SELECT H.fid,H.fname_");
        sql.append(ctx.getLocale());
        sql.append(",H.fnumber,H.FLongNumber,H.FControlUnitID ");
        sql.append(" FROM T_ORG_HRO H ");
        sql.append(" INNER JOIN T_ORG_UnitRelation U ON U.FToUnitID = H.FID ");
        sql.append(" WHERE U.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5' ");
        sql.append(" AND U.FFromUnitID = '");
        sql.append(orgID);
        sql.append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                HROrgUnitInfo hrOrgInfo = new HROrgUnitInfo();
                hrOrgInfo.setId(BOSUuid.read((String)rows.getString("fid")));
                hrOrgInfo.setName(rows.getString("fname_" + ctx.getLocale()));
                hrOrgInfo.setNumber(rows.getString("fnumber"));
                hrOrgInfo.setLongNumber(rows.getString("flongnumber"));
                String cuID = rows.getString("FControlUnitID");
                if (cuID != null) {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("id"));
                    selector.add(new SelectorItemInfo("name"));
                    selector.add(new SelectorItemInfo("longNumber"));
                    CtrlUnitInfo cu = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(cuID), selector);
                    hrOrgInfo.setCU(cu);
                }
                return hrOrgInfo;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected HROrgUnitInfo _getLegalityHROrg(Context ctx, HROrgUnitInfo hrOrgUnit, BOSObjectType metaDataType, IMetaDataPK metaPK) throws BOSException, EASBizException {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (hrOrgUnit == null || !hrOrgUnit.isIsBizUnit() || user == null) {
            return null;
        }
        String userID = user.getId().toString();
        try {
            HRInitFactory.getLocalInstance(ctx).isInitFinish(hrOrgUnit);
        }
        catch (Exception e) {
            return null;
        }
        if (metaDataType != null && metaPK != null) {
            String perItem = this._getPermissionItem(ctx, metaDataType, metaPK);
            if (StringUtils.isEmpty((String)perItem)) {
                return hrOrgUnit;
            }
            if (!PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(userID), (IObjectPK)new ObjectUuidPK(hrOrgUnit.getId()), perItem)) {
                return null;
            }
        }
        return hrOrgUnit;
    }

    @Override
    protected List _getUserOrgRangePerson(Context ctx, FilterInfo filterInfo) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app.UserOrgRangeByDepQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        String id = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)id));
        filter.getFilterItems().add(new FilterItemInfo("orgRange.type", (Object)20));
        filter.setMaskString("#0 and #1");
        if (filterInfo != null && filterInfo.getFilterItems().size() > 0) {
            filter.mergeFilter(filterInfo, "and");
        }
        viewInfo.setFilter(filter);
        queryExcu.setObjectView(viewInfo);
        String sql = queryExcu.getSQL();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet != null && rowSet.size() > 0) {
            ArrayList<PersonInfo> result = new ArrayList<PersonInfo>();
            PersonInfo person = null;
            try {
                while (rowSet.next()) {
                    person = new PersonInfo();
                    person.setId(BOSUuid.read((String)rowSet.getString("person.id")));
                    person.setNumber(rowSet.getString("person.number"));
                    person.setName(rowSet.getString("person.name"));
                    result.add(person);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            return result;
        }
        return null;
    }

    @Override
    protected HROrgUnitInfo _getHROByPerson(Context ctx, String personID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personID)) {
            return null;
        }
        String oql = "select id,personDep.id,person.id where person.id = '" + personID + "'";
        PersonPositionCollection ppCol = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(oql);
        if (ppCol != null && ppCol.size() > 0 && ppCol.get(0).getPersonDep() != null) {
            return this._getHROByAdminOrgUnitID(ctx, ppCol.get(0).getPersonDep().getId().toString());
        }
        return null;
    }

    @Override
    protected CtrlUnitInfo _getCUByHRO(Context ctx, HROrgUnitInfo hrOrg) throws BOSException, EASBizException {
        if (hrOrg == null) {
            return null;
        }
        if (hrOrg.getCU() != null) {
            return hrOrg.getCU();
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        HROrgUnitInfo hrOrgInfo = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(hrOrg.getId()), sic);
        if (hrOrgInfo != null) {
            return hrOrgInfo.getCU();
        }
        return null;
    }

    @Override
    protected HROrgUnitInfo _getHROByPosition(Context ctx, String positionID) throws BOSException, EASBizException {
        return OrgHRCommonFactory.getLocalInstance((Context)ctx).getPositionOrgHRO(positionID);
    }

    @Override
    protected Set _getHroSetOfCurrentUser(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        sql.append("select forgId from T_PM_OrgRange where ftype = ");
        sql.append(10);
        sql.append("and fuserid = '");
        sql.append(userID);
        sql.append("' ");
        sql.append(" and forgId in (select fid from T_ORG_HRO)");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> set = new HashSet<String>();
        try {
            while (rows.next()) {
                set.add(rows.getString("forgId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return set;
    }
}

