/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.hr.base.HREntityPropertyInfo;
import com.kingdee.eas.hr.base.HRSelfPageInfo;
import com.kingdee.eas.hr.base.app.AbstractHRSelfPageControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.ml.util.SHRServerResource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class HRSelfPageControllerBean
extends AbstractHRSelfPageControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.HRSelfPageControllerBean");

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void checkLNForTree(Context ctx, TreeBaseInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRSelfPageInfo info = (HRSelfPageInfo)model;
        if (info.get("Page_PropertyList") != null) {
            ArrayList propertyList = (ArrayList)info.get("Page_PropertyList");
            if (info.getType().getValue() == 1) {
                info.setPageContent(this.convertListToXML(ctx, info, propertyList));
            } else {
                info.setPageContent(this.convertListToXML2(ctx, info, propertyList));
            }
        }
        return super._submit(ctx, (IObjectValue)info);
    }

    private String convertListToXML(Context ctx, HRSelfPageInfo info, ArrayList propertyList) throws BOSException, EASBizException {
        Document doc = new Document();
        Element root = new Element("ui");
        doc.setRootElement(root);
        Element fieldList = new Element("fieldList");
        String sql = "SELECT FEntityName,FEntityInfoName,FType,FQueryInfo,FSelector FROM T_HR_F7Info";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
        HREntityPropertyInfo epInfo = null;
        EntityObjectInfo entityInfo = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        HashMap entityMap = new HashMap();
        boolean isEnable = false;
        int size = propertyList.size();
        for (int i = 0; i < size; ++i) {
            epInfo = (HREntityPropertyInfo)propertyList.get(i);
            Element field = new Element("field");
            field.addContent((Content)new Element("propertyName").setText(epInfo.getPropertyName()));
            field.addContent((Content)new Element("propertyAlias").setText(epInfo.getPropertyAlias()));
            field.addContent((Content)new Element("propertyTag").setText(epInfo.getPropertyTag()));
            field.addContent((Content)new Element("colspan").setText(epInfo.getColspan() + ""));
            field.addContent((Content)new Element("rowspan").setText(epInfo.getRowspan() + ""));
            field.addContent((Content)new Element("instructions").setText(epInfo.getInstructions()));
            field.addContent((Content)new Element("notNull").setText(Boolean.toString(epInfo.isNotNull())));
            field.addContent((Content)new Element("enable").setText(Boolean.toString(epInfo.isEnable())));
            field.addContent((Content)new Element("isCheck").setText(Boolean.toString(epInfo.isCheck())));
            field.addContent((Content)new Element("isComplete").setText(Boolean.toString(epInfo.isComplete())));
            Element dataType = new Element("dataType");
            field.addContent((Content)dataType);
            entityInfo = entityMap.get(epInfo.getEntityName()) == null ? loader.getEntity((IMetaDataPK)new MetaDataPK(epInfo.getEntityName())) : (EntityObjectInfo)entityMap.get(epInfo.getEntityName());
            PropertyInfo propertyInfo = entityInfo.getPropertyByName(epInfo.getPropertyName());
            if (propertyInfo instanceof OwnPropertyInfo) {
                dataType.addContent((Content)new Element("name").setText(((OwnPropertyInfo)propertyInfo).getDataType().getName()));
                if (((OwnPropertyInfo)propertyInfo).getDataType().equals((Object)DataType.STRING)) {
                    int stringLength = ((OwnPropertyInfo)propertyInfo).getMappingField().getLength();
                    dataType.addContent((Content)new Element("length").setText(Integer.toString(stringLength)));
                    if (((OwnPropertyInfo)propertyInfo).isMultilingual()) {
                        dataType.addContent((Content)new Element("isMultiLang").setText(String.valueOf(((OwnPropertyInfo)propertyInfo).isMultilingual())));
                    }
                } else if (((OwnPropertyInfo)propertyInfo).getDataType().equals((Object)DataType.ENUM)) {
                    dataType.addContent((Content)new Element("enumName").setText(((OwnPropertyInfo)propertyInfo).getEnumType().getFullName()));
                }
            }
            if (propertyInfo instanceof LinkPropertyInfo) {
                this.addF7Info(dataType, rows, ((LinkPropertyInfo)propertyInfo).getRelationship().getSupplierObject());
            }
            fieldList.addContent((Content)field);
            if (!epInfo.isEnable()) continue;
            isEnable = true;
        }
        Element toolbar = new Element("toolbar");
        root.addContent((Content)toolbar);
        if (isEnable) {
            Element button = new Element("button");
            button.addContent((Content)new Element("name").setText("btnSave"));
            button.addContent((Content)new Element("displayName").setText(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label107", (Context)ctx)));
            button.addContent((Content)new Element("tagClass").setText("btn blue"));
            button.addContent((Content)new Element("actionBinding").setText("saveAction"));
            button.addContent((Content)new Element("displayCase").setText("edit"));
            toolbar.addContent((Content)button);
            Element button2 = new Element("button");
            button2.addContent((Content)new Element("name").setText("btnCancel"));
            button2.addContent((Content)new Element("displayName").setText(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label108", (Context)ctx)));
            button2.addContent((Content)new Element("tagClass").setText("btn"));
            button2.addContent((Content)new Element("actionBinding").setText("cancelAction"));
            button2.addContent((Content)new Element("displayCase").setText("edit"));
            toolbar.addContent((Content)button2);
            Element button3 = new Element("button");
            button3.addContent((Content)new Element("name").setText("btnEdit"));
            button3.addContent((Content)new Element("displayName").setText(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label109", (Context)ctx)));
            button3.addContent((Content)new Element("iconCls").setText("btn-edit"));
            button3.addContent((Content)new Element("actionBinding").setText("editAction"));
            button3.addContent((Content)new Element("displayCase").setText("read"));
            button3.addContent((Content)new Element("type").setText("iconButton"));
            toolbar.addContent((Content)button3);
        }
        root.addContent((Content)fieldList);
        XMLOutputter outp = new XMLOutputter();
        Format format = Format.getCompactFormat();
        format.setEncoding("utf-8");
        return outp.outputString(doc);
    }

    private String convertListToXML2(Context ctx, HRSelfPageInfo info, ArrayList propertyList) throws BOSException, EASBizException {
        Document doc = new Document();
        Element root = new Element("ui");
        doc.setRootElement(root);
        Element fieldList = new Element("fieldList");
        String sql = "SELECT FEntityName,FEntityInfoName,FType,FQueryInfo,FSelector FROM T_HR_F7Info";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
        HREntityPropertyInfo epInfo = null;
        EntityObjectInfo entityInfo = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        HashMap entityMap = new HashMap();
        boolean isEnable = false;
        int size = propertyList.size();
        for (int i = 0; i < size; ++i) {
            epInfo = (HREntityPropertyInfo)propertyList.get(i);
            Element field = new Element("field");
            field.addContent((Content)new Element("propertyName").setText(epInfo.getPropertyName()));
            field.addContent((Content)new Element("propertyAlias").setText(epInfo.getPropertyAlias()));
            field.addContent((Content)new Element("propertyTag").setText(epInfo.getPropertyTag()));
            field.addContent((Content)new Element("colspan").setText(epInfo.getColspan() + ""));
            field.addContent((Content)new Element("rowspan").setText(epInfo.getRowspan() + ""));
            field.addContent((Content)new Element("instructions").setText(epInfo.getInstructions()));
            field.addContent((Content)new Element("notNull").setText(Boolean.toString(epInfo.isNotNull())));
            field.addContent((Content)new Element("enable").setText(Boolean.toString(epInfo.isEnable())));
            Element dataType = new Element("dataType");
            field.addContent((Content)dataType);
            entityInfo = entityMap.get(epInfo.getEntityName()) == null ? loader.getEntity((IMetaDataPK)new MetaDataPK(epInfo.getEntityName())) : (EntityObjectInfo)entityMap.get(epInfo.getEntityName());
            PropertyInfo propertyInfo = entityInfo.getPropertyByName(epInfo.getPropertyName());
            if (propertyInfo instanceof OwnPropertyInfo) {
                dataType.addContent((Content)new Element("name").setText(((OwnPropertyInfo)propertyInfo).getDataType().getName()));
                if (((OwnPropertyInfo)propertyInfo).getDataType().equals((Object)DataType.STRING)) {
                    int stringLength = ((OwnPropertyInfo)propertyInfo).getMappingField().getLength();
                    dataType.addContent((Content)new Element("length").setText(Integer.toString(stringLength)));
                    if (((OwnPropertyInfo)propertyInfo).isMultilingual()) {
                        dataType.addContent((Content)new Element("isMultiLang").setText(String.valueOf(((OwnPropertyInfo)propertyInfo).isMultilingual())));
                    }
                } else if (((OwnPropertyInfo)propertyInfo).getDataType().equals((Object)DataType.ENUM)) {
                    dataType.addContent((Content)new Element("enumName").setText(((OwnPropertyInfo)propertyInfo).getEnumType().getFullName()));
                }
            }
            if (propertyInfo instanceof LinkPropertyInfo) {
                this.addF7Info(dataType, rows, ((LinkPropertyInfo)propertyInfo).getRelationship().getSupplierObject());
            }
            fieldList.addContent((Content)field);
            if (!epInfo.isEnable()) continue;
            isEnable = true;
        }
        Element toolbar = new Element("toolbar");
        root.addContent((Content)toolbar);
        if (isEnable) {
            Element button = new Element("button");
            button.addContent((Content)new Element("name").setText("btnSave"));
            button.addContent((Content)new Element("displayName").setText(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label107", (Context)ctx)));
            button.addContent((Content)new Element("tagClass").setText("btn blue"));
            button.addContent((Content)new Element("actionBinding").setText("saveAction"));
            button.addContent((Content)new Element("displayCase").setText("edit"));
            toolbar.addContent((Content)button);
            Element button2 = new Element("button");
            button2.addContent((Content)new Element("name").setText("btnCancel"));
            button2.addContent((Content)new Element("displayName").setText(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label108", (Context)ctx)));
            button2.addContent((Content)new Element("tagClass").setText("btn"));
            button2.addContent((Content)new Element("actionBinding").setText("cancelAction"));
            button2.addContent((Content)new Element("displayCase").setText("edit"));
            toolbar.addContent((Content)button2);
            Element button3 = new Element("button");
            button3.addContent((Content)new Element("name").setText("btnEdit"));
            button3.addContent((Content)new Element("displayName").setText(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label109", (Context)ctx)));
            button3.addContent((Content)new Element("iconCls").setText("btn-edit"));
            button3.addContent((Content)new Element("actionBinding").setText("editAction"));
            button3.addContent((Content)new Element("displayCase").setText("read"));
            button3.addContent((Content)new Element("type").setText("iconButton"));
            toolbar.addContent((Content)button3);
            Element button4 = new Element("button");
            button4.addContent((Content)new Element("name").setText("btnAddNew"));
            button4.addContent((Content)new Element("displayName").setText(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label110", (Context)ctx)));
            button4.addContent((Content)new Element("iconCls").setText("btn-addNew"));
            button4.addContent((Content)new Element("actionBinding").setText("addNewAction"));
            button4.addContent((Content)new Element("displayCase").setText("read"));
            button4.addContent((Content)new Element("type").setText("iconButton"));
            toolbar.addContent((Content)button4);
            Element button5 = new Element("button");
            button5.addContent((Content)new Element("name").setText("btnRemove"));
            button5.addContent((Content)new Element("displayName").setText(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label134", (Context)ctx)));
            button5.addContent((Content)new Element("iconCls").setText("btn-remove"));
            button5.addContent((Content)new Element("actionBinding").setText("removeAction"));
            button5.addContent((Content)new Element("displayCase").setText("read"));
            button5.addContent((Content)new Element("type").setText("iconButton"));
            toolbar.addContent((Content)button5);
        }
        root.addContent((Content)fieldList);
        XMLOutputter outp = new XMLOutputter();
        Format format = Format.getCompactFormat();
        format.setEncoding("utf-8");
        return outp.outputString(doc);
    }

    private void addF7Info(Element dataType, IRowSet rows, EntityObjectInfo entityObjectInfo) throws BOSException, EASBizException {
        try {
            String defaultF7Query;
            rows.beforeFirst();
            boolean hasF7Info = false;
            String entityName = entityObjectInfo.getFullName();
            while (rows.next()) {
                if (!rows.getString("FEntityName").equals(entityName)) continue;
                if (rows.getInt("FType") == 0) {
                    dataType.addContent((Content)new Element("name").setText("CommonF7"));
                } else {
                    dataType.addContent((Content)new Element("name").setText("CustomF7"));
                    dataType.addContent((Content)new Element("selector").setText(rows.getString("FSelector")));
                }
                dataType.addContent((Content)new Element("queryInfo").setText(rows.getString("FQueryInfo")));
                dataType.addContent((Content)new Element("refEntity").setText(rows.getString("FEntityInfoName")));
                hasF7Info = true;
                break;
            }
            if (!hasF7Info && (defaultF7Query = entityObjectInfo.getExtendedProperty("defaultF7Query")) != null) {
                dataType.addContent((Content)new Element("name").setText("CommonF7"));
                dataType.addContent((Content)new Element("refEntity").setText(entityObjectInfo.getObjectValueClass()));
                dataType.addContent((Content)new Element("queryInfo").setText(defaultF7Query));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

