/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.PersonBlackListCollection;
import com.kingdee.eas.hr.base.PersonBlackListFactory;
import com.kingdee.eas.hr.base.PersonBlackListInfo;
import com.kingdee.eas.hr.base.SourceEnum;
import com.kingdee.eas.hr.base.StateEnum;
import com.kingdee.eas.hr.base.app.AbstractPersonBlackListControllerBean;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.app.util.PersonBlackListUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class PersonBlackListControllerBean
extends AbstractPersonBlackListControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.PersonBlackListControllerBean");

    private IObjectPK checkRepeat(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PersonBlackListInfo info = (PersonBlackListInfo)model;
        PersonBlackListCollection colls = new PersonBlackListCollection();
        String oql = "";
        String wSql = PersonBlackListUtil.getBlackListWhereSql((String)info.getIdCardNO(), (String)info.getPassportNO());
        if (StringUtils.isEmpty((String)wSql)) {
            return null;
        }
        oql = " where " + wSql;
        colls = PersonBlackListFactory.getLocalInstance(ctx).getPersonBlackListCollection(oql);
        PersonBlackListInfo tempInfo = null;
        for (int i = 0; i < colls.size(); ++i) {
            tempInfo = (PersonBlackListInfo)colls.getObject(i);
            if (tempInfo.getSource().equals((Object)SourceEnum.USER_MOVE)) continue;
            throw new EmployeeException(EmployeeException.REPEATBLACKLIST);
        }
        if (info.getJoinReason() == null) {
            throw new EmployeeException(EmployeeException.BLACKJOINREASONEMPTY);
        }
        if (tempInfo != null && tempInfo.getSource().equals((Object)SourceEnum.USER_MOVE)) {
            tempInfo.setAvailable(true);
            tempInfo.setJoinReason(info.getJoinReason());
            tempInfo.setJoinDate(info.getJoinDate());
            tempInfo.setDescription(info.getDescription());
            tempInfo.setAddPersonId(info.getAddPersonId());
            tempInfo.setAddPersonName(info.getAddPersonName());
            if (info.getPerson() != null || info.get("IS_FROM_PREENTRY") != null) {
                tempInfo.setSource(SourceEnum.USER_ADD);
            } else {
                tempInfo.setSource(SourceEnum.OUTSYSTEM_ADD);
            }
            tempInfo.setAvailable(Boolean.TRUE);
            tempInfo.setState(StateEnum.ENABLE);
            this.addOperator(ctx, (IObjectValue)tempInfo);
            if (!StringUtils.isEmpty((String)info.getEntryId())) {
                tempInfo.setEntryId(info.getEntryId());
            }
            PersonBlackListFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(tempInfo.getId().toString()), (CoreBaseInfo)tempInfo);
            return new ObjectUuidPK(tempInfo.getId().toString());
        }
        return null;
    }

    private void checkRepeat(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        for (int i = 0; i < colls.size(); ++i) {
            PersonBlackListInfo info = (PersonBlackListInfo)colls.getObject(i);
            IObjectPK pk = this.checkRepeat(ctx, (IObjectValue)info);
            if (pk == null) continue;
            colls.removeObject((Object)pk);
        }
    }

    private void addOperator(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PersonBlackListInfo info = (PersonBlackListInfo)model;
        UserInfo userInfo = null;
        try {
            userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String personId = "";
        PersonInfo personinfo = null;
        if (userInfo != null && userInfo.getPerson() != null && StringUtil.isEmpty((String)info.getAddPersonId())) {
            personId = userInfo.getPerson().getId().toString();
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            PersonCollection personCollection = iPerson.getPersonCollection("where id='" + personId + "'");
            if (null != personCollection.get(0)) {
                personinfo = personCollection.get(0);
            }
            if (personinfo != null) {
                info.setAddPersonId(personinfo.getId().toString());
                info.setAddPersonName(personinfo.getName());
            }
        }
    }

    private void updatePersonName(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PersonBlackListInfo info = (PersonBlackListInfo)model;
        PersonInfo pi = info.getPerson();
        this.addOperator(ctx, model);
        if (pi == null) {
            return;
        }
        BOSUuid pid = pi.getId();
        if (pid == null) {
            return;
        }
        IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
        if (info.getJoinDate() == null) {
            info.setJoinDate(info.getCreateTime());
        }
        PersonInfo pinfo = ip.getPersonInfo((IObjectPK)new ObjectUuidPK(pid.toString()));
        String personName = info.getPersonName();
        if (personName == null || "".equals(personName)) {
            info.setPersonName(pinfo.getName());
        }
    }

    private void updatePersonName(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        for (int i = 0; i < colls.size(); ++i) {
            PersonBlackListInfo info = (PersonBlackListInfo)colls.getObject(i);
            this.updatePersonName(ctx, (IObjectValue)info);
        }
    }

    public IObjectPK[] addnewBatchData(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        this.checkRepeat(ctx, (IObjectCollection)colls);
        this.updatePersonName(ctx, (IObjectCollection)colls);
        return super.addnewBatchData(ctx, colls);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PersonBlackListInfo newBlackListInfo = (PersonBlackListInfo)model;
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        newBlackListInfo.setStateModifier(curUser);
        IObjectPK updateObject = this.checkRepeat(ctx, model);
        if (updateObject == null) {
            this.updatePersonName(ctx, model);
            super._addnew(ctx, pk, model);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PersonBlackListInfo newBlackListInfo = (PersonBlackListInfo)model;
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        newBlackListInfo.setStateModifier(curUser);
        IObjectPK updateObject = this.checkRepeat(ctx, model);
        if (updateObject == null) {
            this.updatePersonName(ctx, model);
            return super._addnew(ctx, model);
        }
        return updateObject;
    }

    public void _update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        PersonBlackListInfo newBlackListInfo = (PersonBlackListInfo)model;
        PersonBlackListInfo srcBlackListInfo = this.getPersonBlackListInfo(ctx, pk);
        if (newBlackListInfo.getState() != srcBlackListInfo.getState()) {
            UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
            newBlackListInfo.setStateModifier(curUser);
        }
        super._update(ctx, pk, (IObjectValue)model);
    }

    protected void _updatePartial(Context ctx, IObjectValue model, SelectorItemCollection selector) throws BOSException, EASBizException {
        PersonBlackListInfo newBlackListInfo = (PersonBlackListInfo)model;
        PersonBlackListInfo srcBlackListInfo = this.getPersonBlackListInfo(ctx, (IObjectPK)new ObjectUuidPK(newBlackListInfo.getId()));
        boolean isUpdateState = false;
        int size = selector.size();
        for (int i = 0; i < size; ++i) {
            if (!selector.get(i).getPropertyName().equalsIgnoreCase("state")) continue;
            isUpdateState = true;
        }
        if (newBlackListInfo.getState() != srcBlackListInfo.getState() && isUpdateState) {
            UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
            newBlackListInfo.setStateModifier(curUser);
            selector.add(new SelectorItemInfo("stateModifier"));
        }
        super._updatePartial(ctx, model, selector);
    }

    @Override
    protected void _disable(Context ctx, String fid) throws BOSException, EASBizException {
        this.updatePersonBlackState(ctx, fid, StateEnum.DISABLE);
    }

    @Override
    protected void _enable(Context ctx, String fid) throws BOSException, EASBizException {
        this.updatePersonBlackState(ctx, fid, StateEnum.ENABLE);
    }

    public IObjectPK[] saveBatchData(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        this.checkRepeat(ctx, (IObjectCollection)colls);
        this.updatePersonName(ctx, (IObjectCollection)colls);
        return super.saveBatchData(ctx, colls);
    }

    private void updatePersonBlackState(Context ctx, String fid, StateEnum state) throws EASBizException, BOSException {
        PersonBlackListInfo personBlackListInfo = this.getPersonBlackListInfo(ctx, (IObjectPK)new ObjectUuidPK(fid));
        personBlackListInfo.setState(state);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(fid), (CoreBaseInfo)personBlackListInfo);
    }
}

