/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.app.update.UpdateAffairWaitingAuditedData;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.HRInitInfo;
import com.kingdee.eas.hr.base.app.AbstractSHRSystemUpdateFacadeControllerBean;
import com.kingdee.eas.hr.base.app.update.SHRBaseDataHistoryInitTool;
import com.kingdee.eas.hr.base.app.util.EmpLaborRelationUtil;
import com.kingdee.eas.hr.org.JobGradeModuleStateCollection;
import com.kingdee.eas.hr.org.JobGradeModuleStateFactory;
import com.kingdee.eas.hr.org.JobGradeModuleStateInfo;
import com.kingdee.eas.hr.org.StateEnum;
import com.kingdee.eas.hr.org.util.OrgUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SHRSystemUpdateFacadeControllerBean
extends AbstractSHRSystemUpdateFacadeControllerBean {
    private static final long serialVersionUID = 339715738425040797L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.SHRSystemUpdateFacadeControllerBean");

    @Override
    protected void _startUpdate(Context ctx, Map param) throws BOSException, EASBizException {
        this.checkSHRSystemUpdateFlag(ctx);
        Date sysUpdateTime = (Date)param.get("SHRSystemUpdateTime");
        String sysUpdateBeginDate = "{ts'" + DateTimeUtils.format((Date)sysUpdateTime, (String)"yyyy-MM-dd") + "'}";
        String sysUpdateEndDate = "{ts'2199-12-31'}";
        this.addPersonWorkExpCurIdColumn(ctx);
        this.updateAdminOrgData(ctx, sysUpdateBeginDate, sysUpdateEndDate);
        this.updatePositionData(ctx, sysUpdateBeginDate, sysUpdateEndDate);
        this.updatePersonData(ctx, sysUpdateBeginDate, sysUpdateEndDate);
        this.updateEmpFlowInOut(ctx);
        this.updateJobGrade(ctx);
        this.upgradeUserRole(ctx);
        this.updateSHRSystemUpdateFlag(ctx, sysUpdateTime);
        this.removePersonWorkExpCurIdColumn(ctx);
    }

    private void updateJobGrade(Context ctx) throws BOSException {
        JobGradeModuleStateInfo stateInfo;
        JobGradeModuleStateCollection coll = JobGradeModuleStateFactory.getLocalInstance((Context)ctx).getJobGradeModuleStateCollection();
        if (coll.size() == 1 && (stateInfo = coll.get(0)).getEnable() == StateEnum.ENABLE) {
            String sql = "update T_HR_JobGradeModule set Fenable=1 where fid='" + stateInfo.getJobGradeModule().getId() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "update T_HR_JobGradeModule set Fenable=0 where fid<>'" + stateInfo.getJobGradeModule().getId() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    private void checkSHRSystemUpdateFlag(Context ctx) throws EASBizException, BOSException {
        HRInitInfo hrInitInfo = HRInitFactory.getLocalInstance(ctx).getShrSytemUpdateInfo();
        if (hrInitInfo.isIsFinish()) {
            throw new BaseException(BaseException.SHRSYSTEMUPDATEOVER);
        }
    }

    private void updateSHRSystemUpdateFlag(Context ctx, Date sysUpdateTime) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String beginDate = DateTimeUtils.format((Date)sysUpdateTime, (String)"yyyy-MM-dd");
        sql.append("update T_HR_HRInit set FValue='").append(beginDate).append("',FIsFinish=1").append(" where FKey='").append("IS_SHRSYSTEM_UPDATE").append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void updateEmpFlowInOut(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into t_hr_empflowinout(").append("fpersonid            ,").append("fadminorgid          ,").append("fpositionid          ,").append("feffdt               ,").append("fleffdt              ,").append("fflowinaffairid      ,").append("fflowoutaffairid     ,").append("flaborrelationid     ,").append("factionid            ,").append("factionreasonid      ,").append("frelateadminid       ,").append("fassigntype          ,").append("fpositionstatus      ,").append("fbizdate             ,").append("factiontypeid        ,").append("fcreatorid           ,").append("fcreatetime          ,").append("flastupdateuserid    ,").append("flastupdatetime      ,").append("fcontrolunitid       ,").append("fempposorgrelationid ,").append("fid)").append("\tselect   ").append("fpersonid            ,").append("fadminorgid          ,").append("fpositionid          ,").append("feffdt               ,").append("fleffdt              ,").append("fflowinaffairid      ,").append("fflowoutaffairid     ,").append("flaborrelationid     ,").append("factionid            ,").append("factionreasonid      ,").append("frelateadminid       ,").append("fassigntype          ,").append("fpositionstatus      ,").append("feffdt             ,").append("factiontypeid        ,").append("fcreatorid           ,").append("fcreatetime          ,").append("flastupdateuserid    ,").append("flastupdatetime      ,").append("fcontrolunitid       ,").append("fid ,").append("  newbosid('750C121E')   ").append("from T_HR_EmpOrgRelation ").append("where fid not in (select fempposorgrelationid from t_hr_empflowinout ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void updateAdminOrgData(Context ctx, String sysUpdateBeginDate, String sysUpdateEndDate) throws BOSException {
        String sql;
        String rootOrgSql = "select fid from t_org_adminhis where fhistoryRelateId='00000000-0000-0000-0000-000000000000CCE7AED4'";
        IRowSet rootOrgRs = DbUtil.executeQuery((Context)ctx, (String)rootOrgSql);
        if (rootOrgRs != null && rootOrgRs.size() == 0) {
            sql = "update t_org_admin set feffdt =" + sysUpdateBeginDate + " where fid='00000000-0000-0000-0000-000000000000CCE7AED4'";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "update T_ORG_OUPartAdmin set feffdt =" + sysUpdateBeginDate + " where FUnitID='00000000-0000-0000-0000-000000000000CCE7AED4'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        sql = "update t_org_admin set feffdt =" + sysUpdateBeginDate + " where feffdt is null";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update t_org_admin set fleffdt =" + sysUpdateEndDate + " where fleffdt is null";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update T_ORG_OUPartAdmin set feffdt =" + sysUpdateBeginDate + " where feffdt is null";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update T_ORG_OUPartAdmin set fleffdt =" + sysUpdateEndDate + " where fleffdt is null";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update T_ORG_Admin set FIsJuridicalCompany=1 where fid='00000000-0000-0000-0000-000000000000CCE7AED4'";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update t_org_admin set fsortcode=0 where fid='00000000-0000-0000-0000-000000000000CCE7AED4' and fsortcode is null";
        DbUtil.execute((Context)ctx, (String)sql);
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update t_org_admin  set fdelegatehrid =(");
        updateSql.append("   select ftounitid from  t_org_unitrelation  T ");
        updateSql.append("  where Ftyperelationid='00000000-0000-0000-0000-0000000000100FE9F8B5' ");
        updateSql.append("  and t.ffromunitid = t_org_admin.fid)");
        updateSql.append(" where fdelegatehrid is null;");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        updateSql = new StringBuffer();
        updateSql.append("update t_org_oupartadmin set fdelegatehrid =(");
        updateSql.append(" select ftounitid from  t_org_unitrelation  T ");
        updateSql.append(" where Ftyperelationid='00000000-0000-0000-0000-0000000000100FE9F8B5'");
        updateSql.append(" and t.ffromunitid = t_org_oupartadmin.funitid)");
        updateSql.append(" where fdelegatehrid is null");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        updateSql = new StringBuffer();
        updateSql.append("update t_org_structure set fdisplayName_l2=N'\u7ba1\u7406\u5355\u5143',fdisplayName_l3=N'\u7ba1\u7406\u55ae\u5143' where fid='00000000-0000-0000-0000-00000000000332B85C74' ").append(" and funitid='00000000-0000-0000-0000-000000000000CCE7AED4' and ftreeid='00000000-0000-0000-0000-0000000000034F2827FD' and fdisplayName_l2 is null");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        SHRBaseDataHistoryInitTool.insertAdminOrgHistoryData(ctx);
    }

    private void updatePositionData(Context ctx, String sysUpdateBeginDate, String sysUpdateEndDate) throws BOSException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update t_org_position p set fparentid = (").append("select fparentid from T_ORG_PositionHierarchy t where FHierarchyID='00000000-0000-0000-0000-000000000001396FCAD0'").append(" and t.fchildid = p.fid").append(")").append(" where fparentid is  null");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        String sql = "update t_org_position set FFluCheckTime=0 where FFluCheckTime is null";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update t_org_position set FIsRespPosition = 0 where FIsRespPosition is null";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update t_org_position set feffdt =" + sysUpdateBeginDate + " where feffdt is null";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update t_org_position set fleffdt =" + sysUpdateEndDate + " where fleffdt is null";
        DbUtil.execute((Context)ctx, (String)sql);
        SHRBaseDataHistoryInitTool.insertPositionHistoryData(ctx);
    }

    private void updatePersonData(Context ctx, String sysUpdateBeginDate, String sysUpdateEndDate) throws BOSException, EASBizException {
        String sql = "update t_bd_person set feffdt =" + sysUpdateBeginDate + " where feffdt is null";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update t_bd_person set fleffdt =" + sysUpdateEndDate + " where fleffdt is null";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update t_hr_personposition set feffdt =" + sysUpdateBeginDate + " where feffdt is null";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "update t_hr_personposition set fleffdt =" + sysUpdateEndDate + " where fleffdt is null";
        DbUtil.execute((Context)ctx, (String)sql);
        this.updateEmpPosOrgRelation(ctx, sysUpdateBeginDate, sysUpdateEndDate);
        this.updateNoPositionEmpPosOrgRelation(ctx, sysUpdateBeginDate, sysUpdateEndDate);
        this.updatePersonLaborRelation(ctx, sysUpdateBeginDate, sysUpdateEndDate);
        SHRBaseDataHistoryInitTool.insertPersonHistoryData(ctx);
        SHRBaseDataHistoryInitTool.insertPersonPositionHistoryData(ctx);
        this.insertPersonWorkExpCurToEmpPosOrgRelation(ctx);
        this.updatePositionStatus(ctx);
        sql = "update T_HR_EmpOrgRelation set FIsIncount=1,FIsEnrolled=1 where fIsInner=1 and FAssignType=1";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void updatePositionStatus(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer("update t_Hr_Emporgrelation set FPositionStatus =10 where FPositionStatus  is null");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void updateEmpPosOrgRelation(Context ctx, String sysUpdateBeginDate, String sysUpdateEndDate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into t_Hr_Emporgrelation (fid,FPersonID,Fadminorgid,Fpositionid,FAssignType,Feffdt,FLEFFDT)").append("select newbosid('29288929'),").append("       pm.fpersonid fpersonid,").append("       p.fadminorgunitid fadminorgunitid,").append("       pm.fpositionid fpositionid,").append("       pm.fisprimary fprimary,").append("       ").append(sysUpdateBeginDate).append(" feffectdate,").append(sysUpdateEndDate).append(" FLEFFDT").append("  from t_org_positionmember pm").append(" inner join t_org_position p").append("    on p.fid = pm.fpositionid").append(" inner join t_bd_person person").append("    on person.fid = pm.fpersonid").append(" where person.femployeetypeid is not null").append(" \tand ( pm.FBeginDate <").append(sysUpdateBeginDate).append(" or pm.FBeginDate is null )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("insert into t_Hr_Emporgrelation (fid,FPersonID,Fadminorgid,Fpositionid,FAssignType,Feffdt,FLEFFDT)").append("select newbosid('29288929'),").append("       pm.fpersonid fpersonid,").append("       p.fadminorgunitid fadminorgunitid,").append("       pm.fpositionid fpositionid,").append("       pm.fisprimary fprimary,").append("       pm.fbegindate feffectdate,").append(sysUpdateEndDate).append(" FLEFFDT").append("  from t_org_positionmember pm").append(" inner join t_org_position p").append("    on p.fid = pm.fpositionid").append(" inner join t_bd_person person").append("    on person.fid = pm.fpersonid").append(" where person.femployeetypeid is not null").append(" \tand pm.FBeginDate >").append(sysUpdateBeginDate);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("select distinct  partRela.fid fid ,primRela.Feffdt feffdt from t_Hr_Emporgrelation primRela ").append(" left join t_Hr_Emporgrelation partRela on primRela.fpersonid=partRela.fPersonid ").append(" where  primRela.Feffdt>partRela.Feffdt and primRela.FAssignType = 1 and  partRela.FAssignType = 0 and primRela.FIsInner=1 and partRela.FIsInner=1 ").append(" and to_char(primRela.fleffdt,'yyyy-MM-dd')='2199-12-31' ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String updateSql = "update t_Hr_Emporgrelation set feffdt = ? where fid = ? ";
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        try {
            while (rowSet.next()) {
                Object[] param = new Object[]{rowSet.getDate("feffdt"), rowSet.getString("fid")};
                list.add(param);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (list.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), list);
        }
    }

    private void updateNoPositionEmpPosOrgRelation(Context ctx, String sysUpdateBeginDate, String sysUpdateEndDate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into t_Hr_Emporgrelation (fid,FPersonID,Fadminorgid,Fpositionid,FAssignType,Feffdt,FLEFFDT,FAdminOrgTxt,FPositionTxt)").append("select newbosid('29288929'),").append("       pm.fpersonid fpersonid,").append("       p.fadminorgunitid fadminorgunitid,").append("       pm.fpositionid fpositionid,").append("       pm.fisprimary fprimary,").append("       ").append(sysUpdateBeginDate).append(" feffectdate,").append(sysUpdateEndDate).append(" FLEFFDT,").append("       pm.FPastDept FAdminOrgTxt,").append("       pm.FPastPositon FPositionTxt").append("  from T_HR_PersonWorkExpCur pm").append(" inner join t_org_position p").append("    on p.fid = pm.fpositionid").append(" inner join t_bd_person person").append("    on person.fid = pm.fpersonid").append(" inner join ").append(" (SELECT max(FEndDate) as FEndDate ,fpersonid from T_HR_PersonWorkExpCur where (FIsPrimary=1 and FEndDate is not null) group by fpersonid) as tmpEndDatePerson").append(" on tmpEndDatePerson.fpersonid=pm.fpersonid and tmpEndDatePerson.FEndDate=pm.FEndDate").append(" where  pm.fpersonid not in (select fpersonid from t_hr_emporgrelation)").append("   and person.femployeetypeid is not null").append("   and pm.FPositionID is not null").append(" \tand pm.FEndDate <=").append(sysUpdateBeginDate).append("\tand FIsPrimary=1 ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("insert into t_Hr_Emporgrelation (fid,FPersonID,Fadminorgid,Fpositionid,FAssignType,Feffdt,FLEFFDT,FAdminOrgTxt,FPositionTxt)").append("select newbosid('29288929'),").append("       pm.fpersonid fpersonid,").append("       p.fadminorgunitid fadminorgunitid,").append("       pm.fpositionid fpositionid,").append("       pm.fisprimary fprimary,").append("       pm.FEndDate feffectdate,").append(sysUpdateEndDate).append(" FLEFFDT,").append("       pm.FPastDept FAdminOrgTxt,").append("       pm.FPastPositon FPositionTxt").append("  from T_HR_PersonWorkExpCur pm").append(" inner join t_org_position p").append("    on p.fid = pm.fpositionid").append(" inner join t_bd_person person").append("    on person.fid = pm.fpersonid").append(" inner join ").append(" (SELECT max(FEndDate) as FEndDate ,fpersonid from T_HR_PersonWorkExpCur where (FIsPrimary=1 and FEndDate is not null) group by fpersonid) as tmpEndDatePerson").append(" on tmpEndDatePerson.fpersonid=pm.fpersonid and tmpEndDatePerson.FEndDate=pm.FEndDate").append(" where  pm.fpersonid not in (select fpersonid from t_hr_emporgrelation)").append("   and person.femployeetypeid is not null").append("   and pm.FPositionID is not null").append(" \tand pm.FEndDate >").append(sysUpdateBeginDate).append("\tand FIsPrimary=1 ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void insertPersonWorkExpCurToEmpPosOrgRelation(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into t_Hr_Emporgrelation (fid,FPersonID,FAssignType,Feffdt,FLEFFDT,FAdminOrgTxt,FPositionTxt,FAdminOrgID,FPositionID,FIsInner,PersonWorkExpCurId) ").append("select newbosid('29288929') fid,").append("       pm.fpersonid FPersonID,").append("       pm.fisprimary FAssignType,").append("       pm.FBeginDate Feffdt,").append("\t\tpm.FEndDate FLEFFDT,").append("       pm.FPastDept FAdminOrgTxt,").append("       pm.FPastPositon FPositionTxt,").append("       pm.FDeptID FAdminOrgID,").append("\t\tpm.FPositionID FPositionID,").append("       0 FIsInner,").append("       pm.fid PersonWorkExpCurId").append("  from T_HR_PersonWorkExpCur pm where pm.fid not in (select PersonWorkExpCurId from t_Hr_Emporgrelation where PersonWorkExpCurId is not null)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void updatePersonLaborRelation(Context ctx, String sysUpdateBeginDate, String sysUpdateEndDate) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_HR_EmpLaborRelation").append("(fid,").append(" fpersonid,").append(" Flaborrelationstateid,").append(" FEFFDT,").append(" FLEFFDT,").append(" Flaborrelationtype,").append(" Fcreatorid,").append(" Fcreatetime,").append(" Flastupdateuserid,").append(" Flastupdatetime,").append(" Fcontrolunitid").append(" )").append(" select distinct newbosid('FCCE2F8F'),").append("person.fid,").append("person.femployeetypeid ,").append("empOrgRela.FEFFDT,").append("empOrgRela.FLEFFDT,").append("0 as Flaborrelationtype,").append("'00000000-0000-0000-0000-00000000000013B7DE7F' as Fcreatorid,").append(sysUpdateBeginDate).append(" Fcreatetime,").append("'00000000-0000-0000-0000-00000000000013B7DE7F' as Flastupdateuserid,").append(sysUpdateEndDate).append(" Flastupdatetime,").append("'00000000-0000-0000-0000-000000000000CCE7AED4' as Fcontrolunitid").append(" from t_bd_person person left join T_HR_EmpOrgRelation empOrgRela on person.fid=empOrgRela.fPersonId").append(" where person.femployeetypeid is not null ").append(" and empOrgRela.FAssignType=").append(1).append(" and person.fid not in (select fpersonid from T_HR_EmpLaborRelation)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        this.updateEmpLaborRelationCorporateUnit(ctx);
        sql = new StringBuffer();
        sql.append("update t_Hr_Emporgrelation T1 set FlaborRelationID = (").append("select top 1 FID from T_HR_EmpLaborRelation T2 where t1.fpersonid = T2.Fpersonid)").append("where FlaborRelationID is null");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        SHRBaseDataHistoryInitTool.insertPersonLaborRelationHistoryData(ctx);
    }

    private void updateEmpLaborRelationCorporateUnit(Context ctx) throws BOSException, SQLDataException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FAdminOrgID,FPersonID from t_Hr_Emporgrelation where FAssignType=").append(1);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, String> corporateUnitMap = new HashMap<String, String>();
        String update = "UPDATE T_HR_EmpLaborRelation SET FCorporateunitID = ? WHERE FPersonID = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] params = null;
        try {
            while (rs.next()) {
                String corporateOrgID;
                params = new Object[2];
                String adminOrgID = rs.getString("FAdminOrgID");
                String personID = rs.getString("FPersonID");
                if (corporateUnitMap.get(adminOrgID) != null) {
                    corporateOrgID = (String)corporateUnitMap.get(adminOrgID);
                } else {
                    AdminOrgUnitInfo adminOrgInfo = EmpLaborRelationUtil.getCorporateUnit(ctx, adminOrgID);
                    if (adminOrgInfo == null) {
                        corporateOrgID = "00000000-0000-0000-0000-000000000000CCE7AED4";
                        corporateUnitMap.put(adminOrgID, corporateOrgID);
                    } else {
                        corporateOrgID = adminOrgInfo.getId().toString();
                        corporateUnitMap.put(adminOrgID, corporateOrgID);
                    }
                }
                params[0] = corporateOrgID;
                params[1] = personID;
                paramList.add(params);
            }
            DbUtil.executeBatch((Context)ctx, (String)update, paramList);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, null, null);
        }
        corporateUnitMap = null;
    }

    @Override
    protected PersonCollection _getNotUpdatePersonCollection(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String localLan = ctx.getLocale().toString();
        sql.append(" select fname_").append(localLan).append(" as fname,fnumber as fnumber from t_bd_person ").append(" where (fid not in (select fpersonid from T_HR_EmpOrgRelation where FIsInner=1)) or (FEmployeeTypeID is null)");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        PersonCollection pcll = new PersonCollection();
        PersonInfo personInfo = null;
        try {
            while (rs.next()) {
                personInfo = new PersonInfo();
                personInfo.setName(rs.getString("fname"));
                personInfo.setNumber(rs.getString("fnumber"));
                pcll.add(personInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return pcll;
    }

    @Override
    protected void _affairBizBillUpdate(Context ctx) throws BOSException, EASBizException {
        UpdateAffairWaitingAuditedData updateAffairDate = new UpdateAffairWaitingAuditedData();
        updateAffairDate.update(ctx);
    }

    private void addPersonWorkExpCurIdColumn(Context ctx) throws BOSException {
        String sql = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME ='T_HR_EmpOrgRelation' AND KSQL_COL_NAME = 'PersonWorkExpCurId')";
        sql = sql + " alter table T_HR_EmpOrgRelation add PersonWorkExpCurId varchar(44)";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void removePersonWorkExpCurIdColumn(Context ctx) throws BOSException {
        String sql = "ALTER TABLE T_HR_EmpOrgRelation DROP COLUMN PersonWorkExpCurId";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void upgradeUserRole(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO T_PM_UserRoleOrg (FUserID, FOrgID , FRoleID)");
        sql.append("select distinct u.fid ,u.fdeforgunitid,'00000000-0000-0000-0000-00000000000013B6732A' ").append("from t_org_positionmember pm").append(" inner join t_org_position p1 on p1.fid = pm.fpositionid ").append(" inner join t_pm_user u on u.fpersonid = pm.fpersonid ").append(" where (").append(" p1.fisrespposition = 1").append(") and  not exists(").append("  select 1 from t_pm_userroleorg ur").append(" where ur.froleid='00000000-0000-0000-0000-00000000000013B6732A'").append(" and ur.fuserid = u.fid").append(") and u.fisdelete = 0 and u.fforbidden=0").append(" and u.fdeforgunitid is not null");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String currentDateStr = format.format(new Date());
        StringBuffer personNotInSql = new StringBuffer();
        personNotInSql.append("select e.fpersonid from T_HR_EmpOrgRelation e").append(" inner join t_org_position p on p.fid = e.fpositionid ").append(" where e.FEFFDT<=to_date('").append(currentDateStr).append("')").append(" and e.FLEFFDT>to_date('").append(currentDateStr).append("')").append(" and (").append(" exists (select 1 from t_org_position p1 where p1.fparentid = p.fid)").append(" or p.fisrespposition = 1 )");
        sql = new StringBuffer();
        sql.append("INSERT INTO T_PM_UserRoleOrg (FUserID, FOrgID , FRoleID)");
        sql.append("select distinct u.fid, u.fdeforgunitid,'vqoC6sk6Svmijjatmt+tSBO2cyo=' ").append(" from T_PM_UserRoleOrg ur ").append(" inner join t_pm_user u on u.fid = ur.fuserid").append(" where FRoleID = '00000000-0000-0000-0000-00000000000013B6732A'").append(" and u.fpersonid not in (").append(personNotInSql).append(")").append(" and u.fdeforgunitid is not null ").append(" and  not exists(").append(" select 1 from t_pm_userroleorg uro").append(" where uro.froleid='vqoC6sk6Svmijjatmt+tSBO2cyo='").append(" and uro.fuserid = u.fid").append(") and u.fisdelete = 0 and u.fforbidden=0");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update t_hr_personposition set fisleader=1 ").append("where fpersonid in ( ").append(" select u.fpersonid").append(" from T_PM_UserRoleOrg ur ").append(" inner join t_pm_user u on u.fid = ur.fuserid").append(" where FRoleID = 'vqoC6sk6Svmijjatmt+tSBO2cyo='").append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update t_pm_user set fdeforgunitid=( ").append(" select top 1 u.ftounitid ").append(" from t_org_positionmember pm ").append(" inner join t_org_position p1 on p1.fid = pm.fpositionid ").append(" inner join t_org_unitrelation u on u.ffromunitid = p1.fadminorgunitid ").append(" where u.Ftyperelationid='00000000-0000-0000-0000-0000000000100FE9F8B5'").append(" and pm.fisprimary=1 ").append(" and t_pm_user.fpersonid = pm.fpersonid )");
        sql.append(" where exists( ").append(" select 1 ").append(" from t_org_positionmember pm ").append(" inner join t_org_position p1 on p1.fid = pm.fpositionid ").append(" inner join t_org_unitrelation u on u.ffromunitid = p1.fadminorgunitid ").append(" where u.Ftyperelationid='00000000-0000-0000-0000-0000000000100FE9F8B5'").append(" and pm.fisprimary=1 ").append(" and t_pm_user.fpersonid = pm.fpersonid )");
    }

    @Override
    protected void _initAdminOrgSortCode(Context ctx) throws BOSException, EASBizException {
        IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitInfo adminOrg = iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
        adminOrg.setIndex(0);
        adminOrg.setSortCode("0");
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("index"));
        selector.add(new SelectorItemInfo("sortCode"));
        iAdminOrgUnit.updatePartial((CoreBaseInfo)adminOrg, selector);
        this.updateSubAdminOrgSortCode(ctx, adminOrg);
    }

    @Override
    protected void _initPersonSortCode(Context ctx) throws BOSException, EASBizException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_BD_Person set FIndex =").append(9999999);
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        updateSql = new StringBuffer();
        updateSql.append("update T_BD_PersonHis set FIndex =").append(9999999).append(" where fleffdt={ts'").append("2199-12-31").append("'}");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    @Override
    protected void _initPositionSortCode(Context ctx) throws BOSException, EASBizException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_ORG_Position set FIndex =").append(9999999);
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        updateSql = new StringBuffer();
        updateSql.append("update T_ORG_PositionHis set FIndex =").append(9999999).append(" where fleffdt={ts'").append("2199-12-31").append("'}");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        updateSql = new StringBuffer();
        updateSql.append("update T_ORG_Position set FIndex =-1 where FIsRespPosition=1");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        updateSql = new StringBuffer();
        updateSql.append("update T_ORG_PositionHis set FIndex =-1").append(" where fleffdt={ts'").append("2199-12-31").append("'} and FIsRespPosition=1");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    private void updateSubAdminOrgSortCode(Context ctx, AdminOrgUnitInfo adminOrg) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("index"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("parent.sortCode"));
        viewInfo.setSelector(sic);
        SorterItemCollection sorterColl = new SorterItemCollection();
        SorterItemInfo sorter = new SorterItemInfo("longNumber");
        sorter.setSortType(SortType.ASCEND);
        sorterColl.add(sorter);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(adminOrg.getLongNumber() + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("level", (Object)(adminOrg.getLevel() + 1), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        viewInfo.setSorter(sorterColl);
        IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitCollection orgColl = iAdminOrgUnit.getAdminOrgUnitCollection(viewInfo);
        AdminOrgUnitInfo curOrgInfo = null;
        SelectorItemCollection updateSic = new SelectorItemCollection();
        updateSic.add(new SelectorItemInfo("sortCode"));
        updateSic.add(new SelectorItemInfo("index"));
        if (orgColl.size() > 0) {
            int size = orgColl.size();
            for (int i = 0; i < size; ++i) {
                curOrgInfo = orgColl.get(i);
                if (curOrgInfo.getParent() == null) continue;
                int index = i + 1;
                String indexString = OrgUtils.getAdminOrgIndexString((int)index);
                String sortCode = curOrgInfo.getParent().getSortCode() + "!" + indexString;
                OrgUtils.updateAdminOrgIndexAndSortCode((Context)ctx, (int)index, (String)sortCode, (String)curOrgInfo.getId().toString());
                this.updateSubAdminOrgSortCode(ctx, curOrgInfo);
            }
        } else {
            return;
        }
    }

    @Override
    protected void _initSortCode(Context ctx) throws BOSException, EASBizException {
        this._initAdminOrgSortCode(ctx);
        this._initPositionSortCode(ctx);
        this._initPersonSortCode(ctx);
    }
}

