/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.AffairActionOperateEnum;
import com.kingdee.eas.hr.base.AffairActionReasonInfo;
import com.kingdee.eas.hr.base.AssignTypeEnum;
import com.kingdee.eas.hr.base.EmpPosOrgRelationChangeInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmpPositionInfo;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.PositionStatuEnum;
import com.kingdee.eas.hr.base.app.AffairActionDefManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;

public class TestEmpPosOrgRelationFacade {
    private static Logger logger = Logger.getLogger(TestEmpPosOrgRelationFacade.class);

    public void test(Context ctx) throws BOSException, EASBizException {
        AffairActionDefManager manager = new AffairActionDefManager();
        Date effectDate = DateUtil.getBeforeDay((Date)DateUtil.getBeforeDay((Date)DateUtil.getBeforeDay((Date)new Date())));
        EmpPosOrgRelationChangeInfo terminateInfo = new EmpPosOrgRelationChangeInfo();
        terminateInfo.setPositionInfo(this.getRetirePerson(ctx, effectDate));
        terminateInfo.setAffairOperate(AffairActionOperateEnum.POSITIONTERMINATE);
        AffairActionReasonInfo actionReasonInfo = new AffairActionReasonInfo();
        actionReasonInfo.setId(BOSUuid.read((String)"DawAAAAob5CWEWnu"));
        terminateInfo.setActionType(actionReasonInfo);
        terminateInfo.setStartDate(effectDate);
        terminateInfo.getPositionInfo().setPositionStateEnum(PositionStatuEnum.InActive);
        terminateInfo.setEntryID("001");
        EmployeeTypeInfo employeeType = new EmployeeTypeInfo();
        employeeType.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000007A29E85B3"));
        terminateInfo.getPositionInfo().setEmployeeType(employeeType);
        manager.operate(ctx, terminateInfo);
        EmpPosOrgRelationChangeInfo changeInfo = new EmpPosOrgRelationChangeInfo();
        EmpPositionInfo empPositionInfo = new EmpPositionInfo();
        empPositionInfo.setPersonInfo(terminateInfo.getPositionInfo().getPersonInfo());
        changeInfo.setAffairOperate(AffairActionOperateEnum.POSITIONADDNEW);
        changeInfo.setStartDate(effectDate);
        employeeType = new EmployeeTypeInfo();
        employeeType.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000001A29E85B3"));
        empPositionInfo.setEmployeeType(employeeType);
        PositionInfo pInfo = this.getActivePosition(ctx, null);
        empPositionInfo.setPositionInfo(pInfo);
        empPositionInfo.setAdminInfo(pInfo.getAdminOrgUnit());
        changeInfo.setPositionInfo(empPositionInfo);
        changeInfo.setEntryID("001");
        manager.operate(ctx, changeInfo);
        effectDate = DateUtil.getBeforeDay((Date)DateUtil.getBeforeDay((Date)new Date()));
        EmpPosOrgRelationChangeInfo primaryCancleInfo = new EmpPosOrgRelationChangeInfo();
        primaryCancleInfo.setPositionInfo(changeInfo.getPositionInfo());
        primaryCancleInfo.setAffairOperate(AffairActionOperateEnum.POSITIONTERMINATE);
        primaryCancleInfo.setStartDate(effectDate);
        employeeType = new EmployeeTypeInfo();
        employeeType.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000001A29E85B3"));
        primaryCancleInfo.getPositionInfo().setEmployeeType(employeeType);
        primaryCancleInfo.getPositionInfo().setPositionStateEnum(PositionStatuEnum.InActive);
        primaryCancleInfo.setEntryID("002");
        primaryCancleInfo.setStartDate(effectDate);
        manager.operate(ctx, primaryCancleInfo);
        EmpPosOrgRelationChangeInfo primarynewInfo = new EmpPosOrgRelationChangeInfo();
        PositionInfo newPInfo = this.getActivePosition(ctx, primaryCancleInfo.getPositionInfo().getPositionInfo().getId().toString());
        empPositionInfo.setPositionInfo(newPInfo);
        empPositionInfo.setAdminInfo(newPInfo.getAdminOrgUnit());
        empPositionInfo.setAssignType(AssignTypeEnum.PARTTIME);
        primarynewInfo.setPositionInfo(empPositionInfo);
        primarynewInfo.setAffairOperate(AffairActionOperateEnum.POSITIONADDNEW);
        primarynewInfo.setStartDate(effectDate);
        employeeType = new EmployeeTypeInfo();
        employeeType.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000001A29E85B3"));
        primarynewInfo.getPositionInfo().setEmployeeType(employeeType);
        primarynewInfo.getPositionInfo().setPositionStateEnum(PositionStatuEnum.Active);
        primarynewInfo.setEntryID("002");
        primarynewInfo.setStartDate(effectDate);
        manager.operate(ctx, primarynewInfo);
        effectDate = DateUtil.getBeforeDay((Date)new Date());
        primarynewInfo.setAffairOperate(AffairActionOperateEnum.POSITIONTERMINATE);
        primarynewInfo.getPositionInfo().setPositionStateEnum(PositionStatuEnum.InActive);
        primarynewInfo.setEntryID("003");
        primarynewInfo.setStartDate(effectDate);
        manager.operate(ctx, primarynewInfo);
    }

    private PositionInfo getActivePosition(Context ctx, String positionID) throws BOSException {
        String positionSql = " select top 10 p.fid fid,p.fnumber fnumber,admin.fid fadminOrgUnit,admin.fnumber adminNumber from t_org_position p  inner join t_org_admin admin on admin.fid=p.fadminorgunitid where p.fdeletedStatus=1 ";
        if (!StringUtils.isEmpty((String)positionID)) {
            positionSql = positionSql + " and p.fid <>'" + positionID + "'";
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)positionSql);
        try {
            if (rowSet.next()) {
                PositionInfo pInfo = new PositionInfo();
                pInfo.setId(BOSUuid.read((String)rowSet.getString("fid")));
                pInfo.setNumber(rowSet.getString("fnumber"));
                AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
                adminInfo.setId(BOSUuid.read((String)rowSet.getString("fadminOrgUnit")));
                adminInfo.setNumber(rowSet.getString("adminNumber"));
                pInfo.setAdminOrgUnit(adminInfo);
                logger.error((Object)("positionId=" + pInfo.getId().toString() + " positionNumber=" + pInfo.getNumber() + " adminNumber=" + adminInfo.getNumber()));
                return pInfo;
            }
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    private EmpPositionInfo getRetirePerson(Context ctx, Date appointDate) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        appointDate = DateTimeUtils.truncateDate((Date)appointDate);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.employeeType.id", (Object)"00000000-0000-0000-0000-000000000007A29E85B3"));
        filter.getFilterItems().add(new FilterItemInfo("positionstatus", (Object)new Integer(0), CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("position.id", null));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.EFFDT, (Object)appointDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)appointDate, CompareType.GREATER));
        view.setFilter(filter);
        view.setSelector(this.getSelector());
        EmpPosOrgRelationCollection epoColl = EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationCollection(view);
        if (epoColl != null && epoColl.size() > 0) {
            for (int i = 0; i < epoColl.size(); ++i) {
                if (this.hasAlreadyModify(ctx, epoColl.get(i), appointDate)) continue;
                EmpPositionInfo empPositionInfo = new EmpPositionInfo();
                empPositionInfo.setPersonInfo(epoColl.get(0).getPerson());
                logger.error((Object)("personid=" + epoColl.get(0).getPerson().getId().toString() + " personNum=" + epoColl.get(0).getPerson().getNumber()));
                empPositionInfo.setAdminInfo(epoColl.get(0).getAdminOrg());
                empPositionInfo.setPositionStateEnum(PositionStatuEnum.InActive);
                empPositionInfo.setEmployeeType(epoColl.get(0).getLaborRelation().getLaborRelationState());
                return empPositionInfo;
            }
        }
        return null;
    }

    private boolean hasAlreadyModify(Context ctx, EmpPosOrgRelationInfo empPosOrgRelationInfo, Date appointDate) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)empPosOrgRelationInfo.getPerson().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.EFFDT, (Object)appointDate, CompareType.GREATER_EQUALS));
        return EmpPosOrgRelationFactory.getLocalInstance(ctx).exists(filter);
    }

    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("person.employeetype.id"));
        sic.add(new SelectorItemInfo("person.employeetype.name"));
        sic.add(new SelectorItemInfo("person.employeetype.number"));
        sic.add(new SelectorItemInfo("adminOrg.id"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("adminOrg.number"));
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("position.number"));
        sic.add(new SelectorItemInfo("relateAdmin.id"));
        sic.add(new SelectorItemInfo("relateAdmin.name"));
        sic.add(new SelectorItemInfo("relateAdmin.number"));
        sic.add(new SelectorItemInfo("affairActDef.id"));
        sic.add(new SelectorItemInfo("affairActDef.name"));
        sic.add(new SelectorItemInfo("affairActDef.number"));
        sic.add(new SelectorItemInfo("employeeType.id"));
        sic.add(new SelectorItemInfo("employeeType.name"));
        sic.add(new SelectorItemInfo("employeeType.number"));
        sic.add(new SelectorItemInfo("positionstate.id"));
        sic.add(new SelectorItemInfo("positionstate.name"));
        sic.add(new SelectorItemInfo("positionstate.number"));
        sic.add(new SelectorItemInfo("hrbizDefine.id"));
        sic.add(new SelectorItemInfo("hrbizDefine.name"));
        sic.add(new SelectorItemInfo("hrbizDefine.number"));
        sic.add(new SelectorItemInfo("isPrimary"));
        sic.add(new SelectorItemInfo("effectStartDate"));
        sic.add(new SelectorItemInfo("effectEndDate"));
        sic.add(new SelectorItemInfo("flowInAffairID"));
        sic.add(new SelectorItemInfo("flowOutAffairID"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("id"));
        return sic;
    }
}

