/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.DeletedStatusEnum;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.affair.AffairUnAuditException;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairBizCollection;
import com.kingdee.eas.hr.affair.HRAffairBizFactory;
import com.kingdee.eas.hr.affair.HRAffairBizInfo;
import com.kingdee.eas.hr.affair.IHRAffairBizBill;
import com.kingdee.eas.hr.affair.IHRAffairBizBillEntry;
import com.kingdee.eas.hr.affair.PluralityDelBizBillEntryFactory;
import com.kingdee.eas.hr.affair.PluralityDelBizBillEntryInfo;
import com.kingdee.eas.hr.affair.RiseBizBillEntryCollection;
import com.kingdee.eas.hr.affair.RiseBizBillEntryFactory;
import com.kingdee.eas.hr.affair.RiseBizBillEntryInfo;
import com.kingdee.eas.hr.affair.RiseBizBillInfo;
import com.kingdee.eas.hr.base.AffairActioniOperateException;
import com.kingdee.eas.hr.base.AssignTypeEnum;
import com.kingdee.eas.hr.base.EmpLaborRelationHisCollection;
import com.kingdee.eas.hr.base.EmpLaborRelationHisFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFacadeFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.HRAffairActionTransactionLogCollection;
import com.kingdee.eas.hr.base.HRAffairActionTransactionLogFactory;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.HRBizDefineTypeEnum;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.EmpPostRankCollection;
import com.kingdee.eas.hr.emp.EmpPostRankFactory;
import com.kingdee.eas.hr.emp.EmpPostRankInfo;
import com.kingdee.eas.hr.emp.app.util.EmpPostRankUtil;
import com.kingdee.eas.hr.org.util.OrgAdjLockManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AffairUnAuditAppUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.util.AffairUnAuditAppUtils");
    public static final String PLURALITYADD_BOSTYPE = "B3F8AB50";
    public static final String PLURALITYDEL_BOSTYPE = "6422D4A6";
    public static final String EMPPOSTRANK_BOSTYPE = "C4D946DE";
    private static String strResoure = "com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource";

    public static void checkOperateEmpOrgRelationCanRecovery(Context ctx, EmpPosOrgRelationInfo info, HRAffairBizBillInfo billInfo) throws BOSException, EASBizException {
        String personId = info.getPerson().getId().toString();
        String affairEntryID = null;
        if (AssignTypeEnum.MAIN.equals((Object)info.getAssignType())) {
            affairEntryID = info.getFlowInAffairID();
        }
        if (AssignTypeEnum.PARTTIME.equals((Object)info.getAssignType())) {
            affairEntryID = !StringUtils.isEmpty((String)info.getFlowOutAffairID()) ? info.getFlowOutAffairID() : info.getFlowInAffairID();
        }
        PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
        AffairUnAuditAppUtils.checkLogCanUnAudit(ctx, affairEntryID);
        AffairUnAuditAppUtils.checkOnlyOneEmpPosOrgRelaCannotRecovery(ctx, info);
        String billId = "";
        if (billInfo != null) {
            billId = billInfo.getId().toString();
        }
        if (info.getAssignType().equals((Object)AssignTypeEnum.MAIN)) {
            AffairUnAuditAppUtils.checkEmpOrgRelationMainIsLatest(ctx, info, false);
            AffairUnAuditAppUtils.checkPersonInAffairProcess(ctx, billId, personId, false);
        } else if (info.getAssignType().equals((Object)AssignTypeEnum.PARTTIME)) {
            AffairUnAuditAppUtils.checkEmpOrgRelationPartTimeIFFlowInCanNotFlowOut(ctx, info, affairEntryID);
        }
        EmpPosOrgRelationCollection empPosOrgRelColl = EmpPosOrgRelationFacadeFactory.getLocalInstance(ctx).getAffairRelateEmpPosOrgRelation(affairEntryID, personId);
        AffairUnAuditAppUtils.checkIfOrgLocked(ctx, empPosOrgRelColl);
        AffairUnAuditAppUtils.checkIfOrgPositionEnable(ctx, empPosOrgRelColl);
        AffairUnAuditAppUtils.checkPersonHasEmpJobGradeBill(ctx, personInfo, empPosOrgRelColl);
        AffairUnAuditAppUtils.checkPersonInBuRelationBuilding(ctx, personId);
    }

    private static void checkIfOrgPositionEnable(Context ctx, EmpPosOrgRelationCollection empPosOrgRelColl) throws EASBizException, BOSException {
        StringBuffer errorMsg = new StringBuffer("" + SHRServerResource.getString((String)"com.kingdee.eas.hr.base.BaseBizResourse", (String)"Operation_failed", (Context)ctx) + "\uff01");
        StringBuffer errorMsgDetail = new StringBuffer();
        EmpPosOrgRelationInfo everyInfo = null;
        int size = empPosOrgRelColl.size();
        for (int i = 0; i < size; ++i) {
            everyInfo = empPosOrgRelColl.get(i);
            if (HRUtil.getMaxEndDate().equals(everyInfo.getLEFFDT())) continue;
            Date endDateTime = everyInfo.getEndDateTime();
            String personId = everyInfo.getPerson().getId().toString();
            int assginType = everyInfo.getAssignType().getValue();
            if (assginType == 1) {
                EmpLaborRelationHisCollection empLaborCollection;
                StringBuffer oql = new StringBuffer();
                oql.append(" select id where person ='").append(personId).append("'").append(" and ").append(" laborRelationState.isInCount = 0").append(" and ").append(" startDateTime<=").append(HRUtilExtend.getDateStringWithMinuteTs(endDateTime)).append(" and ").append(" endDateTime>=").append(HRUtilExtend.getDateStringWithMinuteTs(endDateTime));
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("checkIfOrgPositionEnable:oql:" + oql));
                }
                if ((empLaborCollection = EmpLaborRelationHisFactory.getLocalInstance(ctx).getEmpLaborRelationHisCollection(oql.toString())).size() > 0) continue;
            }
            AdminOrgUnitInfo adminOrg = everyInfo.getAdminOrg();
            PositionInfo postionInfo = everyInfo.getPosition();
            if (adminOrg == null || postionInfo == null) continue;
            adminOrg = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrg.getId().toString()));
            if (adminOrg.isIsSealUp()) {
                errorMsgDetail.append(MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label148", (Context)ctx), adminOrg.getName()));
            }
            if (!DeletedStatusEnum.DELETED.equals((Object)(postionInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(postionInfo.getId().toString()))).getDeletedStatus())) continue;
            errorMsgDetail.append(MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label149", (Context)ctx), postionInfo.getName()));
        }
        if (errorMsgDetail.toString().length() > 0) {
            errorMsg.append(errorMsgDetail);
            errorMsg.append(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label150", (Context)ctx));
            NumericExceptionSubItem validException = new NumericExceptionSubItem("00", errorMsg.toString());
            throw new EASBizException(validException);
        }
    }

    public static void checkAffairRelatedEmpOrgRelationCanUntiCheck(Context ctx, String affairEntryId, String personId, boolean isEmpEnroll) throws EASBizException, BOSException {
        EmpPosOrgRelationCollection empPosOrgRelColl = EmpPosOrgRelationFacadeFactory.getLocalInstance(ctx).getAffairRelateEmpPosOrgRelation(affairEntryId, personId);
        EmpPosOrgRelationInfo latestInfo = null;
        if (empPosOrgRelColl.size() == 0) {
            return;
        }
        latestInfo = empPosOrgRelColl.get(0);
        PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
        HRAffairBizCollection coll = HRAffairBizFactory.getLocalInstance((Context)ctx).getHRAffairBizCollection("select billID,entryBizDate where entryID = '" + affairEntryId + "'");
        String billId = coll.get(0).getBillID().toString();
        Date entryBizDate = coll.get(0).getEntryBizDate();
        AffairUnAuditAppUtils.checkLogCanUnAudit(ctx, affairEntryId);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("checkAffairRelatedEmpOrgRelationCanUntiCheck  latestInfo isnull:" + latestInfo == null ? 1 : 0));
        }
        if (latestInfo != null) {
            if (latestInfo.getAssignType().equals((Object)AssignTypeEnum.MAIN)) {
                AffairUnAuditAppUtils.checkEmpOrgRelationMainIsLatest(ctx, latestInfo, isEmpEnroll);
                AffairUnAuditAppUtils.checkHaveAfterCurrentBizDateBill(ctx, billId, personId, entryBizDate, true);
                AffairUnAuditAppUtils.checkPersonInAffairProcess(ctx, billId, personId, isEmpEnroll);
            } else if (latestInfo.getAssignType().equals((Object)AssignTypeEnum.PARTTIME)) {
                AffairUnAuditAppUtils.checkEmpOrgRelationPartTimeIFFlowInCanNotFlowOut(ctx, latestInfo, affairEntryId);
            }
        }
        AffairUnAuditAppUtils.checkIfOrgLocked(ctx, empPosOrgRelColl);
        AffairUnAuditAppUtils.checkIfOrgPositionEnable(ctx, empPosOrgRelColl);
        AffairUnAuditAppUtils.checkPersonHasEmpJobGradeBill(ctx, personInfo, empPosOrgRelColl);
        AffairUnAuditAppUtils.checkPersonInBuRelationBuilding(ctx, personId);
    }

    public static void checkAffairRelatedEmpOrgRelationCanUntiCheckEmpPostRankNotChange(Context ctx, String affairEntryId, String personId, boolean isEmpEnroll) throws EASBizException, BOSException {
        EmpPosOrgRelationCollection empPosOrgRelColl = EmpPosOrgRelationFacadeFactory.getLocalInstance(ctx).getAffairRelateEmpPosOrgRelation(affairEntryId, personId);
        EmpPosOrgRelationInfo latestInfo = null;
        if (empPosOrgRelColl.size() == 0) {
            return;
        }
        latestInfo = empPosOrgRelColl.get(0);
        PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
        HRAffairBizCollection coll = HRAffairBizFactory.getLocalInstance((Context)ctx).getHRAffairBizCollection("select billID,entryBizDate where entryID = '" + affairEntryId + "'");
        String billId = coll.get(0).getBillID().toString();
        Date entryBizDate = coll.get(0).getEntryBizDate();
        AffairUnAuditAppUtils.checkLogCanUnAudit(ctx, affairEntryId);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("checkAffairRelatedEmpOrgRelationCanUntiCheckEmpPostRankNotChange  latestInfo isnull:" + latestInfo == null ? 1 : 0));
        }
        if (latestInfo != null) {
            if (latestInfo.getAssignType().equals((Object)AssignTypeEnum.MAIN)) {
                AffairUnAuditAppUtils.checkEmpOrgRelationMainIsLatest(ctx, latestInfo, isEmpEnroll);
                AffairUnAuditAppUtils.checkHaveAfterCurrentBizDateBill(ctx, billId, personId, entryBizDate, false);
                AffairUnAuditAppUtils.checkPersonInAffairProcessEmpPostRankNotChange(ctx, billId, personId, isEmpEnroll);
            } else if (latestInfo.getAssignType().equals((Object)AssignTypeEnum.PARTTIME)) {
                AffairUnAuditAppUtils.checkEmpOrgRelationPartTimeIFFlowInCanNotFlowOut(ctx, latestInfo, affairEntryId);
            }
            if (HRBizDefineTypeEnum.RESIGN.equals((Object)latestInfo.getAction().getBizDefineType()) || HRBizDefineTypeEnum.RETIRE.equals((Object)latestInfo.getAction().getBizDefineType()) || HRBizDefineTypeEnum.REINVITEFIRE.equals((Object)latestInfo.getAction().getBizDefineType())) {
                AffairUnAuditAppUtils.checkPersonHasEmpJobGradeBill(ctx, personInfo, empPosOrgRelColl);
            }
        }
        AffairUnAuditAppUtils.checkIfOrgLocked(ctx, empPosOrgRelColl);
        AffairUnAuditAppUtils.checkIfOrgPositionEnable(ctx, empPosOrgRelColl);
        AffairUnAuditAppUtils.checkPersonInBuRelationBuilding(ctx, personId);
    }

    public static void checkPersonCanDelete(Context ctx, String personId, boolean isEmpinit) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filterInfo.getFilterItems().add(new FilterItemInfo("isInner", (Object)new Integer(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("assignType", (Object)AssignTypeEnum.MAIN));
        view.setFilter(filterInfo);
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        view.setSelector(helper.getSelector());
        SorterItemCollection sortCollection = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("startDateTime");
        sortInfo.setSortType(SortType.DESCEND);
        sortCollection.add(sortInfo);
        view.setSorter(sortCollection);
        EmpPosOrgRelationCollection empPosOrgRelColl = EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationCollection(view);
        EmpPosOrgRelationInfo latestInfo = null;
        PersonInfo personInfo = null;
        try {
            personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AffairUnAuditException(AffairUnAuditException.ERROR_PERSON_NOT_FOUND);
        }
        String enrollAffairId = "";
        if (empPosOrgRelColl.size() > 1) {
            latestInfo = empPosOrgRelColl.get(0);
            String personName = personInfo.getName();
            HRBizDefineInfo hrBizDefineInfo = latestInfo.getAction();
            Object[] params = new Object[]{personName, hrBizDefineInfo.getName()};
            throw new AffairUnAuditException(AffairUnAuditException.ERROR_ACTION_NOT_NEWEST, params);
        }
        if (empPosOrgRelColl.size() == 1) {
            EmpPosOrgRelationInfo info = empPosOrgRelColl.get(0);
            enrollAffairId = info.getFlowInAffairID();
        }
        AffairUnAuditAppUtils.checkIfOrgLocked(ctx, empPosOrgRelColl);
        AffairUnAuditAppUtils.checkPersonHasEmpJobGradeBill(ctx, personInfo, empPosOrgRelColl);
        AffairUnAuditAppUtils.checkPersonInAffairProcess(ctx, enrollAffairId, personId, true);
        if (!isEmpinit) {
            AffairUnAuditAppUtils.checkPersonInBuRelationBuilding(ctx, personId);
        }
    }

    public static void checkAffairNotRelatedEmpOrgRelationCanUntiCheck(Context ctx, String affairEntryId, String personId) throws EASBizException, BOSException {
        HRAffairBizCollection coll = HRAffairBizFactory.getLocalInstance((Context)ctx).getHRAffairBizCollection("select billID,entryBizDate where entryID = '" + affairEntryId + "'");
        String billId = coll.get(0).getBillID().toString();
        Date entryBizDate = coll.get(0).getEntryBizDate();
        AffairUnAuditAppUtils.checkPersonInAffairProcessEmpPostRankNotChange(ctx, billId, personId, false);
        AffairUnAuditAppUtils.checkHaveAfterCurrentBizDateBill(ctx, billId, personId, entryBizDate, false);
    }

    public static void checkEmpPostRankCanUntiCheck(Context ctx, String affairEntryId, String personId) throws EASBizException, BOSException {
        HRAffairBizCollection coll = HRAffairBizFactory.getLocalInstance((Context)ctx).getHRAffairBizCollection("select billID,entryBizDate where entryID = '" + affairEntryId + "'");
        String billId = coll.get(0).getBillID().toString();
        Date entryBizDate = coll.get(0).getEntryBizDate();
        AffairUnAuditAppUtils.checkPersonInAffairProcessByEmppostRank(ctx, billId, personId);
        AffairUnAuditAppUtils.checkHaveAfterCurrentBizDateBillByEmppostRank(ctx, billId, personId, entryBizDate);
    }

    private static void checkHaveAfterCurrentBizDateBillByEmppostRank(Context ctx, String billId, String personId, Date entryBizDate) throws BOSException, EASBizException {
        String oql = "select person.id,person.name,person.number,billBOSType,billID,entryID where person = '" + personId + "' and billState = " + 3 + " and billID<> '" + billId + "' and entryBizDate >" + HRUtilExtend.getDateStringWithoutMininuteTs(entryBizDate) + " and entryBizDate <= " + HRUtilExtend.getDateStringWithoutMininuteTs(new Date());
        HRAffairBizCollection col = HRAffairBizFactory.getLocalInstance((Context)ctx).getHRAffairBizCollection(oql.toString());
        BatchProcessedResult result = null;
        if (col != null && col.size() > 0) {
            result = new BatchProcessedResult();
            String personNumber = null;
            String personName = null;
            String billName = null;
            HRAffairBizInfo bizInfo = null;
            String bosType = null;
            String exsitBillId = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                bizInfo = col.get(i);
                personNumber = bizInfo.getPerson().getNumber();
                personName = bizInfo.getPerson().getName();
                bosType = bizInfo.getBillBOSType();
                billName = loader.getEntity(BOSObjectType.create((String)bosType)).getAlias();
                exsitBillId = bizInfo.getBillID().toString();
                String entityName = loader.getEntity(BOSObjectType.create((String)bosType)).getFullName();
                IHRAffairBizBill IHRAffairBizBill2 = (IHRAffairBizBill)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
                HRAffairBizBillInfo billInfo = IHRAffairBizBill2.getHRAffairBizBillInfo((IObjectPK)new ObjectUuidPK(exsitBillId));
                if (!AffairUnAuditAppUtils.checkIsEndEmpPostRank(ctx, bizInfo) && !EmpPostRankUtil.isPostRankChange((Context)ctx, (String)exsitBillId, (String)personId)) continue;
                String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"label98", (Context)ctx);
                Object[] params = new Object[]{personNumber, personName, billName, billName, billInfo.getNumber()};
                message = MessageFormat.format(message, params);
                result.addinvalidInfo(message);
            }
        }
        if (result != null && result.isHasValidInfo()) {
            throw new AffairBizException(AffairBizException.BILL_CHECK_FAILED, new Object[]{result.getInvalidInfo()});
        }
    }

    private static boolean checkIsEndEmpPostRank(Context ctx, HRAffairBizInfo bizInfo) throws EASBizException, BOSException {
        String entryId = bizInfo.getEntryID().toString();
        String entryBosTypeString = BOSUuid.read((String)entryId).getType().toString();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String entityName = loader.getEntity(BOSObjectType.create((String)entryBosTypeString)).getFullName();
        IHRAffairBizBillEntry IHRAffairBizBillEntry2 = (IHRAffairBizBillEntry)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
        HRAffairBizBillEntryInfo entryInfo = IHRAffairBizBillEntry2.getHRAffairBizBillEntryInfo("select hrBizDefine.id,hrBizDefine.bizDefineType,id,name,number where id ='" + entryId + "'");
        HRBizDefineInfo action = entryInfo.getHrBizDefine();
        return HRBizDefineTypeEnum.RESIGN.equals((Object)action.getBizDefineType()) || HRBizDefineTypeEnum.RETIRE.equals((Object)action.getBizDefineType()) || HRBizDefineTypeEnum.REINVITEFIRE.equals((Object)action.getBizDefineType());
    }

    private static void checkPersonHasEmpJobGradeBill(Context ctx, PersonInfo personInfo2, EmpPosOrgRelationCollection empPosOrgRelColl) throws EASBizException, BOSException {
        String entryId;
        BOSUuid entryUuid;
        HRAffairActionTransactionLogCollection hrAATLColl;
        EmpPostRankInfo empPostRankInfo;
        EmpPosOrgRelationInfo latestInfo = empPosOrgRelColl.get(0);
        String effdtStr = HRUtilExtend.getDateStringWithMinuteTs(latestInfo.getEFFDT());
        PersonInfo personInfo = latestInfo.getPerson();
        StringBuilder oql = new StringBuilder("where person ='").append(personInfo.getId().toString()).append("' and effdt >= ").append(effdtStr).append(" order by effdt desc, isLatest desc");
        EmpPostRankCollection empPostRankColl = EmpPostRankFactory.getLocalInstance((Context)ctx).getEmpPostRankCollection(oql.toString());
        if (empPostRankColl.size() > 0 && (empPostRankInfo = empPostRankColl.get(0)).getFlowInAffairID() != null && (hrAATLColl = HRAffairActionTransactionLogFactory.getLocalInstance(ctx).getHRAffairActionTransactionLogCollection("select affairEntryID where id = '" + empPostRankInfo.getFlowInAffairID() + "'")).size() > 0 && hrAATLColl.get(0).getAffairEntryID() != null && (entryUuid = BOSUuid.read((String)(entryId = hrAATLColl.get(0).getAffairEntryID()))).getType().equals((Object)new RiseBizBillEntryInfo().getBOSType())) {
            oql = new StringBuilder("select bill.* where id ='").append(entryId).append("' ");
            RiseBizBillEntryCollection riseCollection = RiseBizBillEntryFactory.getLocalInstance((Context)ctx).getRiseBizBillEntryCollection(oql.toString());
            if (riseCollection.size() > 0) {
                RiseBizBillInfo newestBillInfo = riseCollection.get(0).getBill();
                Object[] params = new Object[]{personInfo2.getNumber(), personInfo2.getName(), newestBillInfo.getNumber()};
                throw new AffairUnAuditException(AffairUnAuditException.ERROR_HASEMPJOBGRADE_BEHIND, params);
            }
        }
    }

    private static void checkEmpOrgRelationPartTimeIFFlowInCanNotFlowOut(Context ctx, EmpPosOrgRelationInfo latestInfo, String affairEntryId) throws EASBizException, BOSException {
        if (affairEntryId.equals(latestInfo.getFlowInAffairID())) {
            String personId = latestInfo.getPerson().getId().toString();
            String oql = "select bill.* where person ='" + personId + "' and oldPosition='" + latestInfo.getPosition().getId().toString() + "' and beginDate='" + latestInfo.getEFFDT() + "' ";
            CoreBaseCollection coll = PluralityDelBizBillEntryFactory.getLocalInstance((Context)ctx).getCollection(oql);
            if (coll.size() > 0) {
                PluralityDelBizBillEntryInfo pluralityDel = (PluralityDelBizBillEntryInfo)coll.get(0);
                String billId = pluralityDel.getBill().getId().toString();
                IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                BOSObjectType bosType = BOSUuid.read((String)billId).getType();
                String billName = loader.getEntity(BOSObjectType.create((String)bosType.toString())).getAlias();
                String entityName = loader.getEntity(BOSObjectType.create((String)bosType.toString())).getFullName();
                IHRAffairBizBill IHRAffairBizBill2 = (IHRAffairBizBill)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
                HRAffairBizBillInfo billInfo = IHRAffairBizBill2.getHRAffairBizBillInfo((IObjectPK)new ObjectUuidPK(billId));
                String personName = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId)).getName();
                Object[] params = new Object[]{personName, billName, billName, billInfo.getNumber()};
                String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label126", (Context)ctx);
                message = MessageFormat.format(message, params);
                throw new AffairBizException(AffairBizException.BILL_CHECK_FAILED, new Object[]{message});
            }
        }
    }

    private static void checkEmpOrgRelationMainIsLatest(Context ctx, EmpPosOrgRelationInfo latestInfo, boolean isEmpEnroll) throws EASBizException, BOSException {
        String personId = latestInfo.getPerson().getId().toString();
        Date latestStartDateTime = latestInfo.getStartDateTime();
        EmpPosOrgRelationCollection afterColl = null;
        if (isEmpEnroll) {
            if (!StringUtils.isEmpty((String)personId) && latestStartDateTime != null) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
                filterInfo.getFilterItems().add(new FilterItemInfo("isInner", (Object)new Integer(1)));
                filterInfo.getFilterItems().add(new FilterItemInfo("startDateTime", (Object)latestStartDateTime, CompareType.GREATER));
                filterInfo.setMaskString("#0 and #1 and #2 ");
                view.setFilter(filterInfo);
                EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
                view.setSelector(helper.getSelector());
                SorterItemCollection sortCollection = new SorterItemCollection();
                SorterItemInfo sortInfo = new SorterItemInfo("startDateTime");
                sortInfo.setSortType(SortType.DESCEND);
                sortCollection.add(sortInfo);
                view.setSorter(sortCollection);
                afterColl = EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationCollection(view);
            }
        } else {
            afterColl = EmpPosOrgRelationFacadeFactory.getLocalInstance(ctx).getStartDateAfterAppointDateRecord(personId, latestStartDateTime);
        }
        if (afterColl != null && afterColl.size() > 0) {
            EmpPosOrgRelationInfo newestInfo = afterColl.get(0);
            String personName = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId)).getName();
            HRBizDefineInfo hrBizDefineInfo = newestInfo.getAction();
            Object[] params = new Object[]{personName, hrBizDefineInfo.getName()};
            throw new AffairUnAuditException(AffairUnAuditException.ERROR_ACTION_NOT_NEWEST, params);
        }
    }

    private static void checkEmpOrgRelationFromMultiEntry(Context ctx, PersonInfo personInfo, EmpPosOrgRelationInfo info, HRAffairBizBillInfo billInfo) throws EASBizException, BOSException {
        if (billInfo != null && billInfo.get("isMulti") != null && Boolean.valueOf(billInfo.get("isMulti").toString()).booleanValue()) {
            Object[] params = new Object[4];
            params[0] = personInfo.getNumber();
            params[1] = personInfo.getName();
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            BOSObjectType bosType = billInfo.getBOSType();
            String billMetaName = loader.getEntity(BOSObjectType.create((String)bosType.toString())).getAlias();
            params[2] = billMetaName;
            params[3] = billInfo.getNumber();
            throw new AffairUnAuditException(AffairUnAuditException.ERROR_RECOVER_FROM_MUILTI_BILL, params);
        }
    }

    private static void checkOnlyOneEmpPosOrgRelaCannotRecovery(Context ctx, EmpPosOrgRelationInfo info) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)info.getPerson().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("isInner", (Object)new Integer(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("assignType", (Object)AssignTypeEnum.MAIN));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        EmpPosOrgRelationCollection collection = EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationCollection(view);
        if (collection.size() == 1 && info.getId() != null && info.getId().toString().equals(collection.get(0).getId().toString())) {
            throw new AffairUnAuditException(AffairUnAuditException.IS_FIRST_EMPORGRELATION);
        }
    }

    public static void updatePersonSinglePagePartial(ICoreBase localInterface, CoreBaseInfo plInfo, String columnStrings) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)columnStrings)) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (plInfo instanceof PersonInfo) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)((PersonInfo)plInfo.get("person")).getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)((PersonInfo)plInfo.get("person")).getId().toString()));
        }
        view.setFilter(filter);
        CoreBaseCollection collection = localInterface.getCollection(view);
        if (collection == null || collection.size() == 0) {
            return;
        }
        plInfo.setId(collection.get(0).getId());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        String[] columns = StringUtils.split((String)columnStrings, (String)",");
        for (int i = 0; i < columns.length; ++i) {
            sic.add(new SelectorItemInfo(columns[i]));
        }
        localInterface.updatePartial(plInfo, sic);
    }

    private static void checkLogCanUnAudit(Context ctx, String entryID) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("affairEntryID", (Object)entryID));
        if (!HRAffairActionTransactionLogFactory.getLocalInstance(ctx).exists(filter)) {
            throw new HRCommonException(HRCommonException.UPDATERBEFORERECORDNOTUNAUDIT);
        }
    }

    private static void checkIfOrgLocked(Context ctx, EmpPosOrgRelationCollection empPosOrgRelColl) throws EASBizException, BOSException {
        EmpPosOrgRelationInfo everyInfo = null;
        int size = empPosOrgRelColl.size();
        for (int i = 0; i < size; ++i) {
            everyInfo = empPosOrgRelColl.get(i);
            if (everyInfo.getAdminOrg() == null || everyInfo.getPosition() == null) continue;
            OrgAdjLockManager.checkIfOrgLocked((Context)ctx, (String)everyInfo.getAdminOrg().getId().toString(), (String)everyInfo.getPosition().getId().toString());
        }
    }

    public static void checkPersonInAffairProcess(Context ctx, String billID, String personId, boolean isEmpEnroll) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)personId)) {
            return;
        }
        String bosTypeStr = "";
        Boolean isEmpOrFluc = false;
        Boolean isResign = false;
        BOSObjectType billBOSType = null;
        if (!StringUtils.isEmpty((String)billID)) {
            billBOSType = BOSUuid.read((String)billID).getType();
        }
        if (billBOSType != null) {
            bosTypeStr = billBOSType.toString();
        }
        boolean flag = HRParamUtil.getParamOfHR(ctx, "IS_RESIGN_CHECKOTHERBILL", null);
        if ("B65CCEF1".equals(bosTypeStr) || "C0DAD00D".equals(bosTypeStr)) {
            isEmpOrFluc = true;
        }
        if ("CC58A617".equals(bosTypeStr)) {
            isResign = true;
        }
        String currDate = AffairUnAuditAppUtils.getCurrentDate();
        StringBuffer oql = new StringBuffer("select person.id,person.name,person.number,billBOSType,billID ");
        oql.append("where person.id in ");
        oql.append(AffairUnAuditAppUtils.getIdsSql(personId));
        if (!StringUtils.isEmpty((String)billID)) {
            oql.append(" and billID <> '");
            oql.append(billID);
            oql.append("' ");
        }
        if (!isEmpEnroll) {
            oql.append(" and billBOSType<> 'B3F8AB50' ");
            oql.append(" and billBOSType<> '6422D4A6' ");
        }
        oql.append(" and (");
        oql.append(" billState = ");
        oql.append(0);
        oql.append(" or billState = ");
        oql.append(1);
        oql.append(" or billState = ");
        oql.append(2);
        oql.append(" or (billState = ");
        oql.append(3);
        oql.append(" and entryBizDate > ");
        oql.append(currDate);
        oql.append(" ))");
        HRAffairBizCollection col = HRAffairBizFactory.getLocalInstance((Context)ctx).getHRAffairBizCollection(oql.toString());
        BatchProcessedResult result = new BatchProcessedResult();
        if ((col == null || col.size() <= 0) && isEmpEnroll) {
            StringBuffer oql2 = new StringBuffer("select person.id,person.name,person.number,billBOSType,billID ");
            oql2.append("where person.id in ");
            oql2.append(AffairUnAuditAppUtils.getIdsSql(personId));
            if (!StringUtils.isEmpty((String)billID)) {
                oql2.append(" and billID <> '");
                oql2.append(billID);
                oql2.append("' ");
            }
            oql2.append(" and (billBOSType= 'B3F8AB50' ");
            oql2.append(" or billBOSType= '6422D4A6' ) ");
            col = HRAffairBizFactory.getLocalInstance((Context)ctx).getHRAffairBizCollection(oql2.toString());
        }
        if (col != null && col.size() > 0) {
            String personNumber = null;
            String personName = null;
            String billName = null;
            HRAffairBizInfo bizInfo = null;
            String bosType = null;
            String exsitBillId = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                bizInfo = col.get(i);
                personNumber = bizInfo.getPerson().getNumber();
                personName = bizInfo.getPerson().getName();
                bosType = bizInfo.getBillBOSType();
                billName = loader.getEntity(BOSObjectType.create((String)bosType)).getAlias();
                exsitBillId = bizInfo.getBillID().toString();
                String entityName = loader.getEntity(BOSObjectType.create((String)bosType)).getFullName();
                IHRAffairBizBill IHRAffairBizBill2 = (IHRAffairBizBill)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
                HRAffairBizBillInfo billInfo = IHRAffairBizBill2.getHRAffairBizBillInfo((IObjectPK)new ObjectUuidPK(exsitBillId));
                if (flag && isEmpOrFluc.booleanValue() && "CC58A617".equals(bosType) || flag && isResign.booleanValue() && ("B65CCEF1".equals(bosType) || "C0DAD00D".equals(bosType))) continue;
                String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label127", (Context)ctx);
                Object[] params = new Object[]{personNumber, personName, billName, billName, billInfo.getNumber()};
                message = MessageFormat.format(message, params);
                result.addinvalidInfo(message);
            }
        }
        if (result != null && result.isHasValidInfo()) {
            throw new AffairBizException(AffairBizException.BILL_CHECK_FAILED, new Object[]{result.getInvalidInfo()});
        }
    }

    public static void checkPersonInAffairProcessEmpPostRankNotChange(Context ctx, String billID, String personId, boolean isEmpEnroll) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)personId)) {
            return;
        }
        String bosTypeStr = "";
        Boolean isEmpOrFluc = false;
        Boolean isResign = false;
        BOSObjectType billBOSType = BOSUuid.read((String)billID).getType();
        if (billBOSType != null) {
            bosTypeStr = billBOSType.toString();
        }
        boolean flag = HRParamUtil.getParamOfHR(ctx, "IS_RESIGN_CHECKOTHERBILL", null);
        if ("B65CCEF1".equals(bosTypeStr) || "C0DAD00D".equals(bosTypeStr)) {
            isEmpOrFluc = true;
        }
        if ("CC58A617".equals(bosTypeStr)) {
            isResign = true;
        }
        String currDate = AffairUnAuditAppUtils.getCurrentDate();
        StringBuffer oql = new StringBuffer("select person.id,person.name,person.number,billBOSType,billID ");
        oql.append("where person.id in ");
        oql.append(AffairUnAuditAppUtils.getIdsSql(personId));
        if (!StringUtils.isEmpty((String)billID)) {
            oql.append(" and billID <> '");
            oql.append(billID);
            oql.append("' ");
        }
        if (!isEmpEnroll) {
            oql.append(" and billBOSType<> 'B3F8AB50' ");
            oql.append(" and billBOSType<> '6422D4A6' ");
        }
        oql.append(" and (");
        oql.append(" billState = ");
        oql.append(0);
        oql.append(" or billState = ");
        oql.append(1);
        oql.append(" or billState = ");
        oql.append(2);
        oql.append(" or (billState = ");
        oql.append(3);
        oql.append(" and entryBizDate > ");
        oql.append(currDate);
        oql.append(" ))");
        HRAffairBizCollection col = HRAffairBizFactory.getLocalInstance((Context)ctx).getHRAffairBizCollection(oql.toString());
        BatchProcessedResult result = new BatchProcessedResult();
        if ((col == null || col.size() <= 0) && isEmpEnroll) {
            StringBuffer oql2 = new StringBuffer("select person.id,person.name,person.number,billBOSType,billID ");
            oql2.append("where person.id in ");
            oql2.append(AffairUnAuditAppUtils.getIdsSql(personId));
            if (!StringUtils.isEmpty((String)billID)) {
                oql2.append(" and billID <> '");
                oql2.append(billID);
                oql2.append("' ");
            }
            oql2.append(" and (billBOSType= 'B3F8AB50' ");
            oql2.append(" or billBOSType= '6422D4A6' ) ");
            col = HRAffairBizFactory.getLocalInstance((Context)ctx).getHRAffairBizCollection(oql2.toString());
        }
        if (col != null && col.size() > 0) {
            String personNumber = null;
            String personName = null;
            String billName = null;
            HRAffairBizInfo bizInfo = null;
            String bosType = null;
            String exsitBillId = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                bizInfo = col.get(i);
                personNumber = bizInfo.getPerson().getNumber();
                personName = bizInfo.getPerson().getName();
                bosType = bizInfo.getBillBOSType();
                billName = loader.getEntity(BOSObjectType.create((String)bosType)).getAlias();
                exsitBillId = bizInfo.getBillID().toString();
                String entityName = loader.getEntity(BOSObjectType.create((String)bosType)).getFullName();
                IHRAffairBizBill IHRAffairBizBill2 = (IHRAffairBizBill)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
                HRAffairBizBillInfo billInfo = IHRAffairBizBill2.getHRAffairBizBillInfo((IObjectPK)new ObjectUuidPK(exsitBillId));
                if (EMPPOSTRANK_BOSTYPE.equals(bosType) || flag && isEmpOrFluc.booleanValue() && "CC58A617".equals(bosType) || flag && isResign.booleanValue() && ("B65CCEF1".equals(bosType) || "C0DAD00D".equals(bosType))) continue;
                String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label127", (Context)ctx);
                Object[] params = new Object[]{personNumber, personName, billName, billName, billInfo.getNumber()};
                message = MessageFormat.format(message, params);
                result.addinvalidInfo(message);
            }
        }
        if (result != null && result.isHasValidInfo()) {
            throw new AffairBizException(AffairBizException.BILL_CHECK_FAILED, new Object[]{result.getInvalidInfo()});
        }
    }

    public static void checkPersonInAffairProcessByEmppostRank(Context ctx, String billID, String personId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)personId)) {
            return;
        }
        String currDate = AffairUnAuditAppUtils.getCurrentDate();
        StringBuffer oql = new StringBuffer("select person.id,person.name,person.number,billBOSType,billID ");
        oql.append("where person.id in ");
        oql.append(AffairUnAuditAppUtils.getIdsSql(personId));
        if (!StringUtils.isEmpty((String)billID)) {
            oql.append(" and billID <> '");
            oql.append(billID);
            oql.append("' ");
        }
        oql.append(" and (");
        oql.append(" billState = ");
        oql.append(0);
        oql.append(" or billState = ");
        oql.append(1);
        oql.append(" or billState = ");
        oql.append(2);
        oql.append(" or (billState = ");
        oql.append(3);
        oql.append(" and entryBizDate > ");
        oql.append(currDate);
        oql.append(" ))");
        HRAffairBizCollection col = HRAffairBizFactory.getLocalInstance((Context)ctx).getHRAffairBizCollection(oql.toString());
        BatchProcessedResult result = new BatchProcessedResult();
        if (col != null && col.size() > 0) {
            String personNumber = null;
            String personName = null;
            String billName = null;
            HRAffairBizInfo bizInfo = null;
            String bosType = null;
            String exsitBillId = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                bizInfo = col.get(i);
                personNumber = bizInfo.getPerson().getNumber();
                personName = bizInfo.getPerson().getName();
                bosType = bizInfo.getBillBOSType();
                billName = loader.getEntity(BOSObjectType.create((String)bosType)).getAlias();
                exsitBillId = bizInfo.getBillID().toString();
                String entityName = loader.getEntity(BOSObjectType.create((String)bosType)).getFullName();
                IHRAffairBizBill IHRAffairBizBill2 = (IHRAffairBizBill)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
                HRAffairBizBillInfo billInfo = IHRAffairBizBill2.getHRAffairBizBillInfo((IObjectPK)new ObjectUuidPK(exsitBillId));
                if (!EmpPostRankUtil.isPostRankChange((Context)ctx, (String)exsitBillId, (String)personId)) continue;
                String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"label98", (Context)ctx);
                Object[] params = new Object[]{personNumber, personName, billName, billName, billInfo.getNumber()};
                message = MessageFormat.format(message, params);
                result.addinvalidInfo(message);
            }
        }
        if (result != null && result.isHasValidInfo()) {
            throw new AffairBizException(AffairBizException.BILL_CHECK_FAILED, new Object[]{result.getInvalidInfo()});
        }
    }

    private static String getCurrentDate() {
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "{ts'" + sFormat.format(cal.getTime()) + "'}";
    }

    private static String getIdsSql(String ids) {
        String[] idarrs = ids.split(",");
        StringBuffer idsSql = new StringBuffer();
        boolean isfirst = true;
        idsSql.append("(");
        for (int i = 0; i < idarrs.length; ++i) {
            if (StringUtils.isEmpty((String)idarrs[i])) continue;
            if (!isfirst) {
                idsSql.append(",");
            }
            isfirst = false;
            idsSql.append("'");
            idsSql.append(idarrs[i]);
            idsSql.append("'");
        }
        idsSql.append(")");
        return idsSql.toString();
    }

    private static void checkPersonInBuRelationBuilding(Context ctx, String personId) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder("select Fid from T_HR_EmpOrgRelation eor where Fid not in (").append(" select rel.FEmpOrgRelationID  from T_HR_EmpHRORelationHis rel where eor.Fpersonid = rel.Fpersonid ) and FisInner=1 and FPersonId = '").append(personId).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                throw new AffairActioniOperateException(AffairActioniOperateException.UPDATING_PERSON_BURELA);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private static void checkHaveAfterCurrentBizDateBill(Context ctx, String billId, String personId, Date entryBizDate, boolean isCheckEmpPostRank) throws EASBizException, BOSException {
        String bosTypeStr = "";
        Boolean isEmpOrFluc = false;
        Boolean isResign = false;
        BOSObjectType billBOSType = BOSUuid.read((String)billId).getType();
        if (billBOSType != null) {
            bosTypeStr = billBOSType.toString();
        }
        boolean flag = HRParamUtil.getParamOfHR(ctx, "IS_RESIGN_CHECKOTHERBILL", null);
        if ("B65CCEF1".equals(bosTypeStr) || "C0DAD00D".equals(bosTypeStr)) {
            isEmpOrFluc = true;
        }
        if ("CC58A617".equals(bosTypeStr)) {
            isResign = true;
        }
        String oql = "select person.id,person.name,person.number,billBOSType,billID where person = '" + personId + "' and billState = " + 3 + " and billID<> '" + billId + "' and billBOSType<> '" + PLURALITYADD_BOSTYPE + "'  and billBOSType<> '" + PLURALITYDEL_BOSTYPE + "'  and entryBizDate >" + HRUtilExtend.getDateStringWithoutMininuteTs(entryBizDate);
        HRAffairBizCollection col = HRAffairBizFactory.getLocalInstance((Context)ctx).getHRAffairBizCollection(oql.toString());
        BatchProcessedResult result = new BatchProcessedResult();
        if (col != null && col.size() > 0) {
            String personNumber = null;
            String personName = null;
            String billName = null;
            HRAffairBizInfo bizInfo = null;
            String bosType = null;
            String exsitBillId = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                bizInfo = col.get(i);
                personNumber = bizInfo.getPerson().getNumber();
                personName = bizInfo.getPerson().getName();
                bosType = bizInfo.getBillBOSType();
                billName = loader.getEntity(BOSObjectType.create((String)bosType)).getAlias();
                exsitBillId = bizInfo.getBillID().toString();
                String entityName = loader.getEntity(BOSObjectType.create((String)bosType)).getFullName();
                IHRAffairBizBill IHRAffairBizBill2 = (IHRAffairBizBill)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
                HRAffairBizBillInfo billInfo = IHRAffairBizBill2.getHRAffairBizBillInfo((IObjectPK)new ObjectUuidPK(exsitBillId));
                if (!isCheckEmpPostRank && EMPPOSTRANK_BOSTYPE.equals(bosType) || flag && isEmpOrFluc.booleanValue() && "CC58A617".equals(bosType) || flag && isResign.booleanValue() && ("B65CCEF1".equals(bosType) || "C0DAD00D".equals(bosType)) || "87D81833".equals(bosType) && HRBillStateEnum.AUDITED.equals((Object)billInfo.getBillState()) || "6A86A84F".equals(bosType) && HRBillStateEnum.AUDITED.equals((Object)billInfo.getBillState())) continue;
                String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label127", (Context)ctx);
                Object[] params = new Object[]{personNumber, personName, billName, billName, billInfo.getNumber()};
                message = MessageFormat.format(message, params);
                result.addinvalidInfo(message);
            }
        }
        if (result != null && result.isHasValidInfo()) {
            throw new AffairBizException(AffairBizException.BILL_CHECK_FAILED, new Object[]{result.getInvalidInfo()});
        }
    }
}

