/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import java.util.Locale;

public class CoreBaseObjectUtil {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getValue(Context ctx, CoreBaseInfo obj, String fieldName) throws BOSException {
        if (obj == null) {
            return null;
        }
        Object value = null;
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(obj.getBOSType());
        PropertyInfo propertyInfo = entityInfo.getPropertyByName(fieldName);
        if (!(propertyInfo instanceof OwnPropertyInfo)) return obj.get(fieldName);
        OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)propertyInfo;
        if (ownPropertyInfo.isMultilingual()) {
            return obj.get(fieldName, (Locale)null);
        }
        value = obj.get(fieldName);
        try {
            if (ownPropertyInfo.getEnumType() == null) return value;
            if (value == null) return value;
            if (value instanceof Enum) return value;
            String enumRefName = ownPropertyInfo.getEnumType().getFullName();
            Class<?> enumClass = Class.forName(enumRefName);
            MetaDataPK metaPk = MetaDataPK.create((String)enumRefName);
            BizEnumInfo bizEnum = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEnum((IMetaDataPK)metaPk);
            if (bizEnum.getDataType() == BizEnumValueType.INTEGER) {
                return EnumUtils.getEnum(enumClass, (int)Double.valueOf(value.toString()).intValue());
            }
            if (bizEnum.getDataType() == BizEnumValueType.STRING) {
                return EnumUtils.getEnumByValue(enumClass, (String)value.toString());
            }
            if (bizEnum.getDataType() == BizEnumValueType.LONG) {
                return EnumUtils.getEnum(enumClass, (long)Long.parseLong(value.toString()));
            }
            if (bizEnum.getDataType() == BizEnumValueType.FLOAT) {
                return EnumUtils.getEnum(enumClass, (float)Float.parseFloat(value.toString()));
            }
            if (bizEnum.getDataType() != BizEnumValueType.DOUBLE) return value;
            return EnumUtils.getEnum(enumClass, (double)Double.parseDouble(value.toString()));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void setValue(Context ctx, CoreBaseInfo obj, String fieldName, Object value) {
        if (obj == null) {
            return;
        }
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(obj.getBOSType());
        PropertyInfo propertyInfo = entityInfo.getPropertyByName(fieldName);
        if (propertyInfo instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)propertyInfo;
            if (ownPropertyInfo.isMultilingual()) {
                obj.put(fieldName, value, ctx.getLocale());
            } else {
                obj.put(fieldName, value);
            }
        } else {
            obj.put(fieldName, value);
        }
    }
}

