/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.hr.base.BizBillAttachmentReverseFactory;
import com.kingdee.eas.hr.base.BizBillAttachmentReverseInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.IBizBillAttachmentReverse;
import java.util.HashMap;
import java.util.Map;

public class SHRBizBillAttachmentReverseUtils {
    private static Map<String, IBizBillAttachmentReverse> BizBillAttachmentReverse;

    public static Boolean IsBizBillAttachmentReverse(Context ctx, String billEntryId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("billEntryId", (Object)billEntryId, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        boolean iSReverse = SHRBizBillAttachmentReverseUtils.getBizBillAttachmentReverseInterface(ctx).exists(filter);
        return iSReverse;
    }

    public static void saveBizBillAttachmentReverse(Context ctx, String billEntryId) throws EASBizException, BOSException {
        Boolean isBizBillAttachmentReverse = SHRBizBillAttachmentReverseUtils.IsBizBillAttachmentReverse(ctx, billEntryId);
        if (isBizBillAttachmentReverse.booleanValue()) {
            return;
        }
        BizBillAttachmentReverseInfo bizBillAttachmentReverseInfo = new BizBillAttachmentReverseInfo();
        String bosType = BOSUuid.read((String)billEntryId).getType().toString();
        bizBillAttachmentReverseInfo.setBillEntryId(billEntryId);
        bizBillAttachmentReverseInfo.setBosType(bosType);
        SHRBizBillAttachmentReverseUtils.getBizBillAttachmentReverseInterface(ctx).addnew(bizBillAttachmentReverseInfo);
    }

    public static void deleteBizBillAttachmentReverse(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ICoreBillBase iCoreBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)billID.getType());
        HRBillBaseInfo model = (HRBillBaseInfo)iCoreBillBase.getValue((IObjectPK)new ObjectUuidPK(billID));
        IObjectCollection entries = (IObjectCollection)model.get("entrys");
        HRBillBaseEntryInfo entry = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = (HRBillBaseEntryInfo)entries.getObject(i);
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("billEntryId", (Object)entry.getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            SHRBizBillAttachmentReverseUtils.getBizBillAttachmentReverseInterface(ctx).delete(filter);
        }
    }

    private static IBizBillAttachmentReverse getBizBillAttachmentReverseInterface(Context ctx) throws BOSException {
        IBizBillAttachmentReverse IBizBillAttachmentReverse2;
        if (BizBillAttachmentReverse == null) {
            BizBillAttachmentReverse = new HashMap<String, IBizBillAttachmentReverse>();
        }
        if ((IBizBillAttachmentReverse2 = BizBillAttachmentReverse.get("com.kingdee.eas.hr.base.app.BizBillAttachmentReverse")) == null) {
            try {
                IBizBillAttachmentReverse2 = BizBillAttachmentReverseFactory.getLocalInstance(ctx);
            }
            catch (BOSException e) {
                e.printStackTrace();
                throw e;
            }
            BizBillAttachmentReverse.put("com.kingdee.eas.hr.base.app.BizBillAttachmentReverse", IBizBillAttachmentReverse2);
        }
        return IBizBillAttachmentReverse2;
    }
}

