/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.timezone;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.base.timezone.CollectionUtil;
import com.kingdee.eas.hr.base.timezone.DataFetchModel;
import com.kingdee.eas.hr.base.timezone.Date;
import com.kingdee.eas.hr.base.timezone.RangeDataFetcher;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.InvalidDateException;
import com.kingdee.util.ObjectUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RangeDataUpdater {
    private Logger logger = Logger.getLogger(this.getClass());
    protected Context ctx;
    protected String effdtFieldName = "effdt";
    protected String leffdtFieldName = "leffdt";
    protected String filterObjFieldName = "person";
    protected DataFetchModel dataFetchModel;
    protected Timestamp beginTime;
    protected Timestamp endTime;
    protected int batchIdCount;
    protected boolean throwExceptionWhenNotSatisfy;
    protected int forceUpdateLevel;
    private List<String> delList;
    private List<CoreBaseInfo> originUpdateDatas = new ArrayList<CoreBaseInfo>();
    private Map<String, List<CoreBaseInfo>> existData;
    private CoreBaseCollection needUpdateDatas;

    public boolean update() throws EASBizException {
        this.init();
        if (this.originUpdateDatas.isEmpty()) {
            return false;
        }
        for (CoreBaseInfo updateInfo : this.originUpdateDatas) {
            if (StringUtils.isBlank((String)updateInfo.getString("id"))) {
                updateInfo.setId(BOSUuid.create((BOSObjectType)updateInfo.getBOSType()));
            }
            Timestamp start = updateInfo.getTimestamp(this.effdtFieldName);
            Timestamp end = updateInfo.getTimestamp(this.effdtFieldName);
            if (start == null || end == null || start.after(end)) continue;
            this.updateInner(updateInfo, this.getRelateExistData(updateInfo), this.existData.get(updateInfo.getObjectValue(this.filterObjFieldName).getString("id")));
        }
        return this.save();
    }

    protected boolean save() throws EASBizException {
        if (this.needUpdateDatas != null) {
            this.delList = this.delList == null ? new ArrayList() : this.delList;
            Iterator it = this.needUpdateDatas.iterator();
            while (it.hasNext()) {
                CoreBaseInfo coreBaseInfo = (CoreBaseInfo)it.next();
                if (!coreBaseInfo.getTimestamp(this.effdtFieldName).after(coreBaseInfo.getTimestamp(this.leffdtFieldName)) && !this.delList.contains(coreBaseInfo.getString("id"))) continue;
                it.remove();
            }
        }
        if (this.needUpdateDatas == null || this.needUpdateDatas.size() == 0) {
            return false;
        }
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity(this.needUpdateDatas.get(0).getBOSType());
        String entityName = entityObjectInfo.getFullName();
        try {
            ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)this.ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
            if (this.delList != null && this.delList.size() > 0) {
                String tableName = entityObjectInfo.getTable().getName();
                for (String sql : CollectionUtil.groupToSql(this.delList.iterator(), this.batchIdCount)) {
                    DbUtil.execute((Context)this.ctx, (String)("delete " + tableName + " where fid in " + sql));
                }
            }
            iCoreBase.save(this.needUpdateDatas);
        }
        catch (BOSException e) {
            throw new EASBizException(EASBizException.DBDEADLOCK, (Throwable)e);
        }
        return true;
    }

    protected void updateInner(CoreBaseInfo updateInfo, List<CoreBaseInfo> relateData, List<CoreBaseInfo> existData) throws EASBizException {
        if (relateData == null || relateData.size() == 0) {
            this.addToUpdateCollection(updateInfo, true);
            return;
        }
        CoreBaseInfo needChangeInfo = relateData.remove(0);
        if (relateData.size() > 0) {
            this.processHeadSection(updateInfo, needChangeInfo, existData);
            this.processTailSection(updateInfo, relateData.remove(relateData.size() - 1), existData);
            this.processMiddleSection(updateInfo, relateData);
        } else {
            this.processOnlyOneSection(updateInfo, needChangeInfo, existData);
        }
        if (!this.isUpdateFailed(updateInfo) && !updateInfo.getTimestamp(this.effdtFieldName).after(updateInfo.getTimestamp(this.leffdtFieldName))) {
            this.addToUpdateCollection(updateInfo, true);
        }
    }

    protected void processHeadSection(CoreBaseInfo updateInfo, CoreBaseInfo needChangeInfo, List<CoreBaseInfo> existData) throws EASBizException, InvalidDateException, IllegalConversionException {
        UpdateModel model = this.getUpdateModel(updateInfo, needChangeInfo, this.throwExceptionWhenNotSatisfy);
        if (model == UpdateModel.NOUPDATE) {
            updateInfo.setTimestamp(this.effdtFieldName, (Timestamp)Date.getDate(needChangeInfo.getTimestamp(this.leffdtFieldName)).nextDay());
            return;
        }
        Timestamp start = updateInfo.getTimestamp(this.effdtFieldName);
        if (needChangeInfo.getTimestamp(this.effdtFieldName).equals(start)) {
            this.processEqualEdge(updateInfo, existData, true);
            this.addToDel(needChangeInfo);
        }
        if (model == UpdateModel.UNION) {
            this.unionSection(updateInfo, needChangeInfo);
            return;
        }
        needChangeInfo.setTimestamp(this.leffdtFieldName, (Timestamp)Date.getDate(start).preDay());
        this.addToUpdateCollection(needChangeInfo, false);
    }

    protected boolean processEqualEdge(CoreBaseInfo updateInfo, List<CoreBaseInfo> existData, boolean isHeadEle) {
        if (existData == null || existData.size() == 0) {
            return false;
        }
        CoreBaseInfo needChangeInfo = this.getUpdateInfo(updateInfo, existData, isHeadEle);
        try {
            if (needChangeInfo != null && this.getUpdateModel(updateInfo, needChangeInfo, false) == UpdateModel.UNION) {
                this.unionSection(updateInfo, needChangeInfo);
                return true;
            }
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return false;
    }

    private CoreBaseInfo getUpdateInfo(CoreBaseInfo updateInfo, List<CoreBaseInfo> existData, boolean isHeadEle) {
        if (isHeadEle) {
            Date comparDate = Date.getDate(updateInfo.getTimestamp(this.effdtFieldName)).preDay();
            for (int i = existData.size() - 1; i >= 0; --i) {
                if (!comparDate.equals(existData.get(i).getTimestamp(this.leffdtFieldName))) continue;
                return existData.get(i);
            }
            return null;
        }
        Date comparDate = Date.getDate(updateInfo.getTimestamp(this.leffdtFieldName)).nextDay();
        for (int i = 0; i < existData.size(); ++i) {
            if (!comparDate.equals(existData.get(i).getTimestamp(this.effdtFieldName))) continue;
            return existData.get(i);
        }
        return null;
    }

    protected void processTailSection(CoreBaseInfo updateInfo, CoreBaseInfo needChangeInfo, List<CoreBaseInfo> existData) throws EASBizException, InvalidDateException, IllegalConversionException {
        UpdateModel model = this.getUpdateModel(updateInfo, needChangeInfo, this.throwExceptionWhenNotSatisfy);
        if (model == UpdateModel.NOUPDATE) {
            updateInfo.setTimestamp(this.leffdtFieldName, (Timestamp)Date.getDate(needChangeInfo.getTimestamp(this.effdtFieldName)).preDay());
            return;
        }
        Timestamp end = updateInfo.getTimestamp(this.leffdtFieldName);
        if (needChangeInfo.getTimestamp(this.leffdtFieldName).equals(end)) {
            this.processEqualEdge(updateInfo, existData, false);
            this.addToDel(needChangeInfo);
        }
        if (model == UpdateModel.UNION) {
            this.unionSection(updateInfo, needChangeInfo);
            return;
        }
        needChangeInfo.setTimestamp(this.effdtFieldName, (Timestamp)Date.getDate(end).nextDay());
        this.addToUpdateCollection(needChangeInfo, false);
    }

    protected void unionSection(CoreBaseInfo updateInfo, CoreBaseInfo needChangeInfo) {
        Timestamp start = updateInfo.getTimestamp(this.effdtFieldName);
        Timestamp end = updateInfo.getTimestamp(this.leffdtFieldName);
        if (needChangeInfo.getTimestamp(this.effdtFieldName).before(start)) {
            updateInfo.setTimestamp(this.effdtFieldName, needChangeInfo.getTimestamp(this.effdtFieldName));
        }
        if (needChangeInfo.getTimestamp(this.leffdtFieldName).after(end)) {
            updateInfo.setTimestamp(this.leffdtFieldName, needChangeInfo.getTimestamp(this.leffdtFieldName));
        }
        this.addToDel(needChangeInfo);
    }

    protected void processMiddleSection(CoreBaseInfo updateInfo, List<CoreBaseInfo> relateData) throws EASBizException {
        int total = relateData.size();
        for (int i = 0; i < total; ++i) {
            CoreBaseInfo updateInfoCopy;
            CoreBaseInfo needChangeInfo = relateData.get(i);
            UpdateModel model = this.getUpdateModel(updateInfo, needChangeInfo, this.throwExceptionWhenNotSatisfy);
            if (model != UpdateModel.NOUPDATE) {
                this.addToDel(needChangeInfo);
                continue;
            }
            try {
                updateInfoCopy = (CoreBaseInfo)ObjectUtils.createCopy((Object)updateInfo);
            }
            catch (CloneNotSupportedException e) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, e);
            }
            updateInfoCopy.setId(BOSUuid.create((BOSObjectType)updateInfo.getBOSType()));
            updateInfoCopy.setTimestamp(this.leffdtFieldName, (Timestamp)Date.getDate(needChangeInfo.getTime(this.effdtFieldName)).preDay());
            this.addToUpdateCollection(updateInfoCopy, true);
            updateInfo.setTimestamp(this.effdtFieldName, (Timestamp)Date.getDate(needChangeInfo.getTime(this.leffdtFieldName)).nextDay());
        }
    }

    protected void setUpdateFailed(CoreBaseInfo updateInfo) {
        if (updateInfo != null) {
            updateInfo.setBoolean("updateFailed", true);
        }
    }

    protected boolean isUpdateFailed(CoreBaseInfo updateInfo) {
        if (updateInfo != null) {
            return updateInfo.getBoolean("updateFailed");
        }
        return false;
    }

    protected void processOnlyOneSection(CoreBaseInfo updateInfo, CoreBaseInfo needChangeInfo, List<CoreBaseInfo> existData) throws EASBizException {
        UpdateModel model = this.getUpdateModel(updateInfo, needChangeInfo, this.throwExceptionWhenNotSatisfy);
        if (model == UpdateModel.NOUPDATE) {
            this.setUpdateFailed(updateInfo);
            return;
        }
        if (needChangeInfo.getTimestamp(this.effdtFieldName).equals(updateInfo.getTimestamp(this.effdtFieldName))) {
            this.processEqualEdge(updateInfo, existData, true);
        }
        if (needChangeInfo.getTimestamp(this.leffdtFieldName).equals(updateInfo.getTimestamp(this.leffdtFieldName))) {
            this.processEqualEdge(updateInfo, existData, false);
        }
        if (model == UpdateModel.UNION) {
            this.unionSection(updateInfo, needChangeInfo);
            return;
        }
        Timestamp start = updateInfo.getTimestamp(this.effdtFieldName);
        Timestamp end = updateInfo.getTimestamp(this.leffdtFieldName);
        if (!needChangeInfo.getTimestamp(this.effdtFieldName).before(start)) {
            if (!needChangeInfo.getTimestamp(this.leffdtFieldName).after(end)) {
                this.addToDel(needChangeInfo);
            } else {
                needChangeInfo.setTimestamp(this.effdtFieldName, (Timestamp)Date.getDate(end).nextDay());
                this.addToUpdateCollection(needChangeInfo, false);
            }
            return;
        }
        if (!needChangeInfo.getTimestamp(this.leffdtFieldName).after(end)) {
            needChangeInfo.setTimestamp(this.leffdtFieldName, (Timestamp)Date.getDate(start).preDay());
            this.addToUpdateCollection(needChangeInfo, false);
        } else {
            CoreBaseInfo needChangeInfoCopy = null;
            try {
                needChangeInfoCopy = (CoreBaseInfo)ObjectUtils.createCopy((Object)needChangeInfo);
            }
            catch (CloneNotSupportedException e) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, e);
            }
            needChangeInfo.setTimestamp(this.effdtFieldName, (Timestamp)Date.getDate(end).nextDay());
            needChangeInfoCopy.setTimestamp(this.leffdtFieldName, (Timestamp)Date.getDate(start).preDay());
            needChangeInfoCopy.setId(BOSUuid.create((BOSObjectType)needChangeInfo.getBOSType()));
            this.addToUpdateCollection(needChangeInfoCopy, true);
            this.addToUpdateCollection(needChangeInfo, false);
        }
    }

    protected UpdateModel getUpdateModel(CoreBaseInfo updateInfo, CoreBaseInfo needChangeInfo, boolean throwExceptionWhenNotSatisfy) throws EASBizException {
        return UpdateModel.UPDATE;
    }

    protected RangeDataUpdater addToDel(Object delObjs) {
        if (delObjs == null) {
            return this;
        }
        if (this.delList == null) {
            this.delList = new ArrayList<String>();
        }
        Iterator it = null;
        if (delObjs instanceof Collection) {
            it = ((Collection)delObjs).iterator();
        } else if (delObjs instanceof IObjectCollection) {
            it = ((IObjectCollection)delObjs).iterator();
        }
        if (it == null) {
            this.addOneToDel(delObjs);
        } else {
            while (it.hasNext()) {
                this.addOneToDel(it.next());
            }
        }
        return this;
    }

    private void addOneToDel(Object delObj) {
        if (delObj instanceof CoreBaseInfo) {
            String id = ((CoreBaseInfo)delObj).getString("id");
            this.delList.add(id);
            List<CoreBaseInfo> list = this.existData.get(((CoreBaseInfo)delObj).getObjectValue(this.filterObjFieldName).getString("id"));
            if (list != null) {
                Iterator<CoreBaseInfo> it = list.iterator();
                while (it.hasNext()) {
                    if (!StringUtils.equals((String)id, (String)it.next().getString("id"))) continue;
                    it.remove();
                    break;
                }
            }
            return;
        }
        if (!(delObj instanceof BOSUuid) && !(delObj instanceof String)) {
            return;
        }
        String id = delObj.toString();
        block1: for (List<CoreBaseInfo> values : this.existData.values()) {
            Iterator<CoreBaseInfo> it = values.iterator();
            while (it.hasNext()) {
                if (!StringUtils.equals((String)id, (String)it.next().getString("id"))) continue;
                this.delList.add(id);
                it.remove();
                continue block1;
            }
        }
    }

    private void addToUpdateCollection(CoreBaseInfo updateInfo, boolean updateExistData) {
        if (this.needUpdateDatas == null) {
            this.needUpdateDatas = new CoreBaseCollection();
        }
        this.needUpdateDatas.add(updateInfo);
        if (updateExistData) {
            String id = updateInfo.getObjectValue(this.filterObjFieldName).getString("id");
            List<CoreBaseInfo> curExistData = this.existData.get(id);
            if (curExistData == null) {
                curExistData = new ArrayList<CoreBaseInfo>();
                this.existData.put(id, curExistData);
            }
            curExistData.add(updateInfo);
        }
    }

    private List<CoreBaseInfo> getRelateExistData(CoreBaseInfo updateInfo) {
        List<CoreBaseInfo> relateData = this.existData.get(updateInfo.getObjectValue(this.filterObjFieldName).getString("id"));
        if (relateData == null) {
            return Collections.emptyList();
        }
        relateData = new ArrayList<CoreBaseInfo>(relateData);
        Timestamp start = updateInfo.getTimestamp(this.effdtFieldName);
        Timestamp end = updateInfo.getTimestamp(this.leffdtFieldName);
        Iterator<CoreBaseInfo> it = relateData.iterator();
        while (it.hasNext()) {
            CoreBaseInfo existInfo = it.next();
            if (!existInfo.getTimestamp(this.effdtFieldName).after(end) && !existInfo.getTimestamp(this.leffdtFieldName).before(start)) continue;
            it.remove();
        }
        return relateData;
    }

    public RangeDataUpdater addToUpdate(CoreBaseInfo updateInfo) {
        if (updateInfo != null) {
            if (this.originUpdateDatas == null) {
                this.originUpdateDatas = new ArrayList<CoreBaseInfo>();
            }
            this.originUpdateDatas.add(updateInfo);
        }
        return this;
    }

    private void init() throws EASBizException {
        if (this.originUpdateDatas == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"originUpdateDatas"});
        }
        if (this.originUpdateDatas.isEmpty()) {
            return;
        }
        ArrayList<String> filterObjs = new ArrayList<String>();
        Iterator<CoreBaseInfo> it = this.originUpdateDatas.iterator();
        while (it.hasNext()) {
            filterObjs.add(it.next().getObjectValue(this.filterObjFieldName).getString("id"));
        }
        this.initUpdateTimeRange();
        this.initFilterObjs();
        RangeDataFetcher fetcher = new RangeDataFetcher().setBatchIdCount(this.batchIdCount);
        fetcher.setCtx(this.ctx).addFilterObj(filterObjs).setAsendResult(true).setInsClass(this.originUpdateDatas.get(0).getClass());
        fetcher.setBeginTime(Date.getTime(this.beginTime).preDay()).setEndTime(Date.getTime(this.endTime).nextDay());
        this.dataFetcherProcess(fetcher);
        this.existData = fetcher.fetchMapData();
    }

    protected void dataFetcherProcess(RangeDataFetcher<?> fetcher) {
    }

    private void initUpdateTimeRange() {
        Timestamp start = null;
        Timestamp end = null;
        for (CoreBaseInfo updateInfo : this.originUpdateDatas) {
            Timestamp temp = updateInfo.getTimestamp(this.effdtFieldName);
            start = start == null || start.after(temp) ? temp : start;
            temp = updateInfo.getTimestamp(this.leffdtFieldName);
            end = end == null || end.before(temp) ? temp : end;
        }
        this.beginTime = start;
        this.endTime = end;
    }

    private List<?> initFilterObjs() {
        String number;
        CoreBaseInfo updateInfo;
        if (this.dataFetchModel != DataFetchModel.NUMBER || this.originUpdateDatas == null) {
            return this.originUpdateDatas;
        }
        HashSet<String> numbers = new HashSet<String>();
        Iterator<CoreBaseInfo> it = this.originUpdateDatas.iterator();
        while (it.hasNext()) {
            updateInfo = it.next();
            Object filterInfo = updateInfo == null ? null : updateInfo.get(this.filterObjFieldName);
            String string = number = filterInfo instanceof CoreBaseInfo ? ((CoreBaseInfo)filterInfo).getString("number") : null;
            if (StringUtils.isNotBlank((String)number)) {
                numbers.add(number);
                continue;
            }
            this.logger.error((Object)("remove not fit values coreBase:" + updateInfo + ",filterInfo:" + filterInfo));
            it.remove();
        }
        if (this.originUpdateDatas.isEmpty()) {
            this.logger.error((Object)"no need to update");
            return this.originUpdateDatas;
        }
        CoreBaseInfo firstFilterObj = (CoreBaseInfo)this.originUpdateDatas.get(0).get(this.filterObjFieldName);
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity(firstFilterObj.getBOSType());
        String entityName = entityObjectInfo.getFullName();
        HashMap<String, CoreBaseInfo> filterObjMap = new HashMap<String, CoreBaseInfo>(numbers.size());
        try {
            ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)this.ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
            CoreBaseCollection coll = new CoreBaseCollection();
            for (String sql : CollectionUtil.groupToSql(numbers, this.batchIdCount)) {
                coll.addCollection(iCoreBase.getCollection("select id where number in " + sql));
            }
            for (int i = 0; i < coll.size(); ++i) {
                filterObjMap.put(coll.get(i).getString("number"), coll.get(i));
            }
        }
        catch (BOSException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        Iterator<CoreBaseInfo> it2 = this.originUpdateDatas.iterator();
        while (it2.hasNext()) {
            updateInfo = it2.next();
            number = ((CoreBaseInfo)updateInfo.get(this.filterObjFieldName)).getString("number");
            if (filterObjMap.containsKey(number)) {
                updateInfo.put(this.filterObjFieldName, filterObjMap.get(number));
                continue;
            }
            this.logger.error((Object)("number not exist:" + number + ",coreBase:" + updateInfo));
            it2.remove();
        }
        return this.originUpdateDatas;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public RangeDataUpdater setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public RangeDataUpdater setCtx(Context ctx) {
        this.ctx = ctx;
        return this;
    }

    public String getEffdtFieldName() {
        return this.effdtFieldName;
    }

    public RangeDataUpdater setEffdtFieldName(String effdtFieldName) {
        this.effdtFieldName = effdtFieldName;
        return this;
    }

    public String getLeffdtFieldName() {
        return this.leffdtFieldName;
    }

    public RangeDataUpdater setLeffdtFieldName(String leffdtFieldName) {
        this.leffdtFieldName = leffdtFieldName;
        return this;
    }

    public String getFilterObjFieldName() {
        return this.filterObjFieldName;
    }

    public RangeDataUpdater setFilterObjFieldName(String filterObjFieldName) {
        this.filterObjFieldName = filterObjFieldName;
        return this;
    }

    public DataFetchModel getDataFetchModel() {
        return this.dataFetchModel;
    }

    public RangeDataUpdater setDataFetchModel(DataFetchModel dataFetchModel) {
        this.dataFetchModel = dataFetchModel;
        return this;
    }

    public Timestamp getBeginTime() {
        return this.beginTime;
    }

    public RangeDataUpdater setBeginTime(Timestamp beginTime) {
        this.beginTime = beginTime;
        return this;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public RangeDataUpdater setEndTime(Timestamp endTime) {
        this.endTime = endTime;
        return this;
    }

    public int getBatchIdCount() {
        return this.batchIdCount;
    }

    public RangeDataUpdater setBatchIdCount(int batchIdCount) {
        this.batchIdCount = batchIdCount;
        return this;
    }

    public List<CoreBaseInfo> getOriginUpdateDatas() {
        return this.originUpdateDatas;
    }

    public RangeDataUpdater setOriginUpdateDatas(List<CoreBaseInfo> originUpdateDatas) {
        this.originUpdateDatas = originUpdateDatas;
        return this;
    }

    public boolean isThrowExceptionWhenNotSatisfy() {
        return this.throwExceptionWhenNotSatisfy;
    }

    public RangeDataUpdater setThrowExceptionWhenNotSatisfy(boolean throwExceptionWhenNotSatisfy) {
        this.throwExceptionWhenNotSatisfy = throwExceptionWhenNotSatisfy;
        return this;
    }

    public int getForceUpdateLevel() {
        return this.forceUpdateLevel;
    }

    public void setForceUpdateLevel(int forceUpdateLevel) {
        this.forceUpdateLevel = forceUpdateLevel;
    }

    static enum UpdateModel {
        UPDATE,
        UNION,
        NOUPDATE;

    }
}

