/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;

public class EntityReflectUtil {
    public static final String InfoFix = "Info";
    public static final String PackageFix = "com.kingdee.eas.";
    public static final String PackageAPP = "app";
    public static final String FactoryFix = "Factory";

    public static String getEntityByBosType(Context ctx, BOSObjectType bosType) {
        EntityObjectInfo entityInfo = null;
        entityInfo = ctx != null ? MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType) : MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bosType);
        return entityInfo.getFullName();
    }

    public static String getEntityByInfo(String info) {
        if (StringUtils.isEmpty((String)info) || !info.endsWith(InfoFix)) {
            return null;
        }
        String entity = info.substring(0, info.length() - InfoFix.length());
        String[] path = StringUtils.split((String)entity, (String)".");
        if (path.length > 0) {
            StringBuffer en = new StringBuffer();
            for (int i = 0; i < path.length; ++i) {
                if (i == path.length - 1) {
                    en.append(PackageAPP);
                    en.append(".");
                    en.append(path[i]);
                    continue;
                }
                en.append(path[i]);
                en.append(".");
            }
            return en.toString();
        }
        return null;
    }

    public static String getInfoByEntity(String entity) {
        if (StringUtils.isEmpty((String)entity)) {
            return null;
        }
        String[] s = StringUtils.split((String)entity, (String)".app.");
        if (s.length == 2) {
            return s[0] + "." + s[1] + InfoFix;
        }
        return null;
    }

    public static String getFactoryByEntity(String entity) {
        if (StringUtils.isEmpty((String)entity)) {
            return null;
        }
        String[] s = StringUtils.split((String)entity, (String)".app.");
        if (s.length == 2) {
            return s[0] + "." + s[1] + FactoryFix;
        }
        return null;
    }

    public static String getFactoryByInfo(String info) {
        if (StringUtils.isEmpty((String)info)) {
            return null;
        }
        return info.substring(0, info.length() - InfoFix.length()) + FactoryFix;
    }

    public static ICoreBase getLocalInstance(Context ctx, String entity) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)entity) || ctx == null) {
            return null;
        }
        try {
            return (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)new MetaDataPK(entity));
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
    }

    public static ICoreBase getRemoteInstance(String factory) throws Exception {
        Object iInfo;
        if (StringUtils.isEmpty((String)factory)) {
            return null;
        }
        Class<?> cFactory = Class.forName(factory);
        Method getRemoteInstance = cFactory.getMethod("getRemoteInstance", new Class[0]);
        if (getRemoteInstance != null && (iInfo = getRemoteInstance.invoke(cFactory, new Object[0])) != null && iInfo instanceof ICoreBase) {
            return (ICoreBase)iInfo;
        }
        return null;
    }

    public static Class getPropertyType(PropertyInfo property) throws BOSException {
        if (property == null) {
            return null;
        }
        try {
            if (property instanceof OwnPropertyInfo) {
                DataType type = ((OwnPropertyInfo)property).getDataType();
                if (DataType.ENUM.equals((Object)type)) {
                    return Class.forName(((OwnPropertyInfo)property).getEnumType().getName());
                }
                return EntityReflectUtil.convertBasicDataType(type);
            }
            if (property instanceof LinkPropertyInfo) {
                return Class.forName(EntityReflectUtil.getInfoByEntity(((LinkPropertyInfo)property).getRelationship().getSupplierObject().getFullName()));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return null;
    }

    public static Class convertBasicDataType(DataType type) {
        if (DataType.BOOLEAN.equals((Object)type)) {
            return Boolean.class;
        }
        if (DataType.BOSUUID.equals((Object)type)) {
            return BOSUuid.class;
        }
        if (DataType.CHAR.equals((Object)type)) {
            return String.class;
        }
        if (DataType.DATE.equals((Object)type)) {
            return Date.class;
        }
        if (DataType.DECIMAL.equals((Object)type)) {
            return BigDecimal.class;
        }
        if (DataType.DOUBLE.equals((Object)type)) {
            return Double.class;
        }
        if (DataType.INTEGER.equals((Object)type)) {
            return Integer.class;
        }
        if (DataType.LONG.equals((Object)type)) {
            return Long.class;
        }
        if (DataType.STRING.equals((Object)type)) {
            return String.class;
        }
        return null;
    }

    public static Class getObjectValueClass(Context ctx, String entityName) throws BOSException {
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        String clazz = entityInfo.getObjectValueClass();
        try {
            return Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
    }

    public static IObjectValue newInstance(Class clazz, String entityName) {
        IObjectValue objectInfo = null;
        try {
            objectInfo = (IObjectValue)clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        if (!StringUtils.isEmpty((String)entityName)) {
            MetaDataPK metaDataPK = MetaDataPK.create((String)entityName);
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)metaDataPK);
            if (entityInfo.isDynamic() && objectInfo instanceof ICommonBOSType) {
                ICommonBOSType commonObject = (ICommonBOSType)objectInfo;
                commonObject.setBOSType(entityInfo.getType());
                commonObject.setPK((IMetaDataPK)metaDataPK);
            }
        }
        return objectInfo;
    }
}

