/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.eas.hr.base.EntityListMapping;
import com.kingdee.eas.hr.base.EntityTreeMapping;
import com.kingdee.eas.hr.base.MetaInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MappingUtil {
    public static EntityTreeMapping buildEntityTreeMapping(String entity, String[] fields, IMetaDataLoader loader) {
        if (StringUtils.isEmpty((String)entity) || loader == null || fields == null || fields.length <= 0) {
            return null;
        }
        EntityObjectInfo root = loader.getEntity((IMetaDataPK)new MetaDataPK(entity));
        MetaInfo rootInfo = new MetaInfo();
        rootInfo.setName(null);
        rootInfo.setValue(MappingUtil.getMDAlias(root));
        EntityTreeMapping treeMapping = new EntityTreeMapping(rootInfo);
        PropertyInfo property = null;
        String[] subProp = null;
        EntityObjectInfo subEntity = null;
        HashMap fieldCate = MappingUtil.getOwnerPropSet(fields);
        Object f = null;
        if (fieldCate != null && !fieldCate.isEmpty()) {
            Iterator ite = fieldCate.entrySet().iterator();
            Map.Entry entry = null;
            while (ite.hasNext()) {
                entry = ite.next();
                f = entry.getValue();
                if (f instanceof String) {
                    property = root.getPropertyByName((String)f);
                    if (property == null) continue;
                    treeMapping.getEntityMapping().getFieldMapping(f).setProperty(property);
                    continue;
                }
                subProp = f;
                property = root.getPropertyByName(entry.getKey().toString());
                if (property == null || !(property instanceof LinkPropertyInfo)) continue;
                subEntity = ((LinkPropertyInfo)property).getRelationship().getSupplierObject();
                treeMapping.addChild(property, MappingUtil.buildEntityTreeMapping(subEntity.getFullName(), subProp, loader));
            }
        }
        return treeMapping;
    }

    private static HashMap getOwnerPropSet(String[] fields) {
        if (fields != null && fields.length > 0) {
            String[] props = null;
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < fields.length; ++i) {
                props = StringUtils.split((String)fields[i], (String)".");
                if (props.length == 1) {
                    map.put(props[0], props[0]);
                    continue;
                }
                if (props.length <= 1) continue;
                String[] old = (String[])map.get(props[0]);
                map.put(props[0], MappingUtil.addString(old, MappingUtil.getSubProp(props)));
            }
            return map;
        }
        return null;
    }

    private static String[] addString(String[] old, String add) {
        if (StringUtils.isEmpty((String)add)) {
            return old;
        }
        if (old == null || old.length <= 0) {
            return new String[]{add};
        }
        String[] result = new String[old.length + 1];
        for (int i = 0; i < old.length; ++i) {
            result[i] = old[i];
        }
        result[result.length - 1] = add;
        return result;
    }

    private static String getSubProp(String[] fields) {
        if (fields != null && fields.length > 1) {
            StringBuffer prop = null;
            for (int i = 1; i < fields.length; ++i) {
                if (prop == null) {
                    prop = new StringBuffer();
                } else {
                    prop.append(".");
                }
                prop.append(fields[i]);
            }
            return prop == null ? "" : prop.toString();
        }
        return null;
    }

    public static EntityListMapping buildListByEntity(String entity, IMetaDataLoader loader) throws Exception {
        EntityObjectInfo header = loader.getEntity((IMetaDataPK)MetaDataPK.create((String)entity));
        MetaInfo headerInfo = new MetaInfo();
        headerInfo.setName(null);
        headerInfo.setValue(MappingUtil.getMDAlias(header));
        EntityListMapping headerList = new EntityListMapping(headerInfo);
        MetaInfo fInfo = null;
        PropertyInfo pInfo = null;
        PropertyCollection fields = header.getPropertiesRuntime();
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            pInfo = fields.get(i);
            if ("entrys".equals(pInfo.getName())) {
                EntityObjectInfo dEntity = ((LinkPropertyInfo)pInfo).getRelationship().getSupplierObject();
                MetaInfo dInfo = new MetaInfo();
                dInfo.setName("entrys");
                dInfo.setValue(MappingUtil.getMDAlias(dEntity));
                EntityListMapping dList = new EntityListMapping(dInfo);
                PropertyCollection entryields = dEntity.getPropertiesRuntime();
                PropertyInfo entryPInfo = null;
                int s = entryields.size();
                for (int j = 0; j < s; ++j) {
                    entryPInfo = entryields.get(j);
                    fInfo = new MetaInfo();
                    fInfo.setName(entryPInfo.getName());
                    fInfo.setValue(MappingUtil.getMDAlias(entryPInfo));
                    fInfo.setUserObject(entryPInfo);
                    dList.addField(fInfo);
                }
                headerList.addDetail(dList);
                continue;
            }
            fInfo = new MetaInfo();
            fInfo.setName(pInfo.getName());
            fInfo.setValue(MappingUtil.getMDAlias(pInfo));
            fInfo.setUserObject(pInfo);
            headerList.addField(fInfo);
        }
        return headerList;
    }

    public static EntityListMapping buildListByBinding(String entity, DataBinder binder, IMetaDataLoader loader) throws Exception {
        if (StringUtils.isEmpty((String)entity) || binder == null || loader == null) {
            return null;
        }
        EntityListMapping headerList = null;
        EntityObjectInfo header = loader.getEntity((IMetaDataPK)new MetaDataPK(entity));
        DataComponentMap comMap = binder.getDataComponentMap();
        MetaInfo headerInfo = new MetaInfo();
        headerInfo.setName(null);
        headerInfo.setValue(header.getAlias());
        headerList = new EntityListMapping(headerInfo);
        Field f = null;
        Field d = null;
        MetaInfo fInfo = null;
        PropertyInfo pInfo = null;
        ArrayList headFields = comMap.getHeaderFields();
        if (headFields != null) {
            int size = headFields.size();
            for (int i = 0; i < size; ++i) {
                f = (Field)headFields.get(i);
                pInfo = header.getPropertyByName(f.getName());
                if (pInfo == null) continue;
                fInfo = new MetaInfo();
                fInfo.setName(pInfo.getName());
                fInfo.setValue(pInfo.getAlias());
                fInfo.setUserObject(pInfo);
                headerList.addField(fInfo);
            }
        }
        ArrayList details = comMap.getDetailList(new Field("header"));
        EntityObjectInfo dEntity = null;
        ArrayList dFields = null;
        EntityListMapping dList = null;
        MetaInfo dInfo = null;
        if (details != null) {
            int size = details.size();
            for (int i = 0; i < size; ++i) {
                f = (Field)details.get(i);
                pInfo = header.getPropertyByName(f.getName());
                if (pInfo == null || !(pInfo instanceof LinkPropertyInfo) || (dEntity = ((LinkPropertyInfo)pInfo).getRelationship().getSupplierObject()) == null) continue;
                dInfo = new MetaInfo();
                dInfo.setName(f.getName());
                dInfo.setValue(dEntity.getAlias());
                dList = new EntityListMapping(dInfo);
                dFields = comMap.getDetailFields(f);
                int s = dFields.size();
                for (int j = 0; j < s; ++j) {
                    d = (Field)dFields.get(j);
                    pInfo = dEntity.getPropertyByName(MappingUtil.removePrefix(f.getName(), d.getName()));
                    if (pInfo == null) continue;
                    fInfo = new MetaInfo();
                    fInfo.setName(pInfo.getName());
                    fInfo.setValue(pInfo.getAlias());
                    fInfo.setUserObject(pInfo);
                    dList.addField(fInfo);
                }
                headerList.addDetail(dList);
            }
        }
        return headerList;
    }

    public static String removePrefix(String prefix, String field) {
        String pre;
        if (field != null && prefix != null && field.startsWith(pre = prefix + ".")) {
            return field.substring(pre.length());
        }
        return field;
    }

    public static List getEntityAndSub(String entity, IMetaDataLoader loader) {
        EntityObjectInfo bill;
        ArrayList<MetaInfo> result = null;
        if (!StringUtils.isEmpty((String)entity) && loader != null && (bill = loader.getEntity((IMetaDataPK)new MetaDataPK(entity))) != null) {
            result = new ArrayList<MetaInfo>();
            MetaInfo info = null;
            info = new MetaInfo();
            info.setName(null);
            info.setValue(MappingUtil.getMDAlias(bill));
            info.setUserObject(bill);
            result.add(info);
            PropertyCollection pCol = bill.getInheritedNoDuplicatedProperties();
            if (pCol != null && pCol.size() > 0) {
                PropertyInfo property = null;
                EntityObjectInfo entry = null;
                RelationshipInfo relation = null;
                int size = pCol.size();
                for (int i = 0; i < size; ++i) {
                    property = pCol.get(i);
                    if (!(property instanceof LinkPropertyInfo) || !RelationshipType.COMPOSITION.equals((Object)(relation = ((LinkPropertyInfo)property).getRelationship()).getType())) continue;
                    entry = relation.getSupplierObject();
                    info = new MetaInfo();
                    info.setName(property.getName());
                    info.setValue(MappingUtil.getMDAlias(property));
                    info.setUserObject(entry);
                    result.add(info);
                }
            }
        }
        return result;
    }

    public static boolean isPropertySameType(PropertyInfo pInfo, PropertyInfo otherPInfo) {
        if (pInfo == null && otherPInfo == null) {
            return true;
        }
        if (pInfo != null && otherPInfo != null) {
            if (MappingUtil.isLinkProperty(pInfo) && MappingUtil.isLinkProperty(otherPInfo)) {
                return ((LinkPropertyInfo)pInfo).getRelationship().getSupplierObject().equals((Object)((LinkPropertyInfo)otherPInfo).getRelationship().getSupplierObject());
            }
            if (!MappingUtil.isLinkProperty(pInfo) && !MappingUtil.isLinkProperty(otherPInfo)) {
                return ((OwnPropertyInfo)pInfo).getDataType().equals((Object)((OwnPropertyInfo)otherPInfo).getDataType());
            }
            return true;
        }
        return true;
    }

    public static boolean isLinkProperty(PropertyInfo pInfo) {
        if (pInfo != null) {
            if (pInfo instanceof OwnPropertyInfo) {
                return false;
            }
            if (pInfo instanceof LinkPropertyInfo) {
                return true;
            }
        }
        return false;
    }

    public static String getMDAlias(EntityObjectInfo mdValue) {
        if (!StringUtils.isEmpty((String)mdValue.getAlias())) {
            return mdValue.getAlias();
        }
        return (String)mdValue.getStateManager().getLocaleValue("alias", "zh_CN");
    }

    public static String getMDAlias(PropertyInfo mdValue) {
        if (!StringUtils.isEmpty((String)mdValue.getAlias())) {
            return mdValue.getAlias();
        }
        return (String)mdValue.getStateManager().getLocaleValue("alias", "zh_CN");
    }
}

