/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class PersonPerfUtil {
    public static HashMap getSubordinate(Context ctx, String hierarchyId, HashSet personSet) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)hierarchyId));
        fi.getFilterItems().add(new FilterItemInfo("Person2.id", (Object)personSet, CompareType.INCLUDE));
        fi.setMaskString("#0 and #1");
        viewInfo.setFilter(fi);
        return PersonPerfUtil.getRowSet(ctx, "com.kingdee.eas.hr.base.app.PersonSubordinateQuery", viewInfo);
    }

    public static HashMap getIndirectSubordinate(Context ctx, String hierarchyId, HashSet personSet) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)hierarchyId));
        fi.getFilterItems().add(new FilterItemInfo("Hierarchy2.id", (Object)hierarchyId));
        fi.getFilterItems().add(new FilterItemInfo("Person2.id", (Object)personSet, CompareType.INCLUDE));
        fi.setMaskString("#0 and #1 and #2");
        viewInfo.setFilter(fi);
        return PersonPerfUtil.getRowSet(ctx, "com.kingdee.eas.hr.base.app.PersonIndirectSubordinateQuery", viewInfo);
    }

    public static HashMap getSupervisor(Context ctx, String hierarchyId, HashSet personSet) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)hierarchyId));
        fi.getFilterItems().add(new FilterItemInfo("Person2.id", (Object)personSet, CompareType.INCLUDE));
        fi.setMaskString("#0 and #1");
        viewInfo.setFilter(fi);
        return PersonPerfUtil.getRowSet(ctx, "com.kingdee.eas.hr.base.app.PersonSupervisorQuery", viewInfo);
    }

    public static HashMap getIndirectSupervisor(Context ctx, String hierarchyId, HashSet personSet) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)hierarchyId));
        fi.getFilterItems().add(new FilterItemInfo("Hierarchy2.id", (Object)hierarchyId));
        fi.getFilterItems().add(new FilterItemInfo("Person2.id", (Object)personSet, CompareType.INCLUDE));
        fi.setMaskString("#0 and #1 and #2");
        viewInfo.setFilter(fi);
        return PersonPerfUtil.getRowSet(ctx, "com.kingdee.eas.hr.base.app.PersonIndirectSupervisorQuery", viewInfo);
    }

    public static HashMap getAdminRespPerson(Context ctx, HashSet personSet) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("Person2.id", (Object)personSet, CompareType.INCLUDE));
        viewInfo.setFilter(fi);
        return PersonPerfUtil.getRowSet2(ctx, "com.kingdee.eas.hr.base.app.PersonRespAdminQuery", viewInfo);
    }

    public static HashMap getAllFellow(Context ctx, String hierarchyId, HashSet personSet, boolean flag) throws BOSException, EASBizException {
        Object[] obj = PersonPerfUtil.getSuperPosition(ctx, hierarchyId, personSet);
        HashMap personPosiMap = (HashMap)obj[0];
        HashSet superPosiSet = (HashSet)obj[1];
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)superPosiSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("hierarchy.id", (Object)hierarchyId));
        filter.setMaskString("#0 and #1");
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.hr.base.app.PersonFellowQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        IRowSet rows = queryExec.executeQuery();
        HashMap<String, HashSet> fellowMap = new HashMap<String, HashSet>();
        try {
            String positionId = null;
            String key = null;
            HashSet posiSet = null;
            HashSet fpMap = null;
            HashSet pSet = null;
            HashMap ppMap = null;
            if (!flag) {
                ppMap = PersonPerfUtil.getPositionOfPerson(ctx, personSet);
            }
            while (rows.next()) {
                positionId = rows.getString("SUBPOSITION.ID");
                Iterator iter = personPosiMap.keySet().iterator();
                while (iter.hasNext()) {
                    key = iter.next().toString();
                    posiSet = (HashSet)personPosiMap.get(key);
                    if (!flag && ppMap != null && (pSet = (HashSet)ppMap.get(key)).contains(positionId) || !posiSet.contains(rows.getString("position.ID"))) continue;
                    fpMap = fellowMap.get(key) == null ? new HashSet() : (HashSet)fellowMap.get(key);
                    if (key.equals(rows.getString("id"))) continue;
                    fpMap.add(rows.getString("id"));
                    fellowMap.put(key, fpMap);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return fellowMap;
    }

    public static HashMap getSamePositionFellow(Context ctx, HashSet personSet) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("Person2.id", (Object)personSet, CompareType.INCLUDE));
        viewInfo.setFilter(fi);
        return PersonPerfUtil.getRowSet(ctx, "com.kingdee.eas.hr.base.app.SamePositionPersonFellowQuery", viewInfo);
    }

    public static HashMap getSameGradePerson(Context ctx, HashSet personSet) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("Person2.id", (Object)personSet, CompareType.INCLUDE));
        viewInfo.setFilter(fi);
        return PersonPerfUtil.getRowSet(ctx, "com.kingdee.eas.hr.base.app.SameGradePersonQuery", viewInfo);
    }

    private static HashMap getPositionOfPerson(Context ctx, HashSet personSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personSet, CompareType.INCLUDE));
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.hr.base.app.PositionOfPersonQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        IRowSet rows = queryExec.executeQuery();
        HashMap<String, HashSet> ppMap = new HashMap<String, HashSet>();
        HashSet pSet = null;
        try {
            String personId = null;
            String positionId = null;
            while (rows.next()) {
                personId = rows.getString("Person.id");
                positionId = rows.getString("id");
                pSet = ppMap.get(personId) == null ? new HashSet() : (HashSet)ppMap.get(personId);
                pSet.add(positionId);
                ppMap.put(personId, pSet);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ppMap;
    }

    private static Object[] getSuperPosition(Context ctx, String hierarchyId, HashSet personSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("hierarchy.id", (Object)hierarchyId));
        filter.setMaskString("#0 and #1");
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.SuperPositionQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        IRowSet rows = queryExec.executeQuery();
        HashSet<String> superPosiSet = null;
        HashSet posiSet = null;
        HashMap<String, HashSet> personPosiMap = new HashMap<String, HashSet>();
        try {
            while (rows.next()) {
                if (superPosiSet == null) {
                    superPosiSet = new HashSet<String>(rows.size());
                }
                posiSet = personPosiMap.get(rows.getString("person.id")) == null ? new HashSet() : (HashSet)personPosiMap.get(rows.getString("person.id"));
                posiSet.add(rows.getString("position.id"));
                personPosiMap.put(rows.getString("person.id"), posiSet);
                superPosiSet.add(rows.getString("position.id"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        Object[] obj = new Object[]{personPosiMap, superPosiSet};
        return obj;
    }

    private static HashMap getRowSet(Context ctx, String queryName, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK(queryName);
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        HashMap personMap = new HashMap();
        try {
            String person = null;
            String person2 = null;
            HashSet<String> personSet = null;
            while (rows.next()) {
                person = rows.getString("id");
                person2 = rows.getString("Person2.id");
                personSet = (HashSet<String>)personMap.get(person2);
                if (personSet == null) {
                    personSet = new HashSet<String>();
                }
                if (person.equals(person2)) continue;
                personSet.add(person);
                personMap.put(person2, personSet);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return personMap;
    }

    private static HashMap getRowSet2(Context ctx, String queryName, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK(queryName);
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        HashMap<String, HashSet<String>> personMap = new HashMap<String, HashSet<String>>();
        try {
            String person = null;
            String person2 = null;
            HashSet<String> personSet = null;
            while (rows.next()) {
                person = rows.getString("id");
                person2 = rows.getString("Person2.id");
                personSet = (HashSet<String>)personMap.get(person2);
                if (personSet == null) {
                    personSet = new HashSet<String>();
                }
                personSet.add(person);
                personMap.put(person2, personSet);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return personMap;
    }
}

