/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.hr.compensation.client.BOCSalaryReporSetAccountHelper;
import com.kingdee.eas.hr.compensation.client.BOCSalaryReportUtil;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;
import java.util.Iterator;

public class BOCEmpSalarySummaryReportHelper {
    private static final String DEPT_NO = "FPER004";
    private static final String DEPT_NANME = "FPER005";
    private static final String EMP_NAME = "FPER001";
    private static final int START_COLINDEX = 4;
    private HashMap mapDeptRowIndex = new HashMap(1024);
    private HashMap mapDeptName = new HashMap(1024);
    private KDTable table = null;
    private int[] personCount = null;
    private int totalPersonCount = 0;
    private EntityViewInfo filter = null;

    public BOCEmpSalarySummaryReportHelper(KDTable table, EntityViewInfo filter) {
        this.table = table;
        this.filter = filter;
        this.personCount = new int[table.getRowCount() - 1];
    }

    public void reFillReportData() {
        this.getDeptRowIndex();
        if (this.mapDeptRowIndex.size() == 0) {
            return;
        }
        HashMap map = this.reGroupTableData();
        this.resetTable();
        if (map.size() == 0) {
            return;
        }
        this.fillDataTable(map);
        this.sumCol();
        this.setAcountViewRow(this.table);
        this.merger();
    }

    private void merger() {
        int rowCount = this.table.getRowCount();
        KDTMergeManager merger = this.table.getMergeManager();
        merger.mergeBlock(rowCount - 2, 0, rowCount - 2, 1);
        merger.mergeBlock(rowCount - 1, 0, rowCount - 1, 1);
    }

    private void setAcountViewRow(KDTable table) {
        BOCSalaryReporSetAccountHelper helper = new BOCSalaryReporSetAccountHelper(table, this.getEmpType());
        helper.setAccountView();
    }

    private String getEmpType() {
        return BOCSalaryReportUtil.getEmpType(this.filter);
    }

    private void resetTable() {
        this.table.removeRows();
        this.table.getHeadRow(0).getCell(EMP_NAME).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"143_BOCEmpCostKeepingReportUI"));
        this.table.getColumn("FPER002").getStyleAttributes().setHided(true);
        int rowCount = this.mapDeptRowIndex.size();
        for (int i = 0; i < rowCount; ++i) {
            this.table.addRow();
        }
        Iterator itor = this.mapDeptRowIndex.keySet().iterator();
        String deptNo = "";
        int rowIndex = 0;
        while (itor.hasNext()) {
            deptNo = itor.next().toString();
            rowIndex = (Integer)this.mapDeptRowIndex.get(deptNo);
            IRow row = this.table.getRow(rowIndex);
            row.getCell(DEPT_NO).setValue((Object)deptNo);
            row.getCell(DEPT_NANME).setValue(this.mapDeptName.get(deptNo));
        }
        for (int i = 0; i < rowCount; ++i) {
            this.table.getRow(i).getCell(EMP_NAME).setValue((Object)this.personCount[i]);
        }
        IRow row = this.table.addRow();
        row.getCell(DEPT_NO).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"147_BOCEmpSalaryStatReportHelper"));
        row.getCell(EMP_NAME).setValue((Object)this.totalPersonCount);
        this.table.addRow().getCell(DEPT_NO).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"149_BOCEmpSalarySummaryReportHelper"));
    }

    private void fillDataTable(HashMap map) {
        int colCount = this.table.getColumnCount();
        int rowIndex = 0;
        String deptNo = null;
        double[] rowData = null;
        IRow row = null;
        Iterator itor = this.mapDeptRowIndex.keySet().iterator();
        while (itor.hasNext()) {
            deptNo = itor.next().toString();
            if (!map.containsKey(deptNo)) continue;
            rowData = (double[])map.get(deptNo);
            rowIndex = (Integer)this.mapDeptRowIndex.get(deptNo);
            row = this.table.getRow(rowIndex);
            for (int j = 4; j < colCount; ++j) {
                row.getCell(j).setValue((Object)new Double(rowData[j]));
            }
        }
    }

    private void sumCol() {
        int rowCount = this.table.getRowCount();
        int colCount = this.table.getColumnCount();
        double colSum = 0.0;
        for (int j = 4; j < colCount; ++j) {
            colSum = 0.0;
            for (int i = 0; i < rowCount - 2; ++i) {
                colSum += this.getCellValue(this.table, i, j);
            }
            this.table.getCell(rowCount - 2, j).setValue((Object)new Double(colSum));
        }
    }

    private void getDeptRowIndex() {
        int rowCount = this.table.getRowCount();
        String deptNo = "";
        IRow row = null;
        int rowIndex = 0;
        for (int i = 0; i < rowCount - 1; ++i) {
            row = this.table.getRow(i);
            Object value = row.getCell(DEPT_NO).getValue();
            if (value == null || this.mapDeptRowIndex.containsKey(deptNo = value.toString())) continue;
            this.mapDeptRowIndex.put(deptNo, rowIndex++);
            this.mapDeptName.put(deptNo, row.getCell(DEPT_NANME).getValue().toString());
        }
    }

    private HashMap reGroupTableData() {
        int rowCount = this.table.getRowCount();
        int colCount = this.table.getColumnCount();
        HashMap<String, double[]> mapData = new HashMap<String, double[]>();
        IRow row = null;
        double[] rowData = null;
        String deptNo = "";
        for (int i = 0; i < rowCount - 1; ++i) {
            int rowIndex;
            row = this.table.getRow(i);
            deptNo = row.getCell(DEPT_NO).getValue().toString();
            ++this.totalPersonCount;
            int n = rowIndex = ((Integer)this.mapDeptRowIndex.get(deptNo)).intValue();
            this.personCount[n] = this.personCount[n] + 1;
            if (mapData.containsKey(deptNo)) {
                rowData = (double[])mapData.get(deptNo);
            } else {
                rowData = new double[colCount];
                mapData.put(deptNo, rowData);
            }
            for (int j = 4; j < colCount; ++j) {
                int n2 = j;
                rowData[n2] = rowData[n2] + this.getCellValue(this.table, i, j);
            }
        }
        return mapData;
    }

    private double getCellValue(KDTable table, int row, int col) {
        return BOCSalaryReportUtil.getCellValue(table, row, col);
    }
}

