/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.hr.compensation.client.BOCSalaryReporSetAccountHelper;
import com.kingdee.eas.hr.compensation.client.BOCSalaryReportUtil;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;

public class BOCRetireEmpSalarySummaryReportHelper {
    private static final int START_COL_INDEX = 4;
    private static final int RowIndexOfSum = 4;
    private static final String LI_XIU = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"152_BOCRetireEmpSalarySummaryReportHelper");
    private static final String TUI_XIU = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"153_BOCRetireEmpSalarySummaryReportHelper");
    private static final String NEI_TUI = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"154_BOCRetireEmpSalarySummaryReportHelper");
    private static final String NEI_YANG = EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"155_BOCRetireEmpSalarySummaryReportHelper");
    private HashMap mapRowIndex = new HashMap();
    private int[] personCount = new int[4];
    private int totalPersonCount = 0;
    private EntityViewInfo filter = null;

    public BOCRetireEmpSalarySummaryReportHelper(EntityViewInfo filter) {
        this.filter = filter;
        this.initRowIndex();
    }

    private void initRowIndex() {
        this.mapRowIndex.put(LI_XIU, 0);
        this.mapRowIndex.put(TUI_XIU, 1);
        this.mapRowIndex.put(NEI_TUI, 2);
        this.mapRowIndex.put(NEI_YANG, 3);
    }

    public void fillRetireEmpSalaryReport(KDTable table) {
        double[][] arrData = this.reGroupTableData(table);
        this.resetTableTitle(table);
        if (arrData == null) {
            return;
        }
        this.reFillDataToTable(table, arrData);
        this.setAcountViewRow(table);
        this.merger(table);
    }

    private void merger(KDTable table) {
        int rowCount = table.getRowCount();
        KDTMergeManager merger = table.getMergeManager();
        merger.mergeBlock(rowCount - 1, 0, rowCount - 1, 1);
    }

    private void setAcountViewRow(KDTable table) {
        BOCSalaryReporSetAccountHelper helper = new BOCSalaryReporSetAccountHelper(table, this.getEmpType());
        helper.setAccountView();
    }

    private String getEmpType() {
        return BOCSalaryReportUtil.getEmpType(this.filter);
    }

    private void resetTableTitle(KDTable table) {
        int i;
        table.removeRows();
        IRow row = table.getHeadRow(0);
        row.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"156_BOCRetireEmpSalarySummaryReportHelper"));
        row.getCell(1).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"143_BOCEmpCostKeepingReportUI"));
        table.getColumn(2).getStyleAttributes().setHided(true);
        table.getColumn(3).getStyleAttributes().setHided(true);
        for (i = 0; i < 6; ++i) {
            table.addRow();
        }
        table.getCell(0, 0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"157_BOCRetireEmpSalarySummaryReportHelper"));
        table.getCell(1, 0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"158_BOCRetireEmpSalarySummaryReportHelper"));
        table.getCell(2, 0).setValue((Object)NEI_TUI);
        table.getCell(3, 0).setValue((Object)NEI_YANG);
        table.getCell(4, 0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"147_BOCEmpSalaryStatReportHelper"));
        table.getCell(5, 0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"149_BOCEmpSalarySummaryReportHelper"));
        for (i = 0; i < 4; ++i) {
            table.getCell(i, 1).setValue((Object)this.personCount[i]);
        }
        table.getCell(4, 1).setValue((Object)this.totalPersonCount);
    }

    private void reFillDataToTable(KDTable table, double[][] arrData) {
        int rowCount = 4;
        int colCount = table.getColumnCount();
        double colSum = 0.0;
        for (int j = 4; j < colCount; ++j) {
            colSum = 0.0;
            for (int i = 0; i < rowCount; ++i) {
                colSum += arrData[i][j];
                table.getCell(i, j).setValue((Object)new Double(arrData[i][j]));
            }
            table.getCell(4, j).setValue((Object)new Double(colSum));
        }
    }

    private double[][] reGroupTableData(KDTable table) {
        int rowCount = table.getRowCount() - 1;
        if (rowCount <= 0) {
            return null;
        }
        int colCount = table.getColumnCount();
        double value = 0.0;
        String empType = "";
        String colEmpTypeKey = "FPER018";
        IRow row = null;
        int rowIndex = 0;
        double[][] arrData = new double[rowCount][colCount];
        for (int i = 0; i < rowCount; ++i) {
            row = table.getRow(i);
            empType = row.getCell(colEmpTypeKey).getValue().toString();
            rowIndex = this.getRowIndex(empType);
            if (rowIndex == -1) continue;
            int n = rowIndex;
            this.personCount[n] = this.personCount[n] + 1;
            ++this.totalPersonCount;
            int j = 4;
            while (j < colCount) {
                value = this.getCellValue(table, i, j);
                double[] dArray = arrData[rowIndex];
                int n2 = j++;
                dArray[n2] = dArray[n2] + value;
            }
        }
        return arrData;
    }

    private int getRowIndex(String empType) {
        if (!this.mapRowIndex.containsKey(empType)) {
            return -1;
        }
        return (Integer)this.mapRowIndex.get(empType);
    }

    private double getCellValue(KDTable table, int row, int col) {
        return BOCSalaryReportUtil.getCellValue(table, row, col);
    }
}

