/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.formula.api.IFormulaFunctions;
import com.kingdee.bos.service.formula.builder.FormulaBuilderPanelBean;
import com.kingdee.bos.service.formula.builder.hr.HREnumListener;
import com.kingdee.bos.service.formula.builder.hr.IHRObject;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.compensation.CmpFormulaFactory;
import com.kingdee.eas.hr.compensation.CmpFormulaInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.FormulaCmpItemData;
import com.kingdee.eas.hr.compensation.ICmpFormula;
import com.kingdee.eas.hr.compensation.ICmpItem;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.client.AbstractCmpFormulaEditUI;
import com.kingdee.eas.hr.compensation.client.AccountFormula;
import com.kingdee.eas.hr.compensation.client.HRFormulaFunction;
import com.kingdee.eas.hr.compensation.util.AccountFormulaUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class CmpFormulaEditUI
extends AbstractCmpFormulaEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CmpFormulaEditUI.class);
    protected FormulaBuilderPanelBean formulaBuilderPanelBean = null;
    private String oprtState = OprtState.EDIT;
    private boolean isFromPlatform = true;
    private boolean showFlag = false;
    private boolean isEncodingOrder = false;
    private List lstItemNums = null;
    private static String formulaRes = "com.kingdee.eas.hr.compensation.client.FormulaResource.";
    private Icon iconAdd = EASResource.getIcon((String)"imgTbtn_new");
    private Icon iconEdit = EASResource.getIcon((String)"imgTbtn_edit");
    private Icon iconSave = EASResource.getIcon((String)"imgTbtn_save");
    private Icon iconDelete = EASResource.getIcon((String)"imgTbtn_delete");
    private AccountFormula accf = null;
    protected CmpFormulaInfo cfInfo = null;
    private ICodingRuleManager icrm = null;
    private String currentCUID = null;
    private String numberForAddNew = null;
    private ICmpSchemeItem ICmpSchemeItem = null;
    private String schemeIDGol = null;
    private boolean isChangFlag = false;
    private boolean isRefByScheme = false;
    protected CmpItemInfo isRefByScheItem = null;

    @Override
    protected void tblQueryMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblQueryMain_tableSelectChanged(e);
        if (this.tblQueryMain.getRowCount() > 0) {
            if (this.isEncodingOrder) {
                CmpFormulaInfo info = new CmpFormulaInfo();
                String number = this.txtNumber.getText();
                info.setNumber(number);
                CodingRuleManagerFactory.getRemoteInstance().recycleNumber((IObjectValue)this.cfInfo, HRSchemeUtils.getClientHROrgUnitInfo().getId().toString(), number);
            }
            this.isEncodingOrder = false;
            int index = e.getSelectBlock().getTop();
            this.setFormulaFields(index);
            this.txtNumber.setEnabled(false);
            String id = this.tblQueryMain.getRow(index).getCell("id").getValue().toString().trim();
            this.isRefByCmpScheme(id);
            this.setFormulaEnabled(false, OprtState.VIEW);
        }
        this.isChangFlag = false;
    }

    public ICmpSchemeItem getCmpSchemeItemInterface() throws BOSException {
        if (this.ICmpSchemeItem == null) {
            this.ICmpSchemeItem = CmpSchemeItemFactory.getRemoteInstance();
        }
        return this.ICmpSchemeItem;
    }

    public void isRefByCmpScheme(String cmpFormulaID) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo filterInfo = new FilterInfo();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("cmpItem.number"));
        sic.add(new SelectorItemInfo("cmpItem.name"));
        ev.setSelector(sic);
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme.hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItemFormula.id", (Object)cmpFormulaID));
        if (this.schemeIDGol != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)this.schemeIDGol, CompareType.NOTEQUALS));
            filterInfo.setMaskString("#0 and #1 and #2");
        } else {
            filterInfo.setMaskString("#0 and #1");
        }
        ev.setFilter(filterInfo);
        CmpSchemeItemCollection cmpSchItemColl = this.getCmpSchemeItemInterface().getCmpSchemeItemCollection(ev);
        if (cmpSchItemColl.size() == 0) {
            this.lblAlter.setVisible(false);
            this.isRefByScheItem = null;
            this.isRefByScheme = false;
        } else {
            this.lblAlter.getBoundLabel().setForeground(Color.RED);
            this.lblAlter.setVisible(true);
            this.isRefByScheItem = cmpSchItemColl.get(0).getCmpItem();
            this.isRefByScheme = true;
        }
    }

    public void setRefObejct(Object obj) {
        if (!(obj instanceof AccountFormula)) {
            return;
        }
        this.accf = (AccountFormula)((Object)obj);
    }

    public CmpFormulaEditUI() throws Exception {
        HRSchemeUtils.checkInit();
    }

    public CmpFormulaEditUI(boolean entrance, String cmpSchemeID) throws Exception {
        this.isFromPlatform = entrance;
        this.schemeIDGol = cmpSchemeID;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void initSelf() throws Exception {
        this.initUIContentLayout();
        this.onLoad();
        this.show();
    }

    @Override
    public void initUIContentLayout() {
        if (this.formulaBuilderPanelBean != null) {
            return;
        }
        super.initUIContentLayout();
        this.formulaBuilderPanelBean = new FormulaBuilderPanelBean(true, false);
        this.formulaBuilderPanelBean.setHREnumListener((HREnumListener)new FormulaHREnumListener());
        this.initFormulaBuilderPanelBean();
        this.pnlFormula.add((Component)this.formulaBuilderPanelBean, (Object)"Center");
    }

    private CmpFormulaInfo getCmpFormlaByRow(int index) throws Exception {
        if (index == -1) {
            if (this.cfInfo != null) {
                return this.cfInfo;
            }
            return this.createCmpFormulaInfo();
        }
        IRow row = this.tblQueryMain.getRow(index);
        CmpFormulaInfo info = new CmpFormulaInfo();
        if (row.getCell("id").getValue() != null) {
            info.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
        }
        if (row.getCell("name").getValue() != null) {
            info.setName(row.getCell("name").getValue().toString());
        }
        if (row.getCell("number").getValue() != null) {
            info.setNumber(row.getCell("number").getValue().toString());
        }
        if (row.getCell("formulaStr").getValue() != null) {
            info.setFormula(row.getCell("formulaStr").getValue().toString());
        }
        if (row.getCell("formulaDesc").getValue() != null) {
            info.setFormulaDesc(row.getCell("formulaDesc").getValue().toString());
        }
        if (row.getCell("isPublic").getValue() != null) {
            info.setIsPublic(Integer.parseInt(row.getCell("isPublic").getValue().toString()));
        }
        info.setHrOrgUnit(HRSchemeUtils.getClientHROrgUnitInfo());
        info.setCmpShemeID(this.schemeIDGol);
        return info;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.icrm = CodingRuleManagerFactory.getRemoteInstance();
        this.currentCUID = this.icrm.getCurrentAppOUID((IObjectValue)new CmpFormulaInfo());
        if (this.currentCUID == null || this.currentCUID.trim().length() <= 0) {
            return;
        }
        this.createQuery();
        this.tblQueryMain.checkParsed();
        this.tblQueryMain.getStyleAttributes().setLocked(true);
        this.tblQueryMain.getSelectManager().setSelectMode(2);
        this.tblQueryMain.refresh();
        if (this.tblQueryMain.getRowCount() > 0) {
            if (this.isFromPlatform) {
                this.tblQueryMain.getSelectManager().select(0, 0, 0, 0);
            }
            this.setFormulaEnabled(false, OprtState.VIEW);
        } else {
            this.setFormulaEnabled(true, OprtState.ADDNEW);
            this.isChangFlag = true;
            this.clearField();
        }
    }

    private HashSet getCmpSchemeItem() {
        if (this.schemeIDGol == null) {
            return null;
        }
        HashSet<String> schemeIDSet = new HashSet<String>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("cmpItemFormula.*"));
        evi.getSelector().add(new SelectorItemInfo("cmpScheme.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)this.schemeIDGol));
        evi.setFilter(filterInfo);
        try {
            ICmpSchemeItem iCmpSchemeItem = CmpSchemeItemFactory.getRemoteInstance();
            CmpSchemeItemCollection csItemCol = iCmpSchemeItem.getCmpSchemeItemCollection(evi);
            int size = csItemCol.size();
            for (int i = 0; i < size; ++i) {
                String formulaStr;
                CmpSchemeItemInfo csItemInfoTemp = csItemCol.get(i);
                if (csItemInfoTemp.getCmpItemFormula() == null || schemeIDSet.contains(formulaStr = csItemInfoTemp.getCmpItemFormula().getId().toString())) continue;
                schemeIDSet.add(formulaStr);
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return schemeIDSet;
    }

    private void createQuery() {
        this.queryCmpFormulaQuery = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        if (this.isFromPlatform) {
            filter.getFilterItems().add(new FilterItemInfo("IsPublic", (Object)1, CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("IsPublic", (Object)1, CompareType.EQUALS));
            if (this.schemeIDGol != null) {
                filter.getFilterItems().add(new FilterItemInfo("cmpShemeID", (Object)this.schemeIDGol));
                filter.setMaskString("#0 and (#1 or #2)");
            } else {
                filter.setMaskString("#0 and #1");
            }
        }
        SorterItemInfo sorterOrderItem = new SorterItemInfo("id");
        this.queryCmpFormulaQuery.getSorter().add(sorterOrderItem);
        this.queryCmpFormulaQuery.setFilter(filter);
    }

    private void setFormulaFields(int index) throws Exception {
        CmpFormulaInfo info;
        this.cfInfo = info = this.getCmpFormlaByRow(index);
        UIHelper.loadMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)this.cfInfo, (String)"name");
        this.txtNumber.setText(info.getNumber());
        CmpFormulaInfo caller = null;
        caller = this.cfInfo != null ? this.cfInfo : new CmpFormulaInfo();
        boolean isExistRule = this.icrm.isExist((IObjectValue)caller, this.currentCUID);
        if (isExistRule) {
            if (!this.icrm.isModifiable((IObjectValue)this.cfInfo, this.currentCUID)) {
                this.txtNumber.setEnabled(false);
            }
        } else {
            this.txtNumber.setEnabled(true);
        }
        this.formulaBuilderPanelBean.setFormulaStr(this.cfInfo.getFormula());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnAdd);
        this.btnAdd.setIcon(this.iconAdd);
        this.setButtonDefaultStyl(this.btnEdit);
        this.btnEdit.setIcon(this.iconEdit);
        this.setButtonDefaultStyl(this.btnDelete);
        this.btnDelete.setIcon(this.iconDelete);
        this.setButtonDefaultStyl(this.btnSave);
        this.btnSave.setIcon(this.iconSave);
        this.kDSeparator.setVisible(false);
        this.lblAlter.setVisible(false);
        this.pnlToolBar.setLayout((LayoutManager)new FlowLayout(2));
        this.btnInnerAdd.setText(null);
        this.btnInnerSave.setText(null);
        this.btnInnerDelete.setText(null);
        this.btnInnerAdd.setIcon(this.iconAdd);
        this.btnInnerEdit.setIcon(this.iconEdit);
        this.btnInnerDelete.setIcon(this.iconDelete);
        this.btnInnerSave.setIcon(this.iconSave);
        this.menuItemAdd.setIcon(this.iconAdd);
        this.menuItemSave.setIcon(this.iconSave);
        this.menuItemModify.setIcon(this.iconEdit);
        this.menuItemDelete.setIcon(this.iconDelete);
        this.pnlToolBar.setPreferredSize(new Dimension(0, 27));
        if (this.isFromPlatform) {
            this.btnInnerAdd.setVisible(false);
            this.btnInnerEdit.setVisible(false);
            this.btnInnerDelete.setVisible(false);
            this.btnInnerSave.setVisible(false);
            this.pnlToolBar.setPreferredSize(new Dimension(0, 0));
        }
        this.tblQueryMain.setColumnMoveable(true);
    }

    private void clearField() {
        if (this.cfInfo == null) {
            this.cfInfo = new CmpFormulaInfo();
        }
        this.cfInfo.setName(null);
        UIHelper.loadMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)this.cfInfo, (String)"name");
        this.txtNumber.setText(null);
        this.formulaBuilderPanelBean.clear();
        try {
            this.generateNumber();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.tblQueryMain.getSelectManager().setActiveRowIndex(-1);
        this.tblQueryMain.removeRows();
    }

    private int getSelectedRowIndex() {
        if (this.tblQueryMain.getRowCount() == 0) {
            return -1;
        }
        return this.tblQueryMain.getSelectManager().getActiveRowIndex();
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        this.handlePermissionForItemAction(this.actionAdd);
        this.isChangFlag = true;
        this.lblAlter.setVisible(false);
        this.setFormulaEnabled(true, OprtState.ADDNEW);
        if (this.isEncodingOrder) {
            CmpFormulaInfo info = new CmpFormulaInfo();
            String number = this.txtNumber.getText();
            info.setNumber(number);
            CodingRuleManagerFactory.getRemoteInstance().recycleNumber((IObjectValue)this.cfInfo, HRSchemeUtils.getClientHROrgUnitInfo().getId().toString(), number);
            this.isEncodingOrder = false;
        }
        this.clearField();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.getSelectedRowIndex();
        if (rowIndex < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        if (this.oprtState.equals(OprtState.VIEW)) {
            this.setFormulaEnabled(true, OprtState.EDIT);
        }
        this.isChangFlag = true;
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        this.handlePermissionForItemAction(this.actionDelete);
        int index = this.getSelectedRowIndex();
        if (index == -1) {
            return;
        }
        if (this.isRefByScheme) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"216_CmpFormulaEditUI"));
            return;
        }
        if (!this.confirmRemove()) {
            return;
        }
        String id = this.tblQueryMain.getRow(index).getCell("id").getValue().toString().trim();
        CmpFormulaFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id.trim())));
        CmpFormulaInfo info = new CmpFormulaInfo();
        info.setId(BOSUuid.read((String)id.trim()));
        String number = this.tblQueryMain.getRow(index).getCell("number").getValue().toString();
        info.setNumber(number);
        CodingRuleManagerFactory.getRemoteInstance().recycleNumber((IObjectValue)info, HRSchemeUtils.getClientHROrgUnitInfo().getId().toString(), number);
        this.tblQueryMain.refresh();
    }

    private boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    public boolean checkInput() {
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            if (this.numberForAddNew == null) {
                MsgBox.showInfo((String)EASResource.getString((String)(formulaRes + "NUMBER_ISNULL")));
                return false;
            }
        } else {
            this.numberForAddNew = this.txtNumber.getText();
        }
        if (this.cfInfo == null) {
            this.cfInfo = new CmpFormulaInfo();
        }
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)this.cfInfo, (String)"name");
        if (this.cfInfo.getName() == null || this.cfInfo.getName().trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)(formulaRes + "NAME_ISNULL")));
            return false;
        }
        if (this.txtNumber.getText().trim().length() > 80) {
            MsgBox.showInfo((String)EASResource.getString((String)(formulaRes + "NUMBER_LENGTH")));
            return false;
        }
        if (this.cfInfo.getName().trim().length() > 255) {
            MsgBox.showInfo((String)EASResource.getString((String)(formulaRes + "NAME_LENGTH")));
            return false;
        }
        String formula = this.formulaBuilderPanelBean.getFormulaStr();
        if (formula == null || formula.trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)(formulaRes + "FORMULA_ISNULL")));
            return false;
        }
        return true;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (e != null && !this.checkInput()) {
            return;
        }
        this.isEncodingOrder = false;
        ICmpFormula iCmpFormula = CmpFormulaFactory.getRemoteInstance();
        if (this.oprtState.equals(OprtState.ADDNEW)) {
            this.cfInfo = this.createCmpFormulaInfo();
            this.checkFormula(this.cfInfo.getFormula());
            IObjectPK pk = iCmpFormula.addnew((CoreBaseInfo)this.cfInfo);
            this.cfInfo.setId(BOSUuid.read((String)pk.toString()));
            String formulaNum = this.cfInfo.getNumber();
            if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                this.txtNumber.setText(formulaNum);
            }
            this.tblQueryMain.refresh();
        } else {
            int index;
            if (!this.isFromPlatform && this.isRefByScheme && !MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)(formulaRes + "UN_SAVE_FORMULA"))))) {
                return;
            }
            int indexRow = index = this.getSelectedRowIndex();
            if (index != -1) {
                this.cfInfo = this.getCmpFormlaByRow(index);
                this.cfInfo.setFormula(this.formulaBuilderPanelBean.getFormulaStr());
                this.cfInfo.setFormulaDesc(this.formulaBuilderPanelBean.getFormulaAliasStr());
                this.checkFormula(this.cfInfo.getFormula());
                UIHelper.storeMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)this.cfInfo, (String)"name");
                this.cfInfo.setNumber(this.numberForAddNew);
                iCmpFormula.update((IObjectPK)new ObjectUuidPK(this.cfInfo.getId()), (CoreBaseInfo)this.cfInfo);
                this.tblQueryMain.refresh();
            }
            this.tblQueryMain.getSelectManager().select(indexRow, 0);
        }
        this.setFormulaEnabled(false, OprtState.VIEW);
        if (e != null) {
            MsgBox.showInfo((String)EASResource.getString((String)(formulaRes + "SAVE_OK")));
        }
        this.numberForAddNew = null;
        this.isChangFlag = false;
    }

    protected boolean checkBeforeWindowClosing() {
        return super.checkBeforeWindowClosing();
    }

    public CmpFormulaInfo getFormula() throws Exception {
        return this.getCmpFormlaByRow(this.getSelectedRowIndex());
    }

    private CmpFormulaInfo createCmpFormulaInfo() throws Exception {
        CmpFormulaInfo info = new CmpFormulaInfo();
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)info, (String)"name");
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            info.setNumber(this.icrm.getNumber((IObjectValue)info, this.currentCUID));
        } else {
            info.setNumber(this.numberForAddNew);
        }
        info.setFormula(this.formulaBuilderPanelBean.getFormulaStr());
        info.setFormulaDesc(this.formulaBuilderPanelBean.getFormulaAliasStr());
        info.setSqlStmt(this.formulaBuilderPanelBean.getFormulaStr());
        if (this.isFromPlatform) {
            info.setIsPublic(1);
        } else {
            info.setIsPublic(0);
        }
        info.setHrOrgUnit(HRSchemeUtils.getClientHROrgUnitInfo());
        if (this.schemeIDGol != null) {
            info.setCmpShemeID(this.schemeIDGol);
        } else {
            info.setCmpShemeID(null);
        }
        return info;
    }

    private void initFormulaBuilderPanelBean() {
        try {
            List lst = this.getItemsNum(this.getCmpItemCollection());
            IHRObject[] data = AccountFormulaUtils.getCmpItemList(lst);
            CmpItemCompartor compartor = new CmpItemCompartor();
            Arrays.sort(data, compartor);
            if (data == null) {
                MsgBox.showError((String)HRUtils.getSalariatResourceStr("FORMULA_MISS_DATA"));
                return;
            }
            this.formulaBuilderPanelBean.setHRObjects(data);
            this.formulaBuilderPanelBean.setHREnumObjs(AccountFormulaUtils.getCmpItemInstList((FormulaCmpItemData[])data));
            this.formulaBuilderPanelBean.clearFunctions();
            this.formulaBuilderPanelBean.addFormulaFunctions((IFormulaFunctions)new HRFormulaFunction());
        }
        catch (Exception e) {
            logger.info((Object)e);
            MsgBox.showError((String)HRUtils.getSalariatResourceStr("FORMULA_MISS_DATA"));
            return;
        }
    }

    private CmpItemCollection getCmpItemCollection() throws Exception {
        ICmpItem iCmpItem = CmpItemFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        if (this.schemeIDGol != null) {
            String sql = "select fcmpitemid from t_hr_cmpschemeitem where fisDelete = 0 and fcmpschemeid = '" + this.schemeIDGol + "'";
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"FPER%", CompareType.LIKE));
            filterInfo.setMaskString("#0 and #1 and (#2 or #3)");
        }
        evi.setFilter(filterInfo);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("cmpItemCatalog.number");
        sorterOrderItem.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterOrderItem);
        sorterOrderItem = new SorterItemInfo("defaultOrder");
        sorterOrderItem.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterOrderItem);
        sorterOrderItem = new SorterItemInfo("number");
        sorterOrderItem.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterOrderItem);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("cmpItemCatalog.*"));
        CmpItemCollection colCmpItem = iCmpItem.getCmpItemCollection(evi);
        return colCmpItem;
    }

    private List getItemsNum(CmpItemCollection coll) {
        ArrayList<String> lst = new ArrayList<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            lst.add(coll.get(i).getNumber());
        }
        this.lstItemNums = lst;
        return lst;
    }

    private void checkFormula(String formula) throws Exception {
        if (this.isFromPlatform) {
            this.checkFormulaSelf(formula);
        } else {
            if (this.accf == null) {
                return;
            }
            this.accf.checkFormula();
        }
    }

    private void checkFormulaSelf(String formula) throws Exception {
        AccountFormula accf = new AccountFormula(false);
        AccountFormula.ItemRegex regex = accf.toRegex(this.lstItemNums);
        if (this.oprtState.equals(OprtState.ADDNEW)) {
            this.isRefByScheItem = null;
        }
        AccountFormulaUtils.checkFormulaSelf(formula, regex.personNumRegex, this.isRefByScheItem);
    }

    private void generateNumber() throws EASBizException, BOSException, UuidException, InstantiationException, IllegalAccessException {
        boolean isExistRule = false;
        boolean isUseIntermitNumber = false;
        CmpFormulaInfo caller = null;
        this.numberForAddNew = null;
        caller = this.cfInfo != null ? this.cfInfo : new CmpFormulaInfo();
        isExistRule = this.icrm.isExist((IObjectValue)caller, this.currentCUID);
        if (isExistRule) {
            this.txtNumber.setEnabled(false);
            isUseIntermitNumber = this.icrm.isUseIntermitNumber((IObjectValue)caller, this.currentCUID);
            CodingRuleInfo rule = this.icrm.getCodingRule((IObjectValue)caller, this.currentCUID);
            if (isUseIntermitNumber) {
                this.txtNumber.setText(this.icrm.readNumber((IObjectValue)caller, this.currentCUID));
            } else if (rule.isIsaddnewbreak()) {
                this.txtNumber.setText(this.icrm.getNonbreakNumber((IObjectValue)caller, this.currentCUID));
                this.isEncodingOrder = true;
            } else {
                this.txtNumber.setText(this.icrm.getNumber((IObjectValue)caller, this.currentCUID));
            }
            this.numberForAddNew = this.txtNumber.getText();
            if (!this.icrm.isAddView((IObjectValue)caller, this.currentCUID)) {
                this.txtNumber.setText("");
            } else if (this.icrm.isModifiable((IObjectValue)caller, this.currentCUID) && this.oprtState == OprtState.ADDNEW) {
                this.txtNumber.setEnabled(true);
            } else {
                this.txtNumber.setEnabled(false);
            }
            if (rule.isIsaddnewbreak()) {
                this.txtNumber.setText(this.numberForAddNew);
            }
        } else {
            if (!this.oprtState.equals(OprtState.VIEW)) {
                this.txtNumber.setEnabled(true);
            } else {
                this.txtNumber.setEnabled(false);
            }
            this.txtNumber.setText("");
            if (!this.showFlag) {
                this.showFlag = true;
                HRUtils.msgBoxInfo("com.kingdee.eas.hr.compensation.client.FormulaResource.MUST_RULE", false);
            }
        }
    }

    protected void selectRow(String item, String srcFormula) throws Exception {
        boolean selected = false;
        int size = this.tblQueryMain.getRowCount();
        if (size <= 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblQueryMain.getRow(i);
            String formula = row.getCell("formulaStr").getValue().toString();
            String key = "";
            try {
                key = AccountFormulaUtils.getFormulaKey(formula);
            }
            catch (ParserException pe) {
                continue;
            }
            if (key == null || key.compareToIgnoreCase(item) != 0 || srcFormula.length() != 0 && srcFormula.compareToIgnoreCase(formula) != 0) continue;
            this.tblQueryMain.getSelectManager().select(new KDTSelectBlock(i, 0, i, 2));
            this.setFormulaFields(i);
            selected = true;
            break;
        }
        if (!selected) {
            this.clearField();
        }
    }

    private void setFormulaEnabled(boolean isEnable, String oprtState) throws CodingRuleException, EASBizException, BOSException {
        this.oprtState = oprtState;
        this.btnInnerEdit.setEnabled(!isEnable);
        this.btnEdit.setEnabled(!isEnable);
        this.menuItemModify.setEnabled(!isEnable);
        this.btnInnerSave.setEnabled(isEnable);
        this.btnSave.setEnabled(isEnable);
        this.menuItemSave.setEnabled(isEnable);
        this.txtName.setEnabled(isEnable);
        this.formulaBuilderPanelBean.setEditable(isEnable);
        this.formulaBuilderPanelBean.setTextModeEditable(false);
        if (isEnable) {
            CmpFormulaInfo caller = null;
            caller = this.cfInfo != null ? this.cfInfo : new CmpFormulaInfo();
            boolean isExistRule = this.icrm.isExist((IObjectValue)caller, this.currentCUID);
            if (isExistRule) {
                if (!this.icrm.isModifiable((IObjectValue)caller, this.currentCUID)) {
                    this.txtNumber.setEnabled(false);
                }
            } else {
                this.txtNumber.setEnabled(true);
            }
        } else {
            this.txtNumber.setEnabled(isEnable);
        }
    }

    public boolean isChangFlag() {
        return this.isChangFlag;
    }

    public boolean destroyWindow() {
        if (this.isEncodingOrder) {
            CmpFormulaInfo info = new CmpFormulaInfo();
            String number = this.txtNumber.getText();
            info.setNumber(number);
            try {
                CodingRuleManagerFactory.getRemoteInstance().recycleNumber((IObjectValue)this.cfInfo, HRSchemeUtils.getClientHROrgUnitInfo().getId().toString(), number);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        this.isEncodingOrder = false;
        return super.destroyWindow();
    }

    static class CmpItemCompartor
    implements Comparator,
    Serializable {
        CmpItemCompartor() {
        }

        public int compare(Object arg0, Object arg1) {
            FormulaCmpItemData item0 = (FormulaCmpItemData)arg0;
            FormulaCmpItemData item1 = (FormulaCmpItemData)arg1;
            return item0.getIndex() - item1.getIndex();
        }
    }

    static class FormulaHREnumListener
    implements HREnumListener {
        FormulaHREnumListener() {
        }

        public IHRObject[] getEnumObjs(TreePath path) {
            FormulaCmpItemData itemData;
            Object obj;
            if (path != null && path.getPathCount() >= 3 && (obj = path.getLastPathComponent()) != null && obj instanceof FormulaCmpItemData && (itemData = (FormulaCmpItemData)obj).getCmpItemInstList() != null) {
                IHRObject[] rst = itemData.getCmpItemInstList();
                return rst;
            }
            return null;
        }
    }
}

