/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.BaseCommonQueryClientException;
import com.kingdee.eas.base.commonquery.CompareSignBooleanEnum;
import com.kingdee.eas.base.commonquery.CompareSignDateEnum;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.CompareSignEnumEnum;
import com.kingdee.eas.base.commonquery.CompareSignIntEnum;
import com.kingdee.eas.base.commonquery.CompareSignStringEnum;
import com.kingdee.eas.base.commonquery.LeftBracketSignEnum;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.RightBracketSignEnum;
import com.kingdee.eas.base.commonquery.client.CommonFilterUtil;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.RowObject;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.hr.compensation.client.AbstractCmpItemFilterUI;
import com.kingdee.eas.hr.compensation.client.CmpItemFilterUtil;
import com.kingdee.eas.hr.compensation.client.CmpItemQueryInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class CmpItemFilterUI
extends AbstractCmpItemFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CmpItemFilterUI.class);
    private final Color LOCKED_COLOR = new Color(244, 253, 193);
    protected static final int FILTER_LFET_BRACKET_SIGN = 0;
    protected static final int FILTER_CONDITION = 1;
    protected static final int FILTER_COMPARE_SIGN = 2;
    protected static final int FILTER_COMPARE_VALUE = 3;
    protected static final int FILTER_RIGHT_BRACKET_SIGN = 4;
    protected static final int FILTER_LOGIC_SIGN = 5;
    private String booleanEnumName = "com.kingdee.eas.base.commonquery.BooleanEnum";
    private static final String[] FILTER_COLUMN_CODEs = new String[]{"leftBracketSign", "condition", "compareSign", "compareValue", "rightBracketSign", "loginSign"};
    private static final String commonFilterRes = "com.kingdee.eas.base.commonquery.client.CommonFilterPanel";
    private String panelName;
    private int defaultRows = 10;
    private boolean showFieldCompare;
    private FilterInfo lockedFilterInfo;
    private FilterInfo defalutFilterInfo;
    private CmpItemQueryInfo queryInfo = null;
    private static int defaultFieldMaxLenth = 80;

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtTable.checkParsed();
        this.kdtTable.getActionMap().remove("Paste");
        if (this.queryInfo == null) {
            this.queryInfo = new CmpItemQueryInfo();
        }
        this.fillFilterTableBody();
        this.fillLeftRows();
        this.addTableListener();
    }

    public CmpItemQueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    public void setQueryInfo(CmpItemQueryInfo queryInfo) {
        this.queryInfo = queryInfo;
        this.reInitCondition();
    }

    private void addTableListener() {
        this.kdtTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    CmpItemFilterUI.this.kdtTable_editStopped(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.kdtTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    CmpItemFilterUI.this.onMouseClicked(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    private void fillLeftRows() {
        int rowCount = this.kdtTable.getRowCount();
        if (rowCount < this.defaultRows) {
            for (int i = 0; i < this.defaultRows - rowCount; ++i) {
                IRow row = this.kdtTable.addRow();
                this.initTableEditor(row.getRowIndex());
            }
        }
    }

    private void beforeFillFilterTable() {
        this.checkFilters(this.filterInfo);
    }

    private void setCommonLockedRowStyle(IRow row) {
        row.getStyleAttributes().setLocked(true);
        row.getStyleAttributes().setBackground(this.LOCKED_COLOR);
    }

    private void setLastLockedRowStyle(IRow row) {
        row.getStyleAttributes().setLocked(true);
        row.getStyleAttributes().setBackground(this.LOCKED_COLOR);
        row.getCell(5).getStyleAttributes().setLocked(false);
        row.getCell(5).getStyleAttributes().setBackground(Color.WHITE);
    }

    protected void fillFilterTableBody() throws BaseCommonQueryClientException {
        this.kdtTable.removeRows();
        if (this.filterInfo != null) {
            this.filterInfo = CmpItemFilterUtil.toVerifyFilter(this.queryInfo, this.filterInfo);
            int filterSize = this.filterInfo.getFilterItems().size();
            if (filterSize > 0) {
                this.beforeFillFilterTable();
                ArrayList rowInfos = Util.getRowInfos((FilterInfo)this.filterInfo);
                for (int i = 0; i < filterSize; ++i) {
                    String compare;
                    RowObject rowObject = (RowObject)rowInfos.get(i);
                    FilterItemInfo filterItemInfo = this.filterInfo.getFilterItems().get(i);
                    IRow row = this.kdtTable.addRow(i);
                    if (this.isLockedFilter(filterItemInfo.getPropertyName())) {
                        if (i == this.lockedFilterInfo.getFilterItems().size() - 1) {
                            this.setLastLockedRowStyle(row);
                        } else {
                            this.setCommonLockedRowStyle(row);
                        }
                    }
                    rowObject.setLeftBracket(rowObject.getLeftBracket());
                    rowObject.setCondition(filterItemInfo.getPropertyName());
                    if (!filterItemInfo.isCompareValueIsProperty()) {
                        if (filterItemInfo.getCompareValue() != null) {
                            Util.updateLikeRowObject((RowObject)rowObject, (Object)filterItemInfo.getCompareValue(), (CompareType)filterItemInfo.getCompareType());
                        } else if (filterItemInfo.getCompareValue() == null && filterItemInfo.getCompareType().equals((Object)CompareType.NOTEQUALS) || filterItemInfo.getCompareType().equals((Object)CompareType.EQUALS)) {
                            compare = filterItemInfo.getCompareType().getName();
                            if (compare.equalsIgnoreCase("=")) {
                                compare = "IS";
                            }
                            if (compare.equalsIgnoreCase("<>")) {
                                compare = "IS NOT";
                            }
                            rowObject.setCompare(compare);
                            rowObject.setCompareValue(null);
                        }
                    } else {
                        compare = filterItemInfo.getCompareType().getName();
                        if (compare.equalsIgnoreCase("=")) {
                            compare = "FIELDEQUAL";
                        } else if (compare.equalsIgnoreCase("<>")) {
                            compare = "FIELDNOTEQUAL";
                        } else if (compare.equalsIgnoreCase(">")) {
                            compare = "FIELDLARGE";
                        } else if (compare.equalsIgnoreCase(">=")) {
                            compare = "FIELDLARGEEQUAL";
                        } else if (compare.equalsIgnoreCase("<")) {
                            compare = "FIELDLESS";
                        } else if (compare.equalsIgnoreCase("<=")) {
                            compare = "FIELDLESSEQUAL";
                        }
                        rowObject.setCompare(compare);
                        DataObject ob = CmpItemFilterUtil.getCompareValueObject(this.queryInfo, filterItemInfo.getCompareValue().toString());
                        rowObject.setCompareValue((Object)ob);
                    }
                    rowObject.setRightBracket(rowObject.getRightBracket());
                    rowObject.setLogic(rowObject.getLogic());
                    this.loadFilter(i, rowObject);
                }
            } else {
                this.addRow();
            }
        }
    }

    protected boolean isLockedFilter(String propertyName) {
        if (this.lockedFilterInfo == null) {
            return false;
        }
        int size = this.lockedFilterInfo.getFilterItems().size();
        for (int i = 0; i < size; ++i) {
            FilterItemInfo lockedFilterItemInfo = this.lockedFilterInfo.getFilterItems().get(i);
            if (!lockedFilterItemInfo.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            return true;
        }
        return false;
    }

    private void checkFilters(FilterInfo checkFilterInfo) {
        int dataObjectsLength;
        int filterSize = checkFilterInfo.getFilterItems().size();
        DataObject[] dataObjects = this.getQueryConditionArray();
        int n = dataObjectsLength = dataObjects == null ? 0 : dataObjects.length;
        if (filterSize > 0) {
            for (int i = 0; i < filterSize; ++i) {
                String currentField = "";
                FilterItemInfo itemInfo = checkFilterInfo.getFilterItems().get(i);
                if (itemInfo.isFuncCol()) {
                    List list = itemInfo.getFieldList();
                    if (list.size() > 0) {
                        currentField = (String)list.get(0);
                    }
                } else {
                    currentField = itemInfo.getPropertyName();
                }
                boolean flag = true;
                for (int j = 0; j < dataObjectsLength; ++j) {
                    String queryFieldName = dataObjects[j].getValue();
                    if (!this.compareFiledName(queryFieldName, currentField)) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                logger.error((Object)("field name is:" + currentField));
                MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)commonFilterRes, (String)"versionupgradehint") + "\n" + EASResource.getString((String)commonFilterRes, (String)"versionup2") + "\n" + EASResource.getString((String)commonFilterRes, (String)"versionup3")));
                SysUtil.abort();
            }
        }
    }

    private boolean compareFiledName(String queryFieldName, String currentField) {
        if (queryFieldName.equalsIgnoreCase(currentField)) {
            return true;
        }
        if (("upper(" + queryFieldName + ")").equalsIgnoreCase(currentField)) {
            return true;
        }
        return ("(" + queryFieldName + ")").equalsIgnoreCase(currentField);
    }

    private void increaseRow(KDTEditEvent e) {
        Object object;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == 5 && rowIndex == this.kdtTable.getRowCount() - 1 && (object = this.kdtTable.getRow(rowIndex).getCell(5).getValue()) != null && object.toString() != null && !this.isBlankRow(rowIndex) && !this.checkCurrentHasBlankCol(rowIndex)) {
            this.addRow();
        }
    }

    protected void kdtTable_editStopped(KDTEditEvent e) throws Exception {
        this.increaseRow(e);
        this.editedCellAfter(e);
    }

    private void editedCondtionCellAfter(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(1) == null) {
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(true);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
        } else if (this.kdtTable.getRow(rowIndex).getCell(1).isChange()) {
            if (e.getOldValue() != null) {
                if (!e.getOldValue().equals(e.getValue())) {
                    ICell iCell = this.kdtTable.getRow(rowIndex).getCell(3);
                    if (iCell.getEditor() != null) {
                        iCell.setEditor(null);
                    }
                    this.processCompareSignCell(e);
                    this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(false);
                    this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(false);
                    this.reSetCompareValue(rowIndex);
                }
            } else {
                this.processCompareSignCell(e);
                this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(false);
                this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(false);
            }
        }
    }

    private void reSetCompareValue(int rowIndex) {
        ICell iCell = this.kdtTable.getRow(rowIndex).getCell(3);
        iCell.setValue(null);
    }

    private void editedCompareValueCellAfter(KDTEditEvent e) throws Exception {
        String compareCompare;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        DataObject dataObject = new DataObject();
        String conditonValue = Util.getValue((Object)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).toString();
        if (this.kdtTable.getRow(rowIndex).getCell(2).getValue() != null && CommonFilterUtil.isFieldJudge((String)(compareCompare = this.kdtTable.getRow(rowIndex).getCell(2).getValue().toString()))) {
            this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue(this.kdtTable.getRow(rowIndex).getCell(3).getValue());
            return;
        }
        DataObject dataType = CmpItemFilterUtil.getRefMetaData(this.queryInfo, conditonValue);
        if (dataType == null) {
            return;
        }
        if (CommonFilterUtil.isIntType((String)dataType.getName())) {
            CompareSignEnum signEnum;
            String numberValue = null;
            String entityName = dataType.getValue();
            if (entityName == null) {
                numberValue = Util.getValue((Object)this.kdtTable.getRow(rowIndex).getCell(3).getValue()).toString();
            }
            boolean checkNumber = true;
            String strCompare = Util.getValue((Object)this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString();
            if (strCompare != null && !strCompare.equalsIgnoreCase("") && CmpItemFilterUtil.isIncludeCompare(signEnum = CompareSignEnum.getEnum((String)strCompare))) {
                checkNumber = false;
            }
            if (checkNumber && this.checkIsNumber(numberValue, dataType.getName())) {
                MsgBox.showWarning((String)EASResource.getString((String)commonFilterRes, (String)"compareValueWarning"));
                this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
            }
        } else if (CommonFilterUtil.isDateType((String)dataType.getName()) && this.kdtTable.getRow(rowIndex).getCell(2).getValue() != null && QueryUtils.isDateFunctionCompareSign((String)Util.getValue((Object)this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString())) {
            String numberValue = Util.getValue((Object)this.kdtTable.getRow(rowIndex).getCell(3).getValue()).toString();
            if (this.checkIsNumber(numberValue, DataType.INTEGER.getName())) {
                MsgBox.showWarning((String)EASResource.getString((String)commonFilterRes, (String)"compareValueWarning"));
                this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
            } else {
                dataObject.setValue(numberValue);
                dataObject.setName(numberValue);
                this.kdtTable.getRow(rowIndex).getCell(colIndex).setValue((Object)dataObject);
            }
        }
    }

    private void editedCellAfter(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        Object object = this.kdtTable.getRow(rowIndex).getCell(colIndex).getValue();
        if (object == null) {
            if (colIndex == 1) {
                this.resetCell(this.kdtTable.getRow(rowIndex).getCell(2));
                this.resetCell(this.kdtTable.getRow(rowIndex).getCell(3));
            }
            return;
        }
        switch (colIndex) {
            case 0: {
                return;
            }
            case 1: {
                this.editedCondtionCellAfter(e);
                return;
            }
            case 2: {
                this.processCompareValueCell(e);
                return;
            }
            case 3: {
                this.editedCompareValueCellAfter(e);
                return;
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
        }
    }

    private void loadLeftBracket(int rowIndex, RowObject rowObject) {
        CmpItemFilterUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 0, LeftBracketSignEnum.class.getName(), rowObject.getLeftBracket());
    }

    private void loadCondition(int rowIndex, RowObject rowObject) {
        DataObject queryDataObject = new DataObject();
        queryDataObject.setName(CmpItemFilterUtil.getQueryFieldAlias(rowObject.getCondition(), this.queryInfo));
        queryDataObject.setValue(rowObject.getCondition());
        Object[] objects = this.getQueryConditionArray();
        objects = CmpItemFilterUtil.addObjectToArray(objects, new DataObject());
        int dataObjectsLength = objects.length;
        int selectedIndex = 0;
        for (int j = 1; j < dataObjectsLength; ++j) {
            DataObject dataObject = (DataObject)objects[j];
            String fieldName = dataObject.getValue();
            String selectedFieldName = rowObject.getCondition();
            if (!selectedFieldName.equalsIgnoreCase(fieldName) && !selectedFieldName.equalsIgnoreCase("upper(" + fieldName + ")")) continue;
            selectedIndex = j;
            break;
        }
        KDComboBox comboBox = CmpItemFilterUtil.setComboBoxField(this.kdtTable, rowIndex, 1, objects);
        comboBox.setSelectedIndex(selectedIndex);
        comboBox.setSelectedItem(objects[selectedIndex]);
        this.kdtTable.getRow(rowIndex).getCell(1).setValue(comboBox.getItemAt(selectedIndex));
    }

    private void loadCompareSign(int rowIndex, RowObject rowObject) {
        String condition = Util.getValue((Object)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).toString();
        DataObject dataInfo = CmpItemFilterUtil.getRefMetaData(this.queryInfo, condition);
        KDComboBox comboBox = dataInfo != null ? (CommonFilterUtil.isEnumType((String)dataInfo.getName()) ? CmpItemFilterUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignEnumEnum.class.getName(), rowObject.getCompare()) : (dataInfo.getName().equalsIgnoreCase(DataType.BOOLEAN.getName()) ? CmpItemFilterUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignBooleanEnum.class.getName(), rowObject.getCompare()) : (CommonFilterUtil.isDateType((String)dataInfo.getName()) ? (rowObject.getCompareValue() != null && CommonFilterUtil.isDateCompareSign((String)rowObject.getCompareValue().toString()) ? CmpItemFilterUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignDateEnum.class.getName(), rowObject.getCompareValue().toString()) : CmpItemFilterUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignDateEnum.class.getName(), rowObject.getCompare())) : (CommonFilterUtil.isIntType((String)dataInfo.getName()) ? CmpItemFilterUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignIntEnum.class.getName(), rowObject.getCompare()) : CmpItemFilterUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignStringEnum.class.getName(), rowObject.getCompare()))))) : CmpItemFilterUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignStringEnum.class.getName(), rowObject.getCompare());
        this.processFieldcompare(comboBox);
    }

    private void processFieldcompare(KDComboBox comboBox) {
        if (comboBox != null && !this.isShowFieldCompare()) {
            this.removeFieldCompare(comboBox);
        }
    }

    private void loadCompareValue(int rowIndex, RowObject rowObject) throws BaseCommonQueryClientException {
        String condition = Util.getValue((Object)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).toString();
        String compare = Util.getValue((Object)this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString();
        DataObject dataInfo = CmpItemFilterUtil.getRefMetaData(this.queryInfo, condition);
        String likeCompareValue = null;
        likeCompareValue = Util.getValue((Object)rowObject.getCompareValue()).toString();
        if (CommonFilterUtil.isFieldJudge((String)compare)) {
            return;
        }
        if (dataInfo != null) {
            if (CommonFilterUtil.isDateCompareSign((String)compare) || compare.equals("IS") || compare.equals("IS NOT")) {
                this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
                this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
            } else if (CommonFilterUtil.isEnumType((String)dataInfo.getName())) {
                CmpItemFilterUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 3, dataInfo.getValue(), likeCompareValue);
            } else if (dataInfo.getName().equalsIgnoreCase(DataType.BOOLEAN.getName())) {
                CmpItemFilterUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 3, this.booleanEnumName, Util.getValue((Object)rowObject.getCompareValue()).toString());
            } else if (!CommonFilterUtil.isF7Type((String)dataInfo.getName())) {
                if (CommonFilterUtil.isDateType((String)dataInfo.getName())) {
                    if (rowObject.getCompareValue() == null) {
                        this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
                    } else if (CommonFilterUtil.isDateCompareSign((String)rowObject.getCompareValue().toString())) {
                        this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
                    } else if (QueryUtils.isDateFunctionCompareSign((String)rowObject.getCompareValue().toString())) {
                        String compareValue = rowObject.getCompareValue().toString();
                        this.kdtTable.getRow(rowIndex).getCell(3).setValue((Object)compareValue.split("\\$")[1]);
                    } else {
                        Date dateValue = CmpItemFilterUtil.getDate((Date)rowObject.getCompareValue(), dataInfo.getName(), CompareSignDateEnum.getEnum((String)compare));
                        CmpItemFilterUtil.setDateCtrlField(this.kdtTable, rowIndex, 3, dateValue);
                        this.kdtTable.getRow(rowIndex).getCell(3).setValue((Object)dateValue);
                        String format = CmpItemFilterUtil.getTimeFormatForTable(dataInfo.getName());
                        this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setNumberFormat(format);
                    }
                } else if (CommonFilterUtil.isIntType((String)dataInfo.getName())) {
                    if (dataInfo.getValue() == null || dataInfo.getValue().trim().equalsIgnoreCase("")) {
                        this.kdtTable.getRow(rowIndex).getCell(3).setValue(rowObject.getCompareValue());
                    }
                } else {
                    DataObject queryDataObject = new DataObject();
                    queryDataObject.setName(likeCompareValue);
                    queryDataObject.setValue(likeCompareValue);
                    this.kdtTable.getRow(rowIndex).getCell(3).setValue((Object)queryDataObject);
                }
            }
        } else {
            DataObject queryDataObject = new DataObject();
            queryDataObject.setName(likeCompareValue);
            queryDataObject.setValue(likeCompareValue);
            if (rowObject.getCompareValue() == null || compare.equals("IS") || compare.equals("IS NOT")) {
                this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
            } else {
                this.kdtTable.getRow(rowIndex).getCell(3).setValue((Object)queryDataObject);
            }
        }
    }

    private void loadRightBracket(int rowIndex, RowObject rowObject) {
        CmpItemFilterUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 4, RightBracketSignEnum.class.getName(), rowObject.getRightBracket());
    }

    private void loadLogicSign(int rowIndex, RowObject rowObject) {
        CmpItemFilterUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 5, LogicSignEnum.class.getName(), rowObject.getLogic());
    }

    protected void loadFilter(int rowIndex, RowObject rowObject) throws BaseCommonQueryClientException {
        int length = FILTER_COLUMN_CODEs.length;
        block8: for (int i = 0; i < length; ++i) {
            switch (i) {
                case 0: {
                    this.loadLeftBracket(rowIndex, rowObject);
                    continue block8;
                }
                case 1: {
                    this.loadCondition(rowIndex, rowObject);
                    continue block8;
                }
                case 2: {
                    this.loadCompareSign(rowIndex, rowObject);
                    continue block8;
                }
                case 3: {
                    this.loadCompareValue(rowIndex, rowObject);
                    continue block8;
                }
                case 4: {
                    this.loadRightBracket(rowIndex, rowObject);
                    continue block8;
                }
                case 5: {
                    this.loadLogicSign(rowIndex, rowObject);
                    continue block8;
                }
            }
        }
    }

    private boolean checkIsNumber(String value, String dataType) {
        boolean flag = false;
        try {
            if (dataType.equalsIgnoreCase(DataType.SHORT.getName())) {
                new Short(value);
            } else if (dataType.equalsIgnoreCase(DataType.INTEGER.getName())) {
                Integer.valueOf(value);
            } else if (dataType.equalsIgnoreCase(DataType.LONG.getName())) {
                Long.valueOf(value);
            } else if (dataType.equalsIgnoreCase(DataType.FLOAT.getName())) {
                new Float(value);
            } else if (dataType.equalsIgnoreCase(DataType.DOUBLE.getName())) {
                new Double(value);
            } else if (dataType.equalsIgnoreCase(DataType.DECIMAL.getName())) {
                new BigDecimal(value);
            }
        }
        catch (NumberFormatException e) {
            flag = true;
        }
        return flag;
    }

    private void processCompareSignCell(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        if (this.kdtTable.getRow(rowIndex).getCell(1).getValue() != null && !"".equals(this.kdtTable.getRow(rowIndex).getCell(1).getValue())) {
            Object list;
            String value = null;
            if (this.kdtTable.getRow(rowIndex).getCell(1) != null && this.kdtTable.getRow(rowIndex).getCell(1).getValue() instanceof DataObject) {
                value = ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue();
            }
            DataObject dataType = CmpItemFilterUtil.getRefMetaData(this.queryInfo, value);
            KDComboBox comboBox = null;
            if (!CmpItemFilterUtil.isString(this.queryInfo, value)) {
                if (CmpItemFilterUtil.isBoolean(this.queryInfo, value)) {
                    comboBox = CmpItemFilterUtil.setComboBoxField(this.kdtTable, rowIndex, 2, CmpItemFilterUtil.addObjectToArray(CompareSignBooleanEnum.getEnumList().toArray(), null));
                } else if (dataType != null && (dataType.getName().equals(DataType.DATE.getName()) || dataType.getName().equals(DataType.TIMESTAMP.getName()) || dataType.getName().equals(DataType.TIME.getName()))) {
                    comboBox = CmpItemFilterUtil.setComboBoxField(this.kdtTable, rowIndex, 2, CmpItemFilterUtil.addObjectToArray(CompareSignDateEnum.getEnumList().toArray(), null));
                } else if (dataType != null && (dataType.getName().equalsIgnoreCase(DataType.SHORT.getName()) || dataType.getName().equalsIgnoreCase(DataType.INTEGER.getName()) || dataType.getName().equalsIgnoreCase(DataType.LONG.getName()) || dataType.getName().equalsIgnoreCase(DataType.FLOAT.getName()) || dataType.getName().equalsIgnoreCase(DataType.DOUBLE.getName()) || dataType.getName().equalsIgnoreCase(DataType.DECIMAL.getName()))) {
                    list = CompareSignIntEnum.getEnumList();
                    ArrayList process = new ArrayList();
                    int size = list.size();
                    for (int i = 0; i < size; ++i) {
                        if (CompareSignIntEnum.NULLSIGN.equals(list.get(i)) || CompareSignIntEnum.NOTNULLSIGN.equals(list.get(i))) continue;
                        process.add(list.get(i));
                    }
                    comboBox = CmpItemFilterUtil.setComboBoxField(this.kdtTable, rowIndex, 2, CmpItemFilterUtil.addObjectToArray(process.toArray(), null));
                }
            } else if (this.kdtTable.getRow(rowIndex).getCell(2).getEditor() != null) {
                comboBox = CmpItemFilterUtil.setComboBoxField(this.kdtTable, rowIndex, 2, CmpItemFilterUtil.addObjectToArray(CompareSignStringEnum.getEnumList().toArray(), null));
                if (dataType != null) {
                    list = dataType.getName();
                }
            }
            String condition = Util.getValue((Object)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).toString();
            this.getFieldMaxLength(condition);
            this.processFieldcompare(comboBox);
            boolean isclob = false;
            if (this.kdtTable.getRow(rowIndex).getCell(2).getValue() == null || this.kdtTable.getRow(rowIndex).getCell(1).isChange()) {
                if (!isclob) {
                    this.kdtTable.getRow(rowIndex).getCell(2).setValue((Object)CompareSignStringEnum.EQUALSSIGN);
                } else {
                    this.kdtTable.getRow(rowIndex).getCell(2).setValue((Object)CompareSignStringEnum.LIKESIGN);
                }
                this.processCompareValueCell(e);
            }
        }
    }

    private int getFieldMaxLength(String fieldName) throws Exception {
        if (this.queryInfo != null) {
            int columnLen = this.queryInfo.getMaxLength();
            return columnLen > 0 ? columnLen : defaultFieldMaxLenth;
        }
        return defaultFieldMaxLenth;
    }

    private void processCompareValueCell(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        String filter_compare_sign = Util.getValue((Object)this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString();
        ICell iCell = this.kdtTable.getRow(rowIndex).getCell(3);
        ICell iConditionCell = this.kdtTable.getRow(rowIndex).getCell(1);
        ICell iSignCell = this.kdtTable.getRow(rowIndex).getCell(2);
        if (iConditionCell.getValue() != null && !"".equals(iConditionCell.getValue())) {
            if (CommonFilterUtil.isFieldJudge((String)iSignCell.getValue().toString())) {
                return;
            }
            if (e.getOldValue() != null) {
                String ss = e.getOldValue().toString();
                if (iSignCell.getValue() != null && !iSignCell.getValue().toString().equalsIgnoreCase(ss)) {
                    if (filter_compare_sign.equals("IS") || filter_compare_sign.equals("IS NOT")) {
                        iCell.getStyleAttributes().setLocked(true);
                        iCell.setValue(null);
                    } else {
                        iCell.getStyleAttributes().setLocked(false);
                    }
                    if (CommonFilterUtil.isFieldJudge((String)ss)) {
                        iCell.setValue(null);
                    }
                    String value = ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue();
                    DataObject dataObject = CmpItemFilterUtil.getRefMetaData(this.queryInfo, value);
                    int colMaxLength = this.getFieldMaxLength(value);
                    if (dataObject != null) {
                        this.setDataObjectCompareValue(dataObject, rowIndex, filter_compare_sign, iCell);
                    } else {
                        this.resetCell(iCell, colMaxLength);
                    }
                } else if (CommonFilterUtil.isDateCompareSign((String)filter_compare_sign)) {
                    String value = ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue();
                    DataObject dataObject = CmpItemFilterUtil.getRefMetaData(this.queryInfo, value);
                    int colMaxLength = this.getFieldMaxLength(value);
                    if (dataObject != null) {
                        this.setDataObjectCompareValue(dataObject, rowIndex, filter_compare_sign, iCell);
                    } else {
                        this.resetCell(iCell, colMaxLength);
                    }
                }
            } else if (iSignCell.getValue() != null) {
                String value = null;
                if (this.kdtTable.getRow(rowIndex).getCell(1).getValue() instanceof DataObject) {
                    value = ((DataObject)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getValue();
                }
                DataObject dataObject = CmpItemFilterUtil.getRefMetaData(this.queryInfo, value);
                int colMaxLength = this.getFieldMaxLength(value);
                if (dataObject != null) {
                    this.setDataObjectCompareValue(dataObject, rowIndex, filter_compare_sign, iCell);
                } else {
                    this.resetCell(iCell, colMaxLength);
                }
            }
        }
    }

    private void setDataObjectCompareValue(DataObject dataObject, int rowIndex, String filter_compare_sign, ICell iCell) {
        String type = dataObject.getName();
        if (CommonFilterUtil.isEnumType((String)type)) {
            String enumClassName = dataObject.getValue();
            Object[] em = EnumUtils.getEnumList((String)enumClassName).toArray();
            CmpItemFilterUtil.setComboBoxField(this.kdtTable, rowIndex, 3, CmpItemFilterUtil.addObjectToArray(em, null));
        } else if (CommonFilterUtil.isBooleanType((String)type)) {
            String enumClassName = this.booleanEnumName;
            if (enumClassName != null) {
                Object[] em = EnumUtils.getEnumList((String)enumClassName).toArray();
                CmpItemFilterUtil.setComboBoxField(this.kdtTable, rowIndex, 3, CmpItemFilterUtil.addObjectToArray(em, null));
                iCell.setValue(null);
            }
        } else if (CommonFilterUtil.isDateType((String)type)) {
            if (CommonFilterUtil.isDateCompareSign((String)filter_compare_sign) || "IS".equals(filter_compare_sign) || filter_compare_sign.equals("IS NOT")) {
                iCell.getStyleAttributes().setLocked(true);
                iCell.setValue(null);
            } else if (QueryUtils.isDateFunctionCompareSign((String)filter_compare_sign)) {
                this.resetCell(iCell, dataObject.getColLength());
                iCell.setValue(null);
            } else {
                String format = CmpItemFilterUtil.getTimeFormatForTable(type);
                CmpItemFilterUtil.setDateCtrlField(this.kdtTable, rowIndex, 3, CmpItemFilterUtil.getDate(new Date(), type, CompareSignDateEnum.getEnum((String)filter_compare_sign)));
                iCell.getStyleAttributes().setNumberFormat(format);
                iCell.getStyleAttributes().setLocked(false);
                iCell.setValue(null);
            }
        } else if (!CommonFilterUtil.isF7Type((String)type) && !CommonFilterUtil.isSimpleEntityType((String)type) && CommonFilterUtil.isIntType((String)type)) {
            if (dataObject.getColLength() <= 0) {
                this.resetCell(iCell, 18);
            } else {
                this.resetCell(iCell, dataObject.getColLength());
            }
        }
    }

    private void resetCell(ICell iCell) {
        iCell.setEditor(null);
        iCell.setValue(null);
        if (iCell.getStyleAttributes() != null) {
            iCell.getStyleAttributes().setNumberFormat("");
        }
    }

    private void resetCell(ICell iCell, int maxLength) {
        if (maxLength <= 0) {
            maxLength = defaultFieldMaxLenth;
        }
        KDTextField field = new KDTextField();
        field.setMaxLength(maxLength);
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JTextField)field);
        iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
        if (iCell.getStyleAttributes() != null) {
            iCell.getStyleAttributes().setNumberFormat("%r-[=]{#,##0.00}f");
        }
    }

    protected boolean isBlankRow(int rowIndex) {
        int columnSize = FILTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            if (Util.getValue((Object)this.kdtTable.getRow(rowIndex).getCell(i).getValue()).toString().trim().equalsIgnoreCase("")) continue;
            return false;
        }
        return true;
    }

    private boolean checkCurrentHasTooLongCol(int rowIndex) {
        IRow iRow = this.kdtTable.getRow(rowIndex);
        Object compareValue = null;
        String compare = Util.getValue((Object)iRow.getCell(2).getValue()).toString().toLowerCase();
        if (Util.isF7CompareValue((IRow)iRow) || CommonFilterUtil.isFieldJudge((String)compare) || (compareValue = Util.getValue((Object)iRow.getCell(3).getValue())) instanceof String) {
            // empty if block
        }
        return false;
    }

    private boolean checkCurrentHasBlankCol(int rowIndex) {
        boolean flag = false;
        int columnSize = FILTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            Object filterValue;
            if (i == 0 || i == 4) continue;
            if (i == 5) {
                if (this.isLastUsefulRow(rowIndex)) {
                    return !this.isExistLogicSign(rowIndex);
                }
                filterValue = this.kdtTable.getRow(rowIndex).getCell(i).getValue();
                if (filterValue == null || filterValue.toString().trim().length() == 0) {
                    this.kdtTable.getRow(rowIndex).getCell(i).setValue((Object)LogicSignEnum.AND);
                }
            }
            if ((filterValue = this.kdtTable.getRow(rowIndex).getCell(i).getValue()) == null) {
                String compareSign = Util.getValue((Object)this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString();
                if (CommonFilterUtil.isDateCompareSign((String)compareSign) || compareSign.equalsIgnoreCase("IS") || compareSign.equalsIgnoreCase("IS NOT")) {
                    if (this.kdtTable.getRow(rowIndex).getCell(1).getValue() != null && this.kdtTable.getRow(rowIndex).getCell(3).getValue() == null) continue;
                    return true;
                }
                return true;
            }
            if (filterValue.toString() != null && !filterValue.toString().trim().equalsIgnoreCase("")) continue;
            return true;
        }
        return flag;
    }

    private boolean isLastUsefulRow(int rowIndex) {
        int rowCount = this.kdtTable.getRowCount();
        for (int i = rowIndex + 1; i < rowCount; ++i) {
            if (this.isBlankRow(i)) continue;
            return false;
        }
        return true;
    }

    private void addRow() {
        int currentRowSize = this.kdtTable.getRowCount();
        this.kdtTable.addRow(currentRowSize);
        this.initTableEditor(currentRowSize);
    }

    private void delRow() {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        this.kdtTable.removeRow(selectedRowIndex);
    }

    protected void clearTable() {
        int rowCount;
        int lockedRowSize = 0;
        if (this.lockedFilterInfo != null) {
            lockedRowSize = this.lockedFilterInfo.getFilterItems().size();
        }
        for (int i = rowCount = this.kdtTable.getRowCount(); i >= lockedRowSize; --i) {
            this.kdtTable.removeRow(i);
        }
    }

    private void setLeftBracketCell(int rowIndex) {
        if (this.kdtTable.getRow(rowIndex).getCell(0).getEditor() == null) {
            CmpItemFilterUtil.setComboBoxField(this.kdtTable, rowIndex, 0, CmpItemFilterUtil.addObjectToArray(LeftBracketSignEnum.getEnumList().toArray(), null));
        }
    }

    private void setConditionCell(int rowIndex) {
        if (this.kdtTable.getRow(rowIndex).getCell(1).getEditor() == null) {
            Object[] conditions = null;
            conditions = this.getQueryConditionArray();
            CmpItemFilterUtil.setComboBoxField(this.kdtTable, rowIndex, 1, CmpItemFilterUtil.addObjectToArray(conditions, null));
        }
    }

    public void reInitCondition() {
        for (int i = 0; i < this.kdtTable.getRowCount(); ++i) {
            Object[] conditions = null;
            conditions = this.getQueryConditionArray();
            CmpItemFilterUtil.setComboBoxField(this.kdtTable, i, 1, CmpItemFilterUtil.addObjectToArray(conditions, null));
        }
    }

    private DataObject[] getQueryConditionArray() {
        return CmpItemFilterUtil.getConditionArray(this.queryInfo);
    }

    private void setCompareCell(int rowIndex) {
        KDComboBox comboBox = null;
        if (this.kdtTable.getRow(rowIndex).getCell(1).getEditor() != null && this.kdtTable.getRow(rowIndex).getCell(2).getEditor() == null) {
            String condition = Util.getValue((Object)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).toString();
            DataObject dataInfo = CmpItemFilterUtil.getRefMetaData(this.queryInfo, condition);
            comboBox = dataInfo != null ? (CommonFilterUtil.isEnumType((String)dataInfo.getName()) ? CmpItemFilterUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignEnumEnum.class.getName(), null) : (CommonFilterUtil.isBooleanType((String)dataInfo.getName()) ? CmpItemFilterUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignBooleanEnum.class.getName(), null) : (CommonFilterUtil.isDateType((String)dataInfo.getName()) ? CmpItemFilterUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignDateEnum.class.getName(), null) : (CommonFilterUtil.isIntType((String)dataInfo.getName()) ? CmpItemFilterUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignIntEnum.class.getName(), null) : CmpItemFilterUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignStringEnum.class.getName(), null))))) : CmpItemFilterUtil.setEnumComboBoxField(this.kdtTable, rowIndex, 2, CompareSignStringEnum.class.getName(), null);
        }
        this.processFieldcompare(comboBox);
    }

    private void setCompareValueCell(int rowIndex) throws Exception {
        ICell currentCell = this.kdtTable.getRow(rowIndex).getCell(3);
        if (currentCell.getEditor() != null) {
            String compareSign;
            Component editor = currentCell.getEditor().getComponent();
            if (editor instanceof KDDatePicker && (compareSign = Util.getValue((Object)this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString()) != null && currentCell.getValue() == null && !CommonFilterUtil.isDateCompareSign((String)compareSign) && !compareSign.equalsIgnoreCase("IS") && !compareSign.equalsIgnoreCase("IS NOT")) {
                currentCell.setValue((Object)new Date());
            }
            if (editor instanceof KDPromptBox || editor instanceof KDTextField) {
                // empty if block
            }
        }
    }

    private void setRightBracketCell(int rowIndex) {
        if (this.kdtTable.getRow(rowIndex).getCell(4).getEditor() == null) {
            CmpItemFilterUtil.setComboBoxField(this.kdtTable, rowIndex, 4, CmpItemFilterUtil.addObjectToArray(RightBracketSignEnum.getEnumList().toArray(), null));
        }
    }

    private void setLogicCell(int rowIndex) {
        if (this.kdtTable.getRow(rowIndex).getCell(5).getEditor() == null) {
            CmpItemFilterUtil.setComboBoxField(this.kdtTable, rowIndex, 5, CmpItemFilterUtil.addObjectToArray(LogicSignEnum.getEnumList().toArray(), null));
        }
    }

    private void onMouseClicked(KDTMouseEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (rowIndex >= 0 && e.getType() == 1) {
            switch (columnIndex) {
                case 2: {
                    this.setCompareCell(rowIndex);
                    break;
                }
                case 3: {
                    this.setCompareValueCell(rowIndex);
                    break;
                }
            }
        }
    }

    private void initTableEditor(int rowIndex) {
        this.setLeftBracketCell(rowIndex);
        this.setConditionCell(rowIndex);
        this.setRightBracketCell(rowIndex);
        this.setLogicCell(rowIndex);
    }

    private boolean checkInvaildFilter() {
        int rowCount = this.kdtTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (this.isBlankRow(i)) continue;
            if (this.checkCurrentHasBlankCol(i)) {
                return true;
            }
            if (!this.checkCurrentHasTooLongCol(i)) continue;
            return true;
        }
        return false;
    }

    protected String getExistBlankColumnWarning() {
        String customerFilterWarning = null;
        if (this.checkInvaildFilter()) {
            customerFilterWarning = EASResource.getString((String)commonFilterRes, (String)"blankRowWarning");
        }
        return customerFilterWarning;
    }

    protected boolean isExistLogicSign(int rowIndex) {
        Object object = this.kdtTable.getRow(rowIndex).getCell(5).getValue();
        return object == null || object.toString() == null || object.toString().equalsIgnoreCase("");
    }

    protected String getBracketNotMatchingWarning() {
        String bracketNotMatchingWarning = null;
        int rowCount = this.kdtTable.getRowCount();
        int balance = 0;
        for (int i = 0; i < rowCount; ++i) {
            RightBracketSignEnum rightBracketSignEnum;
            int j;
            String bracketValue;
            LeftBracketSignEnum leftBracketSignEnum;
            int brackAmount = 0;
            Object object = this.kdtTable.getRow(i).getCell(0).getValue();
            if (object != null && object.toString() != null && !object.toString().equalsIgnoreCase("") && (leftBracketSignEnum = (LeftBracketSignEnum)object) != null && (bracketValue = leftBracketSignEnum.getValue()) != null) {
                brackAmount = bracketValue.length();
                for (j = 0; j < brackAmount; ++j) {
                    ++balance;
                }
            }
            if ((object = this.kdtTable.getRow(i).getCell(4).getValue()) == null || object.toString() == null || object.toString().equalsIgnoreCase("") || (rightBracketSignEnum = (RightBracketSignEnum)object) == null || (bracketValue = rightBracketSignEnum.getValue()) == null) continue;
            brackAmount = bracketValue.length();
            for (j = 0; j < brackAmount; ++j) {
                --balance;
            }
        }
        if (balance != 0) {
            bracketNotMatchingWarning = EASResource.getString((String)commonFilterRes, (String)"bracketWarning");
        }
        return bracketNotMatchingWarning;
    }

    protected static DataObject getRefMetaData(QueryInfo queryInfo, String queryFieldName) {
        com.kingdee.eas.base.commonquery.DataObject do1 = QueryUtils.getRefMetaData(null, (QueryInfo)queryInfo, (String)queryFieldName);
        return CmpItemFilterUI.toClientDataObject(do1);
    }

    private static DataObject toClientDataObject(com.kingdee.eas.base.commonquery.DataObject do1) {
        if (do1 == null) {
            return null;
        }
        DataObject dataObject = new DataObject();
        dataObject.setColLength(do1.getColLength());
        dataObject.setExtendValue(do1.getExtendValue());
        dataObject.setName(do1.getName());
        dataObject.setValue(do1.getValue());
        return dataObject;
    }

    private void setCurrentFilterInfo() {
        int rowCount = this.kdtTable.getRowCount();
        FilterInfo newFilterInfo = new FilterInfo();
        if (rowCount > 0) {
            StringBuffer sbFormula = new StringBuffer();
            for (int i = 0; i < rowCount; ++i) {
                FilterItemInfo filterItemInfo;
                if (this.isBlankRow(i)) continue;
                IRow iRow = this.kdtTable.getRow(i);
                String leftBracket = Util.getValue((Object)iRow.getCell(0).getValue()).toString();
                String condition = Util.getValue((Object)iRow.getCell(1).getValue()).toString();
                String compare = Util.getValue((Object)iRow.getCell(2).getValue()).toString().toLowerCase();
                String rightBracket = Util.getValue((Object)iRow.getCell(4).getValue()).toString();
                String logic = Util.getValue((Object)iRow.getCell(5).getValue()).toString();
                Object compareValue = null;
                ICell compareValueCell = iRow.getCell(3);
                if (compareValueCell.getEditor() != null && compareValueCell.getEditor().getComponent() != null) {
                    Component obj = iRow.getCell(3).getEditor().getComponent();
                    if (!(obj instanceof KDBizPromptBox) && (compareValue = Util.getValue((Object)iRow.getCell(3).getValue())) instanceof Date) {
                        String dataType = CmpItemFilterUtil.getRefMetaData(this.queryInfo, condition).getName();
                        compareValue = CmpItemFilterUtil.getDate((Date)compareValue, dataType, CompareSignDateEnum.getEnum((String)compare));
                    }
                } else {
                    compareValue = Util.getValue((Object)iRow.getCell(3).getValue());
                    if (compareValue instanceof Date) {
                        String dataType = CmpItemFilterUtil.getRefMetaData(this.queryInfo, condition).getName();
                        compareValue = CmpItemFilterUtil.getDate((Date)compareValue, dataType, CompareSignDateEnum.getEnum((String)compare));
                    }
                }
                Object compareSign = iRow.getCell(2).getValue();
                if (CommonFilterUtil.isIncludeSign((Object)compareSign)) {
                    FilterItemInfo includeFilter = new FilterItemInfo(condition, (Object)CmpItemFilterUtil.processIncludeValue(compareValue.toString()), CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(includeFilter);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("YESTERDAY")) {
                    newFilterInfo = CmpItemFilterUtil.getYesterdayFilterInfo(newFilterInfo, condition, this.queryInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("TODAY")) {
                    newFilterInfo = CmpItemFilterUtil.getTodayFilterInfo(null, newFilterInfo, condition, this.queryInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("TOMORROW")) {
                    newFilterInfo = CmpItemFilterUtil.getTomorrowFilterInfo(null, newFilterInfo, condition, this.queryInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("LASTWEEK")) {
                    newFilterInfo = CmpItemFilterUtil.getLastWeekFilterInfo(null, newFilterInfo, condition, this.queryInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("THISWEEK")) {
                    newFilterInfo = CmpItemFilterUtil.getThisWeekFilterInfo(null, newFilterInfo, condition, this.queryInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("NEXTWEEK")) {
                    newFilterInfo = CmpItemFilterUtil.getNextWeekFilterInfo(null, newFilterInfo, condition, this.queryInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("LASTMONTH")) {
                    newFilterInfo = CmpItemFilterUtil.getLastMonthFilterInfo(null, newFilterInfo, condition, this.queryInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("THISMONTH")) {
                    newFilterInfo = CmpItemFilterUtil.getThisMonthFilterInfo(null, newFilterInfo, condition, this.queryInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("NEXTMONTH")) {
                    newFilterInfo = CmpItemFilterUtil.getNextMonthFilterInfo(null, newFilterInfo, condition, this.queryInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("BEFORETODAY")) {
                    newFilterInfo = CmpItemFilterUtil.getBeforetoDayFilterInfo(null, newFilterInfo, condition, this.queryInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("AFTERTODAY")) {
                    newFilterInfo = CmpItemFilterUtil.getAftertoDayFilterInfo(null, newFilterInfo, condition, this.queryInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.toUpperCase().startsWith("IN_X_DAYS_AFTER") || compare.toUpperCase().startsWith("IN_X_DAYS_EQUAL") || compare.toUpperCase().startsWith("IN_X_DAYS_BEFORE") || compare.toUpperCase().startsWith("X_DAYS_AGO_AFTER") || compare.toUpperCase().startsWith("X_DAYS_AGO_EQUAL") || compare.toUpperCase().startsWith("X_DAYS_AGO_BEFORE")) continue;
                if (compare.equalsIgnoreCase("IS") || compare.equalsIgnoreCase("IS")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"EMPTY", CompareType.IS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("IS NOT") || compare.equalsIgnoreCase("IS NOT")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"EMPTY", CompareType.ISNOT);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isFieldJudge((String)compare)) {
                    FilterItemInfo filterItemInfo4 = CommonFilterUtil.getFieldFilter((String)compare, (String)condition, (Object)compareValue);
                    newFilterInfo.getFilterItems().add(filterItemInfo4);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isLikeSign((Object)compareSign)) {
                    if (compareSign == CompareSignStringEnum.LEFTLIKESIGN) {
                        compare = compare.substring(compare.length() - 4, compare.length());
                    } else if (compareSign == CompareSignStringEnum.RIGHTLIKESIGN) {
                        compare = compare.substring(compare.length() - 4, compare.length());
                    } else if (compareSign == CompareSignStringEnum.NOTLEFTLIKESIGN) {
                        compare = "not like";
                    }
                    compareValue = CommonFilterUtil.getLikeCompareValue((Object)compareValue, (Object)compareSign);
                }
                DataObject dataInfo = CmpItemFilterUtil.getRefMetaData(this.queryInfo, condition);
                FilterItemInfo filterItemInfo2 = null;
                if (dataInfo != null) {
                    String dataType = CmpItemFilterUtil.getRefMetaData(this.queryInfo, condition).getName();
                    if (CommonFilterUtil.isIntType((String)dataType) || CommonFilterUtil.isBooleanType((String)dataType)) {
                        Number tmpCompareValue = null;
                        tmpCompareValue = compareValue.toString().indexOf(".") >= 0 || DataType.DECIMAL.getName().equals(dataType) ? new BigDecimal(compareValue.toString()) : Integer.valueOf(compareValue.toString());
                        filterItemInfo2 = new FilterItemInfo(condition, (Object)tmpCompareValue, CompareType.getEnum((String)compare));
                        newFilterInfo.getFilterItems().add(filterItemInfo2);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.isF7Type((String)dataType)) {
                        filterItemInfo2 = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                        newFilterInfo.getFilterItems().add(filterItemInfo2);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    filterItemInfo2 = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(filterItemInfo2);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                filterItemInfo2 = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                newFilterInfo.getFilterItems().add(filterItemInfo2);
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
            }
            String strFormula = sbFormula.toString();
            if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
                newFilterInfo.setMaskString(strFormula.substring(0, strFormula.length() - 1));
            }
        }
        this.filterInfo = newFilterInfo;
    }

    private void setCurrentInnerFilterInfo() {
        int rowCount = this.kdtTable.getRowCount();
        FilterInfo newFilterInfo = new FilterInfo();
        if (rowCount > 0) {
            StringBuffer sbFormula = new StringBuffer();
            for (int i = 0; i < rowCount; ++i) {
                FilterItemInfo filterItemInfo;
                Object compareSign;
                if (this.isBlankRow(i)) continue;
                IRow iRow = this.kdtTable.getRow(i);
                String leftBracket = Util.getValue((Object)iRow.getCell(0).getValue()).toString();
                String condition = Util.getValue((Object)iRow.getCell(1).getValue()).toString();
                String compare = Util.getValue((Object)iRow.getCell(2).getValue()).toString().toLowerCase();
                String rightBracket = Util.getValue((Object)iRow.getCell(4).getValue()).toString();
                String logic = Util.getValue((Object)iRow.getCell(5).getValue()).toString();
                Object compareValue = null;
                if (!Util.isF7CompareValue((IRow)iRow) && (compareValue = Util.getValue((Object)iRow.getCell(3).getValue())) instanceof Date) {
                    String dateType = CmpItemFilterUtil.getRefMetaData(this.queryInfo, condition).getName();
                    compareValue = CmpItemFilterUtil.getDate((Date)compareValue, dateType, CompareSignDateEnum.getEnum((String)compare));
                }
                if (CommonFilterUtil.isIncludeSign((Object)(compareSign = iRow.getCell(2).getValue()))) {
                    FilterItemInfo includeFilter = new FilterItemInfo(condition, (Object)CmpItemFilterUtil.processIncludeValue(compareValue.toString()), CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(includeFilter);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("YESTERDAY")) {
                    newFilterInfo = CmpItemFilterUtil.getYesterdayFilterInfo(newFilterInfo, condition, this.queryInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("TODAY")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"TODAY", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("TOMORROW")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"TOMORROW", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("LASTWEEK")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"LASTWEEK", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("THISWEEK")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"THISWEEK", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("NEXTWEEK")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"NEXTWEEK", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("LASTMONTH")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"LASTMONTH", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("THISMONTH")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"THISMONTH", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("NEXTMONTH")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"NEXTMONTH", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("BEFORETODAY")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"BEFORETODAY", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("AFTERTODAY")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"AFTERTODAY", CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.toUpperCase().startsWith("IN_X_DAYS_AFTER")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)("IN_X_DAYS_AFTER$" + compareValue), CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.toUpperCase().startsWith("IN_X_DAYS_EQUAL")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)("IN_X_DAYS_EQUAL$" + compareValue), CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.toUpperCase().startsWith("IN_X_DAYS_BEFORE")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)("IN_X_DAYS_BEFORE$" + compareValue), CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.toUpperCase().startsWith("X_DAYS_AGO_AFTER")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)("X_DAYS_AGO_AFTER$" + compareValue), CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.toUpperCase().startsWith("X_DAYS_AGO_EQUAL")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)("X_DAYS_AGO_EQUAL$" + compareValue), CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.toUpperCase().startsWith("X_DAYS_AGO_BEFORE")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)("X_DAYS_AGO_BEFORE$" + compareValue), CompareType.getEnum((String)"="));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("IS") || compare.equalsIgnoreCase("IS")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"EMPTY", CompareType.IS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("IS NOT") || compare.equalsIgnoreCase("IS NOT")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"EMPTY", CompareType.ISNOT);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isFieldJudge((String)compare)) {
                    FilterItemInfo filterItemInfo4 = CommonFilterUtil.getFieldFilter((String)compare, (String)condition, (Object)compareValue);
                    newFilterInfo.getFilterItems().add(filterItemInfo4);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isLikeSign((Object)compareSign)) {
                    if (compareSign == CompareSignStringEnum.LEFTLIKESIGN) {
                        compare = compare.substring(compare.length() - 4, compare.length());
                    } else if (compareSign == CompareSignStringEnum.RIGHTLIKESIGN) {
                        compare = compare.substring(compare.length() - 4, compare.length());
                    } else if (compareSign == CompareSignStringEnum.NOTLEFTLIKESIGN) {
                        compare = "not like";
                    }
                    compareValue = CommonFilterUtil.getLikeCompareValue((Object)compareValue, (Object)compareSign);
                }
                DataObject dataInfo = CmpItemFilterUtil.getRefMetaData(this.queryInfo, condition);
                FilterItemInfo filterItemInfo2 = null;
                if (dataInfo != null) {
                    String dataType = CmpItemFilterUtil.getRefMetaData(this.queryInfo, condition).getName();
                    if (CommonFilterUtil.isIntType((String)dataType)) {
                        Number oCompareValue = null;
                        oCompareValue = compareValue.toString().indexOf(".") >= 0 || DataType.DECIMAL.getName().equals(dataType) ? new BigDecimal(compareValue.toString()) : Integer.valueOf(compareValue.toString());
                        filterItemInfo2 = new FilterItemInfo(condition, (Object)oCompareValue, CompareType.getEnum((String)compare));
                        newFilterInfo.getFilterItems().add(filterItemInfo2);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (dataType.equals(DataType.DATE.getName()) && compare == CompareType.EQUALS.toString()) {
                        newFilterInfo = CommonFilterUtil.getEqualDateFilter((FilterInfo)newFilterInfo, (String)condition, (Object)compareValue);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (dataType.equals(DataType.DATE.getName()) && compare == CompareType.NOTEQUALS.toString()) {
                        newFilterInfo = CommonFilterUtil.getNotEqualDateFilter((FilterInfo)newFilterInfo, (String)condition, (Object)compareValue);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 3)).append(" ").append("OR").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("OR").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    filterItemInfo2 = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(filterItemInfo2);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                Object[] value = QueryUtils.setStringFilter((String)leftBracket, (String)rightBracket, (String)logic, (FilterInfo)newFilterInfo, (StringBuffer)sbFormula, (String)condition, (Vector)CmpItemFilterUtil.processStringValue(compareValue.toString()), (CompareType)CompareType.getEnum((String)compare));
                newFilterInfo = (FilterInfo)value[0];
                sbFormula = (StringBuffer)value[1];
            }
            String strFormula = sbFormula.toString();
            if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
                newFilterInfo.setMaskString(sbFormula.toString().substring(0, strFormula.length() - 1));
            }
        }
        this.filterInfo = newFilterInfo;
    }

    public FilterInfo getInnerFilterInfo() {
        FilterInfo newFilterInfo = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        this.setCurrentInnerFilterInfo();
        if (this.filterInfo != null && this.filterInfo.getFilterItems().size() > 0) {
            int filterSize = this.filterInfo.getFilterItems().size();
            this.beforeFillFilterTable();
            ArrayList rowInfos = Util.getRowInfos((FilterInfo)this.filterInfo);
            for (int i = 0; i < filterSize; ++i) {
                RowObject rowObject = (RowObject)rowInfos.get(i);
                FilterItemInfo filterItemInfo = this.filterInfo.getFilterItems().get(i);
                String leftBracket = rowObject.getLeftBracket();
                String rightBracket = rowObject.getRightBracket();
                String logic = rowObject.getLogic();
                rowObject.setLeftBracket(rowObject.getLeftBracket());
                rowObject.setCondition(filterItemInfo.getPropertyName());
                if (filterItemInfo.getCompareValue() != null) {
                    String condition = rowObject.getCondition();
                    String compareValue = filterItemInfo.getCompareValue().toString();
                    if (CommonFilterUtil.equalsIgnoreCase((String)compareValue, (String)"YESTERDAY")) {
                        newFilterInfo = CmpItemFilterUtil.getYesterdayFilterInfo(newFilterInfo, condition, this.queryInfo);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    newFilterInfo.getFilterItems().add(this.filterInfo.getFilterItems().get(i));
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (filterItemInfo.getPropertyName() == null) continue;
                newFilterInfo.getFilterItems().add(this.filterInfo.getFilterItems().get(i));
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
            }
            String strFormula = sbFormula.toString();
            if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
                newFilterInfo.setMaskString(sbFormula.toString().substring(0, strFormula.length() - 1));
            }
        }
        return new FilterInfo();
    }

    public FilterInfo getFilterInfo() {
        return new FilterInfo();
    }

    public FilterInfo getCondition() {
        this.setCurrentFilterInfo();
        return this.filterInfo;
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }

    public void setPanelName(String panelName) {
        this.panelName = panelName;
    }

    public String getPanelName() {
        return this.panelName;
    }

    public KDTable getKdtTable() {
        return this.kdtTable;
    }

    public boolean verify() {
        String existBlankColumnWarning = this.getExistBlankColumnWarning();
        if (existBlankColumnWarning != null) {
            MsgBox.showWarning((Component)((Object)this), (String)existBlankColumnWarning);
            return false;
        }
        String bracketNotMatchingWarning = this.getBracketNotMatchingWarning();
        if (bracketNotMatchingWarning != null) {
            MsgBox.showWarning((Component)((Object)this), (String)bracketNotMatchingWarning);
            return false;
        }
        return true;
    }

    public FilterInfo getLockedFilterInfo() {
        return this.lockedFilterInfo;
    }

    public void clear() {
        this.kdtTable.checkParsed();
        if (this.defalutFilterInfo != null) {
            this.filterInfo = this.defalutFilterInfo;
            try {
                this.fillFilterTableBody();
            }
            catch (BaseCommonQueryClientException baseCommonQueryClientException) {}
        } else {
            this.filterInfo = null;
            this.clearTable();
            this.fillLeftRows();
        }
    }

    public void setLockedFilterInfo(FilterInfo info) {
        this.lockedFilterInfo = info;
    }

    private void removeFieldCompare(KDComboBox comboBox) {
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            Object obj = comboBox.getItemAt(i);
            Object enumVlaue = null;
            if (obj == null || !(obj instanceof Enum) || (enumVlaue = CmpItemFilterUtil.getEnumValue((Enum)obj)) == null || !CommonFilterUtil.isFieldJudge((String)enumVlaue.toString())) continue;
            comboBox.removeItem(obj);
            --i;
        }
    }

    public boolean isShowFieldCompare() {
        return this.showFieldCompare;
    }

    public void setShowFieldCompare(boolean showFieldCompare) {
        this.showFieldCompare = showFieldCompare;
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.addRow();
    }

    @Override
    public void actionDelLine_actionPerformed(ActionEvent e) throws Exception {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        int lockedRowSize = -1;
        if (this.lockedFilterInfo != null) {
            lockedRowSize = this.lockedFilterInfo.getFilterItems().size();
        }
        if (selectedRowIndex == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)commonFilterRes, (String)"delWarning"));
        } else if (selectedRowIndex < lockedRowSize) {
            MsgBox.showWarning((String)EASResource.getString((String)commonFilterRes, (String)"delLockedFilterWarning"));
        } else {
            this.delRow();
        }
    }

    @Override
    public void actionClearLine_actionPerformed(ActionEvent e) throws Exception {
        this.clear();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        FilterInfo filter = this.getCondition();
        if (filter != null) {
            cp.addCustomerParam("CmpItemFilter", filter.toString());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        this.kdtTable.checkParsed();
        if (this.queryInfo == null || this.queryInfo.size() <= 0) {
            this.filterInfo = null;
            this.clear();
            return;
        }
        String filterStr = cp.getCustomerParam("CmpItemFilter");
        if (!StringUtils.isEmpty((String)filterStr)) {
            try {
                this.loadFilterInfo(new FilterInfo(filterStr));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            this.clear();
        }
    }

    public void loadFilterInfo(FilterInfo filterInfo) throws Exception {
        if (filterInfo == null) {
            this.clear();
            return;
        }
        if (this.filterInfo != null && this.filterInfo.equals((Object)filterInfo)) {
            return;
        }
        this.filterInfo = filterInfo;
        if (this.queryInfo != null && this.queryInfo.size() > 0) {
            this.kdtTable.checkParsed();
            this.fillFilterTableBody();
        }
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptConditionManager rcm = new RptConditionManager();
        RptParams params = rcm.toRptParams();
        params.setObject("cmpItemFilter", (Object)this.getCondition());
        return params;
    }

    public void setCustomCondition(RptParams params) {
    }
}

