/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.CmpItemException;
import com.kingdee.eas.hr.compensation.CmpItemShrFactory;
import com.kingdee.eas.hr.compensation.CmpItemShrInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemShrFactory;
import com.kingdee.eas.hr.compensation.ICmpItemShr;
import com.kingdee.eas.hr.compensation.ICmpSchemeItemShr;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.ItemSubjectEnum;
import com.kingdee.eas.hr.compensation.ItemUsedEnum;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.client.AbstractCmpItemShrEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class CmpItemShrEditUI
extends AbstractCmpItemShrEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CmpItemShrEditUI.class);
    String resClass = "com.kingdee.eas.hr.compensation.client.CmpItemResource.";
    boolean isFullSize = false;
    boolean changeFlag = false;
    ItemDataTypeEnum datatype = ItemDataTypeEnum.STRING;

    private void init() {
        this.initUITitle();
        this.txtNumber.setEnabled(false);
        EntityViewInfo evi = new EntityViewInfo();
        this.prmtF7.setEntityViewInfo(evi);
    }

    private void initPrecisionControl(ItemDataTypeEnum dataType, CmpItemShrInfo oldItemInfo) {
        if (dataType == null) {
            return;
        }
        SpinnerNumberModel modelLength = null;
        SpinnerNumberModel modelDec = null;
        boolean isF7 = this.ckbIsF7.isSelected();
        if (dataType != ItemDataTypeEnum.STRING) {
            this.ckbIsF7.setEnabled(false);
        }
        if (isF7) {
            this.spinDec.setEnabled(false);
            this.spinLength.setEnabled(false);
            this.comboPrecisionType.setEnabled(false);
            modelLength = new SpinnerNumberModel(255, 0, 255, 1);
            this.spinLength.setModel((SpinnerModel)modelLength);
            this.spinDec.setValue((Object)0);
            this.collectFlag.setEnabled(false);
            this.collectFlag.setSelected(false);
            this.prmtF7.setEnabled(true);
            boolean isOrg = this.ckbIsOrg.isSelected();
            if (isOrg) {
                this.btnF7.setEnabled(false);
            } else {
                this.btnF7.setEnabled(true);
            }
            this.comboDataType.setEnabled(false);
        } else {
            this.prmtF7.setEnabled(false);
            this.btnF7.setEnabled(false);
            this.comboDataType.setEnabled(true);
            if (dataType.equals((Object)ItemDataTypeEnum.CURRENCY)) {
                this.spinDec.setEnabled(true);
                this.spinLength.setEnabled(false);
                this.comboPrecisionType.setEnabled(true);
                modelLength = new SpinnerNumberModel(13, 0, 13, 1);
                this.spinLength.setModel((SpinnerModel)modelLength);
                modelDec = new SpinnerNumberModel(2, 0, 4, 1);
                this.spinDec.setModel((SpinnerModel)modelDec);
                this.collectFlag.setEnabled(true);
            } else if (dataType.equals((Object)ItemDataTypeEnum.FLOAT)) {
                this.spinDec.setEnabled(true);
                this.spinLength.setEnabled(false);
                this.comboPrecisionType.setEnabled(true);
                modelLength = new SpinnerNumberModel(13, 0, 13, 1);
                this.spinLength.setModel((SpinnerModel)modelLength);
                modelDec = new SpinnerNumberModel(2, 0, 8, 1);
                this.spinDec.setModel((SpinnerModel)modelDec);
                this.collectFlag.setEnabled(true);
            } else if (dataType.equals((Object)ItemDataTypeEnum.INT)) {
                this.spinDec.setEnabled(false);
                this.spinLength.setEnabled(false);
                this.comboPrecisionType.setEnabled(false);
                modelLength = new SpinnerNumberModel(13, 0, 13, 1);
                this.spinLength.setModel((SpinnerModel)modelLength);
                this.spinDec.setValue((Object)0);
                this.collectFlag.setEnabled(true);
            } else if (dataType.equals((Object)ItemDataTypeEnum.STRING)) {
                this.spinDec.setEnabled(false);
                this.spinLength.setEnabled(false);
                this.comboPrecisionType.setEnabled(false);
                modelLength = new SpinnerNumberModel(255, 0, 255, 1);
                this.spinLength.setModel((SpinnerModel)modelLength);
                this.spinDec.setValue((Object)0);
                this.collectFlag.setEnabled(false);
                this.collectFlag.setSelected(false);
            } else {
                this.spinDec.setEnabled(false);
                this.spinLength.setEnabled(false);
                this.comboPrecisionType.setEnabled(false);
                this.spinLength.setValue((Object)0);
                this.spinDec.setValue((Object)0);
                this.collectFlag.setEnabled(false);
                this.collectFlag.setSelected(false);
            }
            if (oldItemInfo == null || oldItemInfo.getId() == null) {
                return;
            }
            this.spinLength.setValue((Object)oldItemInfo.getLength());
            this.spinDec.setValue((Object)oldItemInfo.getDecDigital());
        }
    }

    private void initUITitle() {
        if (this.getOprtState().equalsIgnoreCase(OprtState.ADDNEW)) {
            this.setUITitle(com.kingdee.eas.util.client.EASResource.getString((String)(this.resClass + "ADD_TITLE")));
        } else if (this.getOprtState().equalsIgnoreCase(OprtState.EDIT)) {
            this.setUITitle(com.kingdee.eas.util.client.EASResource.getString((String)(this.resClass + "EDIT_TITLE")));
        } else if (this.getOprtState().equalsIgnoreCase(OprtState.VIEW)) {
            this.setUITitle(com.kingdee.eas.util.client.EASResource.getString((String)(this.resClass + "VIEW_TITLE")));
        }
    }

    protected void initListener() {
        super.initListener();
        this.comboDataType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                int state = ie.getStateChange();
                if (state == 1) {
                    ItemDataTypeEnum selItem = (ItemDataTypeEnum)((Object)((KDComboBox)ie.getSource()).getSelectedItem());
                    CmpItemShrEditUI.this.initPrecisionControl(selItem, null);
                }
            }
        });
        this.ckbIsF7.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean isF7 = CmpItemShrEditUI.this.ckbIsF7.isSelected();
                boolean isOrg = CmpItemShrEditUI.this.ckbIsOrg.isSelected();
                if (isF7 || isOrg) {
                    CmpItemShrEditUI.this.comboDataType.setSelectedItem((Object)ItemDataTypeEnum.STRING);
                    CmpItemShrEditUI.this.ckbIsOrg.setSelected(false);
                    CmpItemShrEditUI.this.comboDataType.setEnabled(false);
                    CmpItemShrEditUI.this.prmtF7.setEnabled(true);
                } else {
                    CmpItemShrEditUI.this.prmtF7.setValue(null);
                    CmpItemShrEditUI.this.prmtF7.setEnabled(false);
                    CmpItemShrEditUI.this.txtF7Value.setText("");
                    CmpItemShrEditUI.this.comboDataType.setSelectedItem((Object)CmpItemShrEditUI.this.datatype);
                    CmpItemShrEditUI.this.comboDataType.setEnabled(false);
                }
            }
        });
        this.ckbIsOrg.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean isF7 = CmpItemShrEditUI.this.ckbIsF7.isSelected();
                boolean isOrg = CmpItemShrEditUI.this.ckbIsOrg.isSelected();
                if (isF7 || isOrg) {
                    CmpItemShrEditUI.this.comboDataType.setSelectedItem((Object)ItemDataTypeEnum.STRING);
                    if (isOrg) {
                        CmpItemShrEditUI.this.txtF7Value.setText("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
                        CmpItemShrEditUI.this.prmtF7.setEnabled(false);
                        CmpItemShrEditUI.this.ckbIsF7.setSelected(false);
                        CmpItemShrEditUI.this.comboDataType.setEnabled(false);
                        CmpItemShrEditUI.this.prmtF7.setValue(null);
                    } else {
                        CmpItemShrEditUI.this.prmtF7.setEnabled(true);
                        CmpItemShrEditUI.this.comboDataType.setEnabled(true);
                    }
                } else {
                    CmpItemShrEditUI.this.comboDataType.setSelectedItem((Object)CmpItemShrEditUI.this.datatype);
                    CmpItemShrEditUI.this.txtF7Value.setText("");
                }
            }
        });
        this.prmtF7.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                Object newValue = arg0.getNewValue();
                if (newValue != null) {
                    AsstActTypeInfo aatinfo = (AsstActTypeInfo)newValue;
                    CmpItemShrEditUI.this.prmtF7.setValue((Object)aatinfo);
                    String sQueryPK = aatinfo.getDefaultQueryName();
                    CmpItemShrEditUI.this.txtF7Value.setText(sQueryPK);
                } else {
                    CmpItemShrEditUI.this.prmtF7.setText("");
                    CmpItemShrEditUI.this.txtF7Value.setText("");
                }
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.comboDataType.setEnabled(true);
        this.comboType.setEnabled(false);
        this.comboType.setEditable(false);
        this.chkEnable.setEnabled(true);
        this.btnCopy.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnRemove.setVisible(false);
        this.menuBiz.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        CmpItemShrInfo itemInfo = this.editData;
        this.collectFlag.setSelected(itemInfo.isCollectFlag());
        this.initPrecisionControl(this.editData.getDataType(), this.editData);
        this.doSpecialCondition();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.updateCollectFlag();
    }

    protected IObjectValue createNewData() {
        CmpItemShrInfo info = new CmpItemShrInfo();
        info.setSubject(ItemSubjectEnum.NOTSYSINIT);
        info.setDataType(ItemDataTypeEnum.CURRENCY);
        info.setUsed(ItemUsedEnum.OTHER);
        info.setLength(13);
        info.setDecDigital(4);
        info.setEnable(StateEnum.UNENABLE);
        info.setDefaultOrder(9999);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CmpItemShrFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.init();
        super.onLoad();
        this.lblCtrItemValue.setVisible(false);
        this.txtItemValue.setEditable(false);
        if (this.editData != null && this.editData.get("datatype") != null) {
            this.datatype = ItemDataTypeEnum.getEnum((Integer)this.editData.get("datatype"));
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("enable"));
        sic.add(new SelectorItemInfo("collectFlag"));
        sic.add(new SelectorItemInfo("F7Value"));
        sic.add(new SelectorItemInfo("IsF7"));
        sic.add(new SelectorItemInfo("isOrg"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("dataType"));
        sic.add(new SelectorItemInfo("type"));
        sic.add(new SelectorItemInfo("length"));
        sic.add(new SelectorItemInfo("decDigital"));
        sic.add(new SelectorItemInfo("itemValue"));
        sic.add(new SelectorItemInfo("precisionType"));
        sic.add(new SelectorItemInfo("enableDate"));
        sic.add(new SelectorItemInfo("disableDate"));
        sic.add(new SelectorItemInfo("F7Name"));
        return sic;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.ckbIsF7.setSelected(this.editData.isIsF7());
        this.ckbIsOrg.setSelected(this.editData.isIsOrg());
        String name2 = this.editData.getF7Name();
        if (!"".equals(name2) && name2 != null) {
            AsstActTypeInfo aatinfo = AsstActTypeFactory.getRemoteInstance().getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(name2));
            this.prmtF7.setValue((Object)aatinfo);
        }
        boolean isF7 = this.ckbIsF7.isSelected();
        boolean isOrg = this.ckbIsOrg.isSelected();
        if (isF7 || isOrg) {
            this.comboDataType.setSelectedItem((Object)ItemDataTypeEnum.STRING);
            if (isOrg) {
                this.txtF7Value.setText("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
                this.prmtF7.setEnabled(false);
            } else {
                this.txtF7Value.setText("");
                this.prmtF7.setEnabled(true);
            }
        } else {
            this.prmtF7.setEnabled(false);
        }
    }

    private void doSpecialCondition() {
        if (this.editData.getSubject() != null && this.editData.getSubject().getValue() == 10) {
            this.txtName.setEnabled(false);
            this.comboDataType.setEnabled(false);
            this.comboType.setEnabled(false);
            this.spinLength.setEnabled(false);
        }
        if (this.editData.getEnable() != null && this.editData.getEnable().getValue() != 0 && (this.getOprtState().equalsIgnoreCase(OprtState.EDIT) || this.getOprtState().equalsIgnoreCase(OprtState.VIEW))) {
            this.comboDataType.setEnabled(false);
            this.comboType.setEnabled(false);
            this.spinLength.setEnabled(false);
            if (this.editData.getEnable().getValue() == 1) {
                this.chkEnable.setEnabled(false);
                this.chkEnable.setSelected(true);
            } else {
                this.chkEnable.setEnabled(true);
                this.chkEnable.setSelected(false);
            }
        } else {
            this.chkEnable.setSelected(false);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        boolean flagOfDate;
        Object f7Value;
        boolean isF7 = this.ckbIsF7.isSelected();
        if (isF7 && (f7Value = this.prmtF7.getValue()) == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.resourse.HrCompenMultLangResource", (String)"label4", (Locale)SysContext.getSysContext().getLocale()));
            this.abort();
        }
        this.editData.setIsF7(isF7);
        Object value2 = this.prmtF7.getValue();
        if (value2 != null) {
            AsstActTypeInfo aatinfo = (AsstActTypeInfo)value2;
            this.editData.setF7Name(aatinfo.getId().toString());
        }
        this.editData.setIsOrg(this.ckbIsOrg.isSelected());
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            throw new CmpItemException(CmpItemException.CMPITEM_NUMBER_NOT_BLANK);
        }
        if (this.editData.getNumber().charAt(0) < '\n') {
            throw new CmpItemException(CmpItemException.CMPITEM_NOTNUM);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            throw new CmpItemException(CmpItemException.CMPITEM_NAME_NOT_BLANK);
        }
        if (this.editData.getName().charAt(0) < ':' && this.editData.getName().charAt(0) > '/') {
            throw new CmpItemException(CmpItemException.CMPITEM_NAMENOTNUM);
        }
        if (this.editData.getDataType() != null && (this.editData.getDataType().equals((Object)ItemDataTypeEnum.CURRENCY) || this.editData.getDataType().equals((Object)ItemDataTypeEnum.FLOAT)) && (this.editData.getPrecisionType() == null || this.editData.getPrecisionType().getValue() == 10)) {
            throw new CmpItemException(CmpItemException.CMPITEM_PRECISION_NOT_NULL);
        }
        String strNameCharacter = null;
        int size = this.editData.getName().length();
        for (int i = 0; i < size; ++i) {
            strNameCharacter = this.editData.getName().substring(i, i + 1);
            if (strNameCharacter.equals("%")) {
                throw new CmpItemException(CmpItemException.CMPITEM_NAMENOTBFH);
            }
            if (!strNameCharacter.equals(" ")) continue;
            throw new CmpItemException(CmpItemException.CMPITEM_NOEMPTYCHAR);
        }
        if (this.chkEnable.isSelected()) {
            this.editData.setEnable(StateEnum.ENABLE);
        }
        this.editData.setCollectFlag(this.collectFlag.isSelected());
        if (StringUtils.isEmpty((String)this.editData.getItemValue())) {
            // empty if block
        }
        if (this.spinLength.getIntegerVlaue() < this.spinDec.getIntegerVlaue()) {
            throw new CmpItemException(CmpItemException.CMPITEM_DECGRATELENTH);
        }
        Date pkEnableDate = (Date)this.pkEnableDate.getValue();
        Date pkDisableDate = (Date)this.pkDisableDate.getValue();
        if (pkEnableDate != null && pkDisableDate != null && !(flagOfDate = DateTimeUtils.dayAfter((Date)pkDisableDate, (Date)pkEnableDate))) {
            MsgBox.showInfo((String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource.BEGINDATE_AFTER_ENDDATE"));
            SysUtil.abort();
        }
        this.editData.setEnableDate(pkEnableDate);
        this.editData.setDisableDate(pkDisableDate);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getId() != null) {
            ICmpItemShr iCmpItem = (ICmpItemShr)this.getBizInterface();
            CmpItemShrInfo infoOldCmpItem = iCmpItem.getCmpItemShrInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            if (!infoOldCmpItem.getName().trim().equals(this.txtName.getSelectedItemData().toString().trim()) && iCmpItem.isReferencedByFormula(this.editData.getNumber()) && MsgBox.showConfirm2((String)com.kingdee.eas.util.client.EASResource.getString((String)(this.resClass + "REFEFENCED_BYFORMULA"))) == 2) {
                return;
            }
            if (!this.ckbIsF7.isSelected()) {
                this.editData.put("f7name", null);
            }
        }
        super.actionSubmit_actionPerformed(e);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.ckbIsF7.setSelected(false);
            this.ckbIsOrg.setSelected(false);
            this.prmtF7.setText("");
            this.comboDataType.setSelectedItem((Object)ItemDataTypeEnum.CURRENCY);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnHigh.setIcon(com.kingdee.eas.util.client.EASResource.getIcon((String)"imgTbtn_check"));
        this.btnEdit.setVisible(false);
        this.menuItemEdit.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.menuView.setVisible(false);
        this.menuEdit.setVisible(false);
    }

    @Override
    public void actionHigh_actionPerformed(ActionEvent e) throws Exception {
        super.actionHigh_actionPerformed(e);
        this.resetUISize();
    }

    private void resetUISize() {
        int changed = 344;
        if (this.isFullSize) {
            changed += 0;
            this.isFullSize = false;
        } else {
            changed += 25;
            this.isFullSize = true;
        }
        if (this.getUIWindow() instanceof Frame) {
            Frame uiWindow = (Frame)this.getUIWindow();
            uiWindow.setSize(278, changed);
            uiWindow.repaint();
        } else if (this.getUIWindow() instanceof JDialog) {
            JDialog uiWindow = (JDialog)this.getUIWindow();
            uiWindow.setSize(270, changed);
            uiWindow.repaint();
        }
        this.lblCtrItemValue.setVisible(this.isFullSize);
    }

    @Override
    protected void collectFlag_stateChanged(ChangeEvent e) throws Exception {
        this.changeFlag = true;
    }

    private void updateCollectFlag() {
        BOSUuid Id;
        boolean isCollect;
        if (this.changeFlag && !(isCollect = this.collectFlag.isSelected()) && (Id = this.editData.getId()) != null) {
            try {
                ICmpSchemeItemShr schemeItem = CmpSchemeItemShrFactory.getRemoteInstance();
                schemeItem.updateCollectFlag(this.editData);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    @Override
    protected void btnF7_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.show();
    }
}

