/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.CalCmpSchmFacadeFactory;
import com.kingdee.eas.hr.compensation.CalEmpSchmException;
import com.kingdee.eas.hr.compensation.CmpSchemeException;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.ICalCmpSchmFacade;
import com.kingdee.eas.hr.compensation.client.AbstractCmpTrySchemeListUI;
import com.kingdee.eas.hr.compensation.client.CmpCheckEditUI;
import com.kingdee.eas.hr.compensation.client.CmpSchemeEditUI;
import com.kingdee.eas.hr.compensation.client.CmpSchemeItemFormulasUI;
import com.kingdee.eas.hr.compensation.client.TryEndInputEmployeeUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CmpTrySchemeListUI
extends AbstractCmpTrySchemeListUI {
    private static final Logger logger = CoreUIObject.getLogger(CmpTrySchemeListUI.class);
    private String strAdjustSchemeID = null;
    private String strComeFrom = null;
    private boolean isCaculateSuccess = false;
    private String resClass = "com.kingdee.eas.hr.compensation.client.EmpCmpSchmResource.";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("comeFrom") != null) {
            this.strComeFrom = this.getUIContext().get("comeFrom").toString();
        }
        if (this.getUIContext().get("adjustSchemeId") != null) {
            this.strAdjustSchemeID = this.getUIContext().get("adjustSchemeId").toString();
        }
        super.onLoad();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"isTryScheme", (Object)true);
    }

    @Override
    public void actionEndInput_actionPerformed(ActionEvent e) throws Exception {
        int iActiveRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        String strSchemeId = null;
        if (iActiveRowIndex < 0) {
            return;
        }
        strSchemeId = this.tblMain.getRow(iActiveRowIndex).getCell("id").getValue().toString();
        if (this.strAdjustSchemeID == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"adjustSchemeId", (Object)this.strAdjustSchemeID);
        uiContext.put((Object)"trySchemeId", (Object)strSchemeId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(TryEndInputEmployeeUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    @Override
    public void actionTryCalculate_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        Object objID = HRTableTools.getTableSelectCellValue(this.tblMain, "id");
        if (objID == null) {
            return;
        }
        try {
            this.pubFireVOChangeListener(objID.toString());
        }
        catch (Throwable e2) {
            Object objName = HRTableTools.getTableSelectCellValue(this.tblMain, "name");
            Object[] params = new Object[]{objName};
            throw new CmpSchemeException(CmpSchemeException.CALCULATE_MUTEX, params);
        }
        this.calculate(e, objID);
        if (this.isCaculateSuccess && MsgBox.showConfirm2((String)EASResource.getString((String)(this.resClass + "CMPCHECK_NEEDVIEW"))) == 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)objID.toString());
            Object schemeName = HRTableTools.getTableSelectCellValue(this.tblMain, "name");
            uiContext.put((Object)"adjustSchemeId", (Object)this.strAdjustSchemeID);
            uiContext.put((Object)"schemeName", schemeName);
            uiContext.put((Object)"isComeFrom", (Object)"tryScheme");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(CmpCheckEditUI.class.getName(), (Map)uiContext);
            uiWindow.show();
        }
        MutexServiceControlFactory.getRemoteInstance().releaseObjIDForUpdate(objID.toString());
    }

    private void calculate(ActionEvent e, Object objID) throws Exception {
        this.isCaculateSuccess = false;
        if (objID == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "CALCULATE_NOT_ALLOW")));
            return;
        }
        final String strTrySchemeId = objID.toString();
        GetDataDialog dlg = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        dlg = win instanceof Frame ? new GetDataDialog((Frame)win) : (win instanceof Dialog ? new GetDataDialog((Dialog)win) : new GetDataDialog());
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                try {
                    ICalCmpSchmFacade ics = CalCmpSchmFacadeFactory.getRemoteInstance();
                    ics.calculateTryScheme(strTrySchemeId, CmpTrySchemeListUI.this.strAdjustSchemeID);
                    CmpTrySchemeListUI.this.setMessageText(EASResource.getString((String)(CmpTrySchemeListUI.this.resClass + "CALCULATE_SUCCESS")));
                    CmpTrySchemeListUI.this.showMessage();
                    CmpTrySchemeListUI.this.isCaculateSuccess = true;
                    return null;
                }
                catch (BOSException e) {
                    throw new CalEmpSchmException(CalEmpSchmException.CAL_RUNTIME_EXEC, e);
                }
            }
        });
        dlg.show();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("HROrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        return filter;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getEditUIName() {
        return CmpSchemeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CmpSchemeFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnEndInput.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.btnTryCalculate.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.btnShowAllFormulas.setIcon(EASResource.getIcon((String)"imgTbtn_seesignup"));
        if (this.strComeFrom != null) {
            if (this.strComeFrom.equals("cmpSchemeList")) {
                this.btnEndInput.setVisible(false);
                this.btnTryCalculate.setVisible(false);
            } else if (this.strComeFrom.equals("adjSchemeEdit")) {
                this.btnEndInput.setVisible(true);
                this.btnTryCalculate.setVisible(true);
                this.btnEndInput.setEnabled(true);
                this.btnTryCalculate.setEnabled(true);
            } else {
                this.btnEndInput.setVisible(false);
                this.btnTryCalculate.setVisible(false);
            }
        }
    }

    @Override
    public void actionShowAllFormulas_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        String schemeId = this.tblMain.getRow(rowIndex).getCell("id").getValue().toString();
        String schemeName = this.tblMain.getRow(rowIndex).getCell("name").getValue().toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"schemeId", (Object)schemeId);
        uiContext.put((Object)"schemeName", (Object)schemeName);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(CmpSchemeItemFormulasUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }
}

