/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.AssignTypeEnum;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.DeptSchemeFactory;
import com.kingdee.eas.hr.compensation.DeptSchemeInfo;
import com.kingdee.eas.hr.compensation.IDeptScheme;
import com.kingdee.eas.hr.compensation.TeamGroupCollection;
import com.kingdee.eas.hr.compensation.TeamGroupFactory;
import com.kingdee.eas.hr.compensation.TeamGroupInfo;
import com.kingdee.eas.hr.compensation.client.AbstractDepCmpDepBalanceFilterUI;
import com.kingdee.eas.hr.compensation.client.DeptSchemeEntryEditUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class DepCmpDepBalanceFilterUI
extends AbstractDepCmpDepBalanceFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DepCmpDepBalanceFilterUI.class);
    private String deptSchemeURL = "com.kingdee.eas.hr.compensation.app.F7DeptSchemeQuery";
    private String depInnerResURL = "com.kingdee.eas.hr.compensation.client.DeptInnerSchemeResource.";
    private IDeptScheme iDeptScheme = null;
    private DeptSchemeInfo infoGol = null;

    public IDeptScheme getIDeptScheme() throws BOSException {
        if (this.iDeptScheme == null) {
            this.iDeptScheme = DeptSchemeFactory.getRemoteInstance();
        }
        return this.iDeptScheme;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
    }

    private boolean isTeam() {
        DeptSchemeInfo deptSchemeInfo;
        if (this.infoGol == null && (deptSchemeInfo = (DeptSchemeInfo)this.prmtDeptScheme.getData()) != null) {
            this.infoGol = deptSchemeInfo;
        }
        return this.infoGol != null && AssignTypeEnum.TEAMGROUP.equals((Object)this.infoGol.getAssignType());
    }

    private void initAllEditor() {
        this.btnOrgMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnOrgMovePre.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnOrgMoveNext.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnOrgMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnOrgAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnOrgRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnOrgAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnOrgLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnCmpPeriodMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnCmpPeriodMovePre.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnCmpPeriodMoveNext.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnCmpPeriodMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnCmpPeriodAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnCmpPeriodRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnCmpPeriodAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnCmpPeriodLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.prmtDeptScheme.setQueryInfo(this.deptSchemeURL);
        this.prmtDeptScheme.setEditable(false);
        this.prmtDeptScheme.setEditFormat("$name$");
        this.prmtDeptScheme.setDisplayFormat("$name$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfoDepSch = new FilterInfo();
        filterInfoDepSch.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filterInfoDepSch.getFilterItems().add(new FilterItemInfo("enable", (Object)"1"));
        filterInfoDepSch.setMaskString("#0 AND #1");
        evi.setFilter(filterInfoDepSch);
        this.prmtDeptScheme.setEntityViewInfo(evi);
    }

    public List getSelectCmpPeriodList() {
        ArrayList<CmpPeriodInfo> CmpPeriodList = new ArrayList<CmpPeriodInfo>();
        int countListSelectItem = this.lstCmpPeriodSelectItem.getElementCount();
        if (countListSelectItem > 0) {
            CmpPeriodInfo info = null;
            for (int i = 0; i < countListSelectItem; ++i) {
                info = (CmpPeriodInfo)this.lstCmpPeriodSelectItem.getElement(i);
                CmpPeriodList.add(i, info);
            }
        }
        return CmpPeriodList;
    }

    public List getSelectAdminOrgList() {
        if (this.isTeam()) {
            return this.getTeamGroupList();
        }
        ArrayList<AdminOrgUnitInfo> AdminOrgUnitList = new ArrayList<AdminOrgUnitInfo>();
        int countListSelectItem = this.lstOrgSelectItem.getElementCount();
        if (countListSelectItem > 0) {
            AdminOrgUnitInfo info = null;
            for (int i = 0; i < countListSelectItem; ++i) {
                info = (AdminOrgUnitInfo)this.lstOrgSelectItem.getElement(i);
                AdminOrgUnitList.add(i, info);
            }
        }
        return AdminOrgUnitList;
    }

    private List getTeamGroupList() {
        ArrayList<TeamGroupInfo> teamGroupList = new ArrayList<TeamGroupInfo>();
        TeamGroupInfo info = null;
        if (this.lstOrgSelectItem.getElementCount() <= 0) {
            return teamGroupList;
        }
        for (int i = 0; i < this.lstOrgSelectItem.getElementCount(); ++i) {
            info = (TeamGroupInfo)this.lstOrgSelectItem.getElement(i);
            teamGroupList.add(i, info);
        }
        return teamGroupList;
    }

    public DeptSchemeInfo getSelectDeptSchemeInfo() {
        return this.infoGol;
    }

    protected void initListener() {
        super.initListener();
        this.prmtDeptScheme.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (DepCmpDepBalanceFilterUI.this.prmtDeptScheme.getData() != null) {
                    try {
                        DeptSchemeInfo deptSchemeInfo = (DeptSchemeInfo)DepCmpDepBalanceFilterUI.this.prmtDeptScheme.getData();
                        if (DepCmpDepBalanceFilterUI.this.getIDeptScheme().exists((IObjectPK)new ObjectUuidPK(deptSchemeInfo.getId().toString()))) {
                            DepCmpDepBalanceFilterUI.this.infoGol = (DeptSchemeInfo)DepCmpDepBalanceFilterUI.this.getIDeptScheme().getDeptSchemeInfo(false, (IObjectPK)new ObjectUuidPK(deptSchemeInfo.getId().toString()));
                            DepCmpDepBalanceFilterUI.this.lstCmpPeriodAllItem.removeAllElements();
                            DepCmpDepBalanceFilterUI.this.lstCmpPeriodSelectItem.removeAllElements();
                            DepCmpDepBalanceFilterUI.this.lstOrgAllItem.removeAllElements();
                            DepCmpDepBalanceFilterUI.this.lstOrgSelectItem.removeAllElements();
                            DepCmpDepBalanceFilterUI.this.chkUserStandradScheme.setSelected(DepCmpDepBalanceFilterUI.this.infoGol.isUseDepCmpStandrad());
                        }
                        if (DepCmpDepBalanceFilterUI.this.infoGol != null) {
                            DepCmpDepBalanceFilterUI.this.loadToAllList();
                        }
                    }
                    catch (Exception e) {
                        BOSException be = new BOSException((Throwable)e);
                        be.setStackTrace(e.getStackTrace());
                        DepCmpDepBalanceFilterUI.this.handUIException(be);
                    }
                } else {
                    DepCmpDepBalanceFilterUI.this.clear();
                    return;
                }
            }
        });
    }

    protected void loadToAllList() throws EASBizException, BOSException {
        CmpPeriodCollection cmpPeriodCol = this.infoGol.getCmpPeriodCollection();
        if (cmpPeriodCol != null && cmpPeriodCol.size() != 0) {
            this.loadToCmpPeriodList(cmpPeriodCol);
        }
        if (this.isTeam()) {
            TeamGroupCollection teamGroupColl = this.infoGol.getTeamGroupCollection();
            if (teamGroupColl != null && teamGroupColl.size() != 0) {
                this.loadToTeamGroupList(teamGroupColl);
            }
            this.pnlOrg.setBorder((Border)new TitledBorder(BorderFactory.createLineBorder(new Color(192, 192, 192), 1), EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"298_DepCmpDepBalanceFilterUI")));
        } else {
            DeptSchemeEntryEditUI.modifyDeptSchemeInfoDepColl(this.infoGol, HRSchemeUtils.getCurrentHRAndAdminRangeSet());
            AdminOrgUnitCollection adminOrgCol = this.infoGol.getDeptCollection();
            if (adminOrgCol != null && adminOrgCol.size() != 0) {
                this.loadToAdminOrgList(adminOrgCol);
            }
            this.pnlOrg.setBorder((Border)new TitledBorder(BorderFactory.createLineBorder(new Color(192, 192, 192), 1), this.resHelper.getString("pnlOrg.border.title")));
        }
    }

    private void loadToAdminOrgList(AdminOrgUnitCollection adminOrgCol) {
        AdminOrgUnitInfo infoCmpItem = null;
        int size = adminOrgCol.size();
        for (int i = 0; i < size; ++i) {
            infoCmpItem = adminOrgCol.get(i);
            this.lstOrgAllItem.addElement((Object)infoCmpItem);
        }
        if (this.lstOrgAllItem.getElementCount() > 0) {
            this.lstOrgAllItem.setSelectedIndex(0);
        }
    }

    private void loadToTeamGroupList(TeamGroupCollection teamGroupColl) {
        TeamGroupInfo teamGroupInfo = null;
        int size = teamGroupColl.size();
        for (int i = 0; i < size; ++i) {
            teamGroupInfo = teamGroupColl.get(i);
            this.lstOrgAllItem.addElement((Object)teamGroupInfo);
        }
        if (this.lstOrgAllItem.getElementCount() > 0) {
            this.lstOrgAllItem.setSelectedIndex(0);
        }
    }

    private void loadToCmpPeriodList(CmpPeriodCollection cmpPeriodColl) {
        CmpPeriodInfo infoCmpItem = null;
        int size = cmpPeriodColl.size();
        for (int i = 0; i < size; ++i) {
            infoCmpItem = cmpPeriodColl.get(i);
            this.lstCmpPeriodAllItem.addElement((Object)infoCmpItem);
        }
        if (this.lstCmpPeriodAllItem.getElementCount() > 0) {
            this.lstCmpPeriodAllItem.setSelectedIndex(0);
        }
    }

    private void allCmpPeriodRightToLeftItem() {
        int count = this.lstCmpPeriodSelectItem.getElementCount();
        if (count > 0) {
            CmpPeriodInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpPeriodInfo)this.lstCmpPeriodSelectItem.getElement(0);
                this.lstCmpPeriodAllItem.addElement((Object)info);
                this.lstCmpPeriodSelectItem.removeElement((Object)info);
            }
            this.lstCmpPeriodAllItem.setSelectedIndex(0);
        }
    }

    private void allOrgUnitRightToLeftItem() {
        int count = this.lstOrgSelectItem.getElementCount();
        if (count > 0) {
            Object info = null;
            for (int i = 0; i < count; ++i) {
                info = this.lstOrgSelectItem.getElement(0);
                this.lstOrgAllItem.addElement(info);
                this.lstOrgSelectItem.removeElement(info);
            }
            this.lstOrgAllItem.setSelectedIndex(0);
        }
    }

    private void rightToLeftCmpPeriod() {
        int index = this.lstCmpPeriodSelectItem.getSelectedIndex();
        if (index >= 0) {
            CmpPeriodInfo info = (CmpPeriodInfo)this.lstCmpPeriodSelectItem.getElement(index);
            this.lstCmpPeriodSelectItem.removeElement((Object)info);
            if (this.lstCmpPeriodSelectItem.getElementCount() > 0) {
                this.lstCmpPeriodSelectItem.setSelectedIndex(index - 1);
            }
            this.lstCmpPeriodAllItem.addElement((Object)info);
            this.lstCmpPeriodAllItem.setSelectedValue((Object)info, true);
        }
    }

    private void rightToLeftOrgUnit() {
        int index = this.lstOrgSelectItem.getSelectedIndex();
        if (index >= 0) {
            Object info = this.lstOrgSelectItem.getElement(index);
            this.lstOrgSelectItem.removeElement(info);
            if (this.lstOrgSelectItem.getElementCount() > 0) {
                this.lstOrgSelectItem.setSelectedIndex(index - 1);
            }
            this.lstOrgAllItem.addElement(info);
            this.lstOrgAllItem.setSelectedValue(info, true);
        }
    }

    private void allLeftToRightCmpPeriod() {
        int count = this.lstCmpPeriodAllItem.getElementCount();
        if (count > 0) {
            CmpPeriodInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpPeriodInfo)this.lstCmpPeriodAllItem.getElement(0);
                this.lstCmpPeriodSelectItem.addElement((Object)info);
                this.lstCmpPeriodAllItem.removeElement((Object)info);
            }
            this.lstCmpPeriodSelectItem.setSelectedIndex(0);
        }
    }

    private void allLeftToRightOrgUnit() {
        int count = this.lstOrgAllItem.getElementCount();
        if (count > 0) {
            Object info = null;
            for (int i = 0; i < count; ++i) {
                info = this.lstOrgAllItem.getElement(0);
                this.lstOrgSelectItem.addElement(info);
                this.lstOrgAllItem.removeElement(info);
            }
            this.lstOrgSelectItem.setSelectedIndex(0);
        }
    }

    private void leftToRightCmpPeriod() {
        int index = this.lstCmpPeriodAllItem.getSelectedIndex();
        if (index >= 0) {
            CmpPeriodInfo info = (CmpPeriodInfo)this.lstCmpPeriodAllItem.getElement(index);
            int indexSelect = this.lstCmpPeriodSelectItem.getSelectedIndex() + 1;
            this.lstCmpPeriodSelectItem.insertElement((Object)info, indexSelect);
            if (this.lstCmpPeriodSelectItem.getElementCount() > 0) {
                this.lstCmpPeriodSelectItem.setSelectedIndex(indexSelect - 1);
            }
            this.lstCmpPeriodAllItem.removeElement((Object)info);
            this.lstCmpPeriodSelectItem.setSelectedValue((Object)info, true);
        }
    }

    private void leftToRightOrgUnit() {
        int index = this.lstOrgAllItem.getSelectedIndex();
        if (index >= 0) {
            Object info = this.lstOrgAllItem.getElement(index);
            int indexSelect = this.lstOrgSelectItem.getSelectedIndex() + 1;
            this.lstOrgSelectItem.insertElement(info, indexSelect);
            if (this.lstOrgSelectItem.getElementCount() > 0) {
                this.lstOrgSelectItem.setSelectedIndex(indexSelect - 1);
            }
            this.lstOrgAllItem.removeElement(info);
            this.lstOrgSelectItem.setSelectedValue(info, true);
        }
    }

    @Override
    protected void lstCmpPeriodAllItem_mouseClicked(MouseEvent e) throws Exception {
        super.lstCmpPeriodAllItem_mouseClicked(e);
        if (e.getClickCount() == 2) {
            this.leftToRightCmpPeriod();
        }
    }

    @Override
    protected void lstCmpPeriodSelectItem_mouseClicked(MouseEvent e) throws Exception {
        super.lstCmpPeriodSelectItem_mouseClicked(e);
        if (e.getClickCount() == 2) {
            this.rightToLeftCmpPeriod();
        }
    }

    @Override
    public void actionCmpPeriodAllLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionCmpPeriodAllLeft_actionPerformed(e);
        this.allCmpPeriodRightToLeftItem();
    }

    @Override
    public void actionCmpPeriodLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionCmpPeriodLeft_actionPerformed(e);
        this.rightToLeftCmpPeriod();
    }

    @Override
    public void actionCmpPeriodRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionCmpPeriodRight_actionPerformed(e);
        this.leftToRightCmpPeriod();
    }

    @Override
    public void actionCmpPeriodAllRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionCmpPeriodAllRight_actionPerformed(e);
        this.allLeftToRightCmpPeriod();
    }

    @Override
    public void actionCmpPeriodMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionCmpPeriodMoveTop_actionPerformed(e);
        int index = this.lstCmpPeriodSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpPeriodInfo info = (CmpPeriodInfo)this.lstCmpPeriodSelectItem.getElement(index);
            this.lstCmpPeriodSelectItem.removeElementAt(index);
            this.lstCmpPeriodSelectItem.insertElement((Object)info, 0);
            this.lstCmpPeriodSelectItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionCmpPeriodMovePre_actionPerformed(ActionEvent e) throws Exception {
        super.actionCmpPeriodMovePre_actionPerformed(e);
        int index = this.lstCmpPeriodSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpPeriodInfo info = (CmpPeriodInfo)this.lstCmpPeriodSelectItem.getElement(index);
            this.lstCmpPeriodSelectItem.removeElementAt(index);
            this.lstCmpPeriodSelectItem.insertElement((Object)info, index - 1);
            this.lstCmpPeriodSelectItem.setSelectedIndex(index - 1);
        }
    }

    @Override
    public void actionCmpPeriodMoveNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionCmpPeriodMoveNext_actionPerformed(e);
        int index = this.lstCmpPeriodSelectItem.getSelectedIndex();
        int count = this.lstCmpPeriodSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpPeriodInfo info = (CmpPeriodInfo)this.lstCmpPeriodSelectItem.getElement(index);
            this.lstCmpPeriodSelectItem.removeElementAt(index);
            this.lstCmpPeriodSelectItem.insertElement((Object)info, index + 1);
            this.lstCmpPeriodSelectItem.setSelectedIndex(index + 1);
        }
    }

    @Override
    public void actionCmpPeriodMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        super.actionCmpPeriodMoveBottom_actionPerformed(e);
        int index = this.lstCmpPeriodSelectItem.getSelectedIndex();
        int count = this.lstCmpPeriodSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpPeriodInfo info = (CmpPeriodInfo)this.lstCmpPeriodSelectItem.getElement(index);
            this.lstCmpPeriodSelectItem.removeElementAt(index);
            this.lstCmpPeriodSelectItem.insertElement((Object)info, count - 1);
            this.lstCmpPeriodSelectItem.setSelectedIndex(count - 1);
        }
    }

    @Override
    protected void lstOrgAllItem_mouseClicked(MouseEvent e) throws Exception {
        super.lstOrgAllItem_mouseClicked(e);
        if (e.getClickCount() == 2) {
            this.leftToRightOrgUnit();
        }
    }

    @Override
    protected void lstOrgSelectItem_mouseClicked(MouseEvent e) throws Exception {
        super.lstOrgSelectItem_mouseClicked(e);
        if (e.getClickCount() == 2) {
            this.rightToLeftOrgUnit();
        }
    }

    @Override
    public void actionOrgAllLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionOrgAllLeft_actionPerformed(e);
        this.allOrgUnitRightToLeftItem();
    }

    @Override
    public void actionOrgLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionOrgLeft_actionPerformed(e);
        this.rightToLeftOrgUnit();
    }

    @Override
    public void actionOrgRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionOrgRight_actionPerformed(e);
        this.leftToRightOrgUnit();
    }

    @Override
    public void actionOrgAllRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionOrgAllRight_actionPerformed(e);
        this.allLeftToRightOrgUnit();
    }

    @Override
    public void actionOrgMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionOrgMoveTop_actionPerformed(e);
        int index = this.lstOrgSelectItem.getSelectedIndex();
        if (index > 0) {
            Object info = this.lstOrgSelectItem.getElement(index);
            this.lstOrgSelectItem.removeElementAt(index);
            this.lstOrgSelectItem.insertElement(info, 0);
            this.lstOrgSelectItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionOrgMovePre_actionPerformed(ActionEvent e) throws Exception {
        super.actionOrgMovePre_actionPerformed(e);
        int index = this.lstOrgSelectItem.getSelectedIndex();
        if (index > 0) {
            Object info = this.lstOrgSelectItem.getElement(index);
            this.lstOrgSelectItem.removeElementAt(index);
            this.lstOrgSelectItem.insertElement(info, index - 1);
            this.lstOrgSelectItem.setSelectedIndex(index - 1);
        }
    }

    @Override
    public void actionOrgMoveNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionOrgMoveNext_actionPerformed(e);
        int index = this.lstOrgSelectItem.getSelectedIndex();
        int count = this.lstOrgSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            Object info = this.lstOrgSelectItem.getElement(index);
            this.lstOrgSelectItem.removeElementAt(index);
            this.lstOrgSelectItem.insertElement(info, index + 1);
            this.lstOrgSelectItem.setSelectedIndex(index + 1);
        }
    }

    @Override
    public void actionOrgMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        super.actionOrgMoveBottom_actionPerformed(e);
        int index = this.lstOrgSelectItem.getSelectedIndex();
        int count = this.lstOrgSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            Object info = this.lstOrgSelectItem.getElement(index);
            this.lstOrgSelectItem.removeElementAt(index);
            this.lstOrgSelectItem.insertElement(info, count - 1);
            this.lstOrgSelectItem.setSelectedIndex(count - 1);
        }
    }

    public boolean verify() {
        if (this.prmtDeptScheme.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.depInnerResURL + "MISS_DEPTSCHEME")));
            this.prmtDeptScheme.requestFocusInWindow();
            return false;
        }
        if (this.lstOrgSelectItem.getElementCount() == 0) {
            if (this.isTeam()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"299_DepCmpDepBalanceFilterUI"));
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)(this.depInnerResURL + "MISS_ADMINORGUNIT")));
            }
            return false;
        }
        if (this.lstCmpPeriodSelectItem.getElementCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.depInnerResURL + "MISS_CMPPERIOD")));
            return false;
        }
        return super.verify();
    }

    private String getCustomerString(KDList listItem, boolean flag) {
        StringBuffer allListArray = new StringBuffer();
        int allListItemSize = listItem.getElementCount();
        int controlInt = allListItemSize - 1;
        for (int i = 0; i < allListItemSize; ++i) {
            if (flag) {
                CmpPeriodInfo cmpPeriodInfo = (CmpPeriodInfo)listItem.getElement(i);
                allListArray.append(cmpPeriodInfo.getId().toString());
            } else if (!this.isTeam()) {
                AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)listItem.getElement(i);
                allListArray.append(adminOrgUnitInfo.getId().toString());
            }
            if (!flag && this.isTeam()) {
                TeamGroupInfo teamGroupInfo = (TeamGroupInfo)listItem.getElement(i);
                allListArray.append(teamGroupInfo.getId().toString());
            }
            if (i == controlInt) continue;
            allListArray.append("-");
        }
        return allListArray.toString();
    }

    private void setListControl(KDList listItem, boolean flag, String keyString) {
        listItem.removeAllElements();
        HashSet<String> keySet = new HashSet<String>();
        if (keyString.indexOf("00000000-0000-0000-0000-000000000000CCE7AED4") > -1) {
            keyString = keyString.replaceFirst("00000000-0000-0000-0000-000000000000CCE7AED4", "123456");
            keySet.add("00000000-0000-0000-0000-000000000000CCE7AED4");
        }
        String[] allListStrArray = keyString.split("-");
        int arrayInt = allListStrArray.length;
        for (int i = 0; i < arrayInt; ++i) {
            if (allListStrArray[i] == null || allListStrArray[i].length() <= 0) continue;
            if ("123456".equals(allListStrArray[i])) {
                allListStrArray[i] = "00000000-0000-0000-0000-000000000000CCE7AED4";
                continue;
            }
            keySet.add(allListStrArray[i]);
        }
        EntityViewInfo entityViewInfoTmp = new EntityViewInfo();
        FilterInfo fitlerInfoTmp = new FilterInfo();
        fitlerInfoTmp.getFilterItems().add(new FilterItemInfo("id", keySet, CompareType.INCLUDE));
        entityViewInfoTmp.setFilter(fitlerInfoTmp);
        try {
            int i;
            int catalogSize;
            if (flag) {
                CmpPeriodCollection cmpPeriodColl = CmpPeriodFactory.getRemoteInstance().getCmpPeriodCollection(entityViewInfoTmp);
                this.setPeriodByOrder(listItem, cmpPeriodColl, allListStrArray);
            } else if (!this.isTeam()) {
                AdminOrgUnitCollection adminOrgUnitColl = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(entityViewInfoTmp);
                catalogSize = adminOrgUnitColl.size();
                for (i = 0; i < catalogSize; ++i) {
                    AdminOrgUnitInfo adminOrgUnitInfo = adminOrgUnitColl.get(i);
                    listItem.addElement((Object)adminOrgUnitInfo);
                }
            }
            if (!flag && this.isTeam()) {
                TeamGroupCollection teamGroupColl = TeamGroupFactory.getRemoteInstance().getTeamGroupCollection(entityViewInfoTmp);
                catalogSize = teamGroupColl.size();
                for (i = 0; i < catalogSize; ++i) {
                    TeamGroupInfo teamGroupInfo = teamGroupColl.get(i);
                    listItem.addElement((Object)teamGroupInfo);
                }
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void setPeriodByOrder(KDList listItem, CmpPeriodCollection cmpPeriodColl, String[] allListStrArray) {
        if (allListStrArray == null || cmpPeriodColl == null) {
            return;
        }
        block0: for (String periodId : allListStrArray) {
            int catalogSize = cmpPeriodColl.size();
            for (int c = 0; c < catalogSize; ++c) {
                CmpPeriodInfo cmpPeriodInfo = cmpPeriodColl.get(c);
                if (!periodId.equals(cmpPeriodInfo.getId().toString())) continue;
                listItem.addElement((Object)cmpPeriodInfo);
                continue block0;
            }
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtDeptScheme.getData() != null) {
            cp.addCustomerParam("prmtDeptScheme", ((DeptSchemeInfo)this.prmtDeptScheme.getData()).getId().toString());
        }
        cp.addCustomerParam("allListAdminOrgUnit", this.getCustomerString(this.lstOrgAllItem, false));
        cp.addCustomerParam("selectListAdminOrgUnit", this.getCustomerString(this.lstOrgSelectItem, false));
        cp.addCustomerParam("allListCmpPeriod", this.getCustomerString(this.lstCmpPeriodAllItem, true));
        cp.addCustomerParam("selectListCmpPeriod", this.getCustomerString(this.lstCmpPeriodSelectItem, true));
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        String keyString;
        if (cp == null) {
            return;
        }
        ObjectUuidPK pkTemp = null;
        if (cp.getCustomerParam("prmtDeptScheme") != null) {
            pkTemp = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("prmtDeptScheme")));
            try {
                this.prmtDeptScheme.setData((Object)((DeptSchemeInfo)DeptSchemeFactory.getRemoteInstance().getValue((IObjectPK)pkTemp)));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if ((keyString = cp.getCustomerParam("allListAdminOrgUnit")).trim().length() > 0) {
            this.setListControl(this.lstOrgAllItem, false, keyString);
        } else {
            this.lstOrgAllItem.removeAllElements();
        }
        keyString = cp.getCustomerParam("selectListAdminOrgUnit");
        if (keyString.trim().length() > 0) {
            this.setListControl(this.lstOrgSelectItem, false, keyString);
        } else {
            this.lstOrgSelectItem.removeAllElements();
        }
        keyString = cp.getCustomerParam("allListCmpPeriod");
        if (keyString.trim().length() > 0) {
            this.setListControl(this.lstCmpPeriodAllItem, true, keyString);
        } else {
            this.lstCmpPeriodAllItem.removeAllElements();
        }
        keyString = cp.getCustomerParam("selectListCmpPeriod");
        if (keyString.trim().length() > 0) {
            this.setListControl(this.lstCmpPeriodSelectItem, true, keyString);
        } else {
            this.lstCmpPeriodSelectItem.removeAllElements();
        }
    }

    public void clear() {
        super.clear();
        this.prmtDeptScheme.setData(null);
        this.lstCmpPeriodAllItem.removeAllElements();
        this.lstCmpPeriodSelectItem.removeAllElements();
        this.lstOrgAllItem.removeAllElements();
        this.lstOrgSelectItem.removeAllElements();
        this.chkUserStandradScheme.setSelected(false);
    }
}

