/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.basedata.org.client.f7.NewHROF7;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.ICmpItem;
import com.kingdee.eas.hr.compensation.client.AbstractGroupSummaryReportFilterUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class GroupSummaryReportFilterUI
extends AbstractGroupSummaryReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(GroupSummaryReportFilterUI.class);
    private HashMap cmpItemMap = new HashMap();
    private CmpItemCollection colCmpItemAll = null;
    private static final String GROUPORGUNITID = "00000000-0000-0000-0000-000000000000CCE7AED4";
    private static final String cmpPeriodF7URL = "com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery";
    private String empSumResource = "com.kingdee.eas.hr.compensation.client.EmpSumReportResource.";
    private List cmpPeriodList = new ArrayList();
    private List cmpItemList = new ArrayList();
    private boolean firstLoad = true;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
        this.prmtHROrg.setEditable(false);
        if (this.firstLoad) {
            this.getCmpItemCollection();
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMovePre.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveNext.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
    }

    private void initAllEditor() {
        this.setHrEidtor();
        this.getGroupPromptBox(this.prmtBeginPeriod);
        this.getGroupPromptBox(this.prmtEndPeriod);
        this.btnAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
    }

    private KDBizPromptBox getGroupPromptBox(KDBizPromptBox kdBizGroupPromptBox) {
        kdBizGroupPromptBox.setQueryInfo(cmpPeriodF7URL);
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)GROUPORGUNITID));
        env.setFilter(filterInfo);
        kdBizGroupPromptBox.setEntityViewInfo(env);
        kdBizGroupPromptBox.setEditFormat("$number$");
        kdBizGroupPromptBox.setCommitFormat("$number$");
        kdBizGroupPromptBox.setDisplayFormat("$name$");
        return kdBizGroupPromptBox;
    }

    private void setSelectItemMap() {
        int selectListSize = this.lstSelectItem.getElementCount();
        this.cmpItemMap.clear();
        for (int i = 0; i < selectListSize; ++i) {
            CmpItemInfo cmpItemInfo = (CmpItemInfo)this.lstSelectItem.getElement(i);
            this.cmpItemMap.put(cmpItemInfo.getId().toString(), cmpItemInfo);
        }
    }

    private void setCmpItemList() {
        this.cmpItemList.clear();
        int selectListSize = this.lstSelectItem.getElementCount();
        for (int i = 0; i < selectListSize; ++i) {
            CmpItemInfo cmpItemInfo = (CmpItemInfo)this.lstSelectItem.getElement(i);
            this.cmpItemList.add(cmpItemInfo);
        }
    }

    private void getCmpItemCollection() throws Exception {
        this.colCmpItemAll = new CmpItemCollection();
        String numberStr = this.getCmpItemOfEntity();
        if ("".equals(numberStr)) {
            return;
        }
        ICmpItem iCmpItem = CmpItemFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (this.firstLoad) {
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)((HROrgUnitInfo)this.prmtHROrg.getData()).getId().toString()));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)numberStr, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("enable", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("dataType", (Object)60));
        filterInfo.setMaskString("#0 and #1 and #2 and #3 ");
        evi.setFilter(filterInfo);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("name");
        sorterOrderItem.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterOrderItem);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("cmpItemCatalog.*"));
        this.colCmpItemAll = iCmpItem.getCmpItemCollection(evi);
        this.firstLoad = false;
    }

    private String getCmpItemOfEntity() throws BOSException {
        ICmpItem iCmpItem = CmpItemFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String strHr = "";
        strHr = this.firstLoad ? this.getHROrgUnitCollectionForFirstLoad() : this.getHROrgUnitCollectionOf();
        if ("".equals(strHr) || strHr == null) {
            return "";
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)strHr, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isGroupControl", (Object)Boolean.TRUE));
        filterInfo.setMaskString("#0 and #1 ");
        evi.setFilter(filterInfo);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("number"));
        CmpItemCollection temCmpItemCollection = iCmpItem.getCmpItemCollection(evi);
        HashSet<StringBuffer> numberSet = new HashSet<StringBuffer>();
        String tmpNumber = null;
        StringBuffer strb = new StringBuffer("");
        int j = temCmpItemCollection.size();
        for (int i = 0; i < j; ++i) {
            if ("".equals(strb.toString())) {
                tmpNumber = temCmpItemCollection.get(i).getNumber();
                if (numberSet.contains(tmpNumber)) continue;
                strb.append(tmpNumber);
                numberSet.add(strb);
                continue;
            }
            tmpNumber = temCmpItemCollection.get(i).getNumber();
            if (numberSet.contains(tmpNumber)) continue;
            strb.append("," + temCmpItemCollection.get(i).getNumber());
            numberSet.add(strb);
        }
        return strb.toString();
    }

    private String getHROrgUnitCollectionOf() throws BOSException {
        HROrgUnitInfo hrOrgUnitInfo = (HROrgUnitInfo)this.prmtHROrg.getData();
        if (hrOrgUnitInfo == null) {
            return null;
        }
        String oql = null;
        if (this.chkIncluedeChild.isSelected() && this.cboChildLevel.getSelectedItem() != null) {
            int toLevel = hrOrgUnitInfo.getLevel() + (Integer)this.cboChildLevel.getSelectedItem();
            oql = "SELECT id WHERE isBizUnit='1' and longNumber like '" + hrOrgUnitInfo.getLongNumber() + "%' and level >= " + hrOrgUnitInfo.getLevel() + " and level <= " + toLevel;
            IHROrgUnit iHrOrgUnit = HROrgUnitFactory.getRemoteInstance();
            HROrgUnitCollection hrOrgColl = iHrOrgUnit.getHROrgUnitCollection(oql);
            StringBuffer strb = new StringBuffer("");
            int j = hrOrgColl.size();
            for (int i = 0; i < j; ++i) {
                if ("".equals(strb.toString())) {
                    strb.append(hrOrgColl.get(i).getId().toString());
                    continue;
                }
                strb.append("," + hrOrgColl.get(i).getId().toString());
            }
            return strb.toString();
        }
        return hrOrgUnitInfo.getId().toString();
    }

    private void onLoadAllList() {
        if (this.colCmpItemAll == null || this.colCmpItemAll.size() <= 0) {
            this.lstAllItem.removeAllElements();
            this.lstSelectItem.removeAllElements();
            return;
        }
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        Iterator itrCmpItem = this.colCmpItemAll.iterator();
        CmpItemInfo infoCmpItem = null;
        while (itrCmpItem.hasNext()) {
            infoCmpItem = (CmpItemInfo)itrCmpItem.next();
            if (this.cmpItemMap.containsKey(infoCmpItem.getId().toString())) continue;
            this.lstAllItem.addElement((Object)infoCmpItem);
        }
        if (this.prmtBeginPeriod.getValue() == null || this.prmtEndPeriod.getValue() == null) {
            this.lstAllItem.removeAllElements();
            int n = this.colCmpItemAll.size();
            for (int i = 0; i < n; ++i) {
                infoCmpItem = this.colCmpItemAll.get(i);
                this.lstAllItem.addElement((Object)infoCmpItem);
            }
        }
        if (this.lstAllItem.getElementCount() > 0) {
            this.lstAllItem.setSelectedIndex(0);
        }
    }

    private void reloadAllList(String text) {
        if (this.colCmpItemAll != null && this.colCmpItemAll.size() > 0) {
            this.lstAllItem.removeAllElements();
        }
        CmpItemCollection colCmpItemAllTemp = (CmpItemCollection)((Object)this.colCmpItemAll.clone());
        Iterator itrCmpItem = colCmpItemAllTemp.iterator();
        CmpItemInfo infoCmpItem = null;
        ArrayList<CmpItemInfo> tempList = new ArrayList<CmpItemInfo>();
        while (itrCmpItem.hasNext()) {
            infoCmpItem = (CmpItemInfo)itrCmpItem.next();
            if (this.cmpItemMap.containsKey(infoCmpItem.getId().toString()) || infoCmpItem.getName().indexOf(text) <= -1) continue;
            tempList.add(infoCmpItem);
            this.lstAllItem.addElement((Object)infoCmpItem);
        }
        int size = tempList.size();
        for (int i = 0; i < size; ++i) {
            infoCmpItem = (CmpItemInfo)tempList.get(i);
            colCmpItemAllTemp.remove(infoCmpItem);
        }
        itrCmpItem = colCmpItemAllTemp.iterator();
        while (itrCmpItem.hasNext()) {
            infoCmpItem = (CmpItemInfo)itrCmpItem.next();
            if (this.cmpItemMap.containsKey(infoCmpItem.getId().toString())) continue;
            this.lstAllItem.addElement((Object)infoCmpItem);
        }
        int size2 = this.lstAllItem.getElementCount();
        for (int i = 0; i < size2; ++i) {
            CmpItemInfo cmpItemInfo = (CmpItemInfo)this.lstAllItem.getElement(i);
            if (cmpItemInfo.getName().indexOf(text) <= -1) continue;
            this.lstAllItem.removeElementAt(i);
            this.lstAllItem.insertElement((Object)cmpItemInfo, 0);
            this.lstAllItem.setSelectedIndex(0);
            break;
        }
    }

    public boolean verify() {
        boolean flagOfDate;
        if (this.prmtBeginPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_CMPPER")));
            this.prmtBeginPeriod.requestFocusInWindow();
            return false;
        }
        if (this.prmtEndPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_CMPPER")));
            this.prmtEndPeriod.requestFocusInWindow();
            return false;
        }
        CmpPeriodInfo cmpPeriodInfoBegin = (CmpPeriodInfo)this.prmtBeginPeriod.getData();
        CmpPeriodInfo cmpPeriodInfoEnd = (CmpPeriodInfo)this.prmtEndPeriod.getData();
        if (!cmpPeriodInfoBegin.getId().toString().equals(cmpPeriodInfoEnd.getId().toString()) && !(flagOfDate = DateTimeUtils.dayAfter((Date)cmpPeriodInfoEnd.getBeginDate(), (Date)cmpPeriodInfoBegin.getEndDate()))) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpAdjustiveSchResource.BEGINDATE_AFTER_ENDDATE"));
            this.prmtBeginPeriod.requestFocusInWindow();
            return false;
        }
        if (this.lstSelectItem.getElementCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_CMPITEM")));
            return false;
        }
        return true;
    }

    public HashMap getSelectCmpItemsMap() {
        return this.cmpItemMap;
    }

    public List getSelectCmpItemsList() {
        this.setCmpItemList();
        return this.cmpItemList;
    }

    public List getCmpPeriodList() {
        CmpPeriodInfo beginCmpPeriod = (CmpPeriodInfo)this.prmtBeginPeriod.getData();
        CmpPeriodInfo endCmpPeriod = (CmpPeriodInfo)this.prmtEndPeriod.getData();
        try {
            this.cmpPeriodList = HRUtils.getCmpPeriodList(null, beginCmpPeriod, endCmpPeriod, true);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return this.cmpPeriodList;
    }

    @Override
    protected void lstAllItem_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionRight_actionPerformed(null);
        }
    }

    @Override
    protected void lstSelectItem_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionLeft_actionPerformed(null);
        }
    }

    private void msgBoxInfo(String msgStr) {
        MsgBox.showInfo((String)EASResource.getString((String)msgStr));
        SysUtil.abort();
    }

    @Override
    public void actionAllRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllRight_actionPerformed(e);
        int count = this.lstAllItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstAllItem.getElement(0);
                this.lstSelectItem.addElement((Object)info);
                this.lstAllItem.removeElement((Object)info);
            }
            this.lstSelectItem.setSelectedIndex(0);
        }
        this.setSelectItemMap();
    }

    @Override
    public void actionRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionRight_actionPerformed(e);
        int index = this.lstAllItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstAllItem.getElement(index);
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            this.lstSelectItem.insertElement((Object)info, indexSelect);
            this.lstAllItem.removeElement((Object)info);
            if (index - 1 > 0) {
                this.lstAllItem.setSelectedIndex(index - 1);
            } else if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
            this.lstSelectItem.setSelectedValue((Object)info, true);
        }
        this.setSelectItemMap();
    }

    @Override
    public void actionLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionLeft_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            int indexSelect = this.lstAllItem.getSelectedIndex() + 1;
            this.lstAllItem.insertElement((Object)info, indexSelect);
            this.lstSelectItem.removeElement((Object)info);
            if (index - 1 > 0) {
                this.lstSelectItem.setSelectedIndex(index - 1);
            } else if (this.lstSelectItem.getElementCount() > 0) {
                this.lstSelectItem.setSelectedIndex(0);
            }
            this.lstAllItem.setSelectedValue((Object)info, true);
        }
        this.setSelectItemMap();
    }

    @Override
    public void actionAllLeft_actionPerformed(ActionEvent e) throws Exception {
        int count = this.lstSelectItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstSelectItem.getElement(0);
                this.lstAllItem.addElement((Object)info);
                this.lstSelectItem.removeElement((Object)info);
            }
            this.lstAllItem.setSelectedIndex(0);
        }
        this.setSelectItemMap();
    }

    @Override
    public void actionSearch_actionPerformed(ActionEvent e) throws Exception {
        super.actionSearch_actionPerformed(e);
        String txtIputStr = this.txtInput.getText();
        if (txtIputStr != null && !txtIputStr.equals("")) {
            this.getCmpItemCollection();
            this.reloadAllList(txtIputStr);
        }
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTop_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, 0);
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionMovePre_actionPerformed(ActionEvent e) throws Exception {
        super.actionMovePre_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, index - 1);
            this.lstSelectItem.setSelectedIndex(index - 1);
        }
    }

    @Override
    public void actionMoveNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveNext_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, index + 1);
            this.lstSelectItem.setSelectedIndex(index + 1);
        }
    }

    @Override
    public void actionMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveBottom_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, count - 1);
            this.lstSelectItem.setSelectedIndex(count - 1);
        }
    }

    public void clear() {
        super.clear();
        this.chkIncluedeChild.setSelected(false);
        this.cboChildLevel.setSelectedItem(null);
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        this.prmtBeginPeriod.setData(null);
        this.prmtEndPeriod.setData(null);
        this.onLoadAllList();
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (cp == null) {
            return;
        }
        if (cp.getBoolean("includeChild")) {
            this.chkIncluedeChild.setSelected(true);
            String childLevel = cp.getCustomerParam("childLevel");
            this.cboChildLevel.setSelectedIndex(Integer.parseInt(childLevel) - 1);
        }
        ObjectUuidPK pkTemp = null;
        if (cp.getCustomerParam("prmtCmpBeginPeriod") != null) {
            pkTemp = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("prmtCmpBeginPeriod")));
            try {
                this.prmtBeginPeriod.setData((Object)((CmpPeriodInfo)CmpPeriodFactory.getRemoteInstance().getValue((IObjectPK)pkTemp)));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (cp.getCustomerParam("prmtCmpEndPeriod") != null) {
            pkTemp = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("prmtCmpEndPeriod")));
            try {
                this.prmtEndPeriod.setData((Object)((CmpPeriodInfo)CmpPeriodFactory.getRemoteInstance().getValue((IObjectPK)pkTemp)));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        int arrayInt = 0;
        HashSet<String> keySet = null;
        EntityViewInfo entityViewInfoTmp = null;
        FilterInfo fitlerInfoTmp = null;
        this.lstSelectItem.removeAllElements();
        String selectListStr = cp.getCustomerParam("selectListItem").toString();
        if (selectListStr.trim().length() != 0) {
            String[] selectListStrArray = selectListStr.split("@");
            arrayInt = selectListStrArray.length;
            keySet = new HashSet<String>();
            ArrayList<String> seqList = new ArrayList<String>();
            for (int i = 0; i < arrayInt; ++i) {
                keySet.add(selectListStrArray[i]);
                seqList.add(selectListStrArray[i]);
            }
            entityViewInfoTmp = new EntityViewInfo();
            fitlerInfoTmp = new FilterInfo();
            fitlerInfoTmp.getFilterItems().add(new FilterItemInfo("id", keySet, CompareType.INCLUDE));
            entityViewInfoTmp.setFilter(fitlerInfoTmp);
            try {
                CmpItemInfo cmpItemInfo;
                int i;
                CmpItemCollection cmpItemColl = CmpItemFactory.getRemoteInstance().getCmpItemCollection(entityViewInfoTmp);
                HashMap<String, CmpItemInfo> seqHelperMap = new HashMap<String, CmpItemInfo>();
                int catalogSize = cmpItemColl.size();
                for (i = 0; i < catalogSize; ++i) {
                    cmpItemInfo = cmpItemColl.get(i);
                    if (cmpItemInfo.getHrOrgUnit() == null) continue;
                    seqHelperMap.put(cmpItemInfo.getId().toString(), cmpItemInfo);
                }
                int seqSize = seqList.size();
                for (i = 0; i < seqSize; ++i) {
                    cmpItemInfo = (CmpItemInfo)seqHelperMap.get(seqList.get(i).toString());
                    if (cmpItemInfo == null || cmpItemInfo.getHrOrgUnit() == null) continue;
                    this.lstSelectItem.addElement((Object)cmpItemInfo);
                    this.lstAllItem.removeElement((Object)cmpItemInfo);
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            this.cbZeroToNull.setSelected(cp.getBoolean("cbZeroToNull"));
        }
        this.setSelectItemMap();
    }

    public boolean isZeroToNull() {
        return this.cbZeroToNull.isSelected();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        if (cp == null) {
            cp = new CustomerParams();
        }
        if (this.prmtBeginPeriod.getData() != null) {
            cp.addCustomerParam("prmtCmpBeginPeriod", ((CmpPeriodInfo)this.prmtBeginPeriod.getData()).getId().toString());
        }
        if (this.prmtEndPeriod.getData() != null) {
            cp.addCustomerParam("prmtCmpEndPeriod", ((CmpPeriodInfo)this.prmtEndPeriod.getData()).getId().toString());
        }
        int controlInt = 0;
        StringBuffer selectListArray = new StringBuffer();
        int selectListtemSize = this.lstSelectItem.getElementCount();
        controlInt = selectListtemSize - 1;
        for (int i = 0; i < selectListtemSize; ++i) {
            CmpItemInfo cmpItemInfo = (CmpItemInfo)this.lstSelectItem.getElement(i);
            selectListArray.append(cmpItemInfo.getId().toString());
            if (i == controlInt) continue;
            selectListArray.append("@");
        }
        cp.addCustomerParam("selectListItem", selectListArray.toString());
        cp.putBoolean("cbZeroToNull", this.cbZeroToNull.isSelected());
        cp.putBoolean("includeChild", this.chkIncluedeChild.isSelected());
        if (this.chkIncluedeChild.isSelected()) {
            cp.addCustomerParam("childLevel", this.cboChildLevel.getSelectedItem().toString());
        }
        return cp;
    }

    @Override
    protected void prmtHROrg_dataChanged(DataChangeEvent e) throws Exception {
        this.cmpItemMap.clear();
        if (this.prmtHROrg.getData() != null) {
            this.chkIncluedeChild.setEnabled(true);
            HRUtils.setComboBoxLevel(e, this.cboChildLevel);
            if (!this.chkIncluedeChild.isSelected()) {
                this.cboChildLevel.setSelectedItem(null);
            }
            if (this.cboChildLevel.getItemCount() == 0) {
                this.chkIncluedeChild.setEnabled(false);
            }
        } else {
            this.chkIncluedeChild.setEnabled(false);
            this.chkIncluedeChild.setSelected(false);
            this.cboChildLevel.removeAllItems();
            this.lstAllItem.removeAllElements();
            this.lstSelectItem.removeAllElements();
            this.firstLoad = true;
        }
        this.getCmpItemCollection();
        this.onLoadAllList();
    }

    @Override
    protected void chkIncluedeChild_stateChanged(ChangeEvent e) throws Exception {
        this.cmpItemMap.clear();
        if (this.chkIncluedeChild.isSelected()) {
            this.cboChildLevel.setEnabled(true);
            if (this.cboChildLevel.getSelectedItem() != null) {
                this.cboChildLevel.setSelectedIndex(0);
            }
            this.getCmpItemCollection();
            this.onLoadAllList();
        } else {
            this.cboChildLevel.setEnabled(false);
            this.cboChildLevel.setSelectedItem(null);
        }
    }

    @Override
    protected void cboChildLevel_itemStateChanged(ItemEvent e) throws Exception {
        this.cmpItemMap.clear();
        super.cboChildLevel_itemStateChanged(e);
        if (this.cboChildLevel.getSelectedItem() != null) {
            this.getCmpItemCollection();
            this.onLoadAllList();
        }
    }

    private void setHrEidtor() {
        Object iProducer = null;
        NewHROF7 model = null;
        model = new NewHROF7();
        model.setShowVirtual(true);
        this.prmtHROrg.setSelector((KDPromptSelector)model);
        this.prmtHROrg.setCommitFormat("$number$;$code$");
        this.prmtHROrg.setEditFormat("$number$");
        this.prmtHROrg.setDisplayFormat("$name$");
        this.prmtHROrg.setEnabledMultiSelection(false);
    }

    public boolean isSupportVirturalOrgs() {
        return true;
    }

    private String getHROrgUnitCollectionForFirstLoad() throws BOSException {
        HROrgUnitInfo hrOrgUnitInfo = HRSchemeUtils.getClientHROrgUnitInfo();
        if (hrOrgUnitInfo == null) {
            return null;
        }
        String oql = "SELECT fid WHERE isBizUnit='1' and longNumber like '" + hrOrgUnitInfo.getLongNumber() + "!%'";
        IHROrgUnit iHrOrgUnit = HROrgUnitFactory.getRemoteInstance();
        HROrgUnitCollection hrOrgColl = iHrOrgUnit.getHROrgUnitCollection(oql);
        StringBuffer strb = new StringBuffer("");
        int j = hrOrgColl.size();
        for (int i = 0; i < j; ++i) {
            if ("".equals(strb.toString())) {
                strb.append(hrOrgColl.get(i).getId().toString());
                continue;
            }
            strb.append("," + hrOrgColl.get(i).getId().toString());
        }
        return strb.toString();
    }

    protected HROrgUnitInfo getPrmtHROData() {
        if (this.prmtHROrg.getData() != null) {
            return (HROrgUnitInfo)this.prmtHROrg.getData();
        }
        return null;
    }

    protected boolean isIncludeChild() {
        return this.chkIncluedeChild.isSelected();
    }

    protected Object getChildLevel() {
        if (this.cboChildLevel.getSelectedItem() != null) {
            return (Integer)this.cboChildLevel.getSelectedItem();
        }
        return null;
    }
}

