/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpReportFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.MyCmpReportFacadeFactory;
import com.kingdee.eas.hr.compensation.client.AbstractMyCmpReportFilter;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.event.ItemEvent;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class MyCmpReportFilter
extends AbstractMyCmpReportFilter {
    private static final Logger logger = CoreUIObject.getLogger(MyCmpReportFilter.class);
    private String cmpPeriodF7URL = "com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery";
    private String empSumResource = "com.kingdee.eas.hr.compensation.client.EmpSumReportResource.";
    private HROrgUnitInfo hrOrgUnitInfo = null;

    public void clear() {
        super.clear();
        this.prmtBeginCmpPeriod.setData(null);
        this.prmtEndCmpPeriod.setData(null);
        this.chkIsShowDetail.setSelected(false);
        this.chkIsShowTimeDetail.setSelected(false);
        this.txtFromTime.setText(null);
        this.txtToTime.setText(null);
    }

    public void onLoad() throws Exception {
        this.initAllEditor();
        super.onLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private HROrgUnitInfo getHROrgUnit() {
        if (this.hrOrgUnitInfo == null) {
            this.hrOrgUnitInfo = HRSchemeUtils.getClientHROrgUnitInfo();
        }
        return this.hrOrgUnitInfo;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtBeginCmpPeriod.getData() != null) {
            cp.addCustomerParam("prmtBeginCmpPeriod", ((CmpPeriodInfo)this.prmtBeginCmpPeriod.getData()).getId().toString());
        }
        if (this.prmtEndCmpPeriod.getData() != null) {
            cp.addCustomerParam("prmtEndCmpPeriod", ((CmpPeriodInfo)this.prmtEndCmpPeriod.getData()).getId().toString());
        }
        cp.putBoolean("chkIsShowDetail", this.chkIsShowDetail.isSelected());
        cp.putBoolean("chkIsShowTimeDetail", this.chkIsShowTimeDetail.isSelected());
        if (!StringUtils.isEmpty((String)this.txtFromTime.getText())) {
            cp.addCustomerParam("fromTime", Integer.toString(this.txtFromTime.getNumberValue().intValue()));
        }
        if (!StringUtils.isEmpty((String)this.txtToTime.getText())) {
            cp.addCustomerParam("toTime", Integer.toString(this.txtToTime.getNumberValue().intValue()));
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        this.clear();
        ObjectUuidPK pkTemp = null;
        try {
            if (cp.getCustomerParam("prmtBeginCmpPeriod") != null) {
                pkTemp = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("prmtBeginCmpPeriod")));
                this.prmtBeginCmpPeriod.setData((Object)((CmpPeriodInfo)CmpPeriodFactory.getRemoteInstance().getValue((IObjectPK)pkTemp)));
            }
            if (cp.getCustomerParam("prmtEndCmpPeriod") != null) {
                pkTemp = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("prmtEndCmpPeriod")));
                this.prmtEndCmpPeriod.setData((Object)((CmpPeriodInfo)CmpPeriodFactory.getRemoteInstance().getValue((IObjectPK)pkTemp)));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.chkIsShowDetail.setSelected(cp.getBoolean("chkIsShowDetail"));
        this.chkIsShowTimeDetail.setSelected(cp.getBoolean("chkIsShowTimeDetail"));
        this.txtFromTime.setText(cp.getCustomerParam("fromTime"));
        this.txtToTime.setText(cp.getCustomerParam("toTime"));
    }

    private void initAllEditor() throws ParserException, BOSException, SQLException {
        EntityViewInfo eviCmpPeriod = new EntityViewInfo();
        FilterInfo filterInfoCmpPeriod = new FilterInfo();
        filterInfoCmpPeriod.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getHROrgUnit().getId().toString()));
        FilterInfo filter = new FilterInfo("shutMyCmp = 0 or shutMyCmp is null");
        filterInfoCmpPeriod.mergeFilter(filter, "and");
        eviCmpPeriod.setFilter(filterInfoCmpPeriod);
        this.prmtBeginCmpPeriod.setQueryInfo(this.cmpPeriodF7URL);
        this.prmtBeginCmpPeriod.setEditable(false);
        this.prmtBeginCmpPeriod.setEditFormat("$name$");
        this.prmtBeginCmpPeriod.setDisplayFormat("$name$");
        this.prmtBeginCmpPeriod.setHasCUDefaultFilter(false);
        this.prmtBeginCmpPeriod.setEntityViewInfo(eviCmpPeriod);
        this.prmtEndCmpPeriod.setQueryInfo(this.cmpPeriodF7URL);
        this.prmtEndCmpPeriod.setEditable(false);
        this.prmtEndCmpPeriod.setEditFormat("$name$");
        this.prmtEndCmpPeriod.setDisplayFormat("$name$");
        this.prmtEndCmpPeriod.setHasCUDefaultFilter(false);
        this.prmtEndCmpPeriod.setEntityViewInfo(eviCmpPeriod);
    }

    public boolean verify() {
        boolean flagOfDate;
        if (this.prmtBeginCmpPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_CMPPER")));
            return false;
        }
        if (this.prmtEndCmpPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_CMPPER")));
            return false;
        }
        if (!StringUtils.isEmpty((String)this.txtToTime.getText()) && !StringUtils.isEmpty((String)this.txtFromTime.getText())) {
            String endPeriodId;
            int toTime = this.txtToTime.getNumberValue().intValue();
            int fromTime = this.txtFromTime.getNumberValue().intValue();
            String beginPeriodId = ((CmpPeriodInfo)this.prmtBeginCmpPeriod.getData()).getId().toString();
            if (beginPeriodId.equals(endPeriodId = ((CmpPeriodInfo)this.prmtEndCmpPeriod.getData()).getId().toString()) && fromTime > toTime) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"364_EmployeeToTalFilterUI"));
                this.txtFromTime.requestFocusInWindow();
                return false;
            }
        }
        if (!StringUtils.isEmpty((String)this.txtFromTime.getText()) && this.txtFromTime.getNumberValue().intValue() < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "FROMTIME_NEED_GREATER_THAN_ZERO")));
            return false;
        }
        if (!StringUtils.isEmpty((String)this.txtToTime.getText()) && this.txtToTime.getNumberValue().intValue() < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "TOTIME_NEED_GREATER_THAN_ZERO")));
            return false;
        }
        CmpPeriodInfo cmpPeriodInfoBegin = (CmpPeriodInfo)this.prmtBeginCmpPeriod.getData();
        CmpPeriodInfo cmpPeriodInfoEnd = (CmpPeriodInfo)this.prmtEndCmpPeriod.getData();
        if (!cmpPeriodInfoBegin.getId().toString().equals(cmpPeriodInfoEnd.getId().toString()) && !(flagOfDate = DateTimeUtils.dayAfter((Date)cmpPeriodInfoEnd.getBeginDate(), (Date)cmpPeriodInfoBegin.getEndDate()))) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpAdjustiveSchResource.BEGINDATE_AFTER_ENDDATE"));
            this.prmtBeginCmpPeriod.requestFocusInWindow();
            return false;
        }
        if (this.chkIsShowDetail.isSelected() && this.chkIsShowTimeDetail.isSelected()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"365_EmployeeToTalFilterUI"));
            return false;
        }
        return true;
    }

    public CmpPeriodCollection getCmpPeriodCollection() throws Exception {
        CmpPeriodCollection col = null;
        Date beginDate = ((CmpPeriodInfo)this.prmtBeginCmpPeriod.getData()).getBeginDate();
        Date endDate = ((CmpPeriodInfo)this.prmtEndCmpPeriod.getData()).getEndDate();
        ICmpPeriod iCmpPeriod = CmpPeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo infoFilter = new FilterInfo();
        infoFilter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        infoFilter.getFilterItems().add(new FilterItemInfo("endDate", (Object)endDate, CompareType.LESS_EQUALS));
        infoFilter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getHROrgUnit().getId().toString()));
        infoFilter.getFilterItems().add(new FilterItemInfo("shutMyCmp = 0"));
        infoFilter.getFilterItems().add(new FilterItemInfo("shutMyCmp is null"));
        infoFilter.setMaskString("#0 and #1 and #2 and (#3 or #4)");
        evi.setFilter(infoFilter);
        evi.getSorter().add(new SorterItemInfo("beginDate"));
        col = iCmpPeriod.getCmpPeriodCollection(evi);
        return col;
    }

    private List getCmpSchemeByUserId() throws BOSException, SQLException {
        String fname = "fname_" + SysContext.getSysContext().getLocale().getLanguage();
        ArrayList<CmpSchemeInfo> cmpList = new ArrayList<CmpSchemeInfo>();
        if (SysContext.getSysContext().getCurrentUserInfo().getPerson() != null) {
            String personId = SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString();
            Date beginDate = ((CmpPeriodInfo)this.prmtBeginCmpPeriod.getData()).getBeginDate();
            Date endDate = ((CmpPeriodInfo)this.prmtEndCmpPeriod.getData()).getEndDate();
            GregorianCalendar beginCal = new GregorianCalendar();
            beginCal.setTime(beginDate);
            GregorianCalendar endCal = new GregorianCalendar();
            endCal.setTime(endDate);
            SimpleDateFormat sdf = new SimpleDateFormat("{yyyy-MM-dd HH:mm:ss}");
            String beginDateStr = sdf.format(beginCal.getTime());
            String sql = "SELECT cmpScheme.fid,cmpScheme." + fname + ",cmpScheme.FNumber from T_HR_CmpScheme cmpScheme inner join t_hr_cmpperiod cp on cmpScheme.fcmpperiod = cp.fid inner join t_hr_cmpschemeitem item on item.fcmpschemeid = cmpScheme.fid WHERE cmpScheme.FId IN (SELECT FCmpSchemeID FROM T_HR_CmpSchemePerson WHERE FPersonId = '" + personId + "') and cp.fbegindate >= " + beginDateStr + "and item.fisvisible = 1 group by cmpScheme.fid,cmpScheme." + fname + ", cmpScheme.FNumber having count(item.fid)>=1";
            IRowSet rs = null;
            ISQLExecutor exector = SQLExecutorFactory.getRemoteInstance((String)sql);
            rs = exector.executeSQL();
            while (rs.next()) {
                CmpSchemeInfo schemeInfo = new CmpSchemeInfo();
                schemeInfo.setId(BOSUuid.read((String)rs.getString(1)));
                schemeInfo.setName(rs.getString(2));
                schemeInfo.setNumber(rs.getString(3));
                cmpList.add(schemeInfo);
            }
        }
        return cmpList;
    }

    public AdminOrgUnitCollection getAdminOrgUnitCollection() throws BOSException, SQLException {
        String fname = "fname_" + SysContext.getSysContext().getLocale().getLanguage();
        AdminOrgUnitCollection adminOrgCol = new AdminOrgUnitCollection();
        if (SysContext.getSysContext().getCurrentUserInfo().getPerson() != null) {
            String personId = SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString();
            String sql = "SELECT FId, " + fname + ", FNumber FROM T_ORG_Admin WHERE FId IN (SELECT FAdminOrgUnitId FROM T_HR_CmpSchemePerson csp WHERE FPersonId = '" + personId + "')";
            IRowSet rs = null;
            ISQLExecutor exector = SQLExecutorFactory.getRemoteInstance((String)sql);
            rs = exector.executeSQL();
            while (rs.next()) {
                AdminOrgUnitInfo admin = new AdminOrgUnitInfo();
                admin.setId(BOSUuid.read((String)rs.getString(1)));
                admin.setName(rs.getString(2));
                admin.setNumber(rs.getString(3));
                adminOrgCol.add(admin);
            }
        }
        return adminOrgCol;
    }

    public List getInfoCmpSchemeList() throws BOSException, SQLException {
        List cmpList = this.getCmpSchemeByUserId();
        return cmpList;
    }

    public List getAllSchemePerItems(List lstCmpSchemeInfo) throws BOSException, SQLException, EASBizException {
        List cmpList = lstCmpSchemeInfo;
        if (cmpList.size() < 0) {
            return new ArrayList();
        }
        ArrayList<String> lstSchemeIds = new ArrayList<String>();
        int size = cmpList.size();
        for (int i = 0; i < size; ++i) {
            lstSchemeIds.add(((CmpSchemeInfo)cmpList.get(i)).getId().toString());
        }
        List lst = new ArrayList();
        lst = CmpReportFacadeFactory.getRemoteInstance().getAllPerItemsBySchemes(lstSchemeIds);
        return lst;
    }

    public HashMap getAllSchemeItems(List lstCmpSchemeInfo) throws BOSException, SQLException, EASBizException {
        HashMap allMap = new HashMap();
        List cmpList = lstCmpSchemeInfo;
        if (cmpList.size() < 0) {
            return allMap;
        }
        ArrayList<String> lstSchemeIds = new ArrayList<String>();
        int size = cmpList.size();
        for (int i = 0; i < size; ++i) {
            lstSchemeIds.add(((CmpSchemeInfo)cmpList.get(i)).getId().toString());
        }
        allMap = MyCmpReportFacadeFactory.getRemoteInstance().getAllItemsByScheme(lstSchemeIds);
        return allMap;
    }

    @Override
    protected void chkIsShowDetail_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIsShowDetail_itemStateChanged(e);
        if (this.chkIsShowDetail.isSelected()) {
            this.chkIsShowTimeDetail.setSelected(false);
        }
    }

    @Override
    protected void chkIsShowTimeDetail_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIsShowTimeDetail_itemStateChanged(e);
        if (this.chkIsShowTimeDetail.isSelected()) {
            this.chkIsShowDetail.setSelected(false);
        }
    }
}

