/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.client.AbstractPersonCmpItemFilterUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PersonCmpItemFilterUI
extends AbstractPersonCmpItemFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonCmpItemFilterUI.class);
    private IRowSet allPersonItemRows = null;
    private ArrayList personMappingItem = null;
    private List hasSaveItem = null;
    private static String[] takeOffPerItem = new String[]{"FPER035", "FPER025", "FPER026", "FPER027", "FPER044", "FPER054", "FPER055", "FPER056", "FPER057", "FPER058"};

    public void onLoad() throws Exception {
        super.onLoad();
        this.initWorkButton();
        this.fillSelectList(null);
    }

    public void clear() {
        try {
            this.fillSelectList(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void actionLeft_actionPerformed(ActionEvent e) throws Exception {
        if (this.lstSelectItem.getElementCount() <= 0) {
            return;
        }
        int index = this.lstSelectItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            if (HRSchemeUtils.isNecessaryPersonCmpItem(info)) {
                return;
            }
            this.lstSelectItem.removeElement((Object)info);
            this.lstAllItem.addElement((Object)info);
            this.lstAllItem.setSelectedValue((Object)info, true);
            if (this.lstSelectItem.getElementCount() > 0) {
                this.lstSelectItem.setSelectedIndex(index - 1);
            }
        }
    }

    @Override
    public void actionAllLeft_actionPerformed(ActionEvent e) throws Exception {
        int count = this.lstSelectItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < this.lstSelectItem.getElementCount(); ++i) {
                info = (CmpItemInfo)this.lstSelectItem.getElement(i);
                if (HRSchemeUtils.isNecessaryPersonCmpItem(info)) continue;
                this.lstAllItem.addElement((Object)info);
                this.lstSelectItem.removeElement((Object)info);
                --i;
            }
            this.lstAllItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionAllRight_actionPerformed(ActionEvent e) throws Exception {
        int count = this.lstAllItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstAllItem.getElement(0);
                this.lstSelectItem.addElement((Object)info);
                this.lstAllItem.removeElement((Object)info);
            }
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionRight_actionPerformed(ActionEvent e) throws Exception {
        if (this.lstAllItem.getElementCount() <= 0) {
            return;
        }
        int index = this.lstAllItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstAllItem.getElement(index);
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            this.lstSelectItem.insertElement((Object)info, indexSelect);
            this.lstAllItem.removeElement((Object)info);
            if (index - 1 > 0) {
                this.lstAllItem.setSelectedIndex(index - 1);
            } else if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
            this.lstSelectItem.setSelectedValue((Object)info, true);
        }
    }

    @Override
    protected void lstAllItem_mouseClicked(MouseEvent e) throws Exception {
        int index;
        if (e.getClickCount() == 2 && (index = this.lstAllItem.getSelectedIndex()) >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstAllItem.getElement(index);
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            this.lstSelectItem.insertElement((Object)info, indexSelect);
            this.lstAllItem.removeElement((Object)info);
            if (index - 1 > 0) {
                this.lstAllItem.setSelectedIndex(index - 1);
            } else if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
            this.lstSelectItem.setSelectedValue((Object)info, true);
        }
    }

    @Override
    protected void lstSelectItem_mouseClicked(MouseEvent e) throws Exception {
        int index;
        if (e.getClickCount() == 2 && (index = this.lstSelectItem.getSelectedIndex()) >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            if (HRSchemeUtils.isNecessaryPersonCmpItem(info)) {
                return;
            }
            this.lstSelectItem.removeElement((Object)info);
            this.lstAllItem.addElement((Object)info);
            this.lstAllItem.setSelectedValue((Object)info, true);
            if (this.lstSelectItem.getElementCount() > 0) {
                this.lstSelectItem.setSelectedIndex(index - 1);
            }
        }
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, 0);
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionMovePre_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, index - 1);
            this.lstSelectItem.setSelectedIndex(index - 1);
        }
    }

    @Override
    public void actionMoveNext_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, index + 1);
            this.lstSelectItem.setSelectedIndex(index + 1);
        }
    }

    @Override
    public void actionMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, count - 1);
            this.lstSelectItem.setSelectedIndex(count - 1);
        }
    }

    @Override
    public String getUIHandlerClassName() {
        return null;
    }

    protected void initWorkButton() {
        try {
            this.initListControl();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void setCustomerParams(CustomerParams param) {
        super.setCustomerParams(param);
        try {
            this.fillSelectList(param);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        int count = this.lstSelectItem.getElementCount();
        if (this.lstSelectItem.getElementCount() == 0) {
            return params;
        }
        params.putInt("SelectCount", count);
        CmpItemInfo cmpItemInfo = null;
        for (int i = 0; i < count; ++i) {
            cmpItemInfo = (CmpItemInfo)this.lstSelectItem.getElement(i);
            params.addCustomerParam("SelectCount" + i, cmpItemInfo.getNumber());
        }
        return params;
    }

    private void fillSelectList(CustomerParams params) throws Exception {
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        if (this.allPersonItemRows == null) {
            this.initListControl();
        }
        this.allPersonItemRows.beforeFirst();
        CmpItemInfo cmpItemInfo = null;
        Map defaultSelectMap = this.getDefaultSelectMap(params);
        HashMap<Integer, CmpItemInfo> tempMap = new HashMap<Integer, CmpItemInfo>();
        this.hasSaveItem = new ArrayList();
        while (this.allPersonItemRows.next()) {
            cmpItemInfo = new CmpItemInfo();
            cmpItemInfo.setId(BOSUuid.read((String)this.allPersonItemRows.getString("id")));
            cmpItemInfo.setNumber(this.allPersonItemRows.getString("number"));
            cmpItemInfo.setName(this.allPersonItemRows.getString("name"));
            cmpItemInfo.setDataType(ItemDataTypeEnum.getEnum(this.allPersonItemRows.getInt("dataType")));
            cmpItemInfo.setDecDigital(this.allPersonItemRows.getInt("decDigital"));
            if (defaultSelectMap.containsKey(cmpItemInfo.getNumber())) {
                Integer index = (Integer)defaultSelectMap.get(cmpItemInfo.getNumber());
                tempMap.put(index, cmpItemInfo);
                this.hasSaveItem.add(cmpItemInfo);
                continue;
            }
            this.lstAllItem.addElement((Object)cmpItemInfo);
        }
        ArrayList keyList = new ArrayList(tempMap.keySet());
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            this.lstSelectItem.addElement(tempMap.get(keyList.get(i)));
        }
    }

    private Map getDefaultSelectMap(CustomerParams params) throws Exception {
        HashMap<String, Integer> defaultSelectMap = new HashMap<String, Integer>();
        if (params == null || params.getInt("SelectCount") == 0) {
            defaultSelectMap.put("FPER001", 0);
            defaultSelectMap.put("FPER002", 1);
            defaultSelectMap.put("FPER006", 2);
            defaultSelectMap.put("FPER005", 3);
            defaultSelectMap.put("FPER024", 4);
            defaultSelectMap.put("FPER029", 5);
            defaultSelectMap.put("FPER023", 6);
            return defaultSelectMap;
        }
        int selectCount = params.getInt("SelectCount");
        for (int i = 0; i < selectCount; ++i) {
            defaultSelectMap.put(params.getCustomerParam("SelectCount" + i), i);
        }
        return defaultSelectMap;
    }

    private void initListControl() throws Exception {
        HashSet set = new HashSet();
        if (this.personMappingItem != null) {
            set.addAll(this.personMappingItem);
        }
        HashSet<String> itemSet = new HashSet<String>();
        itemSet.addAll(Arrays.asList(takeOffPerItem));
        String hroId = HRSchemeUtils.getClientHROrgUnitInfo().getId().toString();
        String sql = "SELECT FID FROM T_HR_CMPITEMCAT WHERE FNUMBER = 'FPER' AND FHRORGUNITID = '";
        sql = sql + hroId + "'";
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.CmpItemQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("cmpItemCatalog.id", (Object)sql, CompareType.INNER));
        fi.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        fi.getFilterItems().add(new FilterItemInfo("number", itemSet, CompareType.NOTINCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("subject", (Object)10));
        if (set != null && set.size() != 0) {
            fi.getFilterItems().add(new FilterItemInfo("subject", (Object)10, CompareType.NOTEQUALS));
            fi.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
            fi.setMaskString("#0 and #1 and #2 and (#3 or (#4 and #5))");
        } else {
            fi.setMaskString("#0 and #1 and #2 and #3");
        }
        viewInfo.setFilter(fi);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("defaultOrder");
        sorterOrderItem.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterOrderItem);
        SorterItemInfo sorterOrderItem1 = new SorterItemInfo("enable");
        sorterOrderItem1.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorterOrderItem1);
        queryExcu.setObjectView(viewInfo);
        this.allPersonItemRows = queryExcu.executeQuery();
    }

    public List getSelectedCmpItem() {
        ArrayList<Object> selectCmpItemList = new ArrayList<Object>();
        for (int i = 0; i < this.lstSelectItem.getElementCount(); ++i) {
            if (selectCmpItemList.contains(this.lstSelectItem.getElement(i))) continue;
            selectCmpItemList.add(this.lstSelectItem.getElement(i));
        }
        return selectCmpItemList;
    }

    public List getHasSavePerItem() {
        return this.hasSaveItem;
    }
}

