/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.CmpSystemConfigCollection;
import com.kingdee.eas.hr.base.CmpSystemConfigFactory;
import com.kingdee.eas.hr.compensation.EmpCmpSchmFacadeFactory;
import com.kingdee.eas.hr.compensation.IEmpCmpSchmFacade;
import com.kingdee.eas.hr.compensation.ISalariatHiberProps;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsFactory;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.hr.compensation.client.AbstractSalariatPointF7UI;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Map;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class SalariatPointF7UI
extends AbstractSalariatPointF7UI {
    private static Logger logger = Logger.getLogger(SalariatPointF7UI.class);
    private static final int COLUMN_ID = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_DES = 2;
    private String schemeID = null;
    private String personID = null;
    private ISalariatHiberProps iBiz = null;
    private SalariatHiberPropsCollection hiberCollection = null;
    private SalariatHiberPropsInfo rootInfo = null;
    private DefaultKingdeeTreeNode rootNode = null;
    private DefaultKingdeeTreeNode nowSelectNode = null;
    private boolean isCanceled = true;
    private SalariatHiberPropsInfo pointInfo = null;
    protected boolean isSingleSelect = true;
    private SalariatHiberPropsCollection pointCol = new SalariatHiberPropsCollection();

    public SalariatPointF7UI() throws Exception {
        this.jbInit();
    }

    protected JButton getDefaultButton() {
        return this.btnComfirm;
    }

    private void jbInit() {
        this.kdMainTbl.checkParsed();
        this.kdMainTbl.getColumn(2).getStyleAttributes().setLocked(true);
        this.kdMainTbl.getColumn(1).getStyleAttributes().setLocked(true);
        this.rootNode = new DefaultKingdeeTreeNode((Object)this.getRootInfo());
    }

    private ISalariatHiberProps getBizInterface() {
        if (this.iBiz == null) {
            try {
                this.iBiz = SalariatHiberPropsFactory.getRemoteInstance();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        return this.iBiz;
    }

    public SalariatHiberPropsCollection getHiberCollection() {
        return this.hiberCollection;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("IsSingleSelect") != null && this.getUIContext().get("IsSingleSelect") instanceof Boolean) {
            this.isSingleSelect = (Boolean)this.getUIContext().get("IsSingleSelect");
        }
        if (!this.isSingleSelect) {
            this.kdMainTbl.getSelectManager().setSelectMode(10);
        } else {
            this.kdMainTbl.getSelectManager().setSelectMode(2);
        }
        this.schemeID = (String)this.getUIContext().get("schemeID");
        this.personID = (String)this.getUIContext().get("FPersonID");
        this.hiberCollection = this.getTreeData();
        this.buildCatalogTree();
        InputMap inputMap = this.kdMainTbl.getInputMap(1);
        inputMap.remove(KeyStroke.getKeyStroke(10, 0));
    }

    private void buildCatalogTree() throws Exception {
        this.kdMainTree = new KDTree((ITreeNode)this.rootNode);
        this.kdMainTree.setShowCheckBox(false);
        this.kdMainTree.setRootVisible(true);
        this.kdMainTree.getSelectionModel().setSelectionMode(1);
        this.kdMainTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    SalariatPointF7UI.this.treeMain_valueChanged(e);
                }
                catch (Exception exc) {
                    SalariatPointF7UI.this.handUIException(exc);
                }
            }
        });
        this.rootNode.removeAllChildren();
        SalariatHiberPropsCollection cataloges = this.getCatalogData();
        DefaultKingdeeTreeNode itemNode = null;
        SalariatHiberPropsInfo item = null;
        for (int i = 0; i < cataloges.size(); ++i) {
            item = cataloges.get(i);
            this.getPointsByCatalog(item);
            itemNode = new DefaultKingdeeTreeNode((Object)item);
            this.rootNode.add((MutableTreeNode)itemNode);
        }
        this.kdMainTree.revalidate();
        this.kdMainTree.repaint();
        this.kdMainTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)this.rootNode));
        this.kdTreeView.setTree(this.kdMainTree);
        if (this.rootNode.getChildCount() > 0) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)this.rootNode.getChildAt(0);
            TreePath path = new TreePath(childNode.getPath());
            this.kdMainTree.expandPath(path);
            this.kdMainTree.setSelectionPath(path);
        }
    }

    private SalariatHiberPropsInfo getRootInfo() {
        if (this.rootInfo == null) {
            this.rootInfo = new SalariatHiberPropsInfo();
            this.rootInfo.setNumber("ROOT");
            this.rootInfo.setName(HRUtils.getSalariatResourceStr("HIBER_TREEROOT"));
            this.rootInfo.setLevel(-1);
        }
        return this.rootInfo;
    }

    private SalariatHiberPropsCollection getCatalogData() {
        SalariatHiberPropsCollection sons = new SalariatHiberPropsCollection();
        for (int i = 0; i < this.hiberCollection.size(); ++i) {
            SalariatHiberPropsInfo info = this.hiberCollection.get(i);
            if (info.getParent() != null) continue;
            sons.add(info);
        }
        return sons;
    }

    private void getPointsByCatalog(SalariatHiberPropsInfo catalog) {
        for (int i = 0; i < this.hiberCollection.size(); ++i) {
            SalariatHiberPropsInfo info = this.hiberCollection.get(i);
            if (info.getParent() == null || !info.getParent().getId().equals((Object)catalog.getId())) continue;
            catalog.getSubHibersCollection().add(info);
        }
    }

    private SalariatHiberPropsCollection getTreeData() throws Exception {
        SalariatHiberPropsCollection collection = new SalariatHiberPropsCollection();
        Map map = null;
        if (this.schemeID != null && this.personID != null) {
            IEmpCmpSchmFacade iEmpCmpSchmFacade = EmpCmpSchmFacadeFactory.getRemoteInstance();
            map = iEmpCmpSchmFacade.getEmpSalariatPointRange(this.schemeID, this.personID, null);
        }
        String strCurHrOrgUnitId = null;
        if (SysContext.getSysContext() != null && SysContext.getSysContext().getCurrentHRUnit() != null) {
            strCurHrOrgUnitId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        }
        if (this.personID != null) {
            CmpSystemConfigCollection cmpSysConfigCol = new CmpSystemConfigCollection();
            if (strCurHrOrgUnitId != null) {
                String oql = "select isShowNoneOfSalaryPoint where hrOrgUnit.id = '" + strCurHrOrgUnitId + "'";
                cmpSysConfigCol = CmpSystemConfigFactory.getRemoteInstance().getCmpSystemConfigCollection(oql);
            }
            if (cmpSysConfigCol.size() > 0 && cmpSysConfigCol.get(0).isIsShowNoneOfSalaryPoint() && (map == null || map.size() <= 0)) {
                return collection;
            }
        }
        if (this.schemeID != null) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = view.getSelector();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("description"));
            selector.add(new SelectorItemInfo("isLeaf"));
            selector.add(new SelectorItemInfo("level"));
            selector.add(new SelectorItemInfo("scheme.id"));
            selector.add(new SelectorItemInfo("scheme.name"));
            selector.add(new SelectorItemInfo("scheme.number"));
            selector.add(new SelectorItemInfo("parent.id"));
            selector.add(new SelectorItemInfo("parent.name"));
            selector.add(new SelectorItemInfo("parent.number"));
            selector.add(new SelectorItemInfo("parent.isLeaf"));
            selector.add(new SelectorItemInfo("parent.level"));
            FilterInfo filterInfoItem = new FilterInfo();
            filterInfoItem.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)this.schemeID));
            String sql = (String)this.getUIContext().get("FsalPointSalGradeID");
            if (sql != null) {
                filterInfoItem.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
                filterInfoItem.getFilterItems().add(new FilterItemInfo("parent.id", null));
                filterInfoItem.setMaskString(" #0 and (#1 or #2)  ");
            }
            if (map != null && !map.isEmpty()) {
                HashSet<String> set = new HashSet<String>();
                Object[] objIDs = map.keySet().toArray();
                if (objIDs != null) {
                    int size = objIDs.length;
                    for (int i = 0; i < size; ++i) {
                        if (objIDs[i] == null) continue;
                        set.add(objIDs[i].toString());
                    }
                }
                filterInfoItem.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
                filterInfoItem.getFilterItems().add(new FilterItemInfo("parent.id", null));
                filterInfoItem.setMaskString(" #0 and (#1 or #2)  ");
            }
            view.setFilter(filterInfoItem);
            SorterItemCollection sortCollectiom = view.getSorter();
            sortCollectiom.add(new SorterItemInfo("parent.name"));
            sortCollectiom.add(new SorterItemInfo("name"));
            collection = this.getBizInterface().getSalariatHiberPropsCollection(view);
        }
        return collection;
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        DefaultKingdeeTreeNode node = HRUtils.getSelectTreeNode(this.kdMainTree);
        if (node == null || node.equals(this.rootNode) || node.equals(this.nowSelectNode)) {
            return;
        }
        Object obj = node.getUserObject();
        if (obj == null || !(obj instanceof SalariatHiberPropsInfo)) {
            return;
        }
        SalariatHiberPropsInfo catalogInfo = (SalariatHiberPropsInfo)obj;
        SalariatHiberPropsCollection pointList = catalogInfo.getSubHibersCollection();
        this.nowSelectNode = node;
        this.kdMainTbl.removeRows();
        SalariatHiberPropsInfo pointInfo = null;
        int n = pointList.size();
        for (int i = 0; i < n; ++i) {
            pointInfo = pointList.get(i);
            IRow row = this.kdMainTbl.addRow();
            row.getCell(0).setValue((Object)pointInfo.getId());
            row.getCell(2).setValue((Object)pointInfo.getDescription());
            row.getCell(1).setValue((Object)pointInfo.getName());
            row.setUserObject((Object)pointInfo);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    @Override
    protected void btnComfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnComfirm_actionPerformed(e);
        int activeIndex = this.kdMainTbl.getSelectManager().getActiveRowIndex();
        if (activeIndex >= 0) {
            if (!this.isSingleSelect) {
                int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.kdMainTbl);
                SalariatHiberPropsInfo salInfo = null;
                for (int i = 0; i < rowID.length; ++i) {
                    salInfo = (SalariatHiberPropsInfo)this.kdMainTbl.getRow(rowID[i]).getUserObject();
                    this.pointCol.add(salInfo);
                }
            } else {
                IRow row = this.kdMainTbl.getRow(activeIndex);
                this.pointInfo = (SalariatHiberPropsInfo)row.getUserObject();
            }
            this.isCanceled = false;
            this.getUIWindow().close();
        } else {
            MsgBox.showWarning((String)HRUtils.getSalariatResourceStr("MISS_SELECT_POINT"));
        }
    }

    @Override
    protected void kdMainTbl_tableClicked(KDTMouseEvent e) throws Exception {
        super.kdMainTbl_tableClicked(e);
        if (e.getClickCount() == 2) {
            int activeIndex = this.kdMainTbl.getSelectManager().getActiveRowIndex();
            if (activeIndex >= 0) {
                IRow row = this.kdMainTbl.getRow(activeIndex);
                this.pointInfo = (SalariatHiberPropsInfo)row.getUserObject();
                if (!this.isSingleSelect) {
                    this.pointCol.add(this.pointInfo);
                }
                this.isCanceled = false;
                this.getUIWindow().close();
            } else {
                MsgBox.showWarning((String)HRUtils.getSalariatResourceStr("MISS_SELECT_POINT"));
            }
        }
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public SalariatHiberPropsInfo getPointInfo() {
        if (this.pointInfo != null) {
            this.pointInfo.setSimpleName(this.pointInfo.toString());
        }
        return this.pointInfo;
    }

    public SalariatHiberPropsCollection getPointCol() {
        return this.pointCol;
    }

    public void setCanceled(boolean b) {
        this.isCanceled = b;
    }

    public void setPointInfo(SalariatHiberPropsInfo info) {
        this.pointInfo = info;
    }
}

