/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.compensation.ISalariatScheme;
import com.kingdee.eas.hr.compensation.SalariatException;
import com.kingdee.eas.hr.compensation.SalariatSchemeFactory;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.client.AbstractSalariatSchBasePropsUI;
import org.apache.log4j.Logger;

public class SalariatSchBasePropsUI
extends AbstractSalariatSchBasePropsUI {
    private static Logger logger = Logger.getLogger(SalariatSchBasePropsUI.class);
    private SalariatSchemeInfo baseInfo = null;
    private ISalariatScheme iBiz = null;
    private String oldNumber = null;

    public SalariatSchBasePropsUI() throws Exception {
        this.jbInit();
    }

    private void jbInit() {
        this.kdBizCurr.setEditable(true);
        this.kdBizCurr.setEditFormat("$number$");
        this.kdBizCurr.setDisplayFormat("$name$");
        this.kdBizCurr.setCommitFormat("$number$");
        this.kdBizCurr.setQueryInfo("com.kingdee.eas.hr.compensation.app.SalariatSchAllCurrencyQuery");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isoCode"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("precision"));
        this.kdBizCurr.setSelectorCollection(sic);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.baseInfo == null) {
            return;
        }
        this.oldNumber = this.baseInfo.getNumber();
        this.txtNumber.setText(this.oldNumber);
        this.txtName.setText(this.baseInfo.getName());
        this.kdBizCurr.setValue((Object)this.baseInfo.getCurrency());
        this.kdBizCreator.setValue((Object)this.baseInfo.getCreator());
        this.txtDescription.setText(this.baseInfo.getDescription());
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.baseInfo.setNumber(this.txtNumber.getText());
        this.baseInfo.setName(this.txtName.getText());
        this.baseInfo.setCurrency((CurrencyInfo)this.kdBizCurr.getValue());
        this.baseInfo.setDescription(this.txtDescription.getText());
    }

    public boolean verifyDataNew() throws Exception {
        String newNumber = this.txtNumber.getText();
        if (newNumber == null || newNumber.trim().length() == 0) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.NULL_NUMBER)));
            this.txtNumber.requestFocus();
            return false;
        }
        if (!newNumber.equals(this.oldNumber) && this.getBizInterface().existNumber(this.txtNumber.getText())) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.MULTI_NUMBER)));
            this.txtNumber.requestFocus();
            return false;
        }
        String newName = this.txtName.getText();
        if (newName == null || newName.trim().length() == 0) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.NULL_NAME)));
            this.txtName.requestFocus();
            return false;
        }
        Object curr = this.kdBizCurr.getValue();
        if (curr == null) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.NULL_SCHEME_CURR)));
            this.kdBizCurr.requestFocus();
            return false;
        }
        return true;
    }

    public void onLoad() throws Exception {
        SysContext ctx = SysContext.getSysContext();
        UserInfo curUser = (UserInfo)ctx.getProperty((Object)"UserInfo");
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.baseInfo = new SalariatSchemeInfo();
            this.baseInfo.setCreator(curUser);
            this.baseInfo.setLastUpdateUser(curUser);
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.baseInfo.setLastUpdateUser(curUser);
        }
        this.setControlState();
        this.loadFields();
    }

    private void setControlState() {
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(true);
            this.txtName.setEnabled(true);
            this.kdBizCurr.setEnabled(true);
            this.txtDescription.setEnabled(true);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(false);
            this.txtName.setEnabled(false);
            this.kdBizCurr.setEnabled(false);
            this.txtDescription.setEnabled(false);
        }
    }

    public SalariatSchemeInfo getBaseInfo() {
        return this.baseInfo;
    }

    public void setBaseInfo(SalariatSchemeInfo info) {
        this.baseInfo = info;
    }

    private ISalariatScheme getBizInterface() {
        if (this.iBiz == null) {
            try {
                this.iBiz = SalariatSchemeFactory.getRemoteInstance();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        return this.iBiz;
    }
}

