/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpOutFunctionFactory;
import com.kingdee.eas.hr.compensation.ICmpOutFunction;
import com.kingdee.eas.hr.compensation.client.AbstractSalarySlipMsgUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class SalarySlipMsgUI
extends AbstractSalarySlipMsgUI {
    private static final Logger logger = CoreUIObject.getLogger(SalarySlipMsgUI.class);
    public static final String sepString = "#";
    public static final String DATA = "msgdata";
    public static final String CMPITEM_DATE = "CmpItem_Data";
    private String resClass = "com.kingdee.eas.hr.compensation.client.SalarySlipResource.";
    public String strName = null;
    public String strSFHJ = null;
    private String strBlank = "     ";
    private List lstData = null;
    private List cmpItemList = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.lstData = (List)this.getUIContext().get(DATA);
        this.cmpItemList = (List)this.getUIContext().get(CMPITEM_DATE);
        this.strName = EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.SalarySlipResource", (String)"9_NAME");
        StringBuffer msg = new StringBuffer();
        msg.append(HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.client.SalarySlipResource", (String)"10_CH", (String[])new String[]{this.strName}));
        msg.append("\n");
        msg.append(this.strBlank);
        msg.append(EASResource.getString((String)(this.resClass + "FIRST")));
        msg.append(this.getItemDataStr());
        msg.append("\n");
        msg.append(this.strBlank);
        msg.append(EASResource.getString((String)(this.resClass + "SECOND")));
        msg.append("\n");
        msg.append(this.strBlank);
        msg.append(EASResource.getString((String)(this.resClass + "THRID")));
        this.txtInfo.setText(msg.toString());
        this.txtInfo.setSelectAllOnFocus(false);
    }

    protected JButton getDefaultButton() {
        return this.btnSend;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionSend_actionPerformed(ActionEvent e) throws Exception {
        super.actionSend_actionPerformed(e);
        HashMap<String, String> mapContent = new HashMap<String, String>();
        SalarySlipInfo info = null;
        String id = null;
        Map dataMap = null;
        Iterator iter = null;
        int size = this.lstData.size();
        for (int i = 0; i < size; ++i) {
            info = (SalarySlipInfo)this.lstData.get(i);
            id = info.getId();
            dataMap = info.getDataMap();
            iter = dataMap.keySet().iterator();
            String key = null;
            String bdTotal = null;
            String content = this.txtInfo.getText();
            while (iter.hasNext()) {
                key = iter.next().toString();
                bdTotal = (String)dataMap.get(key);
                if (bdTotal == null) {
                    bdTotal = "0.00";
                }
                content = content.replaceAll(key, bdTotal.toString());
            }
            content = content.replaceAll(this.strName, info.getName());
            mapContent.put(id, content);
        }
        ICmpOutFunction iCmpOutFunction = CmpOutFunctionFactory.getRemoteInstance();
        iCmpOutFunction.sendSalarySlipMessage(mapContent);
        this.disposeUIWindow();
    }

    private String change(String name, BigDecimal bdTotal) {
        String temp = this.txtInfo.getText();
        if (bdTotal == null) {
            bdTotal = new BigDecimal("0.00");
        }
        temp = temp.replaceAll(name, bdTotal.toString());
        this.txtInfo.setText(temp);
        return temp;
    }

    private String getItemDataStr() {
        if (this.cmpItemList == null || this.cmpItemList.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        CmpItemInfo itemInfo = null;
        for (int i = 0; i < this.cmpItemList.size(); ++i) {
            itemInfo = (CmpItemInfo)this.cmpItemList.get(i);
            sb.append(itemInfo.getName()).append(":").append(sepString).append(itemInfo.getNumber()).append(sepString).append(EASResource.getString((String)(this.resClass + "CURRENCY"))).append(";");
        }
        return sb.toString();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public static class SalarySlipInfo {
        private String id = null;
        private BigDecimal bdTotal = null;
        private String name = null;
        private Map dataMap = null;

        public Map getDataMap() {
            return this.dataMap;
        }

        public void setDataMap(Map dataMap) {
            this.dataMap = dataMap;
        }

        public BigDecimal getBdTotal() {
            return this.bdTotal;
        }

        public void setBdTotal(BigDecimal bdTotal) {
            this.bdTotal = bdTotal;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

