/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpSchemeShrInfo;
import com.kingdee.eas.hr.compensation.VoucherTempShrFacadeFactory;
import com.kingdee.eas.hr.compensation.VoucherTemptShrFactory;
import com.kingdee.eas.hr.compensation.client.AbstractSelectCmpSchemeBatchUI;
import com.kingdee.eas.hr.compensation.exception.HRCompensationBizException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JInternalFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class SelectCmpSchemeBatchUI
extends AbstractSelectCmpSchemeBatchUI {
    private static final Logger logger = CoreUIObject.getLogger(SelectCmpSchemeBatchUI.class);
    Map<String, List<Map>> periodInfoMap = new HashMap<String, List<Map>>();

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.kdrFen.setEnabled(true);
        this.kdrAll.setEnabled(true);
        this.btnOK.setEnabled(true);
        this.btnClose.setEnabled(true);
        this.btnSelectAll.setEnabled(true);
        this.btnSelectInvert.setEnabled(true);
        this.toolBar.setVisible(false);
        Map map = this.getUIContext();
        if (map.get("cmpShrInfo") == null) {
            return;
        }
        Map cmpShrInfo = (Map)map.get("cmpShrInfo");
        if (cmpShrInfo.size() < 1) {
            return;
        }
        this.loadPeriodInfo(cmpShrInfo);
        if (this.cmpPeriod.getSelectedItem() != null) {
            String selectItem = (String)this.cmpPeriod.getSelectedItem();
            this.loadTimeInfo(selectItem);
        }
        this.cmpPeriod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (arg0.getStateChange() == 1) {
                    String selectItem = (String)arg0.getItem();
                    SelectCmpSchemeBatchUI.this.loadTimeInfo(selectItem);
                }
            }
        });
        this.kdrFen.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent stateEvent) {
                Map map = SelectCmpSchemeBatchUI.this.getUIContext();
                Map cmpShrInfo = (Map)map.get("cmpShrInfo");
                try {
                    SelectCmpSchemeBatchUI.this.loadPeriodInfo(cmpShrInfo);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected void loadTimeInfo(String item) {
        this.kDTable1.removeRows();
        this.kDTable1.checkParsed();
        Map map = this.getUIContext();
        String tempId = (String)map.get("tempId");
        List<Map> timeInfo = this.periodInfoMap.get(item);
        if (timeInfo != null && timeInfo.size() > 0) {
            int count = timeInfo.size();
            for (int i = 0; i < count; ++i) {
                IRow row = this.kDTable1.addRow();
                Map detail = timeInfo.get(i);
                row.getCell("temptId").setValue(detail.get("temptId"));
                row.getCell("schemeId").setValue(detail.get("schemeId"));
                row.getCell("voucherTempt").setValue(detail.get("temptName"));
                row.getCell("cmpScheme").setValue(detail.get("schemeName"));
                row.getCell("time").setValue(detail.get("calTime"));
                if (detail.get("bizDate") != null) {
                    row.getCell("bizDate").setValue((Object)detail.get("bizDate").toString().substring(0, 10));
                }
                row.getCell("bookDate").setValue(detail.get("bookDate"));
                row.getCell("businessDate").setValue(detail.get("businessDate"));
                if (detail.get("voucherNumber") != null && detail.get("voucherNumber").toString().length() > 0) {
                    row.getCell("voucherNum").setValue(detail.get("voucherNumber"));
                    row.getCell("select").setValue((Object)false);
                    continue;
                }
                row.getCell("select").setValue((Object)true);
            }
            this.kDTable1.setRowCount(timeInfo.size() + 1);
        }
    }

    protected void loadPeriodInfo(Map<String, String> cmpShrInfo) throws BOSException {
        try {
            boolean isfen = false;
            if (this.kdrFen.isSelected()) {
                isfen = true;
            }
            if (this.periodInfoMap == null || this.periodInfoMap.size() < 1) {
                this.periodInfoMap = this.getCmpSchemePeriodBatch(cmpShrInfo);
            }
            this.cmpPeriod.removeAllItems();
            Set<String> set = this.periodInfoMap.keySet();
            if (set != null && set.size() > 0) {
                Iterator<String> it = set.iterator();
                while (it.hasNext()) {
                    this.cmpPeriod.addItem((Object)it.next().toString());
                }
            }
            int size = this.cmpPeriod.getItemCount();
            for (int i = 0; i < size; ++i) {
                this.cmpPeriod.setSelectedIndex(i);
            }
        }
        catch (HRCompensationBizException e) {
            MsgBox.showInfo((String)e.getMessage());
            SysUtil.abort();
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected Map getCmpSchemePeriodBatch(Map<String, String> cmpShrInfo) throws BOSException {
        LinkedHashMap map = new LinkedHashMap();
        Iterator<String> keyIt = cmpShrInfo.keySet().iterator();
        StringBuffer temptBuf = new StringBuffer();
        StringBuffer schemeBuf = new StringBuffer();
        StringBuffer vouTypeBuf = new StringBuffer();
        String voucherTempId = "";
        String cmpSchemeId = "";
        String voucherType = "";
        while (keyIt.hasNext()) {
            voucherTempId = keyIt.next();
            String[] strArr = cmpShrInfo.get(voucherTempId).split("_");
            cmpSchemeId = strArr[0];
            voucherType = strArr[1];
            if (temptBuf.indexOf(voucherTempId) < 0) {
                temptBuf.append(",'").append(voucherTempId).append("'");
            }
            if (schemeBuf.indexOf(cmpSchemeId) < 0) {
                schemeBuf.append(",'").append(cmpSchemeId).append("'");
            }
            if (vouTypeBuf.indexOf(voucherType) >= 0) continue;
            vouTypeBuf.append(",'").append(voucherType).append("'");
        }
        StringBuffer sql = new StringBuffer();
        CmpSchemeShrInfo cmpshinfo = new CmpSchemeShrInfo();
        StringBuffer tmpSqlBuffer = this.getTmpSqlBuffer(temptBuf, vouTypeBuf);
        cmpshinfo.put("guiTemptTableSql", tmpSqlBuffer.toString());
        Map filterByCmpSchemeMap = VoucherTemptShrFactory.getRemoteInstance().getFilterByCmpScheme(cmpshinfo);
        String guiTemptTableName = (String)filterByCmpSchemeMap.get("guiTemptTableName");
        sql.append("SELECT DISTINCT b.VFBIZDATE,b.VFBOOKEDDATE,a.FPERIODYEAR, a.FPERIODMONTH, a.FCALTIME, FBizDate, FVoucherPeriod ,tempt.FID FVoucherTempId, FVoucherNumber, ");
        sql.append(" tempt.CFCOMPANYID AS CFCOMPANYID,tempt.FBIZDATERANGE as FBIZDATERANGE,tempt.FBOOKDATERANGE as FBOOKDATERANGE, ");
        sql.append(" a.FCalSchemeID FCMPSCHEMEID,cmpScheme.FName_L2 cmpSchemeName,tempt.FName_L2 voucherTemptName FROM T_HR_SCMPCALTABLESHR a LEFT JOIN ");
        if (guiTemptTableName != null && !"".equals(guiTemptTableName)) {
            sql.append(guiTemptTableName);
        } else {
            sql.append(" ( ").append(tmpSqlBuffer.toString()).append(" ) ");
        }
        sql.append(" b");
        sql.append(" on a.FCalSchemeID = b.FCmpSchemeId ");
        sql.append(" and a.FPeriodYear = b.FPeriodYear and a.FPeriodMonth = b.FPeriodMonth ");
        sql.append(" and (a.fcaltime = b.ftime or b.ftime = 0)");
        sql.append(" INNER JOIN T_HR_CMPSCHEMEShr cmpScheme on cmpScheme.FID=a.FCalSchemeID ");
        sql.append(" INNER JOIN CT_CP_VoucherTempt tempt on  tempt.CFCmpSchemeID=a.FCalSchemeID and (tempt.FID=b.FVoucherTempId or b.FVoucherTempId is null)");
        sql.append(" WHERE FCALSCHEMEID in (").append(schemeBuf.substring(1)).append(") and tempt.FID in(").append(temptBuf.substring(1));
        sql.append(" )order by FVoucherPeriod asc");
        logger.error((Object)("getCmpSchemePeriodBatch sql:" + sql));
        ISQLExecutor iSQL = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet set = iSQL.executeSQL();
        if (set != null && set.size() > 0) {
            try {
                List list = null;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                while (set.next()) {
                    String periodYear = set.getString("FPERIODYEAR");
                    String periodMonth = set.getString("FPERIODMONTH");
                    String currentTempId = set.getString("FVoucherTempId");
                    String key = this.getPeriodNumber(periodYear, periodMonth);
                    String calTime = set.getString("FCALTIME");
                    String bizDate = set.getString("FBizDate");
                    String voucherNumber = set.getString("FVoucherNumber");
                    String schemeId = set.getString("FCMPSCHEMEID");
                    String schemeName = set.getString("cmpSchemeName");
                    String temptName = set.getString("voucherTemptName");
                    String financialOrgId = set.getString("CFCOMPANYID");
                    int bizDateRange = set.getInt("FBIZDATERANGE");
                    int bookDateRange = set.getInt("FBOOKDATERANGE");
                    HashMap<String, String> otherParamMap = new HashMap<String, String>();
                    otherParamMap.put("financialOrgId", financialOrgId);
                    otherParamMap.put("cmpSchemeId", schemeId);
                    otherParamMap.put("calTime", calTime);
                    HashMap<String, String> detail = new HashMap<String, String>();
                    if (voucherNumber != null && !"".equals(voucherNumber)) {
                        Date sqlBookDate;
                        String bookDateStr = "";
                        String businessDateStr = "";
                        Date sqlBizDate = set.getDate("VFBIZDATE");
                        if (sqlBizDate != null) {
                            java.util.Date utilBizDate = new java.util.Date(sqlBizDate.getTime());
                            businessDateStr = dateFormat.format(utilBizDate);
                        }
                        if ((sqlBookDate = set.getDate("VFBOOKEDDATE")) != null) {
                            java.util.Date utilBookDate = new java.util.Date(sqlBookDate.getTime());
                            bookDateStr = dateFormat.format(utilBookDate);
                        }
                        detail.put("bookDate", bookDateStr);
                        detail.put("businessDate", businessDateStr);
                    } else {
                        Map dateMap = VoucherTempShrFacadeFactory.getRemoteInstance().getBusinessDateAndBookDate(bizDateRange, bookDateRange, key, otherParamMap);
                        detail.put("bookDate", (String)dateMap.get("bookDate"));
                        detail.put("businessDate", (String)dateMap.get("businessDate"));
                    }
                    detail.put("calTime", calTime);
                    detail.put("bizDate", bizDate);
                    detail.put("voucherNumber", voucherNumber);
                    detail.put("temptId", currentTempId);
                    detail.put("schemeId", schemeId);
                    detail.put("schemeName", schemeName);
                    detail.put("temptName", temptName);
                    list = map.get(key) != null ? (List)map.get(key) : new ArrayList();
                    list.add(detail);
                    map.put(key, list);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                String mutiMsg = EASResource.getString((String)"com.kingdee.eas.hr.compensation.resourse.EasHrMultilanResourse", (String)"label13");
                throw new BOSException(mutiMsg);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                String mutiMsg = EASResource.getString((String)"com.kingdee.eas.hr.compensation.resourse.EasHrMultilanResourse", (String)"label13");
                throw new BOSException(mutiMsg);
            }
        }
        if (guiTemptTableName != null && !"".equals(guiTemptTableName)) {
            cmpshinfo = new CmpSchemeShrInfo();
            cmpshinfo.put("releaseTemptTable", guiTemptTableName);
            VoucherTemptShrFactory.getRemoteInstance().getFilterByCmpScheme(cmpshinfo);
        }
        return map;
    }

    protected StringBuffer getTmpSqlBuffer(StringBuffer temptBuf, StringBuffer vouTypeBuf) {
        StringBuffer tmpSqlBuffer = new StringBuffer();
        tmpSqlBuffer.append(" SELECT voucher.FBizDate as VFBIZDATE,voucher.FBookedDate as VFBOOKEDDATE,voucher.FNUMBER as FVoucherNumber,log.FCMPSCHEMEID,");
        tmpSqlBuffer.append(" log.FPEROIDID, voucher.fVoucherTypeId voucherTypeId,log.FPeriodYear,log.FPeriodMonth, TO_INT(case when log.ftime ='' then '0' else log.ftime end) as ftime,");
        tmpSqlBuffer.append(" log.FVoucherTempId FROM T_CP_VoucherTempLog log ");
        tmpSqlBuffer.append(" INNER JOIN T_GL_Voucher voucher on log.FVoucherId = voucher.fid and voucher.fVoucherTypeId in (");
        tmpSqlBuffer.append(vouTypeBuf.substring(1)).append(") and log.FVoucherTempId in (").append(temptBuf.substring(1)).append(")");
        return tmpSqlBuffer;
    }

    private String getPeriodNumber(String year, String month) {
        if (month.length() == 1) {
            return year + "0" + month;
        }
        return year + month;
    }

    @Override
    public void actionKdrAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdrAll.isSelected()) {
            this.kdrFen.setSelected(false);
        } else {
            this.kdrFen.setSelected(true);
        }
    }

    @Override
    public void actionKdrFen_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdrFen.isSelected()) {
            this.kdrAll.setSelected(false);
        } else {
            this.kdrAll.setSelected(true);
        }
    }

    @Override
    public void btnOk_actionPerformed(ActionEvent e) throws Exception {
        String ids = "";
        if (this.cmpPeriod.getSelectedItem() != null) {
            this.getUIContext().put("period", this.cmpPeriod.getSelectedItem());
        }
        int rowcount = this.kDTable1.getRowCount();
        ArrayList list = new ArrayList();
        if (rowcount > 0) {
            for (int i = 0; i < rowcount; ++i) {
                boolean boo;
                IRow row = this.kDTable1.getRow(i);
                if (row == null || !(boo = ((Boolean)row.getCell("select").getValue()).booleanValue())) continue;
                String temptId = (String)row.getCell("temptId").getValue();
                String schemeId = (String)row.getCell("schemeId").getValue();
                String voucherTempt = (String)row.getCell("voucherTempt").getValue();
                String cmpScheme = (String)row.getCell("cmpScheme").getValue();
                String time = (String)row.getCell("time").getValue();
                String bizDate = (String)row.getCell("bizDate").getValue();
                String bookDate = (String)row.getCell("bookDate").getValue();
                String businessDate = (String)row.getCell("businessDate").getValue();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("temptId", temptId);
                map.put("schemeId", schemeId);
                map.put("temptName", voucherTempt);
                map.put("schemeName", cmpScheme);
                map.put("calTime", time);
                map.put("bizDate", bizDate);
                map.put("bookDate", bookDate);
                map.put("businessDate", businessDate);
                list.add(map);
                if (!boo) continue;
                ids = ids + time + ";";
            }
        }
        boolean bool = false;
        if (this.kdrFen.isSelected()) {
            bool = true;
        }
        this.getUIContext().put("isfen", bool);
        this.getUIContext().put("rValue", ids);
        this.getUIContext().put("params", list);
        if (ids.equals("")) {
            String mutiMsg = EASResource.getString((String)"com.kingdee.eas.hr.compensation.resourse.EasHrMultilanResourse", (String)"label14");
            MsgBox.showInfo((String)mutiMsg);
            SysUtil.abort();
        }
        this.disposeUIWindow();
    }

    @Override
    public void btnClosed_actionPerformed(ActionEvent e) throws Exception {
        boolean bool = false;
        if (this.kdrFen.isSelected()) {
            bool = true;
        }
        this.getUIContext().put("isfen", bool);
        this.getUIContext().put("cmpscheme", "");
        this.getUIContext().put("rValue", "Exit");
        this.disposeUIWindow();
    }

    @Override
    public void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int rowcount = this.kDTable1.getRowCount();
        if (rowcount < 1) {
            return;
        }
        for (int i = 0; i < rowcount; ++i) {
            IRow row = this.kDTable1.getRow(i);
            if (row == null) continue;
            row.getCell("select").setValue((Object)true);
        }
    }

    @Override
    public void btnSelectInvert_actionPerformed(ActionEvent e) throws Exception {
        int rowcount = this.kDTable1.getRowCount();
        if (rowcount < 1) {
            return;
        }
        for (int i = 0; i < rowcount; ++i) {
            IRow row = this.kDTable1.getRow(i);
            if (row == null) continue;
            boolean boo = (Boolean)row.getCell("select").getValue();
            row.getCell("select").setValue((Object)(!boo ? 1 : 0));
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    public void actionReset_actionPerformed(ActionEvent e) throws Exception {
        super.actionReset_actionPerformed(e);
    }

    public void actionMsgFormat_actionPerformed(ActionEvent e) throws Exception {
        super.actionMsgFormat_actionPerformed(e);
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateFrom_actionPerformed(e);
    }

    public void actionCopyFrom_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyFrom_actionPerformed(e);
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceUp_actionPerformed(e);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionViewSubmitProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewSubmitProccess_actionPerformed(e);
    }

    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDoProccess_actionPerformed(e);
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiapprove_actionPerformed(e);
    }

    public void actionNextPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionNextPerson_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionWorkFlowG_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkFlowG_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionSendingMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendingMessage_actionPerformed(e);
    }

    public void actionSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionSignature_actionPerformed(e);
    }

    public void actionWorkflowList_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkflowList_actionPerformed(e);
    }

    public void actionViewSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewSignature_actionPerformed(e);
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    protected KDTable getDetailTable() {
        return null;
    }

    public boolean destroyWindow() {
        boolean b = this.checkBeforeWindowClosing();
        if (b) {
            this.disposeUIWindow();
        }
        return b;
    }

    protected void disposeUIWindow() {
        if (this.uiWindow != null) {
            this.removePropertyChangeListener((PropertyChangeListener)this.uiWindow);
        }
        if (this.uiWindow instanceof Dialog) {
            ((Dialog)this.uiWindow).dispose();
        } else if (this.uiWindow instanceof Window) {
            ((Window)this.uiWindow).dispose();
        } else if (this.uiWindow instanceof JInternalFrame) {
            ((JInternalFrame)this.uiWindow).dispose();
        }
    }
}

