/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.client.f7.AdminByCurrentHROF7WithOrgRangeFilter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.client.EmployeeTypePromptBox;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.client.AbstractShRptCmpPrizeStatFilterUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ShRptCmpPrizeStatFilterUI
extends AbstractShRptCmpPrizeStatFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ShRptCmpPrizeStatFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblCompanyUnits.checkParsed();
        this.tblCompanyUnits.setEnabled(false);
        this.tblCompanyUnits.getSelectManager().setSelectMode(10);
    }

    public void initLayout() {
        super.initLayout();
        this.contTableName.setVisible(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        view.setFilter(filter);
        this.prmtPeriod.setEntityViewInfo(view);
        this.prmtPeriod.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
        this.prmtDeptUnit.setSelector((KDPromptSelector)new AdminByCurrentHROF7WithOrgRangeFilter());
        this.prmtEmployeeType.setSelector((KDPromptSelector)new EmployeeTypePromptBox());
        this.prmtEmployeeType.setEditable(false);
        this.prmtEmployeeType.setEnabledMultiSelection(true);
        this.prmtEmployeeType.setDisplayFormat("$name$");
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.prmtDeptUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                ShRptCmpPrizeStatFilterUI.this.deptUnitChange();
            }
        });
        this.clear();
    }

    private void deptUnitChange() {
        try {
            this.cboLevel.removeAllItems();
            if (this.prmtDeptUnit.getData() == null) {
                return;
            }
            int level = this.getAdminOrgLevelCount((AdminOrgUnitInfo)this.prmtDeptUnit.getData());
            if (level > 0) {
                this.chkIncludeChild.setSelected(false);
                this.chkIncludeChild.setEnabled(true);
                this.cboLevel.setEnabled(true);
            } else {
                this.chkIncludeChild.setSelected(false);
                this.chkIncludeChild.setEnabled(false);
                this.cboLevel.setEnabled(false);
            }
            this.initComBox(level);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        AdminByCurrentHROF7WithOrgRangeFilter adminF7 = new AdminByCurrentHROF7WithOrgRangeFilter();
        adminF7.setMultiSelect(true);
        adminF7.show();
        Object obj = adminF7.getData();
        if (obj != null && obj instanceof Object[]) {
            Object[] units = (Object[])obj;
            int size = units.length;
            for (int i = 0; i < size; ++i) {
                AdminOrgUnitInfo unitInfo = (AdminOrgUnitInfo)units[i];
                if (this.isExistInTable(unitInfo.getId().toString())) continue;
                IRow row = this.tblCompanyUnits.addRow();
                row.getCell("id").setValue((Object)unitInfo.getId().toString());
                row.getCell("number").setValue((Object)unitInfo.getNumber());
                row.getCell("name").setValue((Object)unitInfo.getName());
                row.getCell("longnumber").setValue((Object)unitInfo.getLongNumber());
            }
        }
    }

    private boolean isExistInTable(String unitId) {
        boolean isExist = false;
        int size = this.tblCompanyUnits.getRowCount();
        for (int i = 0; i < size; ++i) {
            String strId = this.tblCompanyUnits.getRow(i).getCell("id").getValue().toString();
            if (!strId.equals(unitId)) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblCompanyUnits.getSelectManager().size() != 0) {
            int[] rowIndexs = KDTableUtil.getSelectedRows((KDTable)this.tblCompanyUnits);
            int size = rowIndexs.length;
            for (int i = size - 1; i >= 0; --i) {
                this.tblCompanyUnits.removeRow(rowIndexs[i]);
            }
        }
    }

    @Override
    protected void rboCompany_itemStateChanged(ItemEvent e) throws Exception {
        this.prmtDeptUnit.setEnabled(false);
        this.prmtDeptUnit.setData(null);
        this.tblCompanyUnits.setEditable(true);
        this.btnAdd.setEnabled(true);
        this.btnDelete.setEnabled(true);
        this.chkIncludeChild.setSelected(false);
        this.chkIncludeChild.setEnabled(false);
        this.cboLevel.setEnabled(false);
    }

    @Override
    protected void rboDept_itemStateChanged(ItemEvent e) throws Exception {
        this.prmtDeptUnit.setEnabled(true);
        this.tblCompanyUnits.removeRows();
        this.tblCompanyUnits.setEditable(false);
        this.btnAdd.setEnabled(false);
        this.btnDelete.setEnabled(false);
        this.chkIncludeChild.setSelected(false);
        this.chkIncludeChild.setEnabled(true);
    }

    public void clear() {
        this.prmtEmployeeType.setData(null);
        this.prmtPeriod.setData(null);
        this.prmtDeptUnit.setData(null);
        this.rboDept.setSelected(true);
        this.btnAdd.setEnabled(false);
        this.btnDelete.setEnabled(false);
        this.tblCompanyUnits.removeRows();
        this.rboDept.setSelected(true);
        this.chkIncludeChild.setSelected(false);
        this.contTableName.setVisible(false);
        this.txtTableName.setText(null);
        this.cboLevel.setEnabled(false);
        this.rboMonth.setSelected(true);
    }

    public Object getParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String empTypes = null;
        if (this.prmtEmployeeType.getData() != null) {
            Object[] objEmpTypes = (Object[])this.prmtEmployeeType.getData();
            StringBuffer strEmpTypes = new StringBuffer();
            int size = objEmpTypes.length;
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    strEmpTypes.append("~");
                }
                strEmpTypes.append(((EmployeeTypeInfo)objEmpTypes[i]).getId().toString());
            }
            empTypes = strEmpTypes.toString();
        }
        map.put("empTypeIds", empTypes);
        CmpPeriodInfo periodInfo = (CmpPeriodInfo)this.prmtPeriod.getData();
        String cmpPeriodId = periodInfo.getId().toString();
        map.put("periodId", cmpPeriodId);
        map.put("periodName", periodInfo.getName());
        map.put("tableName", this.txtTableName.getText());
        int iScheme = 0;
        if (this.rboYear.isSelected()) {
            iScheme = 1;
        } else if (this.rboTL.isSelected()) {
            iScheme = 2;
        }
        map.put("schemeType", iScheme);
        String deptOrCompany = "0";
        if (this.rboDept.isSelected()) {
            AdminOrgUnitInfo unitInfo = (AdminOrgUnitInfo)this.prmtDeptUnit.getData();
            map.put("deptUnitId", unitInfo.getId().toString());
            map.put("deptUnitLongNum", unitInfo.getLongNumber());
            map.put("deptUnitLevel", unitInfo.getLevel());
            map.put("includeChild", this.chkIncludeChild.isSelected());
            if (this.cboLevel.getSelectedIndex() != -1) {
                map.put("level", (Integer)this.cboLevel.getSelectedItem());
            } else {
                map.put("level", 1);
            }
        } else {
            deptOrCompany = "1";
            int size = this.tblCompanyUnits.getRowCount();
            String[] compUnitIds = new String[size];
            String[] compUnitLongNums = new String[size];
            String[] compUnitLevels = new String[size];
            for (int i = 0; i < size; ++i) {
                IRow row = this.tblCompanyUnits.getRow(i);
                compUnitIds[i] = row.getCell("id").getValue().toString();
                compUnitLongNums[i] = row.getCell("longnumber").getValue().toString();
            }
            map.put("compUnitIds", compUnitIds);
            map.put("compUnitLevels", compUnitLevels);
            map.put("compUnitLongNums", compUnitLongNums);
        }
        map.put("deptOrCompany", deptOrCompany);
        return map;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtEmployeeType.getData() != null) {
            Object[] objEmpTypes = (Object[])this.prmtEmployeeType.getData();
            StringBuffer strEmpTypes = new StringBuffer();
            int size = objEmpTypes.length;
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    strEmpTypes.append("~");
                }
                strEmpTypes.append(((EmployeeTypeInfo)objEmpTypes[i]).getId().toString());
            }
            cp.addCustomerParam("empTypeIds", strEmpTypes.toString());
        }
        CmpPeriodInfo periodInfo = (CmpPeriodInfo)this.prmtPeriod.getData();
        String cmpPeriodId = periodInfo.getId().toString();
        cp.addCustomerParam("periodId", cmpPeriodId);
        cp.addCustomerParam("periodName", periodInfo.getName());
        cp.addCustomerParam("tableName", this.txtTableName.getText());
        int iScheme = 0;
        if (this.rboYear.isSelected()) {
            iScheme = 1;
        } else if (this.rboTL.isSelected()) {
            iScheme = 2;
        }
        cp.putInt("schemeType", iScheme);
        String deptOrCompany = "0";
        if (this.rboDept.isSelected()) {
            AdminOrgUnitInfo unitInfo = (AdminOrgUnitInfo)this.prmtDeptUnit.getData();
            cp.addCustomerParam("deptUnitId", unitInfo.getId().toString());
            cp.addCustomerParam("deptUnitLongNum", unitInfo.getLongNumber());
            cp.putInt("deptUnitLevel", unitInfo.getLevel());
            cp.putBoolean("includeChild", this.chkIncludeChild.isSelected());
            if (this.cboLevel.getSelectedIndex() != -1) {
                cp.putInt("level", ((Integer)this.cboLevel.getSelectedItem()).intValue());
            }
        } else {
            deptOrCompany = "1";
            int size = this.tblCompanyUnits.getRowCount();
            StringBuffer compUnitIds = new StringBuffer();
            StringBuffer compUnitLongNums = new StringBuffer();
            String compUnitLevels = "";
            for (int i = 0; i < size; ++i) {
                IRow row = this.tblCompanyUnits.getRow(i);
                if (!compUnitIds.toString().equals("")) {
                    compUnitIds.append("~");
                }
                compUnitIds.append(row.getCell("id").getValue().toString());
                if (!compUnitLongNums.toString().equals("")) {
                    compUnitLongNums.append("~");
                }
                compUnitLongNums.append(row.getCell("longnumber").getValue().toString());
            }
            cp.addCustomerParam("compUnitIds", compUnitIds.toString());
            cp.addCustomerParam("compUnitLevels", compUnitLevels);
            cp.addCustomerParam("compUnitLongNums", compUnitLongNums.toString());
        }
        cp.addCustomerParam("deptOrCompany", deptOrCompany);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        try {
            String strEmpTypes = cp.getCustomerParam("empTypeIds");
            if (strEmpTypes != null && !strEmpTypes.equals("")) {
                String oql = "select id,name where id in ('" + strEmpTypes.replaceAll("~", "','") + "')";
                EmployeeTypeCollection typeCol = EmployeeTypeFactory.getRemoteInstance().getEmployeeTypeCollection(oql);
                this.prmtEmployeeType.setData((Object)typeCol.toArray());
            } else {
                this.prmtEmployeeType.setData(null);
            }
            String periodId = cp.getCustomerParam("periodId");
            CmpPeriodInfo periodInfo = CmpPeriodFactory.getRemoteInstance().getCmpPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
            this.prmtPeriod.setData((Object)periodInfo);
            this.txtTableName.setText(cp.getCustomerParam("tableName"));
            int iScheme = cp.getInt("schemeType");
            if (iScheme == 0) {
                this.rboMonth.setSelected(true);
            } else if (iScheme == 1) {
                this.rboYear.setSelected(true);
            } else {
                this.rboTL.setSelected(true);
            }
            String deptOrCompany = cp.getCustomerParam("deptOrCompany").toString();
            IAdminOrgUnit iUnit = AdminOrgUnitFactory.getRemoteInstance();
            if (deptOrCompany.equals("0")) {
                String deptUnitId = cp.getCustomerParam("deptUnitId").toString();
                AdminOrgUnitInfo deptUnitInfo = iUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(deptUnitId));
                this.rboDept.setSelected(true);
                this.prmtDeptUnit.setData((Object)deptUnitInfo);
                this.deptUnitChange();
                this.chkIncludeChild.setSelected(cp.getBoolean("includeChild"));
                if (cp.getBoolean("includeChild")) {
                    this.cboLevel.setSelectedItem((Object)cp.getInt("level"));
                }
            } else {
                this.rboCompany.setSelected(true);
                if (cp.getCustomerParam("compUnitIds") != null) {
                    String[] compUnitIds = cp.getCustomerParam("compUnitIds").split("~");
                    this.tblCompanyUnits.checkParsed();
                    this.tblCompanyUnits.removeRows();
                    int size = compUnitIds.length;
                    for (int i = 0; i < size; ++i) {
                        AdminOrgUnitInfo compUnitInfo = iUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(compUnitIds[i]));
                        IRow row = this.tblCompanyUnits.addRow();
                        row.getCell("id").setValue((Object)compUnitInfo.getId().toString());
                        row.getCell("number").setValue((Object)compUnitInfo.getNumber());
                        row.getCell("name").setValue((Object)compUnitInfo.getName());
                        row.getCell("level").setValue((Object)compUnitInfo.getLevel());
                        row.getCell("longnumber").setValue((Object)compUnitInfo.getLongNumber());
                    }
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
    }

    public boolean verify() {
        if (this.prmtPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"607_ShRptCmpPrizeStatFilterUI"));
            return false;
        }
        if (this.rboDept.isSelected() && this.prmtDeptUnit.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"608_ShRptCmpPrizeStatFilterUI"));
            return false;
        }
        if (this.rboCompany.isSelected() && this.tblCompanyUnits.getRowCount() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"609_ShRptCmpPrizeStatFilterUI"));
            return false;
        }
        if (this.rboCompany.isSelected() && this.tblCompanyUnits.getRowCount() > 40) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"610_ShRptCmpPrizeStatFilterUI"));
            return false;
        }
        return super.verify();
    }

    private int getAdminOrgLevelCount(AdminOrgUnitInfo info) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)info.getLongNumber()));
        fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(info.getLongNumber() + "!%"), CompareType.LIKE));
        fi.setMaskString("(#0 or #1)");
        FilterInfo filterAdminOrg = HRUtil.buildHROFilter((String)"id");
        fi.mergeFilter(filterAdminOrg, "AND");
        viewInfo.setFilter(fi);
        SorterItemInfo sortInfo = new SorterItemInfo("level");
        sortInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sortInfo);
        IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getRemoteInstance();
        AdminOrgUnitCollection coll = iAdmin.getAdminOrgUnitCollection(viewInfo);
        if (coll != null) {
            int size = coll.size();
            if (size <= 1) {
                return 0;
            }
            if (size > 1) {
                return coll.get(size - 1).getLevel() - coll.get(0).getLevel();
            }
        }
        return 0;
    }

    private void initComBox(int level) {
        for (int i = 1; i <= level; ++i) {
            this.cboLevel.addItem((Object)i);
        }
        if (level >= 1) {
            this.cboLevel.setSelectedIndex(0);
        }
    }

    @Override
    protected void chkIncludeChild_itemStateChanged(ItemEvent e) throws Exception {
        if (this.chkIncludeChild.isSelected()) {
            this.cboLevel.setEnabled(true);
        } else {
            this.cboLevel.setEnabled(false);
        }
    }

    @Override
    protected void rboDept_keyPressed(KeyEvent e) throws Exception {
        if (e.getKeyCode() == 8) {
            if (this.contTableName.isVisible()) {
                this.contTableName.setVisible(false);
            } else {
                this.contTableName.setVisible(true);
            }
        }
    }
}

