/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.ShRptCmpPrizeStatFacadeFactory;
import com.kingdee.eas.hr.compensation.client.AbstractShRptCurrentPayStatUI;
import com.kingdee.eas.hr.compensation.client.ShRptCurrentPayStatFilterUI;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class ShRptCurrentPayStatUI
extends AbstractShRptCurrentPayStatUI {
    private static final Logger logger = CoreUIObject.getLogger(ShRptCurrentPayStatUI.class);
    private CommonQueryDialog commonQueryDialog = null;
    private boolean isFirstDefaultQuery = true;
    private HashMap curFilterMap = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getHeadStyleAttributes().setWrapText(true);
        this.tblMain.setColumnMoveable(true);
        HRUtils.removeLintMenu(this.tblMain, this.getMenuManager(this.tblMain));
        this.performCommonQuery();
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    private void loadReportData(HashMap map) throws EASBizException, BOSException, SQLException {
        if (map == null) {
            return;
        }
        String periodName = map.get("periodName").toString();
        this.lblPeriod.setText(HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"747_ShRptCmpPrizeStatUI", (String[])new String[]{periodName}));
        this.tblMain.removeRows();
        this.initTableColumn();
        String strReportType = map.get("reportType").toString();
        IRowSet rs = ShRptCmpPrizeStatFacadeFactory.getRemoteInstance().getCurrentPayStatData(map, false);
        this.fillTableData(rs);
        if (strReportType.equals("2")) {
            rs = ShRptCmpPrizeStatFacadeFactory.getRemoteInstance().getCurrentPayStatData(map, true);
            this.fillTableData(rs);
        }
    }

    private List getCmpItemCollById(String[] selectListStrArray) throws BOSException {
        int i;
        ArrayList al = new ArrayList();
        if (selectListStrArray == null || selectListStrArray.length == 0) {
            return null;
        }
        HashSet<String> keySet = new HashSet<String>();
        String strCmpItemId = null;
        int size = selectListStrArray.length;
        for (int i2 = 0; i2 < size; ++i2) {
            strCmpItemId = selectListStrArray[i2].split(":")[0];
            keySet.add(strCmpItemId);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", keySet, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("decDigital"));
        sic.add(new SelectorItemInfo("precisionType"));
        CmpItemCollection colCmpItemAll = CmpItemFactory.getRemoteInstance().getCmpItemCollection(evi);
        HashMap<String, CmpItemInfo> newCmpMap = new HashMap<String, CmpItemInfo>();
        CmpItemInfo cmpItem = null;
        int size2 = colCmpItemAll.size();
        for (i = 0; i < size2; ++i) {
            cmpItem = colCmpItemAll.get(i);
            newCmpMap.put(cmpItem.getId().toString(), cmpItem);
        }
        size2 = selectListStrArray.length;
        for (i = 0; i < size2; ++i) {
            strCmpItemId = selectListStrArray[i].split(":")[0];
            al.add(newCmpMap.get(strCmpItemId));
        }
        return al;
    }

    private void initTableColumn() throws BOSException {
        String selectListItems = this.curFilterMap.get("selectListItem").toString();
        String[] selectListStrArray = selectListItems.split("~");
        int size = this.tblMain.getColumnCount();
        for (int j = size - 1; j >= 2; --j) {
            this.tblMain.removeColumn(j);
        }
        List cmpItemColl = this.getCmpItemCollById(selectListStrArray);
        int cmpItemSize = selectListStrArray.length;
        String strCmpItemNumber = null;
        String strCmpItemName = null;
        int cmpPrec = 0;
        this.tblMain.addColumns(cmpItemSize);
        CmpItemInfo cmpItem = null;
        for (int i = 0; i < cmpItemSize; ++i) {
            cmpItem = (CmpItemInfo)cmpItemColl.get(i);
            strCmpItemNumber = cmpItem.getNumber();
            strCmpItemName = cmpItem.getName();
            cmpPrec = cmpItem.getDecDigital();
            KDTColumn col = new KDTColumn();
            col.setKey(strCmpItemNumber);
            int colIndex = i + 2;
            this.tblMain.getColumn(colIndex).setKey(strCmpItemNumber);
            StyleAttributes sa = this.tblMain.getColumn(colIndex).getStyleAttributes();
            sa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            sa.setNumberFormat(HRCmpItemUtils.getColumnFormatStr(cmpPrec));
            this.tblMain.getHeadRow(0).getCell(colIndex).setValue((Object)strCmpItemName);
        }
    }

    private void fillTableData(IRowSet rs) throws SQLException {
        String selectListItems = this.curFilterMap.get("selectListItem").toString();
        String[] selectListStrArray = selectListItems.split("~");
        int size = selectListStrArray.length;
        if (size <= 0) {
            return;
        }
        rs.beforeFirst();
        while (rs.next()) {
            IRow row = this.tblMain.addRow();
            row.getCell("unitName").setValue((Object)rs.getString("unitName"));
            row.getCell("rens").setValue((Object)rs.getInt("rens"));
            String strCmpItemNumber = null;
            for (int i = 0; i < size; ++i) {
                strCmpItemNumber = selectListStrArray[i].split(":")[1];
                row.getCell(strCmpItemNumber).setValue((Object)rs.getBigDecimal(strCmpItemNumber));
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    protected void performCommonQuery() throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        String queryName = loader.getQuery(this.queryCmpItemQueryPK).getFullName();
        ShRptCurrentPayStatFilterUI customerPanel = new ShRptCurrentPayStatFilterUI();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            if (solution.getSolutionType().getValue().equals("10")) {
                this.showFilterDialog(customerPanel);
            } else {
                CustomerParams cp = CustomerParams.getCustomerParams2((String)CompUtils.getCustmerParamsUtil(solution));
                ShRptCurrentPayStatFilterUI filterUI = new ShRptCurrentPayStatFilterUI();
                filterUI.setCustomerParams(cp);
                this.curFilterMap = (HashMap)filterUI.getParam();
                this.loadReportData(this.curFilterMap);
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showFilterDialog(customerPanel);
        }
    }

    private void showFilterDialog(ShRptCurrentPayStatFilterUI customerPanel) throws EASBizException, BOSException, SQLException {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setHeight(510);
            this.commonQueryDialog.setWidth(440);
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setQueryObjectPK(this.queryCmpItemQueryPK);
            this.commonQueryDialog.setShowFilter(false);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setShowToolbar(true);
            this.commonQueryDialog.setDisShowRowCount(true);
            customerPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"614_ShRptCmpPrizeStatUI"));
            this.commonQueryDialog.addUserPanel((KDPanel)customerPanel);
            this.commonQueryDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"619_ShRptCurrentPayStatUI"));
        }
        if (this.commonQueryDialog.show()) {
            this.curFilterMap = (HashMap)((ShRptCurrentPayStatFilterUI)this.commonQueryDialog.getUserPanel(0)).getParam();
            this.loadReportData(this.curFilterMap);
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        this.performCommonQuery();
    }

    @Override
    public void actionPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.loadReportData(this.curFilterMap);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }
}

