/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.compensation.CmpDataCheckFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.client.AbstractTaxHistoryListUI;
import com.kingdee.eas.hr.compensation.client.EmpInfoExportQueryUI;
import com.kingdee.eas.hr.compensation.client.PersonalTaxUI;
import com.kingdee.eas.hr.compensation.client.TaxHistoryQueryPanel;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.compensation.util.TaxHistoryQueryUtilParam;
import com.kingdee.eas.hr.org.JobException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class TaxHistoryListUI
extends AbstractTaxHistoryListUI {
    private static Logger logger = Logger.getLogger(TaxHistoryListUI.class);
    private static final int DYNSTARTPOS = 10;
    private static final String resPrefix = "com.kingdee.eas.hr.compensation.client.TaxSchemeResource";
    private static final String resTaxBase = EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.TaxSchemeResource", (String)"TAX_BASE");
    private static final String resTax = EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.TaxSchemeResource", (String)"TAX_VALUE");
    private static final String resSum = EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.TaxSchemeResource", (String)"COL_SUM");
    private TaxHistoryQueryUtilParam queryParam;
    private TaxHistoryQueryUtilParam oldQueryParam;
    private TaxHistoryQueryPanel pnlTax;
    private List lstPeriod = null;
    private boolean refresh = false;
    private boolean isFirstDefaultQuery = true;
    public String flag = null;
    public String reqType = null;
    HashMap natinalMap = null;
    static String taxFlag = null;
    static String getProject = null;
    private String splitFlag = "~~";
    private String nullFlag = "~~~~";
    private CommonQueryDialog dialog = null;
    private EntityViewInfo customEV = null;
    protected IMetaDataPK commonQueryDlgQueryPK = null;
    private CmpPeriodInfo cmpBeginPeriond = new CmpPeriodInfo();
    private CmpPeriodInfo cmpEndPeriond = new CmpPeriodInfo();

    public TaxHistoryListUI() throws Exception {
        HRSchemeUtils.checkInit();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.commonQueryDlgQueryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app", "PersonInfoQuery");
        this.lstPeriod = new ArrayList();
        this.setBtnState();
        this.tblList.checkParsed();
        this.tblList.getStyleAttributes().setLocked(true);
        this.showTaxHistoryQueryUI();
        HRUtils.removeLintMenu(this.tblList, this.getMenuManager(this.tblList));
    }

    private void setBtnState() {
        this.btnQuery.setEnabled(true);
        this.btnRefresh.setEnabled(true);
    }

    private void createColHead() {
        int size = this.lstPeriod.size() * 2;
        HashMap itemMap = HRCmpItemUtils.getCmpItemInfoByNumber(null, new String[]{"FSAL007", "FSAL027"});
        CmpItemInfo itemInfo = null;
        for (int i = 0; i <= size + 1; ++i) {
            IColumn col = this.tblList.addColumn();
            itemInfo = i % 2 == 0 ? (CmpItemInfo)itemMap.get("FSAL027") : (CmpItemInfo)itemMap.get("FSAL007");
            col.getStyleAttributes().setNumberFormat(HRCmpItemUtils.getColumnFormatStr(itemInfo.getDecDigital()));
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        int colCount = this.tblList.getColumnCount();
        IRow row = this.tblList.getHeadRow(0);
        int i = 0;
        int j = 0;
        while (i < size) {
            ICell cell = row.getCell(10 + i++);
            cell.setValue(this.lstPeriod.get(j));
            cell = row.getCell(10 + i);
            cell.setValue(this.lstPeriod.get(j));
            ++i;
            ++j;
        }
        row.getCell(colCount - 2).setValue((Object)resSum);
        row.getCell(colCount - 1).setValue((Object)resSum);
        this.mergeColHead(size, colCount);
        row = this.tblList.getHeadRow(1);
        for (i = 0; i < size; ++i) {
            ICell cell = row.getCell(10 + i++);
            cell.setValue((Object)resTaxBase);
            cell = row.getCell(10 + i);
            cell.setValue((Object)resTax);
        }
        row.getCell(colCount - 2).setValue((Object)resTaxBase);
        row.getCell(colCount - 1).setValue((Object)resTax);
    }

    private void mergeColHead(int size, int colCount) {
        KDTMergeManager mm = this.tblList.getHeadMergeManager();
        for (int i = 0; i <= size; ++i) {
            mm.mergeBlock(0, 10 + i, 0, ++i + 10);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnQuery);
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.setButtonDefaultStyl(this.btnRefresh);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnExportEmp.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnExportTax.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.tblList.setColumnMoveable(true);
        String txtTax = this.resHelper.getString("menuItemTaxExp.text");
        txtTax = txtTax.substring(0, txtTax.indexOf("("));
        KDMenuItem menuItemTaxExpTool = new KDMenuItem(txtTax);
        menuItemTaxExpTool.setEnabled(true);
        menuItemTaxExpTool.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionExportTax), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        menuItemTaxExpTool.setText(txtTax);
        String empTxt = this.resHelper.getString("menuIitemEmpInfoExp.text");
        empTxt = empTxt.substring(0, empTxt.indexOf("("));
        KDMenuItem menuIitemEmpInfoExpTool = new KDMenuItem(empTxt);
        menuIitemEmpInfoExpTool.setEnabled(true);
        menuIitemEmpInfoExpTool.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionExportEmp), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        menuIitemEmpInfoExpTool.setText(empTxt);
        this.btmExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btmExport.addAssistMenuItem((JMenuItem)menuIitemEmpInfoExpTool);
        this.btmExport.addAssistMenuItem((JMenuItem)menuItemTaxExpTool);
    }

    private void clearTable() {
        int cols;
        this.tblList.removeRows();
        for (int i = cols = this.tblList.getColumnCount(); i >= 10; --i) {
            this.tblList.removeColumn(i);
        }
    }

    private void display() throws Exception {
        if (!this.refresh) {
            this.queryParam = new TaxHistoryQueryUtilParam();
            this.cmpBeginPeriond = (CmpPeriodInfo)this.pnlTax.prmtStartPeriod.getData();
            this.cmpEndPeriond = (CmpPeriodInfo)this.pnlTax.prmtEndPeriod.getData();
            this.queryParam.setStartPeriodInfo(this.cmpBeginPeriond);
            this.queryParam.setEndPeriodInfo(this.cmpEndPeriond);
            Object obj = this.pnlTax.prmtCmpScheme.getData();
            this.queryParam.setCmpSchInfos(obj);
        }
        long t5 = System.currentTimeMillis();
        ArrayList lstPerson = new ArrayList(1024);
        Map mapPerson = this.getData(lstPerson);
        long t6 = System.currentTimeMillis();
        logger.info((Object)("getData():" + (t6 - t5)));
        this.clearTable();
        this.createColHead();
        this.fillTableData(mapPerson, lstPerson);
    }

    private Map getData(List lstPerson) throws EASBizException, BOSException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        CmpSchemeInfo cmpSchemeInfo = (CmpSchemeInfo)this.queryParam.getCmpSchInfos();
        params.put("cmpSchemeId", cmpSchemeInfo.getId().toString());
        params.put("customEV", this.customEV);
        params.put("queryParam", this.queryParam);
        IRowSet[] rowsets = new IRowSet[]{CmpDataCheckFacadeFactory.getRemoteInstance().getTaxHistoryRS(params)};
        return this.regroupData(rowsets, lstPerson);
    }

    private Map regroupData(IRowSet[] rowsets, List lstPerson) {
        HashMap mapPerson = new HashMap(1024);
        for (int i = 0; i < rowsets.length; ++i) {
            IRowSet rs = rowsets[i];
            if (rs == null) continue;
            try {
                this.regroupData(rs, lstPerson, mapPerson);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return mapPerson;
    }

    private void regroupData(IRowSet rs, List lstPerson, Map mapPerson) throws SQLException, Exception {
        HashMap<String, TaxValue> mapPeriod = null;
        ArrayList<String> alPeriod = new ArrayList<String>();
        String personId = "";
        while (rs.next()) {
            personId = rs.getString("fpersonid");
            if (mapPerson.containsKey(personId)) {
                mapPeriod = (HashMap<String, TaxValue>)mapPerson.get(personId);
            } else {
                HisBaseInfo info = new HisBaseInfo();
                info.personId = personId;
                info.number = rs.getString("fper002");
                info.name = rs.getString("fper001");
                info.dept = rs.getString("fper005");
                info.idCardNo = rs.getString("fper023");
                info.gendar = rs.getString("fper010");
                info.birthday = rs.getString("fper059");
                info.passportNo = rs.getString("passportno");
                info.basePoint = rs.getBigDecimal("fsal029");
                info.taxScheme = rs.getString("taxScheme");
                if (!lstPerson.contains(info)) {
                    lstPerson.add(info);
                }
                mapPeriod = new HashMap<String, TaxValue>(16);
                mapPerson.put(personId, mapPeriod);
            }
            TaxValue taxValue = new TaxValue();
            taxValue.tax = rs.getString("fsal007") != null ? rs.getBigDecimal("fsal007") : new BigDecimal("0.00");
            taxValue.taxBase = rs.getString("fsal027") != null ? rs.getBigDecimal("fsal027") : new BigDecimal("0.00");
            String fmaneStr = "fname_" + SysContext.getSysContext().getLocale().toString();
            String periodNumber = rs.getString(fmaneStr);
            if (!mapPeriod.containsKey(periodNumber)) {
                mapPeriod.put(periodNumber, taxValue);
            } else {
                TaxValue oldValue = (TaxValue)mapPeriod.get(periodNumber);
                if (oldValue.tax == null) {
                    oldValue.tax = new BigDecimal("0.00");
                }
                if (oldValue.taxBase == null) {
                    oldValue.taxBase = new BigDecimal("0.00");
                }
                oldValue.tax = oldValue.tax.add(taxValue.tax);
                oldValue.taxBase = oldValue.taxBase.add(taxValue.taxBase);
            }
            if (alPeriod.contains(periodNumber)) continue;
            alPeriod.add(periodNumber);
        }
        this.addPeriod(alPeriod);
    }

    private void addPeriod(List lstSubPeriod) {
        this.lstPeriod.clear();
        for (int i = 0; i < lstSubPeriod.size(); ++i) {
            String period = (String)lstSubPeriod.get(i);
            if (this.lstPeriod.contains(period)) continue;
            this.lstPeriod.add(period);
        }
    }

    private void fillTableData(Map mapPerson, List lstPerSon) throws SQLException {
        int size = lstPerSon.size();
        int cols = this.tblList.getColumnCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblList.addRow();
            HisBaseInfo info = (HisBaseInfo)lstPerSon.get(i);
            Map mapPeriod = (Map)mapPerson.get(info.personId);
            this.setFixCol(row, info);
            int pos = 0;
            BigDecimal sum = new BigDecimal("0.00");
            BigDecimal taxSum = new BigDecimal("0.00");
            for (int j = 10; j < cols - 2; ++j) {
                String period = (String)this.lstPeriod.get(pos++);
                TaxValue taxValue = (TaxValue)mapPeriod.get(period);
                ICell cell = row.getCell(j++);
                if (taxValue == null) {
                    taxValue = new TaxValue();
                    taxValue.taxBase = new BigDecimal("0.00");
                    taxValue.tax = new BigDecimal("0.00");
                }
                cell.setValue((Object)taxValue.taxBase);
                cell = row.getCell(j);
                cell.setValue((Object)taxValue.tax);
                sum = sum.add(taxValue.tax);
                taxSum = taxSum.add(taxValue.taxBase);
            }
            row.getCell(cols - 2).setValue((Object)taxSum);
            row.getCell(cols - 1).setValue((Object)sum);
        }
    }

    @Override
    public void actionExportEmp_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EmpInfoExportQueryUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        String flag = EmpInfoExportQueryUI.flag;
        if (flag.equals("Y")) {
            if (this.tblList == null) {
                return;
            }
            KDFileChooser m_chooserSave = new KDFileChooser();
            int result = m_chooserSave.showSaveDialog((Component)this.tblList);
            if (result != 0) {
                return;
            }
            File file = m_chooserSave.getSelectedFile();
            if (null != file.getParentFile() && !file.getParentFile().isDirectory()) {
                throw new BaseException(BaseException.OUTPUT_FILE_ERROR);
            }
            String fileName = null;
            fileName = file.getAbsolutePath().endsWith(".txt") ? file.getAbsolutePath() : file.getAbsolutePath() + ".txt";
            if (file.exists()) {
                if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.FILE_IS_EXIST")) != 0) {
                    return;
                }
                try {
                    file.delete();
                    this.createNewTxtFileForEmp(file, fileName);
                }
                catch (IOException ex) {
                    throw new JobException(JobException.FILE_NAME_ERROR);
                }
            } else {
                try {
                    file.delete();
                    this.createNewTxtFileForEmp(file, fileName);
                }
                catch (IOException ex) {
                    throw new JobException(JobException.FILE_NAME_ERROR);
                }
            }
        } else {
            return;
        }
    }

    @Override
    public void actionExportTax_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PersonalTaxUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        String flag = PersonalTaxUI.flag;
        if (flag.equals("Y")) {
            if (this.tblList == null) {
                return;
            }
            KDFileChooser m_chooserSave = new KDFileChooser();
            int result = m_chooserSave.showSaveDialog((Component)this.tblList);
            if (result != 0) {
                return;
            }
            File file = m_chooserSave.getSelectedFile();
            if (null != file.getParentFile() && !file.getParentFile().isDirectory()) {
                throw new BaseException(BaseException.OUTPUT_FILE_ERROR);
            }
            String fileName = null;
            fileName = file.getAbsolutePath().endsWith(".txt") ? file.getAbsolutePath() : file.getAbsolutePath() + ".txt";
            if (file.exists()) {
                if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.FILE_IS_EXIST")) != 0) {
                    return;
                }
                try {
                    file.delete();
                    this.createNewTxtFileForTax(file, fileName);
                }
                catch (IOException ex) {
                    throw new JobException(JobException.FILE_NAME_ERROR);
                }
            } else {
                try {
                    file.delete();
                    this.createNewTxtFileForTax(file, fileName);
                }
                catch (IOException ex) {
                    throw new JobException(JobException.FILE_NAME_ERROR);
                }
            }
        } else {
            return;
        }
    }

    private void createNewTxtFileForTax(File file, String fileName) throws Exception {
        file = new File(fileName);
        int count = this.tblList.getRowCount();
        String startDate = this.queryParam.getStartPeriodInfo().getBeginDate().toString();
        String endDate = this.queryParam.getEndPeriodInfo().getEndDate().toString();
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        this.tblList.checkParsed();
        String cardType = null;
        String passortid = null;
        IRow row = null;
        int countCol = this.tblList.getColumnCount();
        BigDecimal basePoint = null;
        DecimalFormat df = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
        for (int i = 0; i < count; ++i) {
            row = this.tblList.getRow(i);
            if (row.getCell("idcard").getValue() != null) {
                cardType = row.getCell("idcard").getValue().toString();
                this.cardID18To15(cardType);
            } else {
                cardType = null;
            }
            passortid = row.getCell("passortid").getValue() != null ? row.getCell("passortid").getValue().toString().trim() : null;
            if (cardType != null) {
                out.write("1");
                out.write(this.splitFlag);
                out.write(cardType);
            } else if (passortid != null) {
                out.write("2");
                out.write(this.splitFlag);
                out.write(passortid);
            } else {
                out.write("9");
                out.write(this.splitFlag);
                out.write(this.nullFlag);
            }
            out.write(this.splitFlag);
            if (getProject.length() == 5) {
                getProject = "0".concat(getProject);
            }
            out.write(getProject);
            out.write(this.splitFlag);
            out.write(taxFlag);
            out.write(this.splitFlag);
            out.write(this.tranDate(startDate));
            out.write(this.splitFlag);
            out.write(this.tranDate(endDate));
            out.write(this.splitFlag);
            out.write(df.format(row.getCell(countCol - 2).getValue()));
            out.write(this.splitFlag);
            basePoint = new BigDecimal(row.getCell("basepoint").getValue().toString()).setScale(2);
            out.write(basePoint.toString());
            out.write(this.splitFlag);
            out.write(df.format(row.getCell(countCol - 1).getValue()));
            out.write(13);
            out.write(10);
        }
        out.close();
    }

    private String tranDate(String date) {
        String dateFormat = null;
        String year = null;
        String month = null;
        String day = null;
        if (date.length() != 10) {
            return null;
        }
        year = date.substring(0, 4);
        month = date.substring(5, 7);
        day = date.substring(8, 10);
        dateFormat = year.concat(month);
        dateFormat = dateFormat.concat(day);
        return dateFormat;
    }

    private void createNewTxtFileForEmp(File file, String fileName) throws Exception {
        int count = this.tblList.getRowCount();
        file = new File(fileName);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        this.tblList.checkParsed();
        String passortid = null;
        String cardType = null;
        String name = null;
        String id = null;
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblList.getRow(i);
            id = row.getCell(0).getValue().toString();
            if (id.equals("")) {
                out.write(this.nullFlag);
            } else {
                out.write(id);
            }
            out.write(this.splitFlag);
            if (row.getCell("name").getValue() == null) {
                out.write(this.nullFlag);
            } else if (row.getCell("name").getValue().toString().equals("")) {
                out.write(this.nullFlag);
            } else {
                name = row.getCell("name").getValue().toString();
                out.write(name);
            }
            out.write(this.splitFlag);
            if (row.getCell("idcard").getValue() != null) {
                cardType = row.getCell("idcard").getValue().toString();
                this.cardID18To15(cardType);
            } else {
                cardType = null;
            }
            passortid = row.getCell("passortid").getValue() != null ? row.getCell("passortid").getValue().toString() : null;
            if (cardType != null) {
                out.write("1");
                out.write(this.splitFlag);
                out.write(cardType);
            } else if (passortid != null) {
                out.write("2");
                out.write(this.splitFlag);
                out.write(passortid);
            } else {
                out.write("9");
                out.write(this.splitFlag);
                out.write(this.nullFlag);
            }
            out.write(this.splitFlag);
            out.write(this.flag);
            out.write(this.splitFlag);
            out.write(this.reqType);
            out.write(this.splitFlag);
            if (row.getCell("gendar").getValue() != null) {
                String gendar = row.getCell("gendar").getValue().toString().trim();
                BigDecimal sex = new BigDecimal(gendar);
                if (sex.equals(new BigDecimal("2"))) {
                    sex = sex.subtract(new BigDecimal("2"));
                }
                out.write(sex.toString());
            } else {
                out.write(this.nullFlag);
            }
            out.write(this.splitFlag);
            String birth = this.nullFlag;
            if (row.getCell("birthday").getValue() != null) {
                birth = row.getCell("birthday").getValue().toString().trim().substring(0, 10);
            }
            out.write(birth);
            out.write(this.splitFlag);
            out.write(this.nullFlag);
            out.write(this.splitFlag);
            out.write(this.nullFlag);
            out.write(this.splitFlag);
            out.write(this.nullFlag);
            out.write(13);
            out.write(10);
        }
        out.close();
    }

    private String cardID18To15(String idCard) {
        if (idCard.trim().length() == 18) {
            idCard = idCard.trim().substring(0, 6) + idCard.trim().substring(8, 17);
        }
        return idCard;
    }

    private void setFixCol(IRow row, HisBaseInfo info) {
        ICell cell = row.getCell(0);
        cell.setValue((Object)info.number);
        cell = row.getCell(1);
        cell.setValue((Object)info.name);
        cell = row.getCell(2);
        cell.setValue((Object)info.dept);
        cell = row.getCell(3);
        cell.setValue((Object)info.taxScheme);
        cell = row.getCell(4);
        cell.setValue((Object)info.idCardNo);
        cell = row.getCell(5);
        cell.setValue((Object)info.passportNo);
        cell = row.getCell(6);
        cell.setValue((Object)info.gendar);
        cell = row.getCell(7);
        cell.setValue((Object)info.birthday);
        cell = row.getCell(8);
        cell.setValue((Object)info.basePoint);
        cell = row.getCell(9);
        cell.setValue(null);
    }

    public static QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    private void showTaxHistoryQueryUI() throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        String queryName = loader.getQuery(this.commonQueryDlgQueryPK).getFullName();
        QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
        if (this.isFirstDefaultQuery && solution != null) {
            if (CompUtils.isNullWhere(solution)) {
                try {
                    CustomerParams cp = CustomerParams.getCustomerParams2((String)CompUtils.getCustmerParamsUtil(solution));
                    this.pnlTax = new TaxHistoryQueryPanel();
                    this.pnlTax.setCustomerParams(cp);
                    QueryPanelCollection queryPanelCollection = solution.getQueryPanelInfo();
                    if (queryPanelCollection != null && queryPanelCollection.size() > 0) {
                        int n = queryPanelCollection.size();
                        for (int i = 0; i < n; ++i) {
                            if (this.pnlTax.getMetaDataPK().getFullName().equalsIgnoreCase(queryPanelCollection.get(i).getPanelClassName())) continue;
                            this.customEV = new EntityViewInfo();
                            this.customEV.setFilter(new FilterInfo(solution.getQueryPanelInfo().get(i).getFilterInfo()));
                            break;
                        }
                    }
                    this.display();
                }
                catch (Exception ex) {
                    this.handUIException(ex);
                    this.showFilterDialog();
                }
            } else {
                this.showFilterDialog();
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showFilterDialog();
        }
    }

    private void showFilterDialog() throws Exception {
        if (this.dialog == null) {
            this.dialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.dialog.setOwner((Component)((Object)this));
            }
            this.dialog.setParentUIClassName(TaxHistoryListUI.class.getName());
            this.dialog.setEntityViewInfo(new EntityViewInfo());
            this.dialog.setQueryObjectPK(this.commonQueryDlgQueryPK);
            this.dialog.setShowFilter(true);
            this.dialog.setShowSorter(false);
            this.dialog.setWidth(450);
            this.dialog.setHeight(400);
            this.pnlTax = new TaxHistoryQueryPanel();
            this.dialog.addUserPanel((KDPanel)this.pnlTax);
            this.dialog.setMaxReturnCountVisible(false);
            this.dialog.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.compensation.CmpFilterTitleResource", (String)"TaxHistoryListUI_title"));
        }
        if (this.dialog.show()) {
            this.customEV = null;
            if (this.dialog.getEntityViewInfoResult().getFilter().getMaskString() != null) {
                this.customEV = this.dialog.getEntityViewInfoResult();
            }
            this.display();
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.refresh = false;
        this.oldQueryParam = this.queryParam;
        this.showTaxHistoryQueryUI();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.refresh = true;
        this.display();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }

    protected KDTable getTableForOA() {
        return this.tblList;
    }

    private EntityViewInfo getEntityViewInfo() {
        if (this.customEV == null) {
            this.customEV = new EntityViewInfo();
        }
        return this.customEV;
    }

    static class TaxValue {
        BigDecimal tax;
        BigDecimal taxBase;

        TaxValue() {
        }
    }

    static class HisBaseInfo {
        String personId;
        String number;
        String name;
        String dept;
        String idCardNo;
        String passportNo;
        String gendar;
        String birthday;
        BigDecimal basePoint;
        String taxScheme;

        HisBaseInfo() {
        }

        public boolean equals(Object other) {
            if (!(other instanceof HisBaseInfo)) {
                return false;
            }
            HisBaseInfo hisOther = (HisBaseInfo)other;
            return this.personId.equals(hisOther.personId);
        }

        public int hashCode() {
            return this.personId.hashCode();
        }

        public String toString() {
            return this.personId;
        }
    }
}

