/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.client.AbstractTaxHistoryQueryPanel;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.compensation.util.TaxHistoryQueryUtilParam;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.util.HashSet;

public class TaxHistoryQueryPanel
extends AbstractTaxHistoryQueryPanel {
    private static final String resPrefix = "com.kingdee.eas.hr.compensation.client.TaxSchemeResource";
    private CmpPeriodInfo infoBeginCmpPeriod = null;
    private CmpPeriodInfo infoEndCmpPeriod = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() {
        this.setDisplayFormat();
    }

    public void setDisplayFormat() {
        this.prmtStartPeriod = HRSchemeUtils.getDefaultCmpPeriodF7(this.prmtStartPeriod);
        this.prmtEndPeriod = HRSchemeUtils.getDefaultCmpPeriodF7(this.prmtEndPeriod);
        this.prmtCmpScheme = HRSchemeUtils.getDefaultCmpSchemeF7(this.prmtCmpScheme);
        this.prmtCmpScheme.setEditFormat("$number$");
        this.prmtCmpScheme.setCommitFormat("$number$");
        this.prmtCmpScheme.setDisplayFormat("$name$");
    }

    public Object getParam() {
        TaxHistoryQueryUtilParam param = new TaxHistoryQueryUtilParam();
        if (this.prmtStartPeriod.getData() != null) {
            param.setStartPeriodInfo((CmpPeriodInfo)this.prmtStartPeriod.getData());
        }
        if (this.prmtEndPeriod.getData() != null) {
            param.setEndPeriodInfo((CmpPeriodInfo)this.prmtEndPeriod.getData());
        }
        Object obj = this.prmtCmpScheme.getData();
        param.setCmpSchInfos(obj);
        return param;
    }

    public void setParam(Object param) {
        if (!(param instanceof TaxHistoryQueryUtilParam)) {
            return;
        }
        this.setDisplayFormat();
        TaxHistoryQueryUtilParam taxParam = (TaxHistoryQueryUtilParam)param;
        this.prmtStartPeriod.setData((Object)taxParam.getStartPeriodInfo());
        this.prmtStartPeriod.setText(taxParam.getStartPeriodInfo().getName());
        this.prmtEndPeriod.setData((Object)taxParam.getEndPeriodInfo());
        this.prmtEndPeriod.setText(taxParam.getEndPeriodInfo().getName());
        Object infos = taxParam.getCmpSchInfos();
        if (infos == null) {
            return;
        }
        this.prmtCmpScheme.setData(infos);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtStartPeriod.getData() != null) {
            cp.addCustomerParam("beginCmpPeriod", ((CmpPeriodInfo)this.prmtStartPeriod.getData()).getId().toString());
        }
        if (this.prmtEndPeriod.getData() != null) {
            cp.addCustomerParam("endCmpPeriod", ((CmpPeriodInfo)this.prmtEndPeriod.getData()).getId().toString());
        }
        if (this.prmtCmpScheme.getData() != null) {
            cp.addCustomerParam("CmpScheme", this.getCustomerString());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        ObjectUuidPK pk = null;
        if (cp.getCustomerParam("beginCmpPeriod") != null) {
            pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("beginCmpPeriod")));
            try {
                this.infoBeginCmpPeriod = (CmpPeriodInfo)CmpPeriodFactory.getRemoteInstance().getValue((IObjectPK)pk);
                this.prmtStartPeriod.setData((Object)this.infoBeginCmpPeriod);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (cp.getCustomerParam("endCmpPeriod") != null) {
            pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("endCmpPeriod")));
            try {
                this.infoEndCmpPeriod = (CmpPeriodInfo)CmpPeriodFactory.getRemoteInstance().getValue((IObjectPK)pk);
                this.prmtEndPeriod.setData((Object)this.infoEndCmpPeriod);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (cp.getCustomerParam("CmpScheme") != null) {
            String keyString = cp.getCustomerParam("CmpScheme");
            this.setSchemeInfo(keyString);
        }
        super.setCustomerParams(cp);
    }

    public boolean verify() {
        CmpPeriodInfo startPeriod = (CmpPeriodInfo)this.prmtStartPeriod.getData();
        CmpPeriodInfo endPeriod = (CmpPeriodInfo)this.prmtEndPeriod.getData();
        if (startPeriod == null || endPeriod == null) {
            MsgBox.showInfo((String)EASResource.getString((String)resPrefix, (String)"MUST_SELECT_PERIOD"));
            return false;
        }
        if (startPeriod.getBeginDate() == null || endPeriod.getEndDate() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)resPrefix, (String)"MUST_SELECT_PERIOD"));
            return false;
        }
        try {
            if (!startPeriod.getId().toString().equals(endPeriod.getId().toString()) && HRUtils.getCmpPeriodNumByDateClient(startPeriod, endPeriod) == -1) {
                MsgBox.showInfo((String)EASResource.getString((String)resPrefix, (String)"PERIOD_SEQ_ERROR"));
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object obj = this.prmtCmpScheme.getData();
        if (obj == null) {
            MsgBox.showInfo((String)EASResource.getString((String)resPrefix, (String)"MUST_SELECT_SCHEME"));
            return false;
        }
        return true;
    }

    public void clear() {
        this.prmtCmpScheme.setData(null);
        this.prmtStartPeriod.setData(null);
        this.prmtEndPeriod.setData(null);
    }

    private String getCustomerString() {
        String allListArray = "";
        Object obj = this.prmtCmpScheme.getData();
        allListArray = ((CmpSchemeInfo)obj).getId().toString();
        return allListArray;
    }

    private void setSchemeInfo(String keyString) {
        String[] allStrArray = keyString.split(";");
        String text = "";
        int arrayInt = allStrArray.length;
        HashSet<String> keySet = new HashSet<String>();
        for (int i = 0; i < arrayInt; ++i) {
            keySet.add(allStrArray[i]);
        }
        EntityViewInfo entityViewInfoTmp = new EntityViewInfo();
        FilterInfo fitlerInfoTmp = new FilterInfo();
        fitlerInfoTmp.getFilterItems().add(new FilterItemInfo("id", keySet, CompareType.INCLUDE));
        entityViewInfoTmp.setFilter(fitlerInfoTmp);
        try {
            CmpSchemeCollection cmpSchemeColl = CmpSchemeFactory.getRemoteInstance().getCmpSchemeCollection(entityViewInfoTmp);
            int catalogSize = cmpSchemeColl.size();
            for (int i = 0; i < catalogSize; ++i) {
                CmpSchemeInfo cmpSchemeInfo = cmpSchemeColl.get(i);
                if (i != catalogSize - 1) continue;
            }
            this.prmtCmpScheme.setData((Object)cmpSchemeColl.get(0));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }
}

