/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.FindDialog;
import com.kingdee.eas.framework.client.FindListEvent;
import com.kingdee.eas.framework.client.IFindListListener;
import com.kingdee.eas.framework.client.ListFind;
import com.kingdee.eas.framework.util.StringUtility;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.compensation.CmpFormulaFactory;
import com.kingdee.eas.hr.compensation.CmpFormulaInfo;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.FormulaFacadeFactory;
import com.kingdee.eas.hr.compensation.ICmpFormula;
import com.kingdee.eas.hr.compensation.IFormulaFacade;
import com.kingdee.eas.hr.compensation.ITaxScheme;
import com.kingdee.eas.hr.compensation.TaxSchemeCollection;
import com.kingdee.eas.hr.compensation.TaxSchemeException;
import com.kingdee.eas.hr.compensation.TaxSchemeFactory;
import com.kingdee.eas.hr.compensation.TaxSchemeInfo;
import com.kingdee.eas.hr.compensation.client.AbstractTaxSchemeEditUI;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.emp.IPersonCmp;
import com.kingdee.eas.hr.emp.PersonCmpFactory;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class TaxSchemeEditUI
extends AbstractTaxSchemeEditUI {
    private static Logger logger = Logger.getLogger(TaxSchemeEditUI.class);
    public static final int FIELDTAXNUMBER = 0;
    public static final int FIELDTAXNAME = 1;
    public static final int FIELDTAXBASEPOINT = 2;
    public static final int FIELDISBASICTAXSCHEME = 3;
    public static final int FIELDISCUSTOMFORMUAL = 4;
    public static final int FIELDID = 5;
    public static final int FIELDDEFAULTSCHEME = 6;
    public static final int FIELDCUSTOMFORMULAID = 7;
    public static final int FIELDCUSTOMFORMULANAME = 8;
    public static final int FIELDCUSTOMFORMULANUMBER = 9;
    public static final int CITYID = 10;
    public static final int CUSTOMFORMUALID = 11;
    public static final int CUSTOMFORMUALNAME = 12;
    public static final int CUSTOMFORMUALNUMBER = 13;
    public static final int FIELDPERSONID = 0;
    public static final int FIELDPERSONNUMBER = 1;
    public static final int FIELDPERSONNAME = 2;
    public static final int FIELDPERSONGENDER = 3;
    public static final int FIELDPERSONADMINORG = 4;
    public static final int FIELDPERSONPOSITION = 5;
    public static final int FIELDPERSONCMPTAXNUM = 6;
    public static final int FIELDPERSONCMPTAXNAME = 7;
    public static final int FIELDPERSONCMPID = 9;
    public static final Color REQUIREDBACKGROUND = UIManager.getColor("TextField.requiredBackground");
    private TaxSchemeCollection taxSchemeCollection = new TaxSchemeCollection();
    private TaxSchemeInfo taxSchemeInfo = new TaxSchemeInfo();
    private TaxSchemeInfo taxSchemeInfoForCheck = new TaxSchemeInfo();
    private int taxRowIndex = 0;
    private String cmpFormulaF7URL = "com.kingdee.eas.hr.compensation.app.F7CmpFormulaNewQuery";
    private String taxResourceBasicURL = "com.kingdee.eas.hr.compensation.client.TaxSchemeResource.";
    private ITaxScheme iTaxScheme = null;
    private IPersonCmp iPersonCmp = null;
    static final int OPR_NONE = 0;
    static final int OPR_ADDNEWTAXSCH = 1;
    static final int OPR_MODIFIEDTAXSCH = 2;
    static final int OPR_DELETEDTAXSCH = 3;
    private HashSet personSet = new HashSet();
    private HashSet personDeleteTaxSet = new HashSet();
    private HashMap personDeleteMap = new HashMap();
    private HashSet personModifyTaxSet = new HashSet();
    private String falseFlagString = "0";
    private String trueFlagString = "1";
    private int tabPersonInfoIndex = 1;
    private boolean isModifyPersonFlag = false;
    private String maxNumber = "999999999.99";
    private HROrgUnitInfo hrOrgUnitInfo = null;
    HashMap hsItemInfos = null;
    LanguageInfo lang = new LanguageInfo(SysContext.getSysContext().getLocale());
    private int searcheRowCount = 0;
    private String searchText = null;
    private boolean isMatch = false;
    private FindListEvent preFindListEvent = null;
    private String propertyName = null;
    private FindDialog findDialog = null;
    private static String locateFirst = "Msg_LocateFirst";
    private static String locateLast = "Msg_LocateLast";

    public TaxSchemeEditUI() throws Exception {
        HRSchemeUtils.checkInit();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.setButtonDefaultStyl(this.btnAddNewTaxSch);
        this.setButtonDefaultStyl(this.btnModifyTaxSch);
        this.setButtonDefaultStyl(this.btnDeleteTaxSch);
        this.setButtonDefaultStyl(this.btnAddNewTaxSch);
        this.setButtonDefaultStyl(this.btnPrintView);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnSave);
        this.setButtonDefaultStyl(this.btnRefresh);
        this.btnAddNewTaxSch.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnModifyTaxSch.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnDeleteTaxSch.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnAddPerson.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnRemovePerson.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnLocate.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.btnAddPerson.setText(null);
        this.btnRemovePerson.setText(null);
        this.btnLocate.setText(null);
        this.ctnTaxPerson.addButton((JButton)this.btnAddPerson);
        this.ctnTaxPerson.addButton((JButton)this.btnRemovePerson);
        this.ctnTaxPerson.addButton((JButton)this.btnLocate);
    }

    private HROrgUnitInfo getHROrgUnit() {
        if (this.hrOrgUnitInfo == null) {
            this.hrOrgUnitInfo = HRSchemeUtils.getClientHROrgUnitInfo();
        }
        return this.hrOrgUnitInfo;
    }

    public void initAllEditor() throws ParserException {
        this.kDSplitPane1.setDividerLocation(10000000);
        this.tblMain.checkParsed();
        this.tblPersonMain.checkParsed();
        this.taxSchemeInfo.setOprStatus(0);
        this.txtNumber.setMaxLength(12);
        this.txtName.setMaxLength(50);
        this.bizPromptCmpFormual.setQueryInfo(this.cmpFormulaF7URL);
        this.bizPromptCmpFormual.setEditFormat("$name$");
        this.bizPromptCmpFormual.setDisplayFormat("$name$");
        EntityViewInfo evi = new EntityViewInfo(" where isPublic=1 and hrOrgUnit.id='" + this.getHROrgUnit().getId().toString() + "'");
        this.bizPromptCmpFormual.setEntityViewInfo(evi);
        this.initBasePoinEditor();
        this.initCalEditor();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblPersonMain.getSelectManager().setSelectMode(2);
        this.tblPersonMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(3).getStyleAttributes().setHided(true);
        this.tblMain.getColumn(4).getStyleAttributes().setHided(true);
        this.tblMain.getColumn(5).getStyleAttributes().setHided(true);
        this.tblMain.getColumn(7).getStyleAttributes().setHided(true);
        this.tblMain.getColumn(8).getStyleAttributes().setHided(true);
        this.tblMain.getColumn(9).getStyleAttributes().setHided(true);
        this.tblMain.getColumn(10).getStyleAttributes().setHided(true);
        this.tblMain.getColumn(11).getStyleAttributes().setHided(true);
        this.tblMain.getColumn(12).getStyleAttributes().setHided(true);
        this.tblMain.getColumn(13).getStyleAttributes().setHided(true);
        this.tblPersonMain.getColumn("cmptaxschNum").getStyleAttributes().setHided(true);
        this.tblPersonMain.getColumn("cmptaxschName").getStyleAttributes().setHided(true);
        CmpItemInfo itemInfo = null;
        if (this.hsItemInfos.containsKey("FSAL029")) {
            itemInfo = (CmpItemInfo)this.hsItemInfos.get("FSAL029");
            this.tblMain.getColumn(2).getStyleAttributes().setNumberFormat(HRCmpItemUtils.getColumnFormatStr(itemInfo.getDecDigital()));
        }
        this.txtPersonTax.setSupportedEmpty(true);
        this.txtwageCal.setSupportedEmpty(true);
        this.txtFactCal.setSupportedEmpty(true);
        this.txtShouldPayTaxValue.setSupportedEmpty(true);
        if (this.hsItemInfos.containsKey("FSAL014")) {
            itemInfo = (CmpItemInfo)this.hsItemInfos.get("FSAL014");
            this.txtShouldPayTaxValue.setPrecision(itemInfo.getDecDigital());
        } else {
            this.txtShouldPayTaxValue.setPrecision(2);
        }
        this.txtFactCal.setEnabled(false);
        this.txtPersonTax.setEnabled(false);
        this.txtShouldPayTaxValue.setEnabled(false);
        this.setAllEditorState(false);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock kb = TaxSchemeEditUI.this.tblMain.getSelectManager().get();
                TaxSchemeEditUI.this.txtPersonTax.setText(null);
                TaxSchemeEditUI.this.txtwageCal.setText(null);
                TaxSchemeEditUI.this.txtFactCal.setText(null);
                TaxSchemeEditUI.this.txtShouldPayTaxValue.setText(null);
                TaxSchemeEditUI.this.defaultSchemeBox.setSelected(false);
                TaxSchemeEditUI.this.taxSchemeInfo.setIsChange(TaxSchemeEditUI.this.checkDoProcess());
                if (TaxSchemeEditUI.this.taxSchemeInfo.getIsChange()) {
                    TaxSchemeEditUI.this.doChangedProcess();
                }
                if (TaxSchemeEditUI.this.taxSchemeInfo.getOprStatus() != 1) {
                    TaxSchemeEditUI.this.btnModifyTaxSch.setEnabled(true);
                }
                TaxSchemeEditUI.this.taxSchemeInfo.setOprStatus(0);
                TaxSchemeEditUI.this.isModifyPersonFlag = false;
                TaxSchemeEditUI.this.btnSave.setEnabled(false);
                TaxSchemeEditUI.this.clearAllSet();
                int currRowIndex = -1;
                if (kb != null) {
                    currRowIndex = kb.getTop();
                }
                TaxSchemeEditUI.this.taxRowIndex = currRowIndex;
                IRow currRow = TaxSchemeEditUI.this.tblMain.getRow(currRowIndex);
                if (currRow == null) {
                    return;
                }
                ICell cellNumber = currRow.getCell(0);
                ICell cellName = currRow.getCell(1);
                ICell cellBasePoint = currRow.getCell(2);
                ICell cellDefaultScheme = currRow.getCell(6);
                TaxSchemeEditUI.this.txtNumber.setText(cellNumber.getValue().toString());
                TaxSchemeEditUI.this.txtBasePoint.setValue((Object)Double.valueOf(cellBasePoint.getValue().toString()));
                TaxSchemeEditUI.this.txtwageCal.setValue(null);
                TaxSchemeEditUI.this.defaultSchemeBox.setSelected(Boolean.valueOf(cellDefaultScheme.getValue().toString()).booleanValue());
                if (cellName.getValue() != null) {
                    LanguageInfo lang = null;
                    List list = KDBizMultiLangBox.getLanguageList();
                    int size = list.size();
                    for (int i = 0; i < size; ++i) {
                        lang = (LanguageInfo)list.get(i);
                        TaxSchemeEditUI.this.txtName.setItemData(lang, (Object)cellName.getValue().toString());
                    }
                }
                ICell cellIsBasisTax = currRow.getCell(3);
                ICell cellIsCutTax = currRow.getCell(4);
                TaxSchemeEditUI.this.setAllEditorState(false);
                if (cellIsBasisTax.getValue().toString().equals(TaxSchemeEditUI.this.trueFlagString) && cellIsCutTax.getValue().toString().equals(TaxSchemeEditUI.this.falseFlagString)) {
                    TaxSchemeEditUI.this.btnBasicScheme.setSelected(true);
                    TaxSchemeEditUI.this.btnCustomScheme.setSelected(false);
                    TaxSchemeEditUI.this.chkOnlyOnePayYear.setSelected(false);
                    TaxSchemeEditUI.this.bizPromptCmpFormual.setText(null);
                } else if (cellIsBasisTax.getValue().toString().equals(TaxSchemeEditUI.this.falseFlagString) && cellIsCutTax.getValue().toString().equals(TaxSchemeEditUI.this.falseFlagString)) {
                    TaxSchemeEditUI.this.btnBasicScheme.setSelected(false);
                    TaxSchemeEditUI.this.btnCustomScheme.setSelected(false);
                    TaxSchemeEditUI.this.chkOnlyOnePayYear.setSelected(true);
                    TaxSchemeEditUI.this.bizPromptCmpFormual.setText(null);
                } else if (cellIsBasisTax.getValue().toString().equals(TaxSchemeEditUI.this.falseFlagString) && cellIsCutTax.getValue().toString().equals(TaxSchemeEditUI.this.trueFlagString)) {
                    TaxSchemeEditUI.this.btnBasicScheme.setSelected(false);
                    TaxSchemeEditUI.this.btnCustomScheme.setSelected(true);
                    TaxSchemeEditUI.this.chkOnlyOnePayYear.setSelected(false);
                    ICell cellIsCustomFormulaNum = currRow.getCell(9);
                    if (cellIsCustomFormulaNum.getValue() != null) {
                        if (TaxSchemeEditUI.this.getCurrRowFormulaInfo(TaxSchemeEditUI.this.taxRowIndex) != null) {
                            TaxSchemeEditUI.this.bizPromptCmpFormual.setData((Object)TaxSchemeEditUI.this.getCurrRowFormulaInfo(TaxSchemeEditUI.this.taxRowIndex));
                        }
                        String displayString = cellIsCustomFormulaNum.getValue().toString();
                        TaxSchemeEditUI.this.bizPromptCmpFormual.setText(displayString);
                    }
                }
                ICell cellIsTaxSchemeID = currRow.getCell(5);
                if (cellIsTaxSchemeID.getValue() != null) {
                    TaxSchemeEditUI.this.loadPersonCmpFields(cellIsTaxSchemeID.getValue().toString(), true);
                }
            }
        });
    }

    private void clearAllSet() {
        this.personSet.clear();
        this.personDeleteTaxSet.clear();
        this.personDeleteMap.clear();
        this.personModifyTaxSet.clear();
    }

    protected void doChangedProcess() {
        if (this.taxSchemeInfo != null && this.taxSchemeInfo.getIsChange()) {
            this.taxSchemeInfo.setIsChange(false);
            int result = 0;
            if (this.taxSchemeInfo.getOprStatus() == 1) {
                result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)(this.taxResourceBasicURL + "Confirm_SaveNew_Exit")));
            } else if (this.taxSchemeInfo.getOprStatus() == 2) {
                result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)(this.taxResourceBasicURL + "Confirm_Save_Exit")));
            }
            if (result == 0) {
                try {
                    this.submit();
                    this.setMessageText(EASResource.getString((String)(this.taxResourceBasicURL + "SAVE_SUCCEED")));
                    this.showMessage();
                }
                catch (Exception exc) {
                    this.handUIException(exc);
                }
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
    }

    protected boolean checkBeforeWindowClosing() {
        if (this.checkDoProcess()) {
            this.doChangedProcess();
        }
        return super.checkBeforeWindowClosing();
    }

    private void setAllEditorState(boolean editorState) {
        this.txtName.setEnabled(editorState);
        this.txtNumber.setEnabled(editorState);
        this.txtBasePoint.setEnabled(editorState);
        this.btnBasicScheme.setEnabled(editorState);
        this.btnCustomScheme.setEnabled(editorState);
        this.bizPromptCmpFormual.setEnabled(editorState);
        this.btnAddPerson.setEnabled(editorState);
        this.btnRemovePerson.setEnabled(editorState);
        this.btnSave.setEnabled(editorState);
        this.chkOnlyOnePayYear.setEnabled(editorState);
        this.defaultSchemeBox.setEnabled(editorState);
    }

    private ITaxScheme getBizTaxSchInterface() throws BOSException {
        if (this.iTaxScheme == null) {
            this.iTaxScheme = TaxSchemeFactory.getRemoteInstance();
        }
        return this.iTaxScheme;
    }

    private IPersonCmp getBizPersonCmpInterface() throws BOSException {
        if (this.iPersonCmp == null) {
            this.iPersonCmp = PersonCmpFactory.getRemoteInstance();
        }
        return this.iPersonCmp;
    }

    private void setCtrlState() {
        if (this.tblMain.getRowCount() > 0) {
            this.btnModifyTaxSch.setEnabled(true);
        } else {
            this.btnModifyTaxSch.setEnabled(false);
        }
        if (this.taxSchemeInfo.getOprStatus() == 1) {
            this.btnModifyTaxSch.setEnabled(false);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.loadTaxSchemeFields();
        this.setCtrlState();
    }

    public void loadPersonCmpFields(String taxSchemeId, boolean isSelected) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfoPosition = new FilterInfo();
        filterInfoPosition.getFilterItems().add(new FilterItemInfo("PM.isPrimary", null));
        filterInfoPosition.getFilterItems().add(new FilterItemInfo("PM.isPrimary", (Object)"1"));
        filterInfoPosition.setMaskString("#0 or #1");
        FilterInfo filterInfo = new FilterInfo();
        if (this.taxSchemeInfo.getOprStatus() != 1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TexScheme.id", (Object)taxSchemeId));
            String filterString = "#0";
            if (!isSelected && this.personSet.size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.personSet, CompareType.INCLUDE));
                filterString = "#0 or #1";
            }
            filterInfo.setMaskString(filterString);
        } else if (this.personSet.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.personSet, CompareType.INCLUDE));
            filterInfo.setMaskString("#0");
        } else {
            return;
        }
        try {
            filterInfo.mergeFilter(filterInfoPosition, "AND");
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        entityViewInfo.setFilter(filterInfo);
        this.cmpPersonTexSchemeQuery = entityViewInfo;
        this.tblPersonMain.removeRows();
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private void loadTaxSchemeFields() {
        EntityViewInfo entityViewTaxSchInfo = new EntityViewInfo();
        entityViewTaxSchInfo.getSelector().add(new SelectorItemInfo("id"));
        entityViewTaxSchInfo.getSelector().add(new SelectorItemInfo("number"));
        entityViewTaxSchInfo.getSelector().add(new SelectorItemInfo("name"));
        entityViewTaxSchInfo.getSelector().add(new SelectorItemInfo("basepoint"));
        entityViewTaxSchInfo.getSelector().add(new SelectorItemInfo("isbasictaxscheme"));
        entityViewTaxSchInfo.getSelector().add(new SelectorItemInfo("iscustomformual"));
        entityViewTaxSchInfo.getSelector().add(new SelectorItemInfo("defaultscheme"));
        entityViewTaxSchInfo.getSelector().add(new SelectorItemInfo("customformual.id"));
        entityViewTaxSchInfo.getSelector().add(new SelectorItemInfo("customformual.name"));
        entityViewTaxSchInfo.getSelector().add(new SelectorItemInfo("customformual.number"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getHROrgUnit().getId().toString()));
        entityViewTaxSchInfo.setFilter(filterInfo);
        try {
            this.taxSchemeCollection = this.getBizTaxSchInterface().getTaxSchemeCollection(entityViewTaxSchInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.tblMain.removeRows();
        int countCycle = this.taxSchemeCollection.size();
        for (int i = 0; i < countCycle; ++i) {
            TaxSchemeInfo taxSchemeInfoForCycle = this.taxSchemeCollection.get(i);
            IRow detailRow = this.tblMain.addRow();
            this.loadTaxSchTableRow(taxSchemeInfoForCycle, detailRow);
        }
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    private void loadTaxSchTableRow(TaxSchemeInfo taxSchemeInfoTemp, IRow detailTaxSchRow) {
        detailTaxSchRow.setUserObject((Object)taxSchemeInfoTemp);
        detailTaxSchRow.getCell(0).setValue((Object)taxSchemeInfoTemp.getNumber());
        detailTaxSchRow.getCell(1).setValue((Object)taxSchemeInfoTemp.getName());
        detailTaxSchRow.getCell(2).setValue((Object)taxSchemeInfoTemp.getBasePoint());
        detailTaxSchRow.getCell(3).setValue((Object)this.convertBoolVarToNum(taxSchemeInfoTemp.isIsBasicTaxScheme()));
        detailTaxSchRow.getCell(4).setValue((Object)this.convertBoolVarToNum(taxSchemeInfoTemp.isIsCustomFormual()));
        detailTaxSchRow.getCell(5).setValue((Object)taxSchemeInfoTemp.getId());
        detailTaxSchRow.getCell(6).setValue((Object)new Boolean(taxSchemeInfoTemp.isDefaultScheme()));
        CmpFormulaInfo CmpFormulaInfo2 = taxSchemeInfoTemp.getCustomFormual();
        if (CmpFormulaInfo2 != null) {
            detailTaxSchRow.getCell(7).setValue((Object)CmpFormulaInfo2.getId());
            detailTaxSchRow.getCell(8).setValue((Object)CmpFormulaInfo2.getName());
            detailTaxSchRow.getCell(9).setValue((Object)CmpFormulaInfo2.getNumber());
        }
    }

    private String convertBoolVarToNum(boolean boolVar) {
        if (boolVar) {
            return "1";
        }
        return "0";
    }

    @Override
    protected void btnBasicScheme_stateChanged(ChangeEvent e) throws Exception {
        super.btnBasicScheme_stateChanged(e);
        if (this.btnBasicScheme.isSelected()) {
            this.bizPromptCmpFormual.setText(null);
            this.bizPromptCmpFormual.setEnabled(false);
            this.txtShouldPayTaxValue.setEnabled(false);
        }
    }

    @Override
    protected void chkOnlyOnePayYear_stateChanged(ChangeEvent e) throws Exception {
        super.chkOnlyOnePayYear_stateChanged(e);
        if (this.chkOnlyOnePayYear.isSelected()) {
            this.bizPromptCmpFormual.setText(null);
            this.bizPromptCmpFormual.setEnabled(false);
            this.txtShouldPayTaxValue.setEnabled(true);
        }
    }

    @Override
    protected void btnCustomScheme_stateChanged(ChangeEvent e) throws Exception {
        super.btnCustomScheme_stateChanged(e);
        if (this.btnCustomScheme.isSelected()) {
            this.bizPromptCmpFormual.setEditFormat("$number$");
            this.bizPromptCmpFormual.setDisplayFormat("$number$");
            if (this.taxSchemeInfo.getOprStatus() == 0) {
                this.bizPromptCmpFormual.setEnabled(false);
            } else {
                this.bizPromptCmpFormual.setEnabled(true);
            }
            if (this.taxSchemeInfo.getOprStatus() == 2) {
                ICell cellCmpFormulaIsBasicTaxSch = this.tblMain.getRow(this.taxRowIndex).getCell(3);
                String flagOfIsBasicTaxSch = cellCmpFormulaIsBasicTaxSch.getValue().toString();
                ICell cellCmpFormulaIsCustomTaxSch = this.tblMain.getRow(this.taxRowIndex).getCell(4);
                String flagOfIsCustomTaxSch = cellCmpFormulaIsCustomTaxSch.getValue().toString();
                if (flagOfIsBasicTaxSch.equals(this.falseFlagString) && flagOfIsCustomTaxSch.equals(this.trueFlagString)) {
                    CmpFormulaInfo cmpFormulaInfoTmp = this.getCurrRowFormulaInfo(this.taxRowIndex);
                    this.bizPromptCmpFormual.setText(cmpFormulaInfoTmp.getNumber());
                    this.bizPromptCmpFormual.setData((Object)cmpFormulaInfoTmp);
                    this.bizPromptCmpFormual.setEditable(false);
                }
            }
            this.txtShouldPayTaxValue.setEnabled(false);
        }
    }

    private boolean checkDoProcess() {
        if (this.taxSchemeInfo.getOprStatus() == 0) {
            return false;
        }
        if (this.isModifyPersonFlag) {
            return true;
        }
        String numberText = this.txtNumber.getText();
        String nameText = (String)this.txtName.getItemBy(this.lang).getData();
        Double taxBasePoint = this.txtBasePoint.getDoubleValue();
        boolean radioButtonFlag = false;
        if (this.btnBasicScheme.isSelected()) {
            radioButtonFlag = true;
        }
        if (this.taxSchemeInfoForCheck.getOprStatus() == 1) {
            if (numberText.trim() != null && !numberText.trim().equals("")) {
                return true;
            }
            if (nameText != null && !nameText.trim().equals("")) {
                return true;
            }
            if (!taxBasePoint.equals(new Double(0.0))) {
                return true;
            }
            if (this.taxSchemeInfoForCheck.isIsBasicTaxScheme() != radioButtonFlag) {
                return true;
            }
        }
        if (this.taxSchemeInfoForCheck.getOprStatus() == 2) {
            if (!this.taxSchemeInfoForCheck.getNumber().equals(numberText)) {
                return true;
            }
            if (!this.taxSchemeInfoForCheck.getName().equals(nameText)) {
                return true;
            }
            if (!this.taxSchemeInfoForCheck.getBasePoint().equals(new BigDecimal(taxBasePoint.toString()))) {
                return true;
            }
            if (this.taxSchemeInfoForCheck.isIsBasicTaxScheme() != radioButtonFlag) {
                return true;
            }
        }
        return false;
    }

    private void initBasePoinEditor() {
        String initBasePointString = "0";
        this.txtBasePoint.setDataType(1);
        this.txtBasePoint.setNumberValue((Number)new BigDecimal(initBasePointString));
        CmpItemInfo itemInfo = null;
        if (this.hsItemInfos.containsKey("FSAL029")) {
            itemInfo = (CmpItemInfo)this.hsItemInfos.get("FSAL029");
            this.txtBasePoint.setPrecision(itemInfo.getDecDigital());
        } else {
            this.txtBasePoint.setPrecision(2);
        }
    }

    private void initCalEditor() {
        this.txtFactCal.setDataType(1);
        this.txtwageCal.setDataType(1);
        this.txtwageCal.setPrecision(2);
        this.txtPersonTax.setDataType(1);
    }

    private void verifyInput() throws Exception {
        if (this.taxSchemeInfo.getOprStatus() == 3 || this.taxSchemeInfo.getOprStatus() == 2) {
            ICell cellTaxSchemePk = this.tblMain.getRow(this.taxRowIndex).getCell(5);
            this.taxSchemeInfo.setId((BOSUuid)cellTaxSchemePk.getValue());
            if (this.taxSchemeInfo.getOprStatus() == 3) {
                return;
            }
        }
        String txtNameString = (String)this.txtName.getItemBy(this.lang).getData();
        String txtNumberString = this.txtNumber.getText().trim();
        String basePointNum = this.txtBasePoint.getDoubleValue().toString();
        if (txtNumberString != null && !txtNumberString.equals("")) {
            if (this.getBizTaxSchInterface().existNumber(txtNumberString, this.taxSchemeInfo.getId())) {
                this.txtNumber.requestFocusInWindow();
                throw new TaxSchemeException(TaxSchemeException.MISS_NUMBER);
            }
        } else {
            this.txtNumber.requestFocusInWindow();
            throw new TaxSchemeException(TaxSchemeException.MISS_NUMBER);
        }
        this.taxSchemeInfo.setNumber(txtNumberString);
        if (txtNameString != null && !txtNameString.equals("")) {
            if (this.getBizTaxSchInterface().existName(txtNameString, this.taxSchemeInfo.getId())) {
                this.txtName.requestFocusInWindow();
                throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{txtNameString});
            }
        } else {
            this.txtName.requestFocusInWindow();
            throw new TaxSchemeException(TaxSchemeException.MISS_NAME);
        }
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)this.taxSchemeInfo, (String)"name");
        Double maxTax = new Double(this.maxNumber);
        if (basePointNum != null) {
            Double maxTaxInput = this.txtBasePoint.getDoubleValue();
            if (maxTaxInput.compareTo(maxTax) == 1) {
                throw new TaxSchemeException(TaxSchemeException.MAX_BASEPOINT);
            }
            CmpItemInfo itemInfo = null;
            if (this.hsItemInfos.containsKey("FSAL029")) {
                itemInfo = (CmpItemInfo)this.hsItemInfos.get("FSAL029");
                this.taxSchemeInfo.setBasePoint(HRCmpItemUtils.convertPrecisionForBigDecimal(new BigDecimal(basePointNum), itemInfo.getDecDigital(), itemInfo.getPrecisionType()));
            } else {
                this.taxSchemeInfo.setBasePoint(new BigDecimal(basePointNum));
            }
        } else {
            throw new TaxSchemeException(TaxSchemeException.MISS_BASEPOINT);
        }
        this.taxSchemeInfo.setHrOrgUnit(this.getHROrgUnit());
        if (this.btnBasicScheme.isSelected()) {
            this.taxSchemeInfo.setIsBasicTaxScheme(true);
            this.taxSchemeInfo.setIsCustomFormual(false);
            this.taxSchemeInfo.setCustomFormual(null);
        } else if (this.btnCustomScheme.isSelected()) {
            Object objFormula = this.bizPromptCmpFormual.getData();
            if (objFormula == null) {
                throw new TaxSchemeException(TaxSchemeException.MISS_FORMULA);
            }
            this.taxSchemeInfo.setIsBasicTaxScheme(false);
            this.taxSchemeInfo.setIsCustomFormual(true);
            CmpFormulaInfo cmpFormulaInfo = (CmpFormulaInfo)objFormula;
            this.taxSchemeInfo.setCustomFormual(cmpFormulaInfo);
        } else if (this.chkOnlyOnePayYear.isSelected()) {
            this.taxSchemeInfo.setIsBasicTaxScheme(false);
            this.taxSchemeInfo.setIsCustomFormual(false);
            this.taxSchemeInfo.setCustomFormual(null);
        }
        if (this.defaultSchemeBox.isSelected()) {
            ITaxScheme taxScheme = TaxSchemeFactory.getRemoteInstance();
            TaxSchemeCollection taxSchemeCol = null;
            taxSchemeCol = this.taxSchemeInfo.getId() == null ? taxScheme.getTaxSchemeCollection("select id where defaultScheme =1 and hrOrgUnit.id='" + this.getHROrgUnit().getId().toString() + "'") : taxScheme.getTaxSchemeCollection("select id where defaultScheme =1 and hrOrgUnit.id='" + this.getHROrgUnit().getId().toString() + "' and id !='" + this.taxSchemeInfo.getId() + "'");
            if (taxSchemeCol != null && taxSchemeCol.size() > 0) {
                this.defaultSchemeBox.requestFocusInWindow();
                MsgBox.showInfo((String)EASResource.getString((String)(this.taxResourceBasicURL + "DEFAULT_SCHEME_EXIST")));
                this.abort();
            }
            this.taxSchemeInfo.setDefaultScheme(true);
        } else {
            this.taxSchemeInfo.setDefaultScheme(false);
        }
    }

    public void submitPerson() throws Exception {
        Object pk = null;
        int flagUpdateCmpPersonTaxSch = 1;
        int flagDeleteCmpPersonTaxSch = 2;
        if (!this.personModifyTaxSet.isEmpty()) {
            this.taxSchemeInfo.put("personModifyTaxSet", this.personModifyTaxSet);
            this.getBizTaxSchInterface().updatePersonCmp((IObjectValue)this.taxSchemeInfo, flagUpdateCmpPersonTaxSch);
        }
        if (!this.personDeleteTaxSet.isEmpty()) {
            this.taxSchemeInfo.put("personDeleteTaxSet", this.personDeleteTaxSet);
            this.getBizTaxSchInterface().updatePersonCmp((IObjectValue)this.taxSchemeInfo, flagDeleteCmpPersonTaxSch);
        }
    }

    public void submit() throws Exception {
        this.verifyInput();
        ObjectUuidPK pk = null;
        if (this.taxSchemeInfo.getOprStatus() == 1) {
            this.taxSchemeInfo.put("personSet", this.personSet);
            this.getBizTaxSchInterface().addnew((CoreBaseInfo)this.taxSchemeInfo);
            this.setAddNewUI();
            this.taxSchemeInfo.setIsChange(false);
            return;
        }
        if (this.taxSchemeInfo.getOprStatus() == 2) {
            pk = new ObjectUuidPK(this.taxSchemeInfo.getId());
            this.getBizTaxSchInterface().update((IObjectPK)pk, (CoreBaseInfo)this.taxSchemeInfo);
            this.submitPerson();
            this.taxSchemeInfo.setOprStatus(0);
            this.loadFields();
            this.taxSchemeInfo.setIsChange(false);
            return;
        }
        if (this.taxSchemeInfo.getOprStatus() == 3) {
            pk = new ObjectUuidPK(this.taxSchemeInfo.getId());
            this.getBizTaxSchInterface().delete((IObjectPK)pk);
            this.taxSchemeInfo.setOprStatus(0);
            this.loadFields();
            return;
        }
    }

    private void setAddNewUI() {
        this.taxSchemeInfo = new TaxSchemeInfo();
        this.taxSchemeInfo.setIsChange(true);
        this.taxSchemeInfo.setOprStatus(1);
        this.taxSchemeInfoForCheck.setOprStatus(1);
        this.txtNumber.setText(null);
        UIHelper.loadMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)this.taxSchemeInfo, (String)"name");
        this.taxSchemeInfo.setName(null);
        this.initBasePoinEditor();
        this.btnBasicScheme.setSelected(true);
        this.defaultSchemeBox.setSelected(false);
        this.bizPromptCmpFormual.setData(null);
        this.bizPromptCmpFormual.setText(null);
        this.setAllEditorState(true);
        this.bizPromptCmpFormual.setEnabled(false);
        this.cmpPersonTexSchemeQuery = null;
        this.tblPersonMain.removeRows();
        this.clearAllSet();
        this.btnModifyTaxSch.setEnabled(false);
        this.loadDataToTaxInfo();
    }

    private void loadDataToTaxInfo() {
        String numberText = this.txtNumber.getText();
        String nameText = (String)this.txtName.getItemBy(this.lang).getData();
        Double taxBasePoint = this.txtBasePoint.getDoubleValue();
        this.taxSchemeInfoForCheck.setNumber(numberText);
        this.taxSchemeInfoForCheck.setName(nameText);
        CmpItemInfo itemInfo = null;
        if (this.hsItemInfos.containsKey("FSAL029")) {
            itemInfo = (CmpItemInfo)this.hsItemInfos.get("FSAL029");
            this.taxSchemeInfoForCheck.setBasePoint(HRCmpItemUtils.convertPrecisionForBigDecimal(new BigDecimal(taxBasePoint.toString()), itemInfo.getDecDigital(), itemInfo.getPrecisionType()));
        } else {
            this.taxSchemeInfoForCheck.setBasePoint(new BigDecimal(taxBasePoint.toString()));
        }
        if (this.btnBasicScheme.isSelected()) {
            this.taxSchemeInfoForCheck.setIsBasicTaxScheme(true);
        } else {
            this.taxSchemeInfoForCheck.setIsBasicTaxScheme(false);
        }
    }

    public void onLoad() throws Exception {
        this.hsItemInfos = HRCmpItemUtils.getCmpItemInfoByNumber(null, new String[]{"FSAL029", "FSAL014"});
        super.onLoad();
        this.initAllEditor();
        this.loadFields();
        if (this.tblMain.getRowCount() > 0 && this.tblMain.getColumnCount() > 0) {
            this.tblMain.getEditManager().editCellAt(0, 0);
        }
        this.taxSchemeInfo.setOprStatus(0);
        this.kDSplitPane1.setDividerLocation(280);
        this.setTableHeadSortable(this.tblPersonMain);
        if (!OprtState.VIEW.equals(this.getOprtState())) {
            this.actionLocate.setEnabled(true);
        }
    }

    private void setTableHeadSortable(KDTable table) {
        table.checkParsed();
        KDTSortManager sortManager = new KDTSortManager(table);
        int size = table.getColumnCount();
        for (int i = 0; i < size; ++i) {
            table.getColumn(i).setSortable(true);
        }
        sortManager.setSortAuto(true);
    }

    @Override
    public void actionRemovePerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemovePerson_actionPerformed(e);
        this.taxSchemeInfo.setIsChange(true);
        KDTSelectBlock kb = this.tblPersonMain.getSelectManager().get();
        if (kb != null) {
            int currPersonRowIndex = kb.getTop();
            ICell cellForPersonDelete = this.tblPersonMain.getRow(currPersonRowIndex).getCell(0);
            ICell cellForPersonCmpDelete = this.tblPersonMain.getRow(currPersonRowIndex).getCell(9);
            this.personSet.remove(cellForPersonDelete.getValue());
            if (!this.personDeleteTaxSet.contains(cellForPersonDelete.getValue())) {
                this.personDeleteTaxSet.add(cellForPersonDelete.getValue());
                this.personDeleteMap.put(cellForPersonDelete.getValue().toString(), cellForPersonCmpDelete.getValue());
            }
            this.isModifyPersonFlag = true;
            this.tblPersonMain.removeRow(currPersonRowIndex);
        }
    }

    @Override
    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddPerson_actionPerformed(e);
        this.taxSchemeInfo.setIsChange(true);
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox();
        pmt.setModal(true);
        pmt.showOnlyPayPerson(true);
        pmt.setIsSingleSelect(false);
        pmt.showNoPositionPerson(true);
        pmt.show();
        String currTaxSchemeID = null;
        if (this.taxSchemeInfo.getOprStatus() != 1) {
            ICell cellIsTaxSchemeID = this.tblMain.getRow(this.taxRowIndex).getCell(5);
            currTaxSchemeID = cellIsTaxSchemeID.getValue().toString();
        }
        if (!pmt.isCanceled()) {
            if (pmt.getData() instanceof Object[]) {
                Object[] obj = (Object[])pmt.getData();
                PersonInfo selectedPersonInfo = null;
                int length = obj.length;
                for (int i = 0; i < length; ++i) {
                    selectedPersonInfo = (PersonInfo)obj[i];
                    if (this.isSamePerson(selectedPersonInfo)) continue;
                    BOSUuid objSelectPersonInfoId = selectedPersonInfo.getId();
                    this.personSet.add(objSelectPersonInfoId.toString());
                    this.personModifyTaxSet.add(objSelectPersonInfoId.toString());
                    if (!this.personDeleteTaxSet.contains(objSelectPersonInfoId.toString())) continue;
                    this.personDeleteTaxSet.remove(objSelectPersonInfoId.toString());
                    this.personDeleteMap.remove(objSelectPersonInfoId.toString());
                }
            }
            HashSet personSetTemp = this.personSet;
            this.isModifyPersonFlag = true;
            int allPresonNumber = this.personSet.size();
            this.personSet = this.getBizTaxSchInterface().getPersonCmpMap(this.personSet);
            int cmpPersonNumber = this.personSet.size();
            if (allPresonNumber != cmpPersonNumber) {
                String showStr = HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.compensation.client.TaxSchemeResource", (String)"", (String[])new String[]{String.valueOf(allPresonNumber), String.valueOf(cmpPersonNumber)});
                MsgBox.showInfo((String)showStr);
            }
            if (cmpPersonNumber != 0) {
                this.loadPersonCmpFields(currTaxSchemeID, false);
            }
            this.personSet = personSetTemp;
        }
    }

    private boolean isSamePerson(PersonInfo personInfo) {
        boolean isSamePerson = false;
        if (this.personSet.isEmpty()) {
            return isSamePerson;
        }
        if (this.personSet.contains(personInfo.getId())) {
            isSamePerson = true;
        }
        return isSamePerson;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        CmpFormulaInfo cmpFormulaInfoTemp;
        Object obj;
        super.actionCalculate_actionPerformed(e);
        Double wageCal = this.txtwageCal.getDoubleValue();
        String varWege = "FSAL027";
        String varBasePoint = "FSAL029";
        String varRtn = "FSAL007";
        IFormulaFacade iFormulaFacade = FormulaFacadeFactory.getRemoteInstance();
        if (wageCal == null) {
            throw new TaxSchemeException(TaxSchemeException.MISS_WEGECAL);
        }
        Double maxWega = new Double(this.maxNumber);
        if (wageCal.compareTo(maxWega) == 1) {
            throw new TaxSchemeException(TaxSchemeException.MAX_WEGA);
        }
        int percision = 2;
        String strTaxFormula = null;
        if (this.taxSchemeInfo.getOprStatus() != 1) {
            if (this.tblMain.getRowCount() > 0) {
                ICell cellCalBasic = this.tblMain.getRow(this.taxRowIndex).getCell(3);
                ICell cellCalCut = this.tblMain.getRow(this.taxRowIndex).getCell(4);
                if (cellCalBasic.getValue().equals("1") && cellCalCut.getValue().equals("0")) {
                    strTaxFormula = iFormulaFacade.getTaxFormula();
                } else if (cellCalBasic.getValue().equals("0") && cellCalCut.getValue().equals("1")) {
                    ICell cellCalculateFormualId = this.tblMain.getRow(this.taxRowIndex).getCell(7);
                    ObjectUuidPK formualPk = new ObjectUuidPK(cellCalculateFormualId.getValue().toString());
                    ICmpFormula iCmpFormula = CmpFormulaFactory.getRemoteInstance();
                    CmpFormulaInfo cmpFormulaInfoTemp2 = iCmpFormula.getCmpFormulaInfo((IObjectPK)formualPk);
                    strTaxFormula = cmpFormulaInfoTemp2.getFormula();
                } else if (cellCalBasic.getValue().equals("0") && cellCalCut.getValue().equals("0")) {
                    strTaxFormula = iFormulaFacade.getPrizeYearTax();
                    this.extendCalTaxYear(strTaxFormula);
                    return;
                }
            } else if (this.btnCustomScheme.isSelected()) {
                obj = this.bizPromptCmpFormual.getData();
                if (obj == null) throw new TaxSchemeException(TaxSchemeException.MISS_FORMULA);
                cmpFormulaInfoTemp = (CmpFormulaInfo)obj;
                strTaxFormula = cmpFormulaInfoTemp.getFormula();
            } else if (this.btnBasicScheme.isSelected()) {
                strTaxFormula = iFormulaFacade.getTaxFormula();
            } else if (this.chkOnlyOnePayYear.isSelected()) {
                strTaxFormula = iFormulaFacade.getPrizeYearTax();
                this.extendCalTaxYear(strTaxFormula);
                return;
            }
        } else if (this.btnCustomScheme.isSelected()) {
            obj = this.bizPromptCmpFormual.getData();
            if (obj == null) throw new TaxSchemeException(TaxSchemeException.MISS_FORMULA);
            cmpFormulaInfoTemp = (CmpFormulaInfo)obj;
            strTaxFormula = cmpFormulaInfoTemp.getFormula();
        } else if (this.btnBasicScheme.isSelected()) {
            strTaxFormula = iFormulaFacade.getTaxFormula();
        } else if (this.chkOnlyOnePayYear.isSelected()) {
            strTaxFormula = iFormulaFacade.getPrizeYearTax();
            this.extendCalTaxYear(strTaxFormula);
            return;
        }
        HashMap<String, Double> contextFormula = new HashMap<String, Double>();
        Double basePointCal = this.txtBasePoint.getDoubleValue();
        if (Double.compare(wageCal, basePointCal) < 0) {
            // empty if block
        }
        contextFormula.put(varWege, wageCal);
        contextFormula.put(varBasePoint, basePointCal);
        Interpreter interpreter = new Interpreter();
        try {
            Object rtnVal = interpreter.eval(strTaxFormula, contextFormula);
            BigDecimal rtnValTemp = new BigDecimal(contextFormula.get(varRtn).toString());
            rtnValTemp = rtnValTemp.setScale(percision, 4);
            BigDecimal wageCalTemp = new BigDecimal(wageCal.toString());
            wageCalTemp = wageCalTemp.setScale(percision, 4);
            BigDecimal factCalVal = wageCalTemp.subtract(rtnValTemp);
            factCalVal = factCalVal.setScale(percision, 4);
            this.txtPersonTax.setPrecision(2);
            this.txtPersonTax.setNumberValue((Number)rtnValTemp.setScale(2, 4));
            this.txtFactCal.setPrecision(2);
            this.txtFactCal.setNumberValue((Number)factCalVal.setScale(2, 4));
            BigDecimal basePointTemp = new BigDecimal(basePointCal.toString());
            BigDecimal shouldPayTaxValue = wageCalTemp.subtract(basePointTemp);
            if (shouldPayTaxValue.compareTo(BigDecimal.ZERO) < 0) {
                this.txtShouldPayTaxValue.setNumberValue((Number)BigDecimal.ZERO);
                return;
            } else {
                this.txtShouldPayTaxValue.setNumberValue((Number)shouldPayTaxValue.setScale(2, 4));
            }
            return;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
            throw new TaxSchemeException(TaxSchemeException.CAL_ERROR);
        }
    }

    private void extendCalTaxYear(String formulaStr) throws Exception {
        int percision = 2;
        String varRtn = "FSAL007";
        String OwenValue = "FSAL014";
        HashMap<String, Double> contextFormula = new HashMap<String, Double>();
        Double wageCal = this.txtwageCal.getDoubleValue();
        Double shouldPayTaxValue = this.txtShouldPayTaxValue.getDoubleValue();
        if (shouldPayTaxValue == null) {
            throw new TaxSchemeException(TaxSchemeException.MISS_SHOULDTAX);
        }
        if (shouldPayTaxValue.compareTo(new Double(this.maxNumber)) == 1) {
            throw new TaxSchemeException(TaxSchemeException.MAX_SHOULDTAX);
        }
        contextFormula.put(OwenValue, shouldPayTaxValue);
        Interpreter interpreter = new Interpreter();
        try {
            Object rtnVal = interpreter.eval(formulaStr, contextFormula);
            BigDecimal rtnValTemp = new BigDecimal(contextFormula.get(varRtn).toString());
            rtnValTemp = rtnValTemp.setScale(percision, 4);
            BigDecimal wageCalTemp = new BigDecimal(wageCal.toString());
            wageCalTemp = wageCalTemp.setScale(percision, 4);
            BigDecimal factCalVal = wageCalTemp.subtract(rtnValTemp);
            factCalVal = factCalVal.setScale(percision, 4);
            this.txtPersonTax.setPrecision(2);
            this.txtPersonTax.setNumberValue((Number)rtnValTemp.setScale(2, 4));
            this.txtFactCal.setPrecision(2);
            this.txtFactCal.setNumberValue((Number)factCalVal.setScale(2, 4));
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
            throw new TaxSchemeException(TaxSchemeException.CAL_ERROR);
        }
    }

    private CmpFormulaInfo getCurrRowFormulaInfo(int currTaxRowIndex) {
        CmpFormulaInfo cmpCurrRowFormulaInfo = new CmpFormulaInfo();
        IRow currRowForCurrRow = this.tblMain.getRow(currTaxRowIndex);
        ICell cellFormulaIDCurrRow = currRowForCurrRow.getCell(7);
        ICell cellFormulaNumCurrRow = currRowForCurrRow.getCell(9);
        ICell cellFormulaNameCurrRow = currRowForCurrRow.getCell(8);
        if (cellFormulaIDCurrRow.getValue() != null && cellFormulaNumCurrRow.getValue() != null) {
            cmpCurrRowFormulaInfo.setId(BOSUuid.read((String)cellFormulaIDCurrRow.getValue().toString()));
            cmpCurrRowFormulaInfo.setNumber(cellFormulaNumCurrRow.getValue().toString());
            if (cellFormulaNameCurrRow.getValue() != null) {
                cmpCurrRowFormulaInfo.setName(cellFormulaNameCurrRow.getValue().toString());
            }
            return cmpCurrRowFormulaInfo;
        }
        return null;
    }

    @Override
    public void actionAddNewSch_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNewSch_actionPerformed(e);
        this.tblMain.getSelectManager().removeAll();
        this.setAddNewUI();
        TaxSchemeEditUI taxSchemeEditUI = this;
        List langList = taxSchemeEditUI.txtName.getLanguageList();
        int size = langList.size();
        for (int i = 0; i < size; ++i) {
            LanguageInfo lInfo = (LanguageInfo)langList.get(i);
            this.txtName.setItemData(lInfo, null);
        }
    }

    @Override
    public void actionModifySch_actionPerformed(ActionEvent e) throws Exception {
        super.actionModifySch_actionPerformed(e);
        this.taxSchemeInfo = new TaxSchemeInfo();
        this.taxSchemeInfo.setIsChange(true);
        this.taxSchemeInfo.setOprStatus(2);
        this.taxSchemeInfoForCheck.setOprStatus(2);
        String taxSchemeOldString = this.bizPromptCmpFormual.getText();
        if (this.getCurrRowFormulaInfo(this.taxRowIndex) != null) {
            this.bizPromptCmpFormual.setData((Object)this.getCurrRowFormulaInfo(this.taxRowIndex));
        }
        this.setAllEditorState(true);
        this.txtNumber.setEnabled(false);
        this.bizPromptCmpFormual.setText(taxSchemeOldString);
        if (this.btnBasicScheme.isSelected() || this.chkOnlyOnePayYear.isSelected()) {
            this.bizPromptCmpFormual.setEnabled(false);
            this.bizPromptCmpFormual.setData(null);
        }
        this.loadDataToTaxInfo();
    }

    @Override
    public void actionDeleteTaxSch_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteTaxSch_actionPerformed(e);
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        this.taxSchemeInfo.setOprStatus(3);
        int opeResult = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete"));
        if (opeResult == 0) {
            try {
                this.submit();
                this.setMessageText(EASResource.getString((String)(this.taxResourceBasicURL + "DELETE_SUCEED")));
                this.showMessage();
            }
            catch (Exception exc) {
                this.handUIException(exc);
            }
        }
        this.taxSchemeInfo.setOprStatus(0);
        if (this.tblMain.getRowCount() > 0 && this.tblMain.getColumnCount() > 0) {
            this.tblMain.getEditManager().editCellAt(0, 0);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        try {
            this.submit();
        }
        catch (EASBizException bizE) {
            if ("23".equals(bizE.getSubCode())) {
                ExceptionHandler.handle((Throwable)bizE);
                this.txtNumber.requestFocusInWindow();
                return;
            }
            throw bizE;
        }
        this.setMessageText(EASResource.getString((String)(this.taxResourceBasicURL + "SAVE_SUCCEED")));
        this.showMessage();
        this.isModifyPersonFlag = false;
        this.loadFields();
    }

    @Override
    public void actionPrintView_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintView_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.taxSchemeInfo.setOprStatus(0);
        this.onLoad();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    @Override
    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
        this.searcheRowCount = 0;
        this.searchText = null;
        this.preFindListEvent = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        ArrayList<ListFind> FindPropertyName = new ArrayList<ListFind>();
        int size = this.getLocateNames().length;
        for (int i = 0; i < size; ++i) {
            if (this.tblPersonMain.getColumn(this.getLocateNames()[i]) == null) continue;
            ListFind cEnum = new ListFind(this.getLocateNames()[i], this.tblPersonMain.getHeadRow(0).getCell(this.getLocateNames()[i]).getValue().toString());
            FindPropertyName.add(cEnum);
        }
        if (FindPropertyName.size() == 0) {
            return;
        }
        this.findDialog = win instanceof Frame ? new FindDialog((Frame)win, "", FindPropertyName, true) : new FindDialog((Dialog)win, "", FindPropertyName, true);
        this.findDialog.addFindListListener(new IFindListListener(){

            public void FindNext(FindListEvent e) {
                TaxSchemeEditUI.this.locate(e);
            }

            public void actionPerformed(ActionEvent e) {
            }

            public void FindClose(FindListEvent e) {
                TaxSchemeEditUI.this.findDialog.dispose();
                TaxSchemeEditUI.this.findDialog = null;
                TaxSchemeEditUI.this.searcheRowCount = 0;
                TaxSchemeEditUI.this.searchText = null;
                TaxSchemeEditUI.this.isMatch = false;
            }
        });
        this.findDialog.setLocation(600, 100);
        this.findDialog.show();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"number", "name"};
        return locateNames;
    }

    protected void locate(FindListEvent e) {
        String msg;
        boolean searchResult = false;
        int currentRow = 0;
        int RowCount = 0;
        int curSelectIndex = this.tblPersonMain.getSelectManager().getActiveRowIndex();
        if (curSelectIndex < 0 && (this.tblPersonMain.getRowCount() > 0 || this.tblPersonMain.getRowCount3() > 0)) {
            this.tblPersonMain.getSelectManager().select(0, 0);
            curSelectIndex = 0;
        }
        if (curSelectIndex < 0 || this.tblPersonMain.getRowCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateLast)));
            return;
        }
        if (this.preFindListEvent != null && e.getFindDeration() != this.preFindListEvent.getFindDeration() || this.searchText != null && !this.searchText.equals(e.getSearch()) || this.propertyName != null && !e.getPropertyName().equals(this.propertyName) || this.isMatch != e.isIsMatch()) {
            this.searcheRowCount = 0;
            Object cellValue = null;
            cellValue = this.tblPersonMain.getRow(curSelectIndex).getCell(e.getPropertyName()).getValue();
            String selectText = cellValue == null ? null : cellValue.toString();
            this.propertyName = e.getPropertyName();
            if (selectText != null && StringUtility.isMatch((String)selectText, (String)e.getSearch(), (boolean)e.isIsMatch(), (int)2)) {
                ++this.searcheRowCount;
            }
        }
        this.isMatch = e.isIsMatch();
        this.preFindListEvent = e;
        this.searchText = e.getSearch();
        this.propertyName = e.getPropertyName();
        if (this.isHasQyeryPK()) {
            RowCount = this.tblPersonMain.getBody().size();
        } else {
            this.locateForNotIdList(e);
        }
        if (this.tblPersonMain.getSelectManager().get() != null) {
            currentRow = this.tblPersonMain.getSelectManager().get().getBeginRow();
        }
        int i = 0;
        if (RowCount == 0) {
            return;
        }
        if (e.getFindDeration() == 2) {
            if (i == RowCount) {
                if (this.searcheRowCount == 0) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateLast)));
                } else {
                    msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_LocateLast_end");
                    Object[] objs = new Object[]{this.searcheRowCount};
                    msg = MessageFormat.format(msg, objs);
                    MsgBox.showInfo((Component)((Object)this), (String)msg);
                }
                this.findDialog.show();
            } else {
                for (i = e.getFindDeration() == 2 ? currentRow + 1 : currentRow; i < RowCount; ++i) {
                    String Search;
                    IRow row = null;
                    row = this.tblPersonMain.getRow(i);
                    ICell cell = null == row ? null : row.getCell(e.getPropertyName());
                    Object o = cell == null ? null : cell.getValue();
                    String string = Search = o == null ? null : o.toString();
                    if (Search == null) {
                        if (i != RowCount - 1) continue;
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateLast)));
                        this.findDialog.show();
                        continue;
                    }
                    if (Search != null && StringUtility.isMatch((String)Search, (String)e.getSearch(), (boolean)e.isIsMatch(), (int)2)) {
                        searchResult = true;
                        ++this.searcheRowCount;
                        this.tblPersonMain.getSelectManager().select(i, 0);
                        this.tblPersonMain.getLayoutManager().scrollRowToShow(i);
                        break;
                    }
                    if (i != RowCount - 1) continue;
                    if (this.searcheRowCount == 0) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateLast)));
                    } else {
                        String msg2 = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_LocateLast_end");
                        Object[] objs = new Object[]{this.searcheRowCount};
                        msg2 = MessageFormat.format(msg2, objs);
                        MsgBox.showInfo((Component)((Object)this), (String)msg2);
                    }
                    this.findDialog.show();
                }
            }
        } else {
            if (i == 0) {
                if (this.searcheRowCount == 0) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateFirst)));
                } else {
                    msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_LocateFirst_end");
                    Object[] objs = new Object[]{this.searcheRowCount};
                    msg = MessageFormat.format(msg, objs);
                    MsgBox.showInfo((Component)((Object)this), (String)msg);
                }
                this.findDialog.show();
            }
            while (i > 0) {
                String Search;
                ICell cell = null == this.tblPersonMain.getRow(i - 1) ? null : this.tblPersonMain.getRow(i - 1).getCell(e.getPropertyName());
                Object o = this.tblPersonMain.getCellDisplayValue(cell);
                String string = Search = o == null ? null : o.toString();
                if (Search == null) {
                    if (i == 1) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateFirst)));
                        this.findDialog.show();
                    }
                } else {
                    if (Search != null && StringUtility.isMatch((String)Search, (String)e.getSearch(), (boolean)e.isIsMatch(), (int)2)) {
                        searchResult = true;
                        ++this.searcheRowCount;
                        this.tblPersonMain.getSelectManager().select(i - 1, 0);
                        this.tblPersonMain.getLayoutManager().scrollRowToShow(i - 1);
                        break;
                    }
                    if (i == 1) {
                        if (this.searcheRowCount == 0) {
                            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateFirst)));
                        } else {
                            String msg3 = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_LocateFirst_end");
                            Object[] objs = new Object[]{this.searcheRowCount};
                            msg3 = MessageFormat.format(msg3, objs);
                            MsgBox.showInfo((Component)((Object)this), (String)msg3);
                        }
                        this.findDialog.show();
                    }
                }
                --i;
            }
        }
    }

    public boolean isHasQyeryPK() {
        return false;
    }

    protected void locateForNotIdList(FindListEvent e) {
        int currentRow = 0;
        if (this.tblPersonMain.getSelectManager().get() != null) {
            currentRow = this.tblPersonMain.getSelectManager().get().getBeginRow();
        }
        int i = 0;
        i = e.getFindDeration() == 2 ? currentRow + 1 : currentRow;
        IRow row = this.tblPersonMain.getRow(i);
        this.showMsgNoIdList(row, e);
        while (row != null) {
            String Search;
            if (row.getCell(e.getPropertyName()).getValue() == null) {
                if (e.getFindDeration() == 2) {
                    ++i;
                    continue;
                }
                --i;
                continue;
            }
            int curSelectIndex = this.tblPersonMain.getSelectManager().getActiveRowIndex();
            if (curSelectIndex == i) {
                if (e.getFindDeration() == 2) {
                    ++i;
                    continue;
                }
                --i;
                continue;
            }
            row = this.tblPersonMain.getRow(i);
            if (row == null) {
                this.showMsgNoIdList(null, e);
                break;
            }
            ICell cell = this.tblPersonMain.getRow(i).getCell(e.getPropertyName());
            Object cellValue = cell == null ? null : cell.getValue();
            String string = Search = cellValue == null ? null : cellValue.toString();
            if (Search != null && StringUtility.isMatch((String)Search, (String)e.getSearch(), (boolean)e.isIsMatch(), (int)2)) {
                ++this.searcheRowCount;
                this.tblPersonMain.getSelectManager().select(i, 0);
                this.tblPersonMain.getLayoutManager().scrollRowToShow(i);
                break;
            }
            if (e.getFindDeration() == 2) {
                ++i;
                continue;
            }
            --i;
        }
    }

    private void showMsgNoIdList(IRow row, FindListEvent e) {
        if (row == null) {
            String hint = "";
            hint = e.getFindDeration() == 2 ? (this.searcheRowCount == 0 ? locateLast : "Msg_LocateFirst_end") : (this.searcheRowCount == 0 ? locateFirst : "Msg_LocateFirst_end");
            String msg = EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + hint));
            if (this.searcheRowCount != 0) {
                Object[] objs = new Object[]{this.searcheRowCount};
                msg = MessageFormat.format(msg, objs);
            }
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            this.findDialog.show();
        }
    }
}

