/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.CmpSchemePersonInfo;
import com.kingdee.eas.hr.compensation.ITeamGroup;
import com.kingdee.eas.hr.compensation.TeamGropupPersonCollection;
import com.kingdee.eas.hr.compensation.TeamGropupPersonInfo;
import com.kingdee.eas.hr.compensation.TeamGroupAuditPersonCollection;
import com.kingdee.eas.hr.compensation.TeamGroupAuditPersonInfo;
import com.kingdee.eas.hr.compensation.TeamGroupFactory;
import com.kingdee.eas.hr.compensation.TeamGroupInfo;
import com.kingdee.eas.hr.compensation.TeamGroupStateEnum;
import com.kingdee.eas.hr.compensation.client.AbstractTeamGroupEditUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class TeamGroupEditUI
extends AbstractTeamGroupEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TeamGroupEditUI.class);
    private final String PERSONID_COL = "personid";
    private final String ID_COL = "id";
    private final String PERSONNUMBER_COL = "personNumber";
    private final String PERSONNAME_COL = "personName";
    private final String ADMINORG_COL = "adminorg";
    private final String POSITION_COL = "position";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        UIHelper.loadMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)this.editData, (String)"name");
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.txtDescription, (IObjectValue)this.editData, (String)"description");
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        if (this.editData.getState() == null) {
            this.editData.setState(TeamGroupStateEnum.NEW);
        }
        this.editData.setHrOrgUnit(HRSchemeUtils.getClientHROrgUnitInfo());
        this.editData.setNumber(this.txtNumber.getText());
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)this.editData, (String)"name");
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.txtDescription, (IObjectValue)this.editData, (String)"description");
        this.setTeamGroupMember();
        this.setTeamAuditLeader();
        this.checkPrimaryOfTeam();
        String logItem = null;
        logItem = this.oprtState.endsWith("ADDNEW") ? "TeamGroup_add" : "TeamGroup_edit";
        IObjectPK logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)new TeamGroupInfo().getBOSType(), null, (String)this.editData.getName(), (String)logItem);
        this.runSubmit();
        LogUtil.afterLog(null, (IObjectPK)logPK);
        if (this.oprtState.endsWith("ADDNEW")) {
            this.tblAuditPerson.removeRows();
            this.tblPerson.removeRows();
            this.txtDescription.setSelectedItemData(null);
            this.txtName.setSelectedItemData(null);
            this.txtNumber.setText(null);
            this.pkEnableDate.setValue(null);
            this.pkDisableDate.setValue(null);
            this.prmtCreator.setValue(null);
        }
        this.showSubmitSuccess();
        this.setSave(true);
        this.setSaved(true);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.initBottonState();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    public void actionReset_actionPerformed(ActionEvent e) throws Exception {
        super.actionReset_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        return new TeamGroupInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TeamGroupFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddPerson.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnRmPerson.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnAddPerson.setText("");
        this.btnRmPerson.setText("");
        this.btnAddLeader.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnDelLeader.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnDelLeader.setText("");
        this.btnAddLeader.setText("");
        this.cntPerson.addButton((JButton)this.btnAddPerson);
        this.cntPerson.addButton((JButton)this.btnRmPerson);
        this.cntAuditPerson.addButton((JButton)this.btnAddLeader);
        this.cntAuditPerson.addButton((JButton)this.btnDelLeader);
    }

    @Override
    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox();
        pmt.setModal(true);
        pmt.setIsSingleSelect(false);
        pmt.showNoPositionPerson(true);
        pmt.showOnlyPayPerson(true);
        pmt.setReturnPositionAndUnit(false);
        pmt.show();
        if (!pmt.isCanceled() && pmt.getData() instanceof Object[]) {
            Object[] obj = (Object[])pmt.getData();
            this.fillPersonTableRow(obj);
        }
    }

    protected void fillPersonTableRow(Object[] obj) {
        if (obj == null) {
            return;
        }
        PersonInfo infoPerson = null;
        CmpSchemePersonInfo info = null;
        int length = obj.length;
        for (int i = 0; i < length; ++i) {
            infoPerson = (PersonInfo)obj[i];
            info = new CmpSchemePersonInfo();
            info.setPerson(infoPerson);
            if (infoPerson.get("primaryAdminOrg") != null) {
                info.setAdminOrgUnit((AdminOrgUnitInfo)infoPerson.get("primaryAdminOrg"));
            }
            if (infoPerson.get("primaryPosition") != null) {
                info.setPosition((PositionInfo)infoPerson.get("primaryPosition"));
            }
            if (this.isSamePersonInPersonTable(infoPerson)) continue;
            this.fillPersonTableRow(info);
        }
    }

    private void fillAduitLeader(Object[] obj) {
        if (obj == null) {
            return;
        }
        PersonInfo infoPerson = null;
        int length = obj.length;
        for (int i = 0; i < length; ++i) {
            infoPerson = (PersonInfo)obj[i];
            if (this.isSameLeaderInLeaderTable(infoPerson)) continue;
            this.fillLeaderTableRow(infoPerson);
        }
    }

    protected void fillPersonTableRow(CmpSchemePersonInfo info) {
        if (info == null) {
            return;
        }
        PersonInfo infoPerson = info.getPerson();
        ICell iCell = null;
        IRow iRow = this.tblPerson.addRow();
        iCell = iRow.getCell(this.PERSONID_COL);
        if (iCell != null) {
            iCell.setValue((Object)infoPerson.getId());
        }
        if ((iCell = iRow.getCell("isPrmaryPerson")) != null) {
            iCell.setValue((Object)Boolean.FALSE);
        }
        if ((iCell = iRow.getCell(this.PERSONNAME_COL)) != null) {
            iCell.setValue((Object)infoPerson.getName());
        }
        if ((iCell = iRow.getCell(this.PERSONNUMBER_COL)) != null) {
            iCell.setValue((Object)infoPerson.getNumber());
        }
        if ((iCell = iRow.getCell(this.ADMINORG_COL)) != null) {
            iCell.setValue((Object)info.getAdminOrgUnit());
        }
        if ((iCell = iRow.getCell(this.POSITION_COL)) != null) {
            iCell.setValue((Object)info.getPosition());
        }
    }

    private void fillLeaderTableRow(PersonInfo personInfo) {
        if (personInfo == null) {
            return;
        }
        ICell iCell = null;
        IRow iRow = this.tblAuditPerson.addRow();
        iCell = iRow.getCell(this.PERSONID_COL);
        if (iCell != null) {
            iCell.setValue((Object)personInfo.getId());
        }
        if ((iCell = iRow.getCell(this.PERSONNAME_COL)) != null) {
            iCell.setValue((Object)personInfo.getName());
        }
        if ((iCell = iRow.getCell(this.PERSONNUMBER_COL)) != null) {
            iCell.setValue((Object)personInfo.getNumber());
        }
        if ((iCell = iRow.getCell(this.ADMINORG_COL)) != null) {
            iCell.setValue(personInfo.get("primaryAdminOrg"));
        }
        if ((iCell = iRow.getCell(this.POSITION_COL)) != null) {
            iCell.setValue(personInfo.get("primaryPosition"));
        }
    }

    protected boolean isSamePersonInPersonTable(PersonInfo info) {
        if (info == null) {
            return false;
        }
        boolean isSame = false;
        int count = this.tblPerson.getRowCount();
        if (count <= 0) {
            return isSame;
        }
        IRow iRow = null;
        ICell iCell = null;
        for (int i = 0; i < count; ++i) {
            iRow = this.tblPerson.getRow(i);
            iCell = iRow.getCell(this.PERSONID_COL);
            if (iCell.getValue() == null) continue;
            String temp = iCell.getValue().toString();
            String id = info.getId().toString();
            if (!id.equals(temp)) continue;
            return true;
        }
        return isSame;
    }

    protected boolean isSameLeaderInLeaderTable(PersonInfo info) {
        if (info == null) {
            return false;
        }
        boolean isSame = false;
        int count = this.tblAuditPerson.getRowCount();
        if (count <= 0) {
            return isSame;
        }
        IRow iRow = null;
        ICell iCell = null;
        for (int i = 0; i < count; ++i) {
            iRow = this.tblAuditPerson.getRow(i);
            iCell = iRow.getCell(this.PERSONID_COL);
            if (iCell.getValue() == null) continue;
            String temp = iCell.getValue().toString();
            String id = info.getId().toString();
            if (!id.equals(temp)) continue;
            return true;
        }
        return isSame;
    }

    private void setTeamGroupMember() {
        String id = null;
        String personId = null;
        TeamGropupPersonCollection gropupMember = null;
        TeamGropupPersonInfo memberInfo = null;
        PersonInfo personInfo = null;
        if (this.oprtState.endsWith("ADDNEW")) {
            IRow iRow = null;
            gropupMember = new TeamGropupPersonCollection();
            int size = this.tblPerson.getRowCount();
            for (int i = 0; i < size; ++i) {
                iRow = this.tblPerson.getRow(i);
                memberInfo = new TeamGropupPersonInfo();
                personInfo = new PersonInfo();
                personId = iRow.getCell("personid").getValue().toString();
                personInfo.setId(BOSUuid.read((String)personId));
                memberInfo.setPerson(personInfo);
                memberInfo.put("state", 10);
                ICell firstCell = iRow.getCell("isPrmaryPerson");
                Boolean stateValue = (Boolean)firstCell.getValue();
                if (stateValue != null) {
                    memberInfo.setIsPrimary(stateValue);
                    if (stateValue.booleanValue()) {
                        // empty if block
                    }
                }
                gropupMember.add(memberInfo);
            }
        } else if (this.oprtState.endsWith("EDIT")) {
            int i;
            gropupMember = this.editData.getTeamGroupPerson();
            if (gropupMember == null) {
                gropupMember = new TeamGropupPersonCollection();
            }
            HashMap<String, Boolean> hspMember = new HashMap<String, Boolean>();
            Object primaryID = null;
            boolean hasPrimaryPerson = false;
            int size = this.tblPerson.getRowCount();
            for (i = 0; i < size; ++i) {
                ICell firstCell = this.tblPerson.getRow(i).getCell("isPrmaryPerson");
                Boolean stateValue = (Boolean)firstCell.getValue();
                id = this.tblPerson.getRow(i).getCell("personid").getValue().toString();
                hspMember.put(id, stateValue);
            }
            if (!hasPrimaryPerson) {
                this.editData.setPrimaryPerson(null);
            }
            size = gropupMember.size();
            for (i = 0; i < size; ++i) {
                memberInfo = gropupMember.get(i);
                if (hspMember.get(memberInfo.getPerson().getId().toString()) == null) {
                    memberInfo.put("state", 20);
                    continue;
                }
                Boolean stateValue = (Boolean)hspMember.get(memberInfo.getPerson().getId().toString());
                if (memberInfo.isIsPrimary() == stateValue.booleanValue()) {
                    memberInfo.put("state", 40);
                } else {
                    memberInfo.put("state", 30);
                }
                memberInfo.setIsPrimary(stateValue);
                hspMember.remove(memberInfo.getPerson().getId().toString());
            }
            if (!hspMember.isEmpty()) {
                Iterator itrKey = hspMember.keySet().iterator();
                while (itrKey.hasNext()) {
                    personId = itrKey.next().toString();
                    memberInfo = new TeamGropupPersonInfo();
                    personInfo = new PersonInfo();
                    personInfo.setId(BOSUuid.read((String)personId));
                    memberInfo.setIsPrimary((Boolean)hspMember.get(personId));
                    memberInfo.setPerson(personInfo);
                    memberInfo.put("state", 10);
                    memberInfo.setTeamGroup(this.editData);
                    gropupMember.add(memberInfo);
                }
            }
        }
        this.editData.setTeamGroupPerson(gropupMember);
    }

    private void setTeamAuditLeader() {
        String id = null;
        String personId = null;
        TeamGroupAuditPersonCollection auditPersonColl = null;
        TeamGroupAuditPersonInfo auditPerson = null;
        PersonInfo personInfo = null;
        if (this.oprtState.endsWith("ADDNEW")) {
            IRow iRow = null;
            auditPersonColl = new TeamGroupAuditPersonCollection();
            int size = this.tblAuditPerson.getRowCount();
            for (int i = 0; i < size; ++i) {
                iRow = this.tblAuditPerson.getRow(i);
                auditPerson = new TeamGroupAuditPersonInfo();
                personInfo = new PersonInfo();
                personId = iRow.getCell("personid").getValue().toString();
                personInfo.setId(BOSUuid.read((String)personId));
                auditPerson.setPerson(personInfo);
                auditPerson.put("state", 10);
                auditPersonColl.add(auditPerson);
            }
        } else if (this.oprtState.endsWith("EDIT")) {
            int i;
            auditPersonColl = this.editData.getAuditPerson();
            if (auditPersonColl == null) {
                auditPersonColl = new TeamGroupAuditPersonCollection();
            }
            HashMap<String, String> hspMember = new HashMap<String, String>();
            int size = this.tblAuditPerson.getRowCount();
            for (i = 0; i < size; ++i) {
                id = this.tblAuditPerson.getRow(i).getCell("personid").getValue().toString();
                hspMember.put(id, "VIEW");
            }
            size = auditPersonColl.size();
            for (i = 0; i < size; ++i) {
                auditPerson = auditPersonColl.get(i);
                if (auditPerson.getPerson() != null && !hspMember.containsKey(auditPerson.getPerson().getId().toString())) {
                    auditPerson.put("state", 20);
                    continue;
                }
                auditPerson.put("state", 40);
                hspMember.remove(auditPerson.getPerson().getId().toString());
            }
            if (!hspMember.isEmpty()) {
                Iterator itrKey = hspMember.keySet().iterator();
                while (itrKey.hasNext()) {
                    personId = itrKey.next().toString();
                    auditPerson = new TeamGroupAuditPersonInfo();
                    personInfo = new PersonInfo();
                    personInfo.setId(BOSUuid.read((String)personId));
                    auditPerson.setPerson(personInfo);
                    auditPerson.put("state", 10);
                    auditPerson.setTeamGroup(this.editData);
                    auditPersonColl.add(auditPerson);
                }
            }
        }
        this.editData.setAuditPerson(auditPersonColl);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initBottonState();
        this.tblAuditPerson.checkParsed();
        this.tblPerson.checkParsed();
        if (!this.oprtState.equalsIgnoreCase("ADDNEW")) {
            TeamGroupAuditPersonCollection auditPerson;
            String id = this.getUIContext().get("ID").toString();
            this.editData = ((ITeamGroup)this.getBizInterface()).getTeamGroupInfo((IObjectPK)new ObjectUuidPK(id), true);
            TeamGropupPersonCollection gropupMember = this.editData.getTeamGroupPerson();
            if (gropupMember != null && gropupMember.size() > 0) {
                int size = gropupMember.size();
                for (int i = 0; i < size; ++i) {
                    this.fillTeamMember(gropupMember.get(i));
                }
            }
            if ((auditPerson = this.editData.getAuditPerson()) != null && auditPerson.size() > 0) {
                int size = auditPerson.size();
                for (int i = 0; i < size; ++i) {
                    this.fillAduitLeader(auditPerson.get(i));
                }
            }
            this.lockTable();
        }
    }

    private void fillTeamMember(TeamGropupPersonInfo memberInfo) {
        if (memberInfo == null) {
            return;
        }
        ICell iCell = null;
        IRow iRow = null;
        int length = this.tblPerson.getRowCount();
        for (int i = 0; i < length; ++i) {
            iCell = this.tblPerson.getRow(i).getCell("id");
            if (iCell.getValue() == null || !iCell.getValue().toString().equals(memberInfo.getId().toString())) continue;
            return;
        }
        iRow = this.tblPerson.addRow();
        iCell = iRow.getCell("id");
        if (iCell != null) {
            iCell.setValue((Object)memberInfo.getId());
        }
        if ((iCell = iRow.getCell("personid")) != null) {
            iCell.setValue((Object)memberInfo.getPerson().getId());
        }
        if ((iCell = iRow.getCell("personNumber")) != null) {
            iCell.setValue((Object)memberInfo.getPerson().getNumber());
        }
        if ((iCell = iRow.getCell("personName")) != null) {
            iCell.setValue((Object)memberInfo.getPerson().getName());
        }
        if ((iCell = iRow.getCell("adminorg")) != null) {
            iCell.setValue(memberInfo.getPerson().get("primaryAdminOrg"));
        }
        if ((iCell = iRow.getCell("position")) != null) {
            iCell.setValue(memberInfo.getPerson().get("primaryPosition"));
        }
        if ((iCell = iRow.getCell("isPrmaryPerson")) != null) {
            iCell.setValue((Object)memberInfo.isIsPrimary());
        }
    }

    private void fillAduitLeader(TeamGroupAuditPersonInfo leaderInfo) {
        if (leaderInfo == null) {
            return;
        }
        ICell iCell = null;
        IRow iRow = null;
        int length = this.tblAuditPerson.getRowCount();
        for (int i = 0; i < length; ++i) {
            iCell = this.tblAuditPerson.getRow(i).getCell("id");
            if (iCell.getValue() == null || !iCell.getValue().toString().equals(leaderInfo.getId().toString())) continue;
            return;
        }
        iRow = this.tblAuditPerson.addRow();
        iCell = iRow.getCell("id");
        if (iCell != null) {
            iCell.setValue((Object)leaderInfo.getId());
        }
        if ((iCell = iRow.getCell("personid")) != null) {
            iCell.setValue((Object)leaderInfo.getPerson().getId());
        }
        if ((iCell = iRow.getCell("personNumber")) != null) {
            iCell.setValue((Object)leaderInfo.getPerson().getNumber());
        }
        if ((iCell = iRow.getCell("personName")) != null) {
            iCell.setValue((Object)leaderInfo.getPerson().getName());
        }
        if ((iCell = iRow.getCell("adminorg")) != null) {
            iCell.setValue(leaderInfo.getPerson().get("primaryAdminOrg"));
        }
        if ((iCell = iRow.getCell("position")) != null) {
            iCell.setValue(leaderInfo.getPerson().get("primaryPosition"));
        }
    }

    public IObjectPK runSubmit() throws Exception {
        if (this.getBizInterface() == null) {
            throw new Exception("don't implement getBizInterface()  !");
        }
        return this.getBizInterface().submit((CoreBaseInfo)this.editData);
    }

    @Override
    public void actionRemovePerson_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblPerson.getRowCount() <= 0) {
            return;
        }
        int rowIndex = this.tblPerson.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"625_TeamGroupEditUI"));
            SysUtil.abort();
        }
        this.tblPerson.removeRow(rowIndex);
    }

    @Override
    protected void tblPerson_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (this.tblPerson.getSelectManager().getActiveColumnIndex() != 2) {
            return;
        }
        int rowIndex = this.tblPerson.getSelectManager().getActiveRowIndex();
        if (this.oprtState.equalsIgnoreCase("VIEW")) {
            return;
        }
        for (int i = 0; i < this.tblPerson.getRowCount(); ++i) {
            if (i == rowIndex) continue;
        }
    }

    private void initBottonState() {
        if (!this.oprtState.equalsIgnoreCase("VIEW")) {
            this.btnAddLeader.setEnabled(true);
            this.btnDelLeader.setEnabled(true);
            this.btnAddPerson.setEnabled(true);
            this.btnRmPerson.setEnabled(true);
            this.tblPerson.setEnabled(true);
        } else {
            this.btnAddLeader.setEnabled(false);
            this.btnDelLeader.setEnabled(false);
            this.btnAddPerson.setEnabled(false);
            this.btnRmPerson.setEnabled(false);
            this.tblPerson.setEnabled(false);
        }
    }

    private void lockTable() {
        if (this.oprtState.equalsIgnoreCase("VIEW")) {
            this.tblPerson.getColumn("isPrmaryPerson").getStyleAttributes().setLocked(true);
        } else {
            this.tblPerson.getColumn("isPrmaryPerson").getStyleAttributes().setLocked(false);
        }
        this.tblPerson.getColumn("personNumber").getStyleAttributes().setLocked(true);
        this.tblPerson.getColumn("personName").getStyleAttributes().setLocked(true);
        this.tblPerson.getColumn(this.POSITION_COL).getStyleAttributes().setLocked(true);
        this.tblPerson.getColumn(this.ADMINORG_COL).getStyleAttributes().setLocked(true);
        this.tblAuditPerson.setEnabled(false);
    }

    @Override
    public void actionAddLeader_actionPerformed(ActionEvent e) throws Exception {
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox();
        pmt.setModal(true);
        pmt.setIsSingleSelect(false);
        pmt.showNoPositionPerson(true);
        pmt.setReturnPositionAndUnit(false);
        pmt.show();
        if (!pmt.isCanceled() && pmt.getData() instanceof Object[]) {
            Object[] obj = (Object[])pmt.getData();
            this.fillAduitLeader(obj);
        }
    }

    @Override
    public void actionDelLeader_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblAuditPerson.getRowCount() <= 0) {
            return;
        }
        int rowIndex = this.tblAuditPerson.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"625_TeamGroupEditUI"));
            SysUtil.abort();
        }
        this.tblAuditPerson.removeRow(rowIndex);
    }

    public boolean checkBeforeWindowClosing() {
        return true;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isEnabled() && StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NUMBER_CAN_NOT_BLANK);
        }
        if (this.txtName.getSelectedItemData() == null || StringUtils.isEmpty((String)this.txtName.getSelectedItemData().toString())) {
            this.txtName.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
    }

    private void checkPrimaryOfTeam() {
        if (this.editData.getTeamGroupPerson() == null || this.editData.getTeamGroupPerson().size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"626_TeamGroupEditUI"));
            SysUtil.abort();
        }
        for (int i = 0; i < this.editData.getTeamGroupPerson().size(); ++i) {
            if (!this.editData.getTeamGroupPerson().get(i).isIsPrimary()) continue;
            return;
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"627_TeamGroupEditUI"));
        SysUtil.abort();
    }
}

