/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class YearSalaryConfiguration {
    private static Logger logger = Logger.getLogger(YearSalaryConfiguration.class);
    public static final String STATION_SALARY = "FSAL031";
    public static final String YEAR_SALARY = "FSAL035";
    public static final String YearSalaryConfTable = "t_hr_boc_yearsalaryconf";
    public static final int LEVEL_OFFSET = 10;
    public static final int MID_VALUE = 6;
    public static final int Sales_Positon = 1;
    public static final int No_Sales_Positon = 2;
    private KDTable table = null;
    private HashMap mapYearSalary = null;
    private HashMap mapGradeWidth = null;
    private HashMap mapPersonPosition = null;

    public YearSalaryConfiguration(KDTable table) {
        this.table = table;
        this.loadConfigurations();
    }

    public void matchPersonStationSalary() {
        int rows = this.table.getRowCount();
        IRow row = null;
        String personId = null;
        String gradeKey = null;
        YearSalaryConfInfo sinfo = null;
        SimplePositionInfo pinfo = null;
        float yearSalary = 0.0f;
        for (int i = 0; i < rows; ++i) {
            row = this.table.getRow(i);
            personId = row.getCell("FPersonID").getValue().toString();
            if (!this.mapPersonPosition.containsKey(personId)) continue;
            pinfo = this.getPersonPosInfo(personId);
            gradeKey = pinfo.grade + "_" + pinfo.posType;
            if (!this.mapYearSalary.containsKey(gradeKey)) continue;
            sinfo = (YearSalaryConfInfo)this.mapYearSalary.get(gradeKey);
            yearSalary = sinfo.yearSalary;
            if (sinfo.posType == 1) {
                yearSalary *= 1.0f + sinfo.offsetPercent;
            }
            int salaryPoint = this.getSalaryPoint(row);
            BigDecimal stationSalary = new BigDecimal("0.0");
            stationSalary = salaryPoint == 6 ? this.calculateStationSalary(yearSalary, sinfo.stationPercent) : this.getStationSalary(personId, salaryPoint);
            stationSalary = stationSalary.setScale(2, 4);
            row.getCell(STATION_SALARY).setValue((Object)stationSalary);
        }
    }

    private int getSalaryPoint(IRow row) {
        Object obj = row.getCell("FSAL000").getValue();
        if (obj == null || !(obj instanceof SalariatHiberPropsInfo)) {
            return 6;
        }
        SalariatHiberPropsInfo info = (SalariatHiberPropsInfo)obj;
        int salaryPoint = 6;
        try {
            salaryPoint = Integer.parseInt(info.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return salaryPoint;
    }

    private BigDecimal calculateStationSalary(float salary, float percent) {
        BigDecimal bigStationSalary = null;
        BigDecimal bigYearSalary = new BigDecimal(salary);
        BigDecimal bigPercent = new BigDecimal(percent);
        BigDecimal bigMonth = new BigDecimal("12.0");
        bigStationSalary = bigYearSalary.multiply(bigPercent).divide(bigMonth, 4);
        bigStationSalary = bigStationSalary.setScale(2, 4);
        return bigStationSalary;
    }

    private SimplePositionInfo getPersonPosInfo(String personId) {
        return (SimplePositionInfo)this.mapPersonPosition.get(personId);
    }

    public BigDecimal getStationSalary(String personId, int salaryPointLevel) {
        YearSalaryConfInfo sinfo = null;
        SimplePositionInfo pinfo = null;
        float yearSalary = 0.0f;
        if (!this.mapPersonPosition.containsKey(personId)) {
            return new BigDecimal("0.0");
        }
        pinfo = (SimplePositionInfo)this.mapPersonPosition.get(personId);
        String gradeKey = pinfo.grade + "_" + pinfo.posType;
        if (!this.mapYearSalary.containsKey(gradeKey)) {
            return new BigDecimal("0.0");
        }
        sinfo = (YearSalaryConfInfo)this.mapYearSalary.get(gradeKey);
        yearSalary = sinfo.yearSalary;
        if (sinfo.posType == 1) {
            yearSalary *= 1.0f + sinfo.offsetPercent;
        }
        BigDecimal stationSalary = this.calculateStationSalary(yearSalary, sinfo.stationPercent);
        return this.calculateStationSalary(pinfo.grade, stationSalary, salaryPointLevel);
    }

    private BigDecimal calculateStationSalary(int grade, BigDecimal stationSalary, int salaryPointLevel) {
        float gradeWidth = ((Float)this.mapGradeWidth.get(grade)).floatValue();
        float eachWidth = gradeWidth / 10.0f;
        float offset = salaryPointLevel - 6;
        float percent = 1.0f + eachWidth * offset;
        BigDecimal bigValue = stationSalary.multiply(new BigDecimal(percent));
        bigValue = bigValue.setScale(2, 4);
        return bigValue;
    }

    private void loadConfigurations() {
        this.mapYearSalary = this.getYearSalaryConfiguration();
        this.mapGradeWidth = this.getGradeWidth();
        this.mapPersonPosition = this.getPersonPosition();
    }

    public HashMap getYearSalaryConfiguration() {
        HashMap<String, YearSalaryConfInfo> map = new HashMap<String, YearSalaryConfInfo>(48);
        String key = null;
        YearSalaryConfInfo info = null;
        String sql = "select * from t_hr_boc_yearsalaryconf";
        try {
            IRowSet rs = this.getRowSet(sql);
            while (rs.next()) {
                info = new YearSalaryConfInfo();
                info.grade = rs.getInt("fgrade");
                info.posType = rs.getInt("fpostype");
                info.yearSalary = rs.getFloat("fsalary");
                info.stationPercent = rs.getFloat("fstationpercent");
                info.offsetPercent = rs.getFloat("foffsetpercent");
                key = info.grade + "_" + info.posType;
                map.put(key, info);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    private HashMap getGradeWidth() {
        HashMap<Integer, Float> map = new HashMap<Integer, Float>(48);
        String sql = "select fgrade,fwidth from t_hr_boc_salpointwidth order by fgrade";
        try {
            IRowSet rs = this.getRowSet(sql);
            while (rs.next()) {
                map.put(rs.getInt(1), new Float(rs.getFloat(2)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    private HashMap getPersonPosition() {
        HashMap<String, SimplePositionInfo> map = new HashMap<String, SimplePositionInfo>(48);
        String sql = "select fpersonid,fpostype,fgrade from v_hr_boc_perpos";
        SimplePositionInfo pinfo = null;
        try {
            IRowSet rs = this.getRowSet(sql);
            while (rs.next()) {
                pinfo = new SimplePositionInfo();
                pinfo.grade = rs.getInt("fgrade");
                pinfo.posType = rs.getInt("fpostype");
                map.put(rs.getString(1), pinfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    private IRowSet getRowSet(String sql) throws BOSException {
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        return exec.executeSQL();
    }

    public void testCalculateSalPoint(int salaryPointLevel) {
        float gradeWidth = 0.5f;
        float eachWidth = gradeWidth / 10.0f;
        float offset = salaryPointLevel - 6;
        float percent = 1.0f + eachWidth * offset;
        logger.info((Object)("final result:" + percent));
    }

    public static void main(String[] args) {
        YearSalaryConfiguration ysconf = new YearSalaryConfiguration(null);
        ysconf.testCalculateSalPoint(1);
        ysconf.testCalculateSalPoint(11);
        ysconf.testCalculateSalPoint(10);
        ysconf.testCalculateSalPoint(2);
        ysconf.testCalculateSalPoint(6);
    }

    static class SimplePositionInfo {
        int posType;
        int grade;

        SimplePositionInfo() {
        }

        public String toString() {
            return this.grade + "_" + this.posType;
        }
    }

    static class YearSalaryConfInfo {
        int grade;
        int posType;
        float yearSalary;
        float stationPercent;
        float offsetPercent;

        YearSalaryConfInfo() {
        }

        public String toString() {
            return "[" + this.yearSalary + ":" + this.stationPercent + ":" + this.offsetPercent + "]";
        }
    }
}

