/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.DynamicTableInfo;
import com.kingdee.eas.hr.base.util.HRBaseDynamicTableUtils;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.ColumnMetasInfo;
import com.kingdee.eas.hr.compensation.EmpCmpSchmFacadeFactory;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.IEmpCmpSchmFacade;
import com.kingdee.eas.hr.compensation.ISalariatHiberProps;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.ItemSubjectEnum;
import com.kingdee.eas.hr.compensation.ItemTypeEnum;
import com.kingdee.eas.hr.compensation.ItemUsedEnum;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsFactory;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.hr.compensation.SchmItemInfo;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.util.HRReportUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HRDynamicTableUtils {
    public static DynamicTableInfo createDynamicTable(String strCmpSchemeID, String strSalSchemeID, KDTable table, int iSchemeType) throws Exception {
        DynamicTableInfo infoDynamicTable = HRDynamicTableUtils.getCmpSchemeDynamicTableInfo(strCmpSchemeID, iSchemeType);
        HRDynamicTableUtils.createTableHead(table, infoDynamicTable, true);
        HRDynamicTableUtils.fillDynamicTableData(strCmpSchemeID, strSalSchemeID, table, infoDynamicTable, iSchemeType);
        return infoDynamicTable;
    }

    public static DynamicTableInfo createDynamicTable(String strCmpSchemeID, String strSalSchemeID, KDTable table, int iSchemeType, boolean isRemoveSomeAction) throws Exception {
        DynamicTableInfo infoDynamicTable = HRDynamicTableUtils.getCmpSchemeDynamicTableInfo(strCmpSchemeID, iSchemeType);
        HRDynamicTableUtils.createTableHead(table, infoDynamicTable, isRemoveSomeAction);
        HRDynamicTableUtils.fillDynamicTableData(strCmpSchemeID, strSalSchemeID, table, infoDynamicTable, iSchemeType);
        return infoDynamicTable;
    }

    public static void createTableHead(KDTable table, DynamicTableInfo infoDynamicTable) {
        HRDynamicTableUtils.createTableHead(table, infoDynamicTable, true);
    }

    public static void createTableHead(KDTable table, DynamicTableInfo infoDynamicTable, boolean isRemoveSomeAction) {
        HRBaseDynamicTableUtils.createTableHead((KDTable)table, (DynamicTableInfo)infoDynamicTable, (boolean)isRemoveSomeAction);
        HRSchemeUtils.setSpecialFormatString(table);
    }

    public static DynamicTableInfo getCmpSchemeDynamicTableInfo(String strCmpSchemeID, int iSchemeType) throws Exception {
        DynamicTableInfo infoDynamicTable = new DynamicTableInfo();
        ICmpScheme iCmpScheme = CmpSchemeFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)strCmpSchemeID));
        CmpSchemeInfo infoCmpScheme = (CmpSchemeInfo)iCmpScheme.getValue((IObjectPK)pk);
        infoDynamicTable.setName(infoCmpScheme.getHorTableName());
        infoDynamicTable.setCountHeadLine(1);
        SchmItemInfo[] infosSchmItem = HRDynamicTableUtils.getCmpSchemeItemInfo(strCmpSchemeID);
        if (infosSchmItem == null) {
            return null;
        }
        int countColumn = infosSchmItem.length + 1;
        DynamicTableInfo.ColumnInfo[] infosColumn = new DynamicTableInfo.ColumnInfo[countColumn];
        int length = infosSchmItem.length;
        for (int i = 0; i < length; ++i) {
            infosColumn[i + 1] = new DynamicTableInfo.ColumnInfo(infosSchmItem[i].getCompenItemInfo());
        }
        infosColumn[0] = new DynamicTableInfo.ColumnInfo();
        infosColumn[0].setHide(true);
        infosColumn[0].setReadOnly(false);
        infosColumn[0].setKey("FPersonID");
        infosColumn[0].setColumnNumber("FPersonID");
        infosColumn[0].setColumnName("FPersonID");
        infosColumn[0].getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        infosColumn[0].getInfosHead()[0].setHeadName("FPersonID");
        infosColumn[0].getInfosHead()[0].setHeadValue("FPersonID");
        infoDynamicTable.setInfosColumn(infosColumn);
        if (iSchemeType == 1) {
            HRDynamicTableUtils.converForCmpCheckTable(infoDynamicTable.getInfosColumn());
        } else if (iSchemeType == 2) {
            HRDynamicTableUtils.converForCmpSendTable(infoDynamicTable.getInfosColumn());
        } else if (iSchemeType == 0) {
            HRDynamicTableUtils.converForEmpCmpSchmTable(infoDynamicTable.getInfosColumn());
        }
        return infoDynamicTable;
    }

    public static SchmItemInfo[] getCmpSchemeItemInfo(String strCmpSchemeID) throws Exception {
        SchmItemInfo[] infosSchmItem = null;
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.CmpSchemeItemQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo compenSchItemQuery = new EntityViewInfo();
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("CmpScheme.id", (Object)strCmpSchemeID));
        compenSchItemQuery.setFilter(filterInfoItem);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("sortOrder");
        sorterOrderItem.setSortType(SortType.ASCEND);
        compenSchItemQuery.getSorter().add(sorterOrderItem);
        SorterItemInfo sorterDefaultOrderItem = new SorterItemInfo("cmpItem.defaultOrder");
        sorterDefaultOrderItem.setSortType(SortType.ASCEND);
        compenSchItemQuery.getSorter().add(sorterDefaultOrderItem);
        exec.setObjectView(compenSchItemQuery);
        IRowSet rowSet = exec.executeQuery();
        if (rowSet.size() <= 0) {
            return null;
        }
        infosSchmItem = new SchmItemInfo[rowSet.size()];
        int count = 0;
        SchmItemInfo info = null;
        CmpItemInfo infoCompenItem = null;
        while (rowSet.next()) {
            info = new SchmItemInfo();
            info.setId(null);
            info.setStrCmpSchmItemID(rowSet.getString("id"));
            info.setCalLevel(rowSet.getInt("calLevel"));
            info.setSortOrder(rowSet.getInt("sortOrder"));
            info.setSqlStmt(null);
            info.setFormulaDesc(rowSet.getString("formulaDesc"));
            info.setFormula(null);
            info.setSchemeID(null);
            info.setCatalogName(null);
            info.setCatalogID(null);
            infoCompenItem = new CmpItemInfo();
            infoCompenItem.setId(BOSUuid.read((String)rowSet.getString("cmpItem.id")));
            infoCompenItem.setName(rowSet.getString("cmpItem.name"));
            infoCompenItem.setNumber(rowSet.getString("cmpItem.number"));
            infoCompenItem.setUsed(ItemUsedEnum.getEnum(rowSet.getInt("cmpItem.used")));
            infoCompenItem.setDataType(ItemDataTypeEnum.getEnum(rowSet.getInt("cmpItem.dataType")));
            infoCompenItem.setSubject(ItemSubjectEnum.getEnum(rowSet.getInt("cmpItem.subject")));
            infoCompenItem.setType(ItemTypeEnum.getEnum(rowSet.getInt("cmpItem.type")));
            infoCompenItem.setDefaultOrder(rowSet.getInt("cmpItem.defaultOrder"));
            infoCompenItem.setDecDigital(rowSet.getInt("cmpItem.decDigital"));
            infoCompenItem.setLength(rowSet.getInt("cmpItem.length"));
            infoCompenItem.setItemValue(rowSet.getString("cmpItem.itemValue"));
            infoCompenItem.setEnable(StateEnum.getEnum(rowSet.getInt("cmpItem.enable")));
            info.setCompenItemInfo(infoCompenItem);
            infosSchmItem[count] = info;
            ++count;
        }
        return infosSchmItem;
    }

    public static void fillDynamicTableData(String strCmpSchemeID, String strSalSchemeID, KDTable table, DynamicTableInfo infoDynamicTable, int iSchemeType) throws Exception {
        table.removeRows();
        Hashtable hst = null;
        if (strSalSchemeID != null) {
            hst = HRDynamicTableUtils.getSalPointInfo(strSalSchemeID);
        }
        IRowSet iRowSet = HRDynamicTableUtils.getEmpCmpSchmData(strCmpSchemeID);
        DynamicTableInfo.ColumnInfo[] infosColumn = infoDynamicTable.getInfosColumn();
        while (iRowSet.next()) {
            IRow iRow = table.addRow();
            ICell cell = null;
            DynamicTableInfo.ColumnInfo infoColumn2 = null;
            String number = null;
            for (DynamicTableInfo.ColumnInfo infoColumn2 : infosColumn) {
                int scale;
                number = infoColumn2.getColumnNumber();
                cell = iRow.getCell(number);
                int dataType = infoColumn2.getColumnType();
                if (HRDynamicTableUtils.doSpecialCell(iSchemeType, iRowSet, infoColumn2, cell, hst)) continue;
                if (dataType == 60) {
                    scale = infoColumn2.getScale();
                    cell.setValue((Object)iRowSet.getBigDecimal(number).setScale(scale, 4));
                    continue;
                }
                if (dataType == 30) {
                    cell.setValue((Object)iRowSet.getString(number));
                    continue;
                }
                if (dataType == 40) {
                    cell.setValue((Object)iRowSet.getInt(number));
                    continue;
                }
                if (dataType == 50) {
                    scale = infoColumn2.getScale();
                    cell.setValue((Object)iRowSet.getBigDecimal(number).setScale(scale, 4));
                    continue;
                }
                if (dataType == 10) {
                    cell.setValue((Object)iRowSet.getBoolean(number));
                    continue;
                }
                cell.setValue((Object)iRowSet.getString(number));
            }
        }
    }

    public static void fillDynamicTableData(String strCmpSchemeID, String strSalSchemeID, KDTable table, DynamicTableInfo infoDynamicTable, IRowSet iRowSet, Map map, int iSchemeType) throws Exception {
        table.removeRows();
        DynamicTableInfo.ColumnInfo[] infosColumn = infoDynamicTable.getInfosColumn();
        while (iRowSet.next()) {
            IRow iRow = table.addRow();
            ICell cell = null;
            DynamicTableInfo.ColumnInfo infoColumn2 = null;
            String number = null;
            for (DynamicTableInfo.ColumnInfo infoColumn2 : infosColumn) {
                int scale;
                number = infoColumn2.getColumnNumber();
                cell = iRow.getCell(number);
                int dataType = infoColumn2.getColumnType();
                if (HRDynamicTableUtils.doSpecialCell(iSchemeType, iRowSet, infoColumn2, cell, map)) continue;
                if (dataType == 60) {
                    scale = infoColumn2.getScale();
                    cell.setValue((Object)iRowSet.getBigDecimal(number).setScale(scale, 4));
                    continue;
                }
                if (dataType == 30) {
                    cell.setValue((Object)iRowSet.getString(number));
                    continue;
                }
                if (dataType == 40) {
                    cell.setValue((Object)iRowSet.getInt(number));
                    continue;
                }
                if (dataType == 50) {
                    scale = infoColumn2.getScale();
                    cell.setValue((Object)iRowSet.getBigDecimal(number).setScale(scale, 4));
                    continue;
                }
                if (dataType == 10) {
                    cell.setValue((Object)iRowSet.getBoolean(number));
                    continue;
                }
                cell.setValue((Object)iRowSet.getString(number));
            }
        }
    }

    private static boolean doSpecialCell(int iSchemeType, IRowSet iRowSet, DynamicTableInfo.ColumnInfo infoColumn, ICell cell, Map map) throws Exception {
        String number;
        boolean isDoIt = false;
        if (iSchemeType == 0 && infoColumn.getType() == 20) {
            cell.setValue(null);
        }
        if ((number = infoColumn.getColumnNumber()).equalsIgnoreCase("FPER010")) {
            cell.setValue((Object)Genders.getEnum((int)iRowSet.getInt(number)));
            return true;
        }
        if (number.equalsIgnoreCase("FSAL000")) {
            String id = iRowSet.getString(number);
            if (map != null && id != null && map.get(id) != null) {
                SalariatHiberPropsInfo salHiberPropsInfo = (SalariatHiberPropsInfo)map.get(id);
                cell.setValue((Object)salHiberPropsInfo);
            } else {
                cell.setValue(null);
            }
            return true;
        }
        return isDoIt;
    }

    private static Hashtable getSalPointInfo(String strSalSchemeID) throws Exception {
        Hashtable<String, SalariatHiberPropsInfo> hst = new Hashtable<String, SalariatHiberPropsInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("scheme", (Object)strSalSchemeID));
        evi.setFilter(filterInfoItem);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("id"));
        ISalariatHiberProps iSalariatHiberProps = SalariatHiberPropsFactory.getRemoteInstance();
        SalariatHiberPropsCollection col = iSalariatHiberProps.getSalariatHiberPropsCollection(evi);
        if (col == null || col.size() <= 0) {
            return null;
        }
        Iterator itr = col.iterator();
        SalariatHiberPropsInfo info = null;
        while (itr.hasNext()) {
            info = (SalariatHiberPropsInfo)itr.next();
            hst.put(info.getId().toString(), info);
        }
        return hst;
    }

    public static IRowSet getEmpCmpSchmData(String strCmpSchemeID) throws Exception {
        IEmpCmpSchmFacade iEmpCmpSchmFacade = EmpCmpSchmFacadeFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)strCmpSchemeID));
        List ls = iEmpCmpSchmFacade.getEmpCompenseDataPKs((IObjectPK)pk, null);
        return iEmpCmpSchmFacade.getEmpCompenseData((IObjectPK)pk, ls, null);
    }

    public static IRowSet getEmpCmpSchmData(String strCmpSchemeID, List lst) throws Exception {
        IEmpCmpSchmFacade iEmpCmpSchmFacade = EmpCmpSchmFacadeFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)strCmpSchemeID));
        List ls = iEmpCmpSchmFacade.getEmpCompenseDataPKs((IObjectPK)pk, null);
        return iEmpCmpSchmFacade.getEmpCompenseData((IObjectPK)pk, ls, null);
    }

    public static DynamicTableInfo.ColumnInfo[] converForEmpCmpSchmTable(DynamicTableInfo.ColumnInfo[] infosColumn) {
        if (infosColumn == null || infosColumn.length == 0) {
            return null;
        }
        DynamicTableInfo.ColumnInfo infoColumn = null;
        String number = null;
        int length = infosColumn.length;
        for (int i = 0; i < length; ++i) {
            infoColumn = infosColumn[i];
            number = infoColumn.getColumnNumber();
            if (infoColumn.getType() == 10) {
                infoColumn.setReadOnly(false);
                infoColumn.setLocked(false);
            } else {
                infoColumn.setReadOnly(true);
                infoColumn.setLocked(true);
            }
            if (number != null && number.trim().substring(0, 4).equalsIgnoreCase("FPer")) {
                infoColumn.setLocked(true);
                infoColumn.setReadOnly(true);
            }
            infosColumn[0].setReadOnly(false);
            if (!infoColumn.isLocked()) continue;
            infoColumn.setColor(HRDynamicTableUtils.getUnEditableColor());
        }
        return infosColumn;
    }

    public static DynamicTableInfo.ColumnInfo[] converForCmpCheckTable(DynamicTableInfo.ColumnInfo[] infosColumn) {
        if (infosColumn == null || infosColumn.length == 0) {
            return null;
        }
        DynamicTableInfo.ColumnInfo infoColumn = null;
        int length = infosColumn.length;
        for (int i = 0; i < length; ++i) {
            infoColumn = infosColumn[i];
            String number = infoColumn.getColumnNumber();
            if (infoColumn.getType() == 20) {
                infoColumn.setReadOnly(false);
                infoColumn.setLocked(false);
            } else {
                infoColumn.setReadOnly(true);
                infoColumn.setLocked(true);
            }
            if (number != null && number.trim().substring(0, 4).equalsIgnoreCase("FPer")) {
                infoColumn.setReadOnly(true);
                infoColumn.setLocked(true);
            }
            if (!infoColumn.isLocked()) continue;
            infoColumn.setColor(HRDynamicTableUtils.getUnEditableColor());
        }
        infosColumn[0].setReadOnly(false);
        return infosColumn;
    }

    public static DynamicTableInfo.ColumnInfo[] converForCmpSendTable(DynamicTableInfo.ColumnInfo[] infosColumn) {
        if (infosColumn == null || infosColumn.length == 0) {
            return null;
        }
        DynamicTableInfo.ColumnInfo infoColumn = null;
        int length = infosColumn.length;
        for (int i = 0; i < length; ++i) {
            infoColumn = infosColumn[i];
            String number = infoColumn.getColumnNumber();
            if (infoColumn.getType() == 20) {
                infoColumn.setReadOnly(false);
                infoColumn.setLocked(false);
            } else {
                infoColumn.setReadOnly(true);
                infoColumn.setLocked(true);
            }
            if (number != null && number.trim().substring(0, 4).equalsIgnoreCase("FPer")) {
                infoColumn.setReadOnly(true);
                infoColumn.setLocked(true);
            }
            infoColumn.setColor(HRDynamicTableUtils.getUnEditableColor());
        }
        infosColumn[0].setReadOnly(false);
        return infosColumn;
    }

    public static Color getUnEditableColor() {
        return HRReportUtils.UNEDIT_COLOR;
    }

    public static Color getEditableColor() {
        return HRReportUtils.TOTAL_COLOR;
    }

    public static Color getSplitColor() {
        return HRReportUtils.SPLIT_COLOR;
    }

    public static Color getRateColor() {
        return HRReportUtils.RATE_COLOR;
    }

    public static Object getEditedCellValue(KDTEditEvent e) {
        return e.getValue();
    }

    public static void setEditedCellColor(KDTEditEvent e) {
        KDTable table = (KDTable)e.getSource();
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        ICell cell = table.getRow(rowIndex).getCell(colIndex);
        if (e.getOldValue() == e.getValue()) {
            return;
        }
        cell.getStyleAttributes().setBackground(HRDynamicTableUtils.getEditableColor());
    }

    public static void setEditedCellColor(ICell cell) {
        cell.getStyleAttributes().setBackground(HRDynamicTableUtils.getEditableColor());
    }

    public static int getVirtualModePageSize() {
        return 100;
    }

    public static ArrayList getSchemeDynamicTableInfosSchmItem(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ArrayList<ColumnMetasInfo> lst = new ArrayList<ColumnMetasInfo>();
        ColumnMetasInfo infoColumnMetas = null;
        infoColumnMetas = new ColumnMetasInfo();
        infoColumnMetas.setName("FPersonID");
        infoColumnMetas.setDataType(HRSchemeUtils.getDataType(100));
        infoColumnMetas.setPrecision(44);
        infoColumnMetas.setLength(44);
        infoColumnMetas.setAllowNull(Boolean.FALSE);
        infoColumnMetas.setPrimaryKey(true);
        lst.add(infoColumnMetas);
        infoColumnMetas = new ColumnMetasInfo();
        infoColumnMetas.setName("FPERIOD");
        infoColumnMetas.setDataType(HRSchemeUtils.getDataType(100));
        infoColumnMetas.setPrecision(44);
        infoColumnMetas.setLength(44);
        infoColumnMetas.setAllowNull(Boolean.FALSE);
        infoColumnMetas.setPrimaryKey(true);
        lst.add(infoColumnMetas);
        infoColumnMetas = new ColumnMetasInfo();
        infoColumnMetas.setName("FTIME");
        infoColumnMetas.setDataType(HRSchemeUtils.getDataType(40));
        infoColumnMetas.setPrecision(4);
        infoColumnMetas.setLength(4);
        infoColumnMetas.setAllowNull(Boolean.FALSE);
        infoColumnMetas.setPrimaryKey(true);
        lst.add(infoColumnMetas);
        infoColumnMetas = new ColumnMetasInfo();
        infoColumnMetas.setName("FADMINORGUNITID");
        infoColumnMetas.setDataType(HRSchemeUtils.getDataType(100));
        infoColumnMetas.setPrecision(44);
        infoColumnMetas.setLength(44);
        infoColumnMetas.setAllowNull(Boolean.FALSE);
        infoColumnMetas.setPrimaryKey(true);
        lst.add(infoColumnMetas);
        infoColumnMetas = new ColumnMetasInfo();
        infoColumnMetas.setName("FPOSITIONID");
        infoColumnMetas.setDataType(HRSchemeUtils.getDataType(100));
        infoColumnMetas.setPrecision(44);
        infoColumnMetas.setLength(44);
        infoColumnMetas.setAllowNull(Boolean.TRUE);
        infoColumnMetas.setPrimaryKey(false);
        lst.add(infoColumnMetas);
        infoColumnMetas = new ColumnMetasInfo();
        infoColumnMetas.setName("FSequence");
        infoColumnMetas.setDataType(HRSchemeUtils.getDataType(40));
        infoColumnMetas.setPrecision(4);
        infoColumnMetas.setLength(4);
        infoColumnMetas.setAllowNull(Boolean.FALSE);
        infoColumnMetas.setPrimaryKey(false);
        lst.add(infoColumnMetas);
        infoColumnMetas = new ColumnMetasInfo();
        infoColumnMetas.setName("FCalType");
        infoColumnMetas.setDataType(HRSchemeUtils.getDataType(40));
        infoColumnMetas.setPrecision(4);
        infoColumnMetas.setLength(4);
        infoColumnMetas.setAllowNull(Boolean.TRUE);
        infoColumnMetas.setPrimaryKey(false);
        lst.add(infoColumnMetas);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)pk.toString()));
        evi.setFilter(filterInfo);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("cmpItem.*"));
        SorterItemInfo sorterOrderItem = new SorterItemInfo("id");
        sorterOrderItem.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterOrderItem);
        ICmpSchemeItem iCmpSchemeItem = CmpSchemeItemFactory.getLocalInstance(ctx);
        CmpSchemeItemCollection col = iCmpSchemeItem.getCmpSchemeItemCollection(evi);
        if (col != null && col.size() > 0) {
            Iterator itr = col.iterator();
            CmpSchemeItemInfo info = null;
            CmpItemInfo infoCmpItem = null;
            while (itr.hasNext()) {
                info = (CmpSchemeItemInfo)itr.next();
                infoCmpItem = info.getCmpItem();
                if (infoCmpItem == null || infoCmpItem.getNumber() == null || infoCmpItem.getNumber().substring(0, 4).equalsIgnoreCase("FPer")) continue;
                infoColumnMetas = new ColumnMetasInfo();
                infoColumnMetas.setName(infoCmpItem.getNumber());
                infoColumnMetas.setDataType(HRSchemeUtils.getDataType(infoCmpItem.getDataType().getValue()));
                if (infoCmpItem.getNumber().equals("FSAL000")) {
                    infoColumnMetas.setDataType(HRSchemeUtils.getDataType(100));
                    infoColumnMetas.setPrecision(44);
                    infoColumnMetas.setLength(44);
                    infoColumnMetas.setAllowNull(Boolean.TRUE);
                    infoColumnMetas.setPrimaryKey(false);
                } else if (infoCmpItem.getDataType().equals((Object)ItemDataTypeEnum.CURRENCY)) {
                    infoColumnMetas.setPrecision(17);
                    infoColumnMetas.setScale(4);
                    infoColumnMetas.setLength(17);
                    infoColumnMetas.defaultValueExpr = SqlExpr.toExpr((int)0);
                } else if (infoCmpItem.getDataType().equals((Object)ItemDataTypeEnum.FLOAT)) {
                    infoColumnMetas.setPrecision(21);
                    infoColumnMetas.setScale(8);
                    infoColumnMetas.setLength(21);
                    infoColumnMetas.defaultValueExpr = SqlExpr.toExpr((int)0);
                } else if (infoCmpItem.getDataType().equals((Object)ItemDataTypeEnum.INT)) {
                    infoColumnMetas.setPrecision(infoCmpItem.getLength());
                    infoColumnMetas.setScale(infoCmpItem.getDecDigital());
                    infoColumnMetas.setLength(infoCmpItem.getLength());
                    infoColumnMetas.defaultValueExpr = SqlExpr.toExpr((int)0);
                } else {
                    infoColumnMetas.setPrecision(infoCmpItem.getLength());
                    infoColumnMetas.setScale(infoCmpItem.getDecDigital());
                    infoColumnMetas.setLength(infoCmpItem.getLength());
                }
                infoColumnMetas.setAllowNull(Boolean.TRUE);
                lst.add(infoColumnMetas);
            }
        }
        return lst;
    }

    public static DynamicTableInfo.ColumnInfo addColumn(String columnName, String columnKey, boolean hideFlag, ItemDataTypeEnum dataType) {
        DynamicTableInfo.ColumnInfo infoColumn = new DynamicTableInfo.ColumnInfo();
        infoColumn.setHide(hideFlag);
        infoColumn.setReadOnly(true);
        infoColumn.setLocked(true);
        infoColumn.setType(30);
        infoColumn.setColumnType(dataType.getValue());
        infoColumn.setKey(columnKey);
        infoColumn.setColumnNumber(columnKey);
        infoColumn.setColumnName(columnName);
        if (!hideFlag) {
            infoColumn.setWidth(100);
        } else {
            infoColumn.setWidth(0);
        }
        infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[0].setHeadName(columnName);
        infoColumn.getInfosHead()[0].setHeadValue(columnKey);
        return infoColumn;
    }

    public static DynamicTableInfo.ColumnInfo addColumn(String columnName, String columnKey, boolean hideFlag, ItemDataTypeEnum dataType, int headRow) {
        DynamicTableInfo.ColumnInfo infoColumn = new DynamicTableInfo.ColumnInfo();
        infoColumn.setHide(hideFlag);
        infoColumn.setReadOnly(true);
        infoColumn.setLocked(true);
        infoColumn.setType(30);
        infoColumn.setColumnType(dataType.getValue());
        infoColumn.setKey(columnKey);
        infoColumn.setColumnNumber(columnKey);
        infoColumn.setColumnName(columnName);
        if (!hideFlag) {
            infoColumn.setWidth(100);
        } else {
            infoColumn.setWidth(0);
        }
        infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[headRow]);
        for (int i = 0; i < headRow; ++i) {
            infoColumn.getInfosHead()[i] = new DynamicTableInfo.HeadInfo();
            infoColumn.getInfosHead()[i].setHeadName(columnName);
            infoColumn.getInfosHead()[i].setHeadValue(columnKey);
        }
        return infoColumn;
    }
}

