/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpTempTableInfo;
import com.kingdee.eas.hr.compensation.app.AbstractBIEmpCmpDiffFacadeControllerBean;
import com.kingdee.eas.hr.compensation.app.AppCmpReportUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BIEmpCmpDiffFacadeControllerBean
extends AbstractBIEmpCmpDiffFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.BIEmpCmpDiffFacadeControllerBean");

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return params;
    }

    private HashMap getCmpItems(List list, HashMap items) {
        if (list != null) {
            CmpItemInfo ci = null;
            if (items == null) {
                items = new HashMap<String, CmpItemInfo>();
            }
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                ci = (CmpItemInfo)list.get(i);
                items.put(ci.getNumber(), ci);
            }
        }
        return items;
    }

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        SchemaSource ss = new SchemaSource();
        ss.setCaller(BIEmpCmpDiffFacadeControllerBean.class);
        ss.setFilename("BIEmpCmpDiff.xml");
        HashMap customFilterMap = (HashMap)params.getObject("customFilterMap");
        boolean notIncDelItem = false;
        if (customFilterMap.get("chkIncDelItem") != null) {
            notIncDelItem = (Boolean)customFilterMap.get("chkIncDelItem");
        }
        List privateItems = (List)customFilterMap.get("AllPrivateItem");
        List publicItems = (List)customFilterMap.get("AllPublicItem");
        CmpSchemeInfo[] cmpSchemeInfos = (CmpSchemeInfo[])customFilterMap.get("CmpSchemeInfos");
        CmpPeriodInfo beginPeriod = (CmpPeriodInfo)customFilterMap.get("BeginPeriod");
        CmpPeriodInfo endPeriod = (CmpPeriodInfo)customFilterMap.get("EndPeriod");
        String hrOrgID = null;
        hrOrgID = beginPeriod.getHrOrgUnit() == null ? (String)customFilterMap.get("RootHROrgID") : beginPeriod.getHrOrgUnit().getId().toString();
        AdminOrgUnitCollection colDept = (AdminOrgUnitCollection)customFilterMap.get("AdminOrgUnitColl");
        String adminFilter = null;
        adminFilter = colDept == null || colDept.size() == 0 ? " T.FAdminOrgUnitId in ('') " : AppCmpReportUtil.getAdminFilter(ctx, colDept);
        CmpPeriodInfo[] periods = AppCmpReportUtil.getPeriods(ctx, beginPeriod, endPeriod, hrOrgID);
        EntityViewInfo personFilter = (EntityViewInfo)params.getObject("EntityViewInfo");
        CmpTempTableInfo tInfo = AppCmpReportUtil.fillDataToTempTable(ctx, privateItems, publicItems, cmpSchemeInfos, periods, personFilter, adminFilter, notIncDelItem);
        if (ctx.get((Object)"ADMINTEMPTABLE") != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(ctx.get((Object)"ADMINTEMPTABLE").toString());
        }
        if (tInfo == null) {
            return ss;
        }
        HashMap cmpItems = this.getCmpItems(publicItems, this.getCmpItems(privateItems, null));
        StringBuffer mdx = null;
        String table = this.convertToVerTable(ctx, tInfo);
        ss.setDataItem("Person", this.getPersonData(ctx, tInfo), null);
        ss.setDataItem("CmpPeriod", this.getPeriodData(periods), null);
        ss.setDataItem("CmpItem", this.getCmpItemData(cmpItems, tInfo, ctx), null);
        ss.setDataItem("Fact", this.getAnalyseData(table), null);
        mdx = new StringBuffer();
        mdx.append("WITH MEMBER [CmpPeriod].[").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"4_BIEmpCmpDiffFacadeControllerBean", (Locale)ctx.getOriginLocale())).append("] as 'sum([CmpPeriod].Members)'");
        mdx.append(" MEMBER [CmpPeriod].[").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"5_BIEmpCmpDiffFacadeControllerBean", (Locale)ctx.getOriginLocale())).append("] as 'avg([CmpPeriod].Members)'");
        mdx.append(" select {[Person].Members*[CmpItem].Members} dimension properties [Person].[number] on rows,{[CmpPeriod].Members,[CmpPeriod].[").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"4_BIEmpCmpDiffFacadeControllerBean", (Locale)ctx.getOriginLocale())).append("],[CmpPeriod].[").append(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"5_BIEmpCmpDiffFacadeControllerBean", (Locale)ctx.getOriginLocale())).append("]} on columns from Fact");
        ss.setMdx(mdx.toString());
        return ss;
    }

    private String getPersonData(Context ctx, CmpTempTableInfo tInfo) throws EASBizException, BOSException {
        String createTable = "create table personTempTable(KSQL_SEQ int,fid varchar(44),fnumber NVarchar(80),FName NVarchar(255))";
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tmpTbl = null;
        try {
            tmpTbl = pool.createTempTable(createTable);
        }
        catch (Exception e1) {
            pool.releaseTable(tmpTbl);
            throw new BOSException((Throwable)e1);
        }
        String personTempTable = tInfo.getPersonTempTable();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct P.FID,P.FNumber,P.fname_");
        sql.append(ctx.getLocale());
        sql.append(" as FName from T_BD_Person AS P");
        sql.append(" inner join ");
        sql.append(personTempTable);
        sql.append(" AS T on T.FPersonID = P.FID");
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(tmpTbl).append("(fid,fnumber,fname) ").append(sql);
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
        StringBuffer updateSql = new StringBuffer("update ");
        updateSql.append(tmpTbl);
        updateSql.append(" set KSQL_SEQ = select top 1 KSQL_SEQ from ");
        updateSql.append(personTempTable);
        updateSql.append(" where ");
        updateSql.append(personTempTable);
        updateSql.append(".fpersonid = ");
        updateSql.append(tmpTbl);
        updateSql.append(".fid");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        return "select KSQL_SEQ as FSeq,fid,fnumber,fname from " + tmpTbl;
    }

    private String getPeriodData(CmpPeriodInfo[] periods) {
        StringBuffer sql = null;
        for (int i = 0; i < periods.length; ++i) {
            if (sql == null) {
                sql = new StringBuffer();
            } else {
                sql.append(" union all ");
            }
            sql.append("select '");
            sql.append(periods[i].getNumber());
            sql.append("' as FPeriodNum,'");
            sql.append(periods[i].getName());
            sql.append("' as FName ");
        }
        return sql.toString();
    }

    private String getCmpItemData(HashMap cmpItems, CmpTempTableInfo tInfo, Context ctx) {
        List columns = tInfo.getColumns();
        Map prefix = tInfo.getSchemePrefixMap();
        CmpSchemeInfo[] sInfos = tInfo.getCmpSchemeInfos();
        String column = null;
        String num = null;
        String[] nums = null;
        Iterator ite = null;
        Object key = null;
        CmpSchemeInfo sInfo = null;
        CmpItemInfo iInfo = null;
        String sID = null;
        String sName = null;
        String iNum = null;
        String iName = null;
        HashSet<String> schemeSet = new HashSet<String>();
        StringBuffer sql = null;
        Map.Entry entry2 = null;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            column = (String)columns.get(i);
            nums = StringUtils.split((String)column, (String)"_");
            if (nums.length > 1) {
                block1: for (Map.Entry entry2 : prefix.entrySet()) {
                    key = entry2.getKey();
                    if (!entry2.getValue().equals(nums[0])) continue;
                    for (int j = 0; j < sInfos.length; ++j) {
                        if (!key.equals(sInfos[j].getId().toString())) continue;
                        sInfo = sInfos[j];
                        break block1;
                    }
                }
                num = nums[1];
            } else {
                num = column;
            }
            iInfo = (CmpItemInfo)cmpItems.get(num);
            if (iInfo == null) continue;
            if (sInfo == null) {
                sID = "0000000";
                sName = ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"3_BICmpStructFacadeControllerBean", (Locale)ctx.getOriginLocale());
            } else {
                sID = sInfo.getId().toString();
                sName = sInfo.getName();
            }
            iNum = column;
            iName = iInfo.getName();
            if (sql == null) {
                sql = new StringBuffer();
            } else {
                sql.append(" union all ");
            }
            sql.append("select '");
            sql.append(sID);
            sql.append("' as FCmpSchemeID,'");
            sql.append(sName);
            sql.append("' as FCmpSchemeName,'");
            sql.append(iNum);
            sql.append("' as FCmpItemNumber,'");
            sql.append(iName);
            sql.append("'as FCmpItemName");
            if (schemeSet.contains(sID)) continue;
            sql.append(" union all ");
            sql.append("select null as FCmpSchemeID,null as FCmpSchemeName,'");
            sql.append(sID);
            sql.append("' as FCmpItemNumber,'");
            sql.append(sName);
            sql.append("'as FCmpItemName");
            schemeSet.add(sID);
        }
        if (sql != null) {
            return sql.toString();
        }
        return null;
    }

    private String getAnalyseData(String table) {
        StringBuffer sql = new StringBuffer("select FPersonID,FCmpItemNumber,FPeriodNum,sum(FItemValue) AS FSalValue");
        sql.append(" from ");
        sql.append(table);
        sql.append(" group by FPersonID,FCmpItemNumber,FPeriodNum");
        return sql.toString();
    }

    private String convertToVerTable(Context ctx, CmpTempTableInfo tInfo) throws BOSException, EASBizException {
        if (tInfo == null) {
            return null;
        }
        String createTempTable = "Create Table Temp_Cmp(FPersonID VARCHAR(44),FCmpItemNumber NVARCHAR(80),FPeriodNum NVARCHAR(80),FItemValue Decimal(22,8))";
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String toTable = null;
        try {
            toTable = pool.createTempTable(createTempTable);
        }
        catch (Exception e) {
            pool.releaseTable(toTable);
            throw new BOSException((Throwable)e);
        }
        if (StringUtils.isEmpty((String)toTable)) {
            return null;
        }
        String fromTable = tInfo.getTableName();
        List columns = tInfo.getColumns();
        String column = null;
        String sql = null;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            column = (String)columns.get(i);
            if (StringUtils.indexOfIgnoreCase((String)column, (String)"FPer") >= 0) continue;
            sql = this.getInsertSql(fromTable, toTable);
            sql = StringUtils.replace((String)sql, (String)"@cmpItemNumber", (String)column);
            sql = StringUtils.replace((String)sql, (String)"@cmpItem", (String)column);
            DbUtil.execute((Context)ctx, (String)sql);
        }
        return toTable;
    }

    private String getInsertSql(String fromTable, String toTable) {
        StringBuffer sql = new StringBuffer("insert into ");
        sql.append(toTable);
        sql.append("(FPersonID,FCmpItemNumber,FPeriodNum,FItemValue) ");
        sql.append("Select T.FPersonId,'@cmpItemNumber' as FCmpItemNumber,T.FPeriodNum,sum(T.@cmpItem)");
        sql.append(" from ");
        sql.append(fromTable);
        sql.append(" AS T ");
        sql.append(" group by T.FPersonId,T.FPeriodNum");
        return sql.toString();
    }
}

