/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodException;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.app.AbstractCmpPeriodControllerBean;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class CmpPeriodControllerBean
extends AbstractCmpPeriodControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.CmpPeriodControllerBean");

    @Override
    protected boolean _deleteAble(Context ctx, IObjectPK pk) throws BOSException {
        return false;
    }

    public void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String HRID = HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString();
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        FilterInfo filterInfoHR = new FilterInfo();
        filterInfoHR.getFilterItems().add(new FilterItemInfo("hrOrgUnit", (Object)HRID));
        filter.mergeFilter(filterInfoHR, "AND");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    @Override
    protected IObjectValue _getNextCmpPeriod(Context ctx, IObjectPK pkCmpPeriod) throws BOSException, EASBizException {
        String oqlString = null;
        Object nextBeginDateString = null;
        ICmpPeriod iCmpPeriod = CmpPeriodFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)pkCmpPeriod.toString()));
        CmpPeriodInfo currCmpPeriodInfo = iCmpPeriod.getCmpPeriodInfo((IObjectPK)pk);
        Date nextBeginDate = DateTimeUtils.addDay((Date)currCmpPeriodInfo.getEndDate(), (long)1L);
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        String nextDateSimpleString = sd.format(nextBeginDate);
        HROrgUnitInfo hrOrgInfo = HRSchemeUtils.getServerHROrgUnitInfo(ctx);
        oqlString = "SELECT id,name,number,beginDate,endDate,fiscalPeriod.id,enableState,hrOrgUnit.id,groupCmpPeriod.id,pEndInputClose,cmpPeriodYear,cmpPeriod,shutMyCmp  WHERE BEGINDATE=' " + nextDateSimpleString + " ' AND hrOrgUnit ='" + hrOrgInfo.getId().toString() + "'";
        CmpPeriodInfo nextCmpPeriodInfo = null;
        try {
            nextCmpPeriodInfo = iCmpPeriod.getCmpPeriodInfo(oqlString);
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)e.getMessage());
            throw new CmpPeriodException(CmpPeriodException.NOT_NEXT_PERIOD);
        }
        return nextCmpPeriodInfo;
    }

    private int getCmpPeriodNumByDate(Context ctx, CmpPeriodInfo beginCmpPeriod, CmpPeriodInfo endCmpPeriod) throws EASBizException, BOSException {
        int cmpPeriodNumber = 1;
        String endPKString = endCmpPeriod.getId().toString();
        ObjectUuidPK pkBeginCmpPeriod = new ObjectUuidPK(BOSUuid.read((String)beginCmpPeriod.getId().toString()));
        boolean flagOfDate = DateTimeUtils.dayAfter((Date)beginCmpPeriod.getEndDate(), (Date)endCmpPeriod.getBeginDate());
        if (flagOfDate) {
            return -1;
        }
        CmpPeriodInfo nextCmpPeriodInfo = (CmpPeriodInfo)this._getNextCmpPeriod(ctx, (IObjectPK)pkBeginCmpPeriod);
        while (!nextCmpPeriodInfo.getId().toString().equals(endPKString)) {
            ++cmpPeriodNumber;
            ObjectUuidPK pkNextCmpPeriod = new ObjectUuidPK(BOSUuid.read((String)nextCmpPeriodInfo.getId().toString()));
            nextCmpPeriodInfo = (CmpPeriodInfo)this._getNextCmpPeriod(ctx, (IObjectPK)pkNextCmpPeriod);
        }
        return cmpPeriodNumber;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CmpPeriodInfo cmpPeriodInfo = (CmpPeriodInfo)model;
        HashSet updateSet = (HashSet)cmpPeriodInfo.get("modifyCmpPeriodInfo");
        Iterator updateIterator = updateSet.iterator();
        ObjectUuidPK pkUpdate = null;
        while (updateIterator.hasNext()) {
            CmpPeriodInfo cmpPeriodInfoTemp = (CmpPeriodInfo)updateIterator.next();
            cmpPeriodInfoTemp.put("name", cmpPeriodInfoTemp.getName(), LocaleUtils.locale_en_US);
            cmpPeriodInfoTemp.put("name", cmpPeriodInfoTemp.getName(), LocaleUtils.locale_zh_CN);
            cmpPeriodInfoTemp.put("name", cmpPeriodInfoTemp.getName(), LocaleUtils.locale_zh_TW);
            pkUpdate = new ObjectUuidPK(cmpPeriodInfoTemp.getId());
            super._update(ctx, (IObjectPK)pkUpdate, (IObjectValue)cmpPeriodInfoTemp);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CmpPeriodInfo cmpPeriodInfo = (CmpPeriodInfo)model;
        HashSet addNewSet = (HashSet)cmpPeriodInfo.get("newCmpPeriodInfo");
        Iterator addNewIterator = addNewSet.iterator();
        IObjectPK pkLastAddNew = null;
        while (addNewIterator.hasNext()) {
            CmpPeriodInfo cmpPeriodInfoTemp = (CmpPeriodInfo)addNewIterator.next();
            cmpPeriodInfoTemp.put("name", cmpPeriodInfoTemp.getName(), LocaleUtils.locale_en_US);
            cmpPeriodInfoTemp.put("name", cmpPeriodInfoTemp.getName(), LocaleUtils.locale_zh_CN);
            cmpPeriodInfoTemp.put("name", cmpPeriodInfoTemp.getName(), LocaleUtils.locale_zh_TW);
            pkLastAddNew = super._addnew(ctx, (IObjectValue)cmpPeriodInfoTemp);
        }
        return pkLastAddNew;
    }

    protected boolean isDoDelete(String cmpPeriodId, Context ctx) throws BOSException, SQLException {
        boolean isDoDeleteFlag = true;
        String cmpInHisTableFN = "FPERIOD";
        String cmpInHorTableFN = "FPERIOD";
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        int length = 10000;
        String sql1 = "select top 10000 fhistablename from (select top ";
        String sql2 = " fhistablename,fnumber from t_hr_cmpscheme order by fnumber asc) as cmpscheme order by cmpscheme.fnumber desc ";
        int size = 0;
        IRowSet iRowSetszie = DbUtil.executeQuery((Context)ctx, (String)"select count(*) from t_hr_cmpscheme ");
        while (iRowSetszie.next()) {
            size = iRowSetszie.getInt(1);
        }
        while (true) {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)(sql1 + length + sql2 + ""));
            while (iRowSet.next()) {
                if (cmpPeriodId != null && !(isDoDeleteFlag = this.isCanDelete("T_HR_CMPSCHEME", "FCmpPeriod", cmpPeriodId, ctx))) {
                    return isDoDeleteFlag;
                }
                String hisTableName = iRowSet.getString("fhistablename");
                if (hisTableName != null && !(isDoDeleteFlag = this.isCanDelete(hisTableName, cmpInHisTableFN, cmpPeriodId, ctx))) {
                    return isDoDeleteFlag;
                }
                if (isDoDeleteFlag) continue;
                break;
            }
            if (length > size) break;
            length += 10000;
        }
        if (cmpPeriodId != null && !(isDoDeleteFlag = this.isCanDelete("T_HR_AccountDetail", "FCurPeriodID", cmpPeriodId, ctx))) {
            return isDoDeleteFlag;
        }
        return isDoDeleteFlag;
    }

    private boolean isCanDelete(String tableName, String fieldName, String cmpPeriodId, Context ctx) throws BOSException, SQLException {
        String sql = "SELECT * FROM " + tableName + " WHERE " + fieldName + "='" + cmpPeriodId + "'";
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        return !iRowSet.next();
    }

    @Override
    protected boolean _isDoDeleteIF(Context ctx, String cmpPeriodId) throws BOSException {
        boolean flag = true;
        try {
            flag = this.isDoDelete(cmpPeriodId, ctx);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return flag;
    }

    @Override
    protected int _getCmpPeriodNumByDateIF(Context ctx, IObjectValue beginCmpPeriod, IObjectValue endCmpPeriod) throws BOSException, EASBizException {
        if (beginCmpPeriod instanceof CmpPeriodInfo && endCmpPeriod instanceof CmpPeriodInfo) {
            CmpPeriodInfo beginCmpPeriodTemp = (CmpPeriodInfo)beginCmpPeriod;
            CmpPeriodInfo endCmpPeriodTemp = (CmpPeriodInfo)endCmpPeriod;
            return this.getCmpPeriodNumByDate(ctx, beginCmpPeriodTemp, endCmpPeriodTemp);
        }
        return -1;
    }
}

