/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.ColCmpSchemeEntryCollection;
import com.kingdee.eas.hr.compensation.ColCmpSchemeEntryInfo;
import com.kingdee.eas.hr.compensation.ColCmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ColCmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.ColCmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.app.AbstractColCmpSchemeControllerBean;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class ColCmpSchemeControllerBean
extends AbstractColCmpSchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.ColCmpSchemeControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ((ColCmpSchemeInfo)model).setHrOrgUnit(HRSchemeUtils.getServerHROrgUnitInfo(ctx));
        ColCmpSchemeInfo info = (ColCmpSchemeInfo)model;
        ColCmpSchemeEntryCollection colEntry = info.getColCmpSchemeEntry();
        ColCmpSchemeItemCollection colItem = info.getColCmpSchemeItem();
        info.setColCmpSchemeEntry(null);
        info.setColCmpSchemeItem(null);
        info.setHrOrgUnit(HRSchemeUtils.getServerHROrgUnitInfo(ctx));
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        this.addColCmpSchemeEntries(ctx, colEntry, pk);
        this.addColCmpSchemeItems(ctx, colItem, pk);
        return pk;
    }

    private void addColCmpSchemeEntries(Context ctx, ColCmpSchemeEntryCollection colEntry, IObjectPK pk) throws BOSException, EASBizException {
        if (colEntry == null || colEntry.size() == 0) {
            return;
        }
        String sqlAdd = " INSERT INTO T_HR_ColCmpSchemeEntry(FID,FColCmpSchemeID,FCmpSchemeID) VALUES(?,?,?) ";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sqlAdd);
            ColCmpSchemeEntryInfo info = null;
            String fid = null;
            String fColCmpSchemeID = null;
            Object fCmpSchemeID = null;
            int size = colEntry.size();
            for (int i = 0; i < size; ++i) {
                info = colEntry.get(i);
                fid = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
                ps.setString(1, fid);
                fColCmpSchemeID = pk.toString();
                ps.setString(2, fColCmpSchemeID);
                if (info.getCmpScheme() != null && info.getCmpScheme().getId() != null) {
                    ps.setString(3, info.getCmpScheme().getId().toString());
                } else {
                    ps.setNull(3, 12);
                }
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private void deleteEntries(Context ctx, IObjectPK pk) throws BOSException {
        String sqlDelete = " DELETE FROM T_HR_COLCMPSCHEMEENTRY WHERE FCOLCMPSCHEMEID = ?";
        Object[] params = new Object[]{pk.toString()};
        DbUtil.execute((Context)ctx, (String)sqlDelete, (Object[])params);
    }

    private void addColCmpSchemeItems(Context ctx, ColCmpSchemeItemCollection colItem, IObjectPK pk) throws BOSException, EASBizException {
        if (colItem == null || colItem.size() == 0) {
            return;
        }
        String sqlAdd = " INSERT INTO T_HR_ColCmpSchemeItem(FID,FColCmpSchemeID,FCmpItemID,FOrder) VALUES(?,?,?,?) ";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sqlAdd);
            ColCmpSchemeItemInfo info = null;
            String fid = null;
            String fColCmpSchemeID = null;
            Object fCmpSchemeID = null;
            int size = colItem.size();
            for (int i = 0; i < size; ++i) {
                info = colItem.get(i);
                fid = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
                ps.setString(1, fid);
                fColCmpSchemeID = pk.toString();
                ps.setString(2, fColCmpSchemeID);
                if (info.getCmpItem() != null && info.getCmpItem().getId() != null) {
                    ps.setString(3, info.getCmpItem().getId().toString());
                } else {
                    ps.setNull(3, 12);
                }
                ps.setInt(4, info.getOrder());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private void deleteItems(Context ctx, IObjectPK pk) throws BOSException {
        String sqlDelete = " DELETE FROM T_HR_COLCMPSCHEMEITEM WHERE FCOLCMPSCHEMEID = ?";
        Object[] params = new Object[]{pk.toString()};
        DbUtil.execute((Context)ctx, (String)sqlDelete, (Object[])params);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.deleteItems(ctx, pk);
        this.deleteEntries(ctx, pk);
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ((ColCmpSchemeInfo)model).setHrOrgUnit(HRSchemeUtils.getServerHROrgUnitInfo(ctx));
        this.deleteItems(ctx, pk);
        this.deleteEntries(ctx, pk);
        ColCmpSchemeInfo info = (ColCmpSchemeInfo)model;
        ColCmpSchemeEntryCollection colEntry = info.getColCmpSchemeEntry();
        ColCmpSchemeItemCollection colItem = info.getColCmpSchemeItem();
        info.setColCmpSchemeEntry(null);
        info.setColCmpSchemeItem(null);
        super._update(ctx, pk, model);
        this.addColCmpSchemeEntries(ctx, colEntry, pk);
        this.addColCmpSchemeItems(ctx, colItem, pk);
    }

    protected FilterInfo getFilterForCheckNumber(IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        ColCmpSchemeInfo info = (ColCmpSchemeInfo)model;
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)info.getHrOrgUnit().getId().toString()));
        return filter;
    }
}

