/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.IHRInit;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeCollection;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeException;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeFacadeFactory;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeInfo;
import com.kingdee.eas.hr.compensation.IFixedCmpSchemeFacade;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.app.AbstractFixedCmpSchemeControllerBean;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class FixedCmpSchemeControllerBean
extends AbstractFixedCmpSchemeControllerBean {
    @Override
    protected boolean _hasEnableFixedScheme(Context ctx) throws BOSException, EASBizException {
        HROrgUnitInfo hrOrgInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        if (hrOrgInfo == null) {
            return false;
        }
        String hrOrgId = hrOrgInfo.getId().toString();
        String oql = " select id where enable=1 and hrOrgUnit.id='" + hrOrgId + "'";
        return this.exists(ctx, oql);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue obj) throws BOSException, EASBizException {
        FixedCmpSchemeInfo otherSchemeInfo;
        this._checkNumberBlank(ctx, obj);
        this._checkNameBlank(ctx, obj);
        FixedCmpSchemeInfo model = (FixedCmpSchemeInfo)obj;
        IObjectPK pk = null;
        IFixedCmpSchemeFacade iFixedCmpSchemeFacade = FixedCmpSchemeFacadeFactory.getLocalInstance(ctx);
        Object oldState = null;
        if (model.getId() == null) {
            pk = iFixedCmpSchemeFacade.initFixedCmpScheme(model);
        } else {
            this._checkNumberDup(ctx, obj);
            pk = super._submit(ctx, (IObjectValue)model);
        }
        if (!StateEnum.ENABLE.equals((Object)model.getEnable())) {
            return pk;
        }
        if (oldState != null && StateEnum.ENABLE.equals(oldState)) {
            return pk;
        }
        HROrgUnitInfo hrOrgInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        String hrOrgId = hrOrgInfo.getId().toString();
        String oql = "where enable=1 and hrOrgUnit.id='" + hrOrgId + "' and id <>'" + pk.toString() + "'";
        if (this.exists(ctx, oql) && (otherSchemeInfo = this.getFixedCmpSchemeInfo(ctx, oql)) != null && otherSchemeInfo.getId() != null) {
            java.util.Date disDate = model.getEnableDate();
            otherSchemeInfo.setEnable(StateEnum.DISABLE);
            otherSchemeInfo.setDisableDate(DateTimeUtils.addDay((java.util.Date)disDate, (long)-1L));
            this.update(ctx, (IObjectPK)new ObjectUuidPK(otherSchemeInfo.getId()), (CoreBaseInfo)otherSchemeInfo);
        }
        return pk;
    }

    @Override
    protected void _updateEnableState(Context ctx, String fixedID, StateEnum state) throws BOSException, EASBizException {
        FixedCmpSchemeInfo SchemeInfo = this.getFixedCmpSchemeInfo(ctx, (IObjectPK)new ObjectUuidPK(fixedID));
        SchemeInfo.setEnable(state);
        this._submit(ctx, (IObjectValue)SchemeInfo);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FixedCmpSchemeInfo SchemeInfo = this.getFixedCmpSchemeInfo(ctx, pk);
        String horTableName = SchemeInfo.getHorTableName();
        if (!StringUtils.isEmpty((String)horTableName)) {
            DbUtil.execute((Context)ctx, (String)(" drop table " + horTableName));
        }
        String deleteSql = " delete from T_HR_FixedCmpSchemePerson where FFixedCmpSchemeID='" + pk.toString() + "'";
        DbUtil.execute((Context)ctx, (String)deleteSql);
        deleteSql = "delete from T_HR_FixedCmpSchemeItem where FFixedCmpSchemeID='" + pk.toString() + "'";
        DbUtil.execute((Context)ctx, (String)deleteSql);
        super._delete(ctx, pk);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        FixedCmpSchemeInfo info = (FixedCmpSchemeInfo)model;
        if (info == null) {
            return null;
        }
        if (info.getHrOrgUnit() == null) {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString(), CompareType.EQUALS));
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)info.getHrOrgUnit().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    @Override
    protected void _upgradeFixedSchemeData(Context ctx) throws BOSException, EASBizException {
        HROrgUnitInfo hrOrgInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        String hrOrgId = hrOrgInfo.getId().toString();
        String oql = " select * where enable=1 and hrOrgUnit.id='" + hrOrgId + "'";
        FixedCmpSchemeCollection colls = this.getFixedCmpSchemeCollection(ctx, oql);
        if (colls == null || colls.size() <= 0) {
            return;
        }
        FixedCmpSchemeInfo fixedInfo = colls.get(0);
        if (!StringUtils.isEmpty((String)fixedInfo.getNumber())) {
            return;
        }
        IHRInit iHRInit = HRInitFactory.getLocalInstance((Context)ctx);
        if (iHRInit.getSPSchema() != 0) {
            SalariatSchemeInfo info = HRSchemeUtils.getCurrentHRSalSchm(ctx);
            if (info == null) {
                throw new FixedCmpSchemeException(FixedCmpSchemeException.NOT_ENABLE_SALARIATSCHEME);
            }
            fixedInfo.setSalariatScheme(info);
        }
        fixedInfo.setEnableDate(fixedInfo.getCreateTime());
        fixedInfo.setNumber(hrOrgInfo.getNumber() + "_fixedNumber");
        fixedInfo.setName(hrOrgInfo.getName() + "_" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"47_FixedCmpSchemeControllerBean", (Locale)ctx.getOriginLocale()));
        this.update(ctx, (IObjectPK)new ObjectUuidPK(fixedInfo.getId()), (CoreBaseInfo)fixedInfo);
    }

    @Override
    protected HashMap _getPerLastAjustDate(Context ctx, List personIDs) throws BOSException, EASBizException {
        if (personIDs == null || personIDs.size() == 0) {
            return null;
        }
        StringBuffer sqlDelete = new StringBuffer(" select FPersonID,FLastAdjustSalDate from T_HR_PersonCmp where FPersonID in ( ");
        String tempPersonTableName = null;
        if (personIDs.size() > 2000) {
            tempPersonTableName = HRTableTools.createPersonTempTable(ctx, personIDs);
            sqlDelete.append(" select FPersonID from ").append(tempPersonTableName);
        } else {
            int size = personIDs.size();
            for (int i = 0; i < size; ++i) {
                sqlDelete.append("'");
                sqlDelete.append(personIDs.get(i).toString());
                sqlDelete.append("',");
            }
            sqlDelete.deleteCharAt(sqlDelete.length() - 1);
        }
        sqlDelete.append(" ) ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlDelete.toString());
        HRTableTools.releaseTmpTable(ctx, tempPersonTableName);
        HashMap<String, Date> returnValue = new HashMap<String, Date>();
        try {
            while (rowSet.next()) {
                returnValue.put(rowSet.getString("FPersonID"), rowSet.getDate("FLastAdjustSalDate"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return returnValue;
    }
}

