/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlJoinedTableSource;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.IHRInit;
import com.kingdee.eas.hr.compensation.AdjSchemeException;
import com.kingdee.eas.hr.compensation.CmpAdjSchItemCollection;
import com.kingdee.eas.hr.compensation.CmpAdjSchItemFactory;
import com.kingdee.eas.hr.compensation.CmpAdjSchItemInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.ColumnMetasInfo;
import com.kingdee.eas.hr.compensation.EmpCmpSchmFacadeException;
import com.kingdee.eas.hr.compensation.EmpCompenseException;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeCatalogEnum;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeCollection;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeException;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeFactory;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeInfo;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.FixedCmpSchemePersonCollection;
import com.kingdee.eas.hr.compensation.FixedCmpSchemePersonFactory;
import com.kingdee.eas.hr.compensation.HRParameterEnum;
import com.kingdee.eas.hr.compensation.HRParameterFactory;
import com.kingdee.eas.hr.compensation.ICmpAdjSchItem;
import com.kingdee.eas.hr.compensation.ICmpItem;
import com.kingdee.eas.hr.compensation.IFixedCmpScheme;
import com.kingdee.eas.hr.compensation.IFixedCmpSchemeItem;
import com.kingdee.eas.hr.compensation.IFixedCmpSchemePerson;
import com.kingdee.eas.hr.compensation.IHRParameter;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.app.AbstractFixedCmpSchemeFacadeControllerBean;
import com.kingdee.eas.hr.compensation.app.AdapterDynamicDBTable;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCmpIndexUtils;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.compensation.util.PersonInfoUtils;
import com.kingdee.eas.hr.emp.EmpInnerFacadeFactory;
import com.kingdee.eas.hr.emp.IEmpInnerFacade;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FixedCmpSchemeFacadeControllerBean
extends AbstractFixedCmpSchemeFacadeControllerBean {
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.FixedCmpSchemeFacadeControllerBean");

    @Override
    protected void _initFixedCmpScheme(Context ctx, IObjectPK fixedCmpSchemePK, IObjectCollection cmpItemCollection, String salSchemeID) throws BOSException, EASBizException {
        if (fixedCmpSchemePK != null) {
            throw new FixedCmpSchemeException(FixedCmpSchemeException.NOT_ALLOW_INITFIXEDCMPSCHEME);
        }
        IHRInit iHRInit = HRInitFactory.getLocalInstance((Context)ctx);
        if (iHRInit.getSPSchema() != 0) {
            SalariatSchemeInfo info = HRSchemeUtils.getCurrentHRSalSchm(ctx);
            if (info != null) {
                salSchemeID = info.getId().toString();
            } else {
                throw new FixedCmpSchemeException(FixedCmpSchemeException.NOT_ENABLE_SALARIATSCHEME);
            }
        }
        String horTableName = null;
        FixedCmpSchemeInfo info = new FixedCmpSchemeInfo();
        horTableName = this.getNewHorTableName(ctx);
        info.setHorTableName(horTableName);
        info.setEnable(StateEnum.ENABLE);
        info.setHrOrgUnit(HRSchemeUtils.getServerHROrgUnitInfo(ctx));
        fixedCmpSchemePK = new ObjectUuidPK(info.getId());
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)info.getBOSType(), (IObjectPK)fixedCmpSchemePK, (String)"", (String)"fixedCmpScheme_add");
        ICmpItem iCmpItem = CmpItemFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)10));
        filterInfo.getFilterItems().add(new FilterItemInfo("dataType", (Object)60));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItemCatalog.number", (Object)"FPER", CompareType.NOTEQUALS));
        filterInfo.setMaskString("#0  and #1 and #2 and #3 and #4");
        evi.setFilter(filterInfo);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("defaultOrder");
        sorterOrderItem.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterOrderItem);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("cmpItemCatalog.*"));
        cmpItemCollection = iCmpItem.getCmpItemCollection(evi);
        if (salSchemeID != null) {
            cmpItemCollection.addObject(0, (IObjectValue)this.getSalPointCmpItem(ctx));
        }
        IFixedCmpSchemeItem iFixedCmpSchemeItem = FixedCmpSchemeItemFactory.getLocalInstance(ctx);
        FixedCmpSchemeItemInfo infoItem = null;
        CmpItemInfo infoCmpItem = null;
        int size = cmpItemCollection.size();
        for (int i = 0; i < size; ++i) {
            infoCmpItem = (CmpItemInfo)cmpItemCollection.getObject(i);
            if (HRCmpItemUtils.isExcludeFixedCmpItem(infoCmpItem.getNumber())) continue;
            infoItem = new FixedCmpSchemeItemInfo();
            infoItem.setCmpItem(infoCmpItem);
            infoItem.setFixedCmpScheme(info);
            infoItem.setSortOrder(i);
            if (infoCmpItem.getNumber().equalsIgnoreCase("FSAL000")) {
                infoItem.setVisible(1);
            }
            iFixedCmpSchemeItem.addnew(infoItem);
        }
        CmpItemInfo temp = new CmpItemInfo();
        temp.setName("FOTHERENABLEDATE");
        temp.setNumber("FOTHERENABLEDATE");
        temp.setDataType(ItemDataTypeEnum.DATE);
        temp.setDecDigital(2);
        temp.setLength(8);
        cmpItemCollection.addObject((IObjectValue)temp);
        AdapterDynamicDBTable iDynamicDBTable = new AdapterDynamicDBTable(ctx, horTableName, this.getHorTableInfosItem((CmpItemCollection)((Object)cmpItemCollection)));
        try {
            iDynamicDBTable.create();
            String indexSql = " CREATE INDEX idx" + horTableName + " ON " + horTableName + "(" + "FPersonID" + ") ";
            DbUtil.execute((Context)ctx, (String)indexSql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _setupCmpItem(Context ctx, IObjectPK fixedCmpSchemePK, IObjectCollection cmpItemCollection) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement ps1 = null;
        PreparedStatement ps2 = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String sqlDel = "UPDATE T_HR_FixedCmpSchemeItem SET FVisible=0 WHERE FFixedCmpSchemeID=?";
            ps1 = conn.prepareStatement(sqlDel);
            ps1.setString(1, fixedCmpSchemePK.toString());
            ps1.execute();
            sqlDel = " UPDATE T_HR_FixedCmpSchemeItem SET FVisible =1,FSortOrder=? WHERE FCmpItemID=? AND FFixedCmpSchemeID=? ";
            ps2 = conn.prepareStatement(sqlDel);
            CmpItemInfo info = null;
            int size = cmpItemCollection.size();
            for (int i = 0; i < size; ++i) {
                info = (CmpItemInfo)cmpItemCollection.getObject(i);
                ps2.setInt(1, i);
                ps2.setString(2, info.getId().toString());
                ps2.setString(3, fixedCmpSchemePK.toString());
                ps2.addBatch();
            }
            if (cmpItemCollection.size() > 0) {
                ps2.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps1);
                SQLUtils.cleanup(ps2, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps1);
        SQLUtils.cleanup((Statement)ps2, (Connection)conn);
    }

    private CmpItemInfo getSalPointCmpItem(Context ctx) throws BOSException, EASBizException {
        ICmpItem iCmpItem = CmpItemFactory.getLocalInstance(ctx);
        CmpItemInfo info = iCmpItem.getCmpItemInfo("select * where number='FSAL000' and hrOrgUnit.id= '" + HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString() + "'");
        return info;
    }

    private List getCmpPerson(Context ctx) throws BOSException, EASBizException {
        ArrayList lst = new ArrayList();
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String cuID = cu.getId().toString();
        IEmpInnerFacade iInner = EmpInnerFacadeFactory.getLocalInstance((Context)ctx);
        HashMap map = iInner.getPersonCmpByCurrentCU(cuID);
        Iterator itr = map.keySet().iterator();
        while (itr.hasNext()) {
            lst.add(itr.next());
        }
        return lst;
    }

    private List getHorTableInfosItem(CmpItemCollection col) {
        ArrayList<ColumnMetasInfo> lst = new ArrayList<ColumnMetasInfo>();
        ColumnMetasInfo infoColumnMetas = null;
        infoColumnMetas = new ColumnMetasInfo();
        infoColumnMetas.setName("FPersonID");
        infoColumnMetas.setDataType(HRSchemeUtils.getDataType(100));
        infoColumnMetas.setPrecision(44);
        infoColumnMetas.setLength(44);
        infoColumnMetas.setAllowNull(Boolean.FALSE);
        infoColumnMetas.setPrimaryKey(true);
        lst.add(infoColumnMetas);
        if (col != null && col.size() > 0) {
            Iterator itr = col.iterator();
            CmpItemInfo infoCmpItem = null;
            while (itr.hasNext()) {
                infoCmpItem = (CmpItemInfo)itr.next();
                if (infoCmpItem.getNumber().substring(0, 4).equalsIgnoreCase("FPer")) continue;
                infoColumnMetas = new ColumnMetasInfo();
                infoColumnMetas.setName(infoCmpItem.getNumber());
                infoColumnMetas.setDataType(HRSchemeUtils.getDataType(infoCmpItem.getDataType().getValue()));
                infoColumnMetas.setAllowNull(Boolean.TRUE);
                if (infoCmpItem.getDataType().equals((Object)ItemDataTypeEnum.CURRENCY)) {
                    infoColumnMetas.setPrecision(17);
                    infoColumnMetas.setScale(4);
                    infoColumnMetas.setLength(17);
                    infoColumnMetas.defaultValueExpr = SqlExpr.toExpr((int)0);
                } else if (infoCmpItem.getDataType().equals((Object)ItemDataTypeEnum.FLOAT)) {
                    infoColumnMetas.setPrecision(21);
                    infoColumnMetas.setScale(8);
                    infoColumnMetas.setLength(21);
                    infoColumnMetas.defaultValueExpr = SqlExpr.toExpr((int)0);
                } else if (infoCmpItem.getDataType().equals((Object)ItemDataTypeEnum.INT)) {
                    infoColumnMetas.setPrecision(infoCmpItem.getLength());
                    infoColumnMetas.setScale(infoCmpItem.getDecDigital());
                    infoColumnMetas.setLength(infoCmpItem.getLength());
                    infoColumnMetas.defaultValueExpr = SqlExpr.toExpr((int)0);
                } else {
                    infoColumnMetas.setPrecision(infoCmpItem.getLength());
                    infoColumnMetas.setScale(infoCmpItem.getDecDigital());
                    infoColumnMetas.setLength(infoCmpItem.getLength());
                }
                lst.add(infoColumnMetas);
            }
        }
        return lst;
    }

    private String getNewHorTableName(Context ctx) throws BOSException, EASBizException {
        IHRParameter iHRParameter = HRParameterFactory.getLocalInstance(ctx);
        String schm_prefix = iHRParameter.getParamterValue(HRParameterEnum.FIXCMPSCHM_HORTABLE_PREFIX);
        String schm_suffix = iHRParameter.getParamterValue(HRParameterEnum.FIXCMPSCHM_HORTABLE_SUFFIX);
        int int_schm_suffix = Integer.parseInt(schm_suffix);
        String newSchmValue = Integer.valueOf(++int_schm_suffix).toString();
        iHRParameter.updateParamterValue(HRParameterEnum.FIXCMPSCHM_HORTABLE_SUFFIX, newSchmValue);
        String tableName = schm_prefix + schm_suffix;
        tableName = tableName + new Date().getTime();
        if (tableName.length() > 30) {
            tableName = tableName.substring(0, 30);
        }
        return tableName;
    }

    @Override
    protected IRowSet _getEmpData(Context ctx, int catalog, int state, IObjectPK fixedCmpSchemePK, EntityViewInfo infoEntityView, List lstCmpItem) throws BOSException, EASBizException {
        long start = System.currentTimeMillis();
        HRUtils.prinntExecuteTime("********* begin personID ", start);
        String strSalPointID = null;
        if (infoEntityView.get("XinDian") != null) {
            strSalPointID = infoEntityView.get("XinDian").toString();
            boolean isHas = false;
            int size = lstCmpItem.size();
            for (int i = 0; i < size; ++i) {
                if (!((CmpItemInfo)lstCmpItem.get(i)).getNumber().equalsIgnoreCase("FSAL000")) continue;
                isHas = true;
            }
            if (!isHas) {
                strSalPointID = null;
            }
        }
        String horTableName = HRSchemeUtils.getFixedCmpSchemeHorTableName(ctx, fixedCmpSchemePK.toString());
        HRTableTools.addColumnToTable(ctx, horTableName, "FADJUSTCAUSE");
        String sql = "";
        SqlSelect select = null;
        select = this.getFixedItemSQL(ctx, infoEntityView);
        String language = ctx.getLocale().getLanguage();
        ArrayList orderedSelectors = this.buildSelectItemList(lstCmpItem, horTableName, select, language);
        try {
            String upSql = "If not exists (select 1 from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FSalPointSalGradeID' and KSQL_COL_TABNAME='" + horTableName + "') ALTER TABLE " + horTableName + " ADD FSalPointSalGradeID VARCHAR(44)";
            DbUtil.execute((Context)ctx, (String)upSql);
            String itemNumber = "FSalPointSalGradeID";
            SqlSelectItem item = new SqlSelectItem();
            SqlExprParser parser = new SqlExprParser(horTableName + ".FSalPointSalGradeID");
            item.expr = parser.expr();
            item.alias = itemNumber;
            orderedSelectors.add(item);
        }
        catch (ParserException e) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        select.selectList = null;
        select.selectList = orderedSelectors;
        SqlTableSource tableSource = new SqlTableSource(horTableName);
        SqlBinaryOpExpr newExpr = null;
        try {
            newExpr = new SqlBinaryOpExpr(new SqlExprParser("\"PERSON\".FID").expr(), 10, new SqlExprParser(horTableName + ".FPersonID").expr());
        }
        catch (ParserException e1) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        select.tableSource = new SqlJoinedTableSource(select.tableSource, (SqlTableSourceBase)tableSource, 1, (SqlExpr)newExpr);
        if (state != 10 && state != 20) {
            String nameFixedCmpSchemePersonTable = "T_HR_FIXEDCMPSCHEMEPERSON";
            tableSource = new SqlTableSource(nameFixedCmpSchemePersonTable);
            try {
                newExpr = new SqlBinaryOpExpr(new SqlExprParser("\"PERSON\".FID").expr(), 10, new SqlExprParser(nameFixedCmpSchemePersonTable + ".FPersonID").expr());
            }
            catch (ParserException e1) {
                throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
            }
            select.tableSource = new SqlJoinedTableSource(select.tableSource, (SqlTableSourceBase)tableSource, 1, (SqlExpr)newExpr);
        }
        StringBuffer sb = new StringBuffer();
        try {
            DrSQLFormater formater = new DrSQLFormater(sb);
            formater.formatSelect(select);
        }
        catch (FormaterException e2) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        sql = catalog == 50 ? StringUtils.replace((String)sb.toString(), (String)"\"PERSONCMP\".FIsPayPerson = 1 AND", (String)" ") : (catalog == 40 ? StringUtils.replace((String)sb.toString(), (String)"\"PERSONCMP\".FIsPayPerson = 1", (String)" (\"PERSONCMP\".FIsPayPerson = 0 or \"PERSONCMP\".FIsPayPerson is null) ") : sb.toString());
        if (state == 20) {
            StringBuffer sqlDelete = new StringBuffer();
            sqlDelete.append(" DELETE FROM T_HR_FIXEDCMPSCHEMEPERSON WHERE FAudited =0 AND FFixedCmpSchemeID = '").append(fixedCmpSchemePK.toString()).append("'");
            DbUtil.execute((Context)ctx, (String)sqlDelete.toString());
            sql = sb.toString() + " AND (\"PERSON\".FID not in (select fpersonid from T_HR_FIXEDCMPSCHEMEPERSON where FFixedCmpSchemeID = '" + fixedCmpSchemePK.toString() + "'))";
        } else if (state == 30) {
            sql = sb.toString() + " AND T_HR_FIXEDCMPSCHEMEPERSON.FAudited = 1 AND T_HR_FIXEDCMPSCHEMEPERSON.FEnable = 0 AND T_HR_FIXEDCMPSCHEMEPERSON.FFixedCmpSchemeID='" + fixedCmpSchemePK.toString() + "'";
        } else if (state == 40) {
            sql = sb.toString() + " AND T_HR_FIXEDCMPSCHEMEPERSON.FAudited = 1 AND T_HR_FIXEDCMPSCHEMEPERSON.FEnable = 1 AND T_HR_FIXEDCMPSCHEMEPERSON.FFixedCmpSchemeID='" + fixedCmpSchemePK.toString() + "'";
        }
        if (strSalPointID != null) {
            sql = sql + " AND " + horTableName + ".FSAL000 ='" + strSalPointID + "' ";
        }
        sql = HRSchemeUtils.getReplaceQuerySQL(ctx, sql, false);
        sql = this.getOrderBySQL(sql);
        sql = PersonInfoUtils.getOptimizeSql(sql);
        IRowSet rs = HRUtils.executeQuery(ctx, sql);
        return rs;
    }

    private SqlSelect getFixedItemSQL(Context ctx, EntityViewInfo infoEntityView) throws BOSException, EmpCmpSchmFacadeException {
        SqlSelectBase sb;
        EntityViewInfo evi;
        IQueryExecutor exec = null;
        MetaDataPK metaDataPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.HRPersonInfoQuery");
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metaDataPK);
        try {
            evi = HRCmpItemUtils.getCmpItemDynQueryFilter(ctx, HRUtils.getSchemeQueryType(metaDataPK.toString()), infoEntityView);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        exec.setObjectView(evi);
        String sql = exec.getSQL();
        if (sql.indexOf("ORDER") > 0) {
            sql = sql.substring(0, sql.indexOf("ORDER"));
        }
        SqlSelect select = null;
        try {
            SelectParser parser = new SelectParser(sql);
            sb = parser.select();
        }
        catch (ParserException e) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.PARSE_SQL_EXEC, e);
        }
        if (sb == null || !(sb instanceof SqlSelect)) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GET_FIXEDSQL_EXEC);
        }
        select = (SqlSelect)sb;
        return select;
    }

    private String getOrderBySQL(String sql) {
        if (sql.indexOf("ORDER BY") <= 0) {
            sql = sql + " ORDER BY \"PERSON\".FINDEX ";
        }
        return sql;
    }

    protected String getItemSelectSQL(Context ctx, IObjectPK schemePK, int catalog, List lstCmpItem, String horTableName, EntityViewInfo infoEntityView) throws BOSException, EASBizException {
        SqlSelect select = null;
        select = HRSchemeUtils.getFixedItemSQL(ctx, infoEntityView);
        String language = ctx.getLocale().getLanguage();
        ArrayList orderedSelectors = this.buildSelectItemList(lstCmpItem, horTableName, select, language);
        select.selectList = null;
        select.selectList = orderedSelectors;
        SqlBinaryOpExpr newExpr = null;
        try {
            newExpr = new SqlBinaryOpExpr(new SqlExprParser("\"PERSON\".FID").expr(), 10, new SqlExprParser(horTableName + ".FPersonID").expr());
        }
        catch (ParserException e1) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        SqlTableSource tableSource = new SqlTableSource(horTableName);
        select.tableSource = new SqlJoinedTableSource(select.tableSource, (SqlTableSourceBase)tableSource, 1, (SqlExpr)newExpr);
        StringBuffer sb = new StringBuffer();
        try {
            DrSQLFormater formater = new DrSQLFormater(sb);
            formater.formatSelect(select);
        }
        catch (FormaterException e2) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        return sb.toString();
    }

    private ArrayList buildSelectItemList(List lstCmpItem, String horTableName, SqlSelect select, String language) throws EmpCompenseException {
        List selectors = select.selectList;
        ArrayList<SqlSelectItem> orderedSelectors = new ArrayList<SqlSelectItem>();
        String itemNumber = "";
        SqlExprParser parser = null;
        SqlSelectItem item = null;
        int size = lstCmpItem.size();
        for (int i = 0; i < size; ++i) {
            itemNumber = ((CmpItemInfo)lstCmpItem.get(i)).getNumber();
            item = null;
            int jsize = selectors.size();
            for (int j = 0; j < jsize; ++j) {
                if (!((SqlSelectItem)selectors.get((int)j)).alias.replaceAll("\"", "").trim().equals(itemNumber.replaceAll("\"", "").trim())) continue;
                item = (SqlSelectItem)selectors.get(j);
                break;
            }
            if (item == null) {
                try {
                    item = new SqlSelectItem();
                    if (itemNumber.equalsIgnoreCase("FOTHERTOTAL")) {
                        String temp = this.getTotalExpr(lstCmpItem, horTableName);
                        parser = new SqlExprParser(temp);
                    } else {
                        parser = itemNumber.equalsIgnoreCase("FPersonID") ? new SqlExprParser("\"PERSON\".FID") : new SqlExprParser(horTableName + "." + itemNumber);
                    }
                    item.expr = parser.expr();
                    item.alias = itemNumber;
                    orderedSelectors.add(item);
                    continue;
                }
                catch (ParserException e1) {
                    throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
                }
            }
            orderedSelectors.add(item);
        }
        try {
            itemNumber = "FID";
            item = new SqlSelectItem();
            parser = new SqlExprParser("\"PERSON\".FID");
            item.expr = parser.expr();
            item.alias = itemNumber;
            orderedSelectors.add(item);
            itemNumber = "HROrgUnitID";
            item = new SqlSelectItem();
            parser = new SqlExprParser("\"ATTACHTOUNIT\".FID");
            item.expr = parser.expr();
            item.alias = itemNumber;
            orderedSelectors.add(item);
            itemNumber = "HROrgUnitName";
            item = new SqlSelectItem();
            parser = new SqlExprParser("\"ATTACHTOUNIT\".FName_" + language);
            item.expr = parser.expr();
            item.alias = itemNumber;
            orderedSelectors.add(item);
        }
        catch (ParserException e1) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        int jsize = selectors.size();
        for (int j = 0; j < jsize; ++j) {
            if (!((SqlSelectItem)selectors.get((int)j)).alias.replaceAll("\"", "").trim().equalsIgnoreCase("FPER003")) continue;
            orderedSelectors.add((SqlSelectItem)selectors.get(j));
            break;
        }
        if (orderedSelectors != null && orderedSelectors.size() > 0) {
            try {
                boolean existItem = false;
                parser = new SqlExprParser("\"PERSON\".FIndex");
                SqlSelectItem indexOf = new SqlSelectItem(parser.expr(), "INDEXOF");
                int size2 = orderedSelectors.size();
                for (int i = 0; i < size2; ++i) {
                    if (!indexOf.toString().equals(orderedSelectors.get(i).toString())) continue;
                    existItem = true;
                    break;
                }
                if (!existItem) {
                    orderedSelectors.add(indexOf);
                }
            }
            catch (ParserException e1) {
                throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
            }
        }
        return orderedSelectors;
    }

    private String getTotalExpr(List lstColumn, String horTableName) {
        StringBuffer sb = new StringBuffer("");
        CmpItemInfo infoColumn = null;
        String number = null;
        int dataType = 0;
        int size = lstColumn.size();
        for (int i = 0; i < size; ++i) {
            infoColumn = (CmpItemInfo)lstColumn.get(i);
            number = infoColumn.getNumber();
            dataType = infoColumn.getDataType().getValue();
            if (number.equalsIgnoreCase("FOTHERTOTAL") || dataType != 60) continue;
            sb.append(" ISNULL(" + horTableName);
            sb.append(".");
            sb.append(number + ",0.00) ");
            sb.append("+");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        if (sb.length() < 2) {
            sb = new StringBuffer(" 0.00  ");
        }
        return sb.toString();
    }

    @Override
    protected void _enablePerson(Context ctx, IObjectPK fixedCmpSchemePK, List IDs) throws BOSException, EASBizException {
        if (IDs == null || IDs.size() == 0) {
            return;
        }
        FixedCmpSchemeInfo fixedScheme = FixedCmpSchemeFactory.getLocalInstance(ctx).getFixedCmpSchemeInfo(fixedCmpSchemePK);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new FixedCmpSchemeInfo().getBOSType(), (IObjectPK)fixedCmpSchemePK, (String)fixedScheme.getName(), (String)"fixedCmpScheme_enable");
        String personTempTable = null;
        Connection conn = null;
        PreparedStatement ps1 = null;
        String sqlAddPersons = null;
        try {
            if (IDs != null && IDs.size() > 2000) {
                personTempTable = HRTableTools.createPersonTempTable(ctx, IDs);
                sqlAddPersons = " UPDATE T_HR_FixedCmpSchemePerson FIX set FEnable =1 where FFixedCmpSchemeID='" + fixedCmpSchemePK + "' and EXISTS (select FPERSONID from " + personTempTable + " TEMP  where FIX.FPERSONID = TEMP.FPERSONID) ";
                DbUtil.execute((Context)ctx, (String)sqlAddPersons);
                ctx.put((Object)"FixedCmpSchemeFacade_enablePerson", (Object)personTempTable);
            } else {
                sqlAddPersons = " UPDATE T_HR_FixedCmpSchemePerson set FEnable =1 where  FPersonID=? and FFixedCmpSchemeID=? ";
                conn = EJBFactory.getConnection((Context)ctx);
                ps1 = conn.prepareStatement(sqlAddPersons);
                int size = IDs.size();
                for (int i = 0; i < size; ++i) {
                    ps1.setString(1, IDs.get(i).toString());
                    ps1.setString(2, fixedCmpSchemePK.toString());
                    ps1.addBatch();
                }
                if (IDs.size() > 0) {
                    ps1.executeBatch();
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps1, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps1, (Connection)conn);
        String horTableName = null;
        String sql = " SELECT FHORTABLENAME FROM T_HR_FIXEDCMPSCHEME WHERE FID=?";
        Object[] param = new Object[]{fixedCmpSchemePK.toString()};
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        try {
            while (iRowSet.next()) {
                horTableName = iRowSet.getString("FHORTABLENAME");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)iRowSet);
        }
        if (horTableName != null) {
            StringBuffer sbUpdate = new StringBuffer(" update t_hr_personcmp  set (flastadjustsaldate) = ( select b.fotherenabledate FROM ");
            sbUpdate.append(horTableName);
            sbUpdate.append(" b WHERE  b.FPERSONID = t_hr_personcmp.fpersonid ");
            sbUpdate.append(" and b.fpersonid in (");
            if (StringUtils.isEmpty((String)personTempTable)) {
                int size = IDs.size();
                for (int i = 0; i < size; ++i) {
                    sbUpdate.append("'" + IDs.get(i) + "',");
                }
                sbUpdate.deleteCharAt(sbUpdate.length() - 1);
            } else {
                sbUpdate.append("select fpersonID from ").append(personTempTable);
            }
            sbUpdate.append(" ) and (t_hr_personcmp.flastadjustsaldate < b.fotherenabledate ");
            sbUpdate.append("  or t_hr_personcmp.flastadjustsaldate is null)) ");
            DbUtil.execute((Context)ctx, (String)sbUpdate.toString());
        }
        ICmpAdjSchItem iCmpAdjSchItem = CmpAdjSchItemFactory.getLocalInstance(ctx);
        iCmpAdjSchItem.addCmpAdjSchemeForEnable(fixedCmpSchemePK.toString(), IDs);
        HRTableTools.releaseTmpTable(ctx, personTempTable);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _unEnablePerson(Context ctx, IObjectPK fixedCmpSchemePK, List lstIDs) throws BOSException, EASBizException {
        if (lstIDs == null || lstIDs.size() == 0) {
            return;
        }
        FixedCmpSchemeInfo fixedScheme = FixedCmpSchemeFactory.getLocalInstance(ctx).getFixedCmpSchemeInfo(fixedCmpSchemePK);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new FixedCmpSchemeInfo().getBOSType(), (IObjectPK)fixedCmpSchemePK, (String)fixedScheme.getName(), (String)"fixedCmpScheme_unenable");
        String hrOrg = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        String personID = null;
        ArrayList<String> availList = new ArrayList<String>();
        int size = lstIDs.size();
        for (int i = 0; i < size; ++i) {
            personID = (String)lstIDs.get(i);
            if (!this._canBeDisable(ctx, fixedCmpSchemePK.toString(), personID)) continue;
            availList.add(personID);
        }
        if (availList.size() > 0) {
            String sqlUpdatePer = "update T_HR_FixedCmpSchemePerson set FEnable = 0 where FFixedCmpSchemeID = ? and FPersonID in" + CompUtils.getStrFromList(availList);
            DbUtil.execute((Context)ctx, (String)sqlUpdatePer, (Object[])new Object[]{fixedCmpSchemePK.toString()});
            String sqlDel = "delete from T_HR_ADJSCHITEM where FFixedCmpSchemeID = ? and FADJSCHEMEID in( select fid from T_HR_ADJSCHEME where FDisplayFlag = 0 and (fnumber like 'Init_FixedSch_%' or fnumber like 'EMP_SayA_%' or fnumber like 'N0000000001%' )) and FAdjEmpID in " + CompUtils.getStrFromList(availList);
            DbUtil.execute((Context)ctx, (String)sqlDel, (Object[])new Object[]{fixedCmpSchemePK.toString()});
            StringBuffer sb = new StringBuffer();
            sb.append("update t_hr_personcmp  set flastadjustsaldate = \n");
            sb.append("( select T1.FEffectDate FROM  (");
            sb.append(" select T.FAdjEmpID,max(T.FEffectDate) FEffectDate  from T_HR_ADJSCHITEM T ");
            sb.append(" inner join T_HR_ADJSCHEME adjSche on T.FADJSCHEMEID = adjSche.fid \n");
            sb.append(" where adjSche.FHROrgUnitID = '").append(hrOrg).append("' \n");
            sb.append(" and adjSche.fadjschemestate = 30 and (adjSche.FIsHistoryData = 0 or adjSche.FIsHistoryData is null) ");
            sb.append(" group by T.FAdjEmpID ) T1 ");
            sb.append(" where T1.FAdjEmpID = t_hr_personcmp.FPersonID )");
            sb.append("where FPersonID in ");
            sb.append(CompUtils.getStrFromList(availList));
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected boolean _canBeDisable(Context ctx, String fixedCmpSchemeID, String personID) throws BOSException, EASBizException {
        String hrOrg = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("select top 1 sche.FDisplayFlag,item.FFixedCmpSchemeID from T_HR_ADJSCHITEM item \n");
        sb.append("inner join T_HR_ADJSCHEME sche on item.FADJSCHEMEID = sche.FID \n");
        sb.append("where item.FAdjEmpID = '").append(personID).append("' \n");
        sb.append("and sche.FHROrgUnitID = '").append(hrOrg).append("' \n");
        sb.append("and sche.FDisplayFlag = 1 \n");
        sb.append("and sche.FIsHistoryData <> 1");
        sb.append("order by item.FEffectDate DESC ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (rows.next()) {
                String fixedCmpScheme = rows.getString("FFixedCmpSchemeID");
                if (StringUtils.isEmpty((String)fixedCmpScheme)) {
                    return false;
                }
                return !fixedCmpScheme.equals(fixedCmpSchemeID);
            }
            return true;
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
    }

    @Override
    protected void _updateTable(Context ctx, String tableName, List lstColumn, List lstValue) throws BOSException, EASBizException {
        int i;
        if (lstValue == null || lstValue.size() <= 0) {
            return;
        }
        HRTableTools.addColumnToTable(ctx, tableName, "FADJUSTCAUSE");
        StringBuffer sqlDelete = new StringBuffer(" DELETE FROM ");
        sqlDelete.append(tableName);
        sqlDelete.append(" WHERE FPERSONID IN(");
        Iterator itr = lstValue.iterator();
        Object[] value = null;
        String tempPersonTableName = null;
        if (lstValue.size() > 2000) {
            ArrayList<String> personIDList = new ArrayList<String>();
            for (int i2 = 0; i2 < lstValue.size(); ++i2) {
                value = (Object[])lstValue.get(i2);
                personIDList.add(value[0].toString());
            }
            tempPersonTableName = HRTableTools.createPersonTempTable(ctx, personIDList);
            sqlDelete.append(" select FPersonID from ").append(tempPersonTableName);
        } else {
            while (itr.hasNext()) {
                value = (Object[])itr.next();
                sqlDelete.append("'");
                sqlDelete.append(value[0].toString());
                sqlDelete.append("',");
            }
            sqlDelete.deleteCharAt(sqlDelete.length() - 1);
        }
        sqlDelete.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sqlDelete.toString());
        HRTableTools.releaseTmpTable(ctx, tempPersonTableName);
        Connection conn = null;
        PreparedStatement ps = null;
        StringBuffer sqlTemp = new StringBuffer(" INSERT INTO  ");
        sqlTemp.append(tableName);
        sqlTemp.append("(");
        CmpItemInfo infoColumn = null;
        int countLine = lstColumn.size();
        for (i = 0; i < countLine; ++i) {
            infoColumn = (CmpItemInfo)lstColumn.get(i);
            sqlTemp.append(infoColumn.getNumber());
            sqlTemp.append(",");
        }
        sqlTemp.deleteCharAt(sqlTemp.length() - 1);
        sqlTemp.append(") VALUES(");
        for (i = 0; i < countLine; ++i) {
            sqlTemp.append("?");
            sqlTemp.append(",");
        }
        sqlTemp.deleteCharAt(sqlTemp.length() - 1);
        sqlTemp.append(")");
        itr = lstValue.iterator();
        value = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sqlTemp.toString());
            int psAddCount = 0;
            while (itr.hasNext()) {
                value = (Object[])itr.next();
                int i3 = 0;
                int param = 1;
                while (i3 < countLine) {
                    if (value[i3] instanceof Integer) {
                        if (value[i3] == null) {
                            ps.setNull(param, 4);
                        } else {
                            ps.setInt(param, (Integer)value[i3]);
                        }
                    } else if (value[i3] instanceof BigDecimal) {
                        if (value[i3] == null) {
                            ps.setBigDecimal(param, HRSchemeUtils.BD_ZERO);
                        } else {
                            ps.setBigDecimal(param, (BigDecimal)value[i3]);
                        }
                    } else if (value[i3] instanceof java.sql.Date) {
                        if (value[i3] == null) {
                            ps.setNull(param, 91);
                        } else {
                            ps.setDate(param, (java.sql.Date)value[i3]);
                        }
                    } else if (value[i3] instanceof Date) {
                        if (value[i3] == null) {
                            ps.setNull(param, 91);
                        } else {
                            ps.setDate(param, HRUtils.getDate((Date)value[i3]));
                        }
                    } else if (value[i3] == null) {
                        ps.setNull(param, 12);
                    } else {
                        ps.setString(param, value[i3].toString());
                    }
                    ++i3;
                    ++param;
                }
                ps.addBatch();
                if (++psAddCount != 8000) continue;
                psAddCount = 0;
                ps.executeBatch();
                ps.clearBatch();
            }
            if (psAddCount > 0) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    @Override
    protected boolean _canInitFixedCmpScheme(Context ctx, String pk) throws BOSException, EASBizException {
        if (pk == null) {
            return true;
        }
        IFixedCmpSchemePerson iFixedCmpSchemePerson = FixedCmpSchemePersonFactory.getLocalInstance(ctx);
        FixedCmpSchemePersonCollection col = iFixedCmpSchemePerson.getFixedCmpSchemePersonCollection(" where enable = 1 and fixedCmpScheme.id='" + pk + "'");
        if (col != null && col.size() > 0) {
            throw new FixedCmpSchemeException(FixedCmpSchemeException.NOT_ALLOW_INITFIXEDCMPSCHEME);
        }
        return true;
    }

    @Override
    protected List _getCatalogPersonIDs(Context ctx, int catalog, IObjectPK fixedCmpSchemePK) throws BOSException, EASBizException {
        ArrayList lstFixedPersonID = new ArrayList();
        HashMap<String, String> mapEnablePerson = new HashMap<String, String>();
        if (catalog != 50 && catalog != 40) {
            String sql = " SELECT FENABLE,FPERSONID FROM T_HR_FIXEDCMPSCHEMEPERSON WHERE FENABLE =1 AND FFIXEDCMPSCHEMEID='" + fixedCmpSchemePK + "'";
            try {
                IRowSet iRowset = DbUtil.executeQuery((Context)ctx, (String)sql);
                String personID = null;
                while (iRowset.next()) {
                    int isPayPerson = iRowset.getInt("FENABLE");
                    personID = iRowset.getString("FPERSONID");
                    mapEnablePerson.put(personID, personID);
                }
            }
            catch (SQLException e1) {
                this.logger.error((Object)e1.getMessage());
                throw new BOSException((Throwable)e1);
            }
        }
        ArrayList<String> lstAllPerson = new ArrayList<String>();
        ArrayList<String> lstNoPayPerson = new ArrayList<String>();
        ArrayList<String> lstPayPerson = new ArrayList<String>();
        ArrayList<String> lstEnablePayPerson = new ArrayList<String>();
        ArrayList<String> lstUnEnablePayPerson = new ArrayList<String>();
        String sql = " SELECT FISPAYPERSON,FPERSONID FROM T_HR_PERSONCMP WHERE FHRORGUNITID='" + HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString() + "'";
        try {
            IRowSet iRowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            String personID = null;
            while (iRowset.next()) {
                int isPayPerson = iRowset.getInt("FISPAYPERSON");
                personID = iRowset.getString("FPERSONID");
                if (isPayPerson == 1) {
                    lstPayPerson.add(personID);
                    if (mapEnablePerson.get(personID) != null) {
                        lstEnablePayPerson.add(personID);
                    } else {
                        lstUnEnablePayPerson.add(personID);
                    }
                } else {
                    lstNoPayPerson.add(personID);
                }
                lstAllPerson.add(personID);
            }
        }
        catch (SQLException e1) {
            this.logger.error((Object)e1.getMessage());
            throw new BOSException((Throwable)e1);
        }
        if (catalog == 50) {
            return lstAllPerson;
        }
        if (catalog == 10) {
            return lstEnablePayPerson;
        }
        if (catalog == 20) {
            return lstUnEnablePayPerson;
        }
        if (catalog == 40) {
            return lstNoPayPerson;
        }
        return lstFixedPersonID;
    }

    @Override
    protected HashMap _getPersonCmpItemValue(Context ctx, List lstPerson, String fixedCmpSchemeID) throws BOSException, EASBizException {
        String personID;
        HashMap hspAllData = new HashMap();
        FixedCmpSchemeInfo fixedInfo = null;
        if (fixedCmpSchemeID == null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
            evi.getSelector().add(new SelectorItemInfo("id"));
            evi.getSelector().add(new SelectorItemInfo("horTableName"));
            evi.setFilter(filterInfo);
            FixedCmpSchemeCollection col = FixedCmpSchemeFactory.getLocalInstance(ctx).getFixedCmpSchemeCollection(evi);
            if (col == null || col.size() <= 0 || lstPerson == null || lstPerson.size() <= 0) {
                return hspAllData;
            }
            fixedInfo = col.get(0);
        } else {
            fixedInfo = FixedCmpSchemeFactory.getLocalInstance(ctx).getFixedCmpSchemeInfo((IObjectPK)new ObjectUuidPK(fixedCmpSchemeID));
        }
        fixedCmpSchemeID = fixedInfo.getId().toString();
        String tableName = fixedInfo.getHorTableName();
        String cmpItemNumber = null;
        FixedCmpSchemeItemCollection colItem = FixedCmpSchemeItemFactory.getLocalInstance(ctx).getFixedCmpSchemeItemCollection(" select cmpItem.* where fixedCmpScheme.id='" + fixedCmpSchemeID + "'");
        if (colItem == null || colItem.size() <= 0) {
            return hspAllData;
        }
        String personTempTable = null;
        if (ctx.get((Object)"FixedCmpSchemeFacade_enablePerson") != null) {
            personTempTable = (String)ctx.get((Object)"FixedCmpSchemeFacade_enablePerson");
        } else if (lstPerson.size() > 2000) {
            personTempTable = HRTableTools.createPersonTempTable(ctx, lstPerson);
        }
        StringBuffer sbSql = new StringBuffer("");
        sbSql.append(" SELECT * FROM ");
        sbSql.append(tableName);
        sbSql.append(" WHERE FPERSONID IN (");
        if (StringUtils.isEmpty((String)personTempTable)) {
            int size = lstPerson.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    sbSql.append(",");
                }
                sbSql.append("'");
                personID = lstPerson.get(i).toString();
                sbSql.append(personID);
                sbSql.append("'");
            }
        } else {
            sbSql.append("select fpersonID from ").append(personTempTable);
        }
        sbSql.append(" ) ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString());
        if (rs == null) {
            return hspAllData;
        }
        try {
            HashMap<String, Object> hspPersonData = null;
            BigDecimal bdTemp = null;
            while (rs.next()) {
                hspPersonData = new HashMap<String, Object>();
                personID = rs.getString("FPERSONID");
                int size = colItem.size();
                for (int i = 0; i < size; ++i) {
                    String cmpItemID = colItem.get(i).getCmpItem().getId().toString();
                    cmpItemNumber = colItem.get(i).getCmpItem().getNumber();
                    if (!cmpItemNumber.equalsIgnoreCase("FSAL000")) {
                        bdTemp = rs.getBigDecimal(cmpItemNumber);
                        if (bdTemp == null || bdTemp.equals(HRSchemeUtils.BD_ZERO)) continue;
                        hspPersonData.put(cmpItemID, bdTemp);
                        continue;
                    }
                    hspPersonData.put(cmpItemID, rs.getString(cmpItemNumber));
                }
                hspPersonData.put("effectDate", rs.getDate("FOTHERENABLEDATE"));
                hspAllData.put(personID, hspPersonData);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        if (!StringUtils.isEmpty((String)personTempTable)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(personTempTable);
        }
        return hspAllData;
    }

    @Override
    protected void _auditePerson(Context ctx, IObjectPK fixedCmpSchemePK, List IDs) throws BOSException, EASBizException {
        if (IDs == null || IDs.size() == 0) {
            return;
        }
        FixedCmpSchemeInfo fixedScheme = FixedCmpSchemeFactory.getLocalInstance(ctx).getFixedCmpSchemeInfo(fixedCmpSchemePK);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new FixedCmpSchemeInfo().getBOSType(), (IObjectPK)fixedCmpSchemePK, (String)fixedScheme.getName(), (String)"fixedCmpScheme_audit");
        String deleteSql = "delete from T_HR_FixedCmpSchemePerson where FFixedCmpSchemeID=? and fpersonid in ";
        String tempPersonTableName = null;
        if (IDs.size() > 5000) {
            tempPersonTableName = HRTableTools.createPersonTempTable(ctx, IDs);
            deleteSql = deleteSql + " (select FPersonID from " + tempPersonTableName + ")";
        } else {
            deleteSql = deleteSql + CompUtils.getStrFromList(IDs);
        }
        DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new Object[]{fixedCmpSchemePK.toString()});
        String sqlAddPersons = " INSERT INTO T_HR_FixedCmpSchemePerson(FID,FPersonID,FFixedCmpSchemeID,FEnable,FAudited) VALUES(?,?,?,?,?)";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sqlAddPersons);
            int size = IDs.size();
            for (int i = 0; i < size; ++i) {
                ps.setString(1, BOSUuid.create((String)"C36A4AEC").toString());
                ps.setString(2, IDs.get(i).toString());
                ps.setString(3, fixedCmpSchemePK.toString());
                ps.setInt(4, 0);
                ps.setInt(5, 1);
                ps.addBatch();
            }
            if (IDs.size() > 0) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                HRTableTools.releaseTmpTable(ctx, tempPersonTableName);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        HRTableTools.releaseTmpTable(ctx, tempPersonTableName);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _anAutidPerson(Context ctx, IObjectPK fixedCmpSchemePK, List lstIDs) throws BOSException, EASBizException {
        if (lstIDs == null || lstIDs.size() == 0) {
            return;
        }
        FixedCmpSchemeInfo fixedScheme = FixedCmpSchemeFactory.getLocalInstance(ctx).getFixedCmpSchemeInfo(fixedCmpSchemePK);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new FixedCmpSchemeInfo().getBOSType(), (IObjectPK)fixedCmpSchemePK, (String)fixedScheme.getName(), (String)"fixedCmpScheme_anaudit");
        String deleteSql = "delete from T_HR_FixedCmpSchemePerson  where FFixedCmpSchemeID = ? and FPersonID in";
        String tempPersonTableName = null;
        if (lstIDs.size() > 5000) {
            tempPersonTableName = HRTableTools.createPersonTempTable(ctx, lstIDs);
            deleteSql = deleteSql + " (select FPersonID from " + tempPersonTableName + ")";
        } else {
            deleteSql = deleteSql + CompUtils.getStrFromList(lstIDs);
        }
        DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new Object[]{fixedCmpSchemePK.toString()});
        HRTableTools.releaseTmpTable(ctx, tempPersonTableName);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected List _checkAdjDateValid(Context ctx, Map adjPerMap, List adjPerIdList) throws BOSException, EASBizException {
        if (adjPerIdList.size() <= 0) {
            return new ArrayList();
        }
        ArrayList<String> invalidList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select fadjempid,fadjcmpitemid,Max(feffectdate) as feffectdate from T_HR_ADJSCHITEM ");
        sql.append(" where fadjempid in ").append(CompUtils.getStrFromList(adjPerIdList));
        sql.append(" and fadjcmpitemid in ").append(CompUtils.getStrFromList((List)adjPerMap.get("addCmpItemList")));
        if (adjPerMap.get("adjustSchemeID") != null) {
            sql.append(" and FADJSCHEMEID <> '").append(adjPerMap.get("adjustSchemeID").toString()).append("' ");
        }
        sql.append(" group by fadjempid,fadjcmpitemid ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        java.sql.Date effectOldDate = null;
        String personID = "";
        Date adjDate = null;
        try {
            while (rowSet.next()) {
                effectOldDate = rowSet.getDate("feffectdate");
                if (adjPerMap.get(rowSet.getString("fadjempid")) == null || effectOldDate == null || !DateTimeUtils.dayBefore((Date)(adjDate = (Date)adjPerMap.get(rowSet.getString("fadjempid"))), (Date)effectOldDate) && !DateTimeUtils.dayEquals((Date)adjDate, (Date)effectOldDate) || rowSet.getString("fadjempid") == null || personID.equals(rowSet.getString("fadjempid"))) continue;
                if (!invalidList.contains(rowSet.getString("fadjempid"))) {
                    invalidList.add(rowSet.getString("fadjempid"));
                }
                personID = rowSet.getString("fadjempid");
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        ArrayList<String> invalidPerList = new ArrayList<String>();
        int size = adjPerIdList.size();
        for (int i = 0; i < size; ++i) {
            if (!invalidList.contains(adjPerIdList.get(i).toString())) continue;
            invalidPerList.add(adjPerIdList.get(i).toString());
        }
        return invalidPerList;
    }

    @Override
    protected Map _getFixedReportData(Context ctx, Map paramsMap) throws BOSException, EASBizException {
        String language = ctx.getLocale().getLanguage();
        EntityViewInfo infoEntityView = (EntityViewInfo)paramsMap.get("infoEntityView");
        if (infoEntityView.getSorter() == null || infoEntityView.getSorter().size() == 0) {
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo sorterOrderItem = new SorterItemInfo("indexOf");
            sorterOrderItem.setSortType(SortType.ASCEND);
            sorter.add(sorterOrderItem);
            infoEntityView.setSorter(sorter);
        }
        boolean countByOrg = (Boolean)paramsMap.get("countByOrg");
        String fixedCmpSchemeIds = (String)paramsMap.get("fixedCmpSchemeIds");
        List itemList = (List)paramsMap.get("lstCmpItem");
        List lstCmpItem = HRCmpItemUtils.deleteNoMappingPersonItem(ctx, itemList);
        HashMap<String, IRowSet> result = new HashMap<String, IRowSet>();
        Map horTblMap = HRSchemeUtils.getFixedCmpSchemeHorTableNames(ctx, fixedCmpSchemeIds);
        StringBuffer querySql = new StringBuffer();
        Iterator horTblNameKey = horTblMap.entrySet().iterator();
        int i = 0;
        SqlSelect sourceSelect = this.getFixedItemSQL(ctx, infoEntityView);
        Map.Entry entry = null;
        while (horTblNameKey.hasNext()) {
            entry = horTblNameKey.next();
            String fixedSchmId = (String)entry.getKey();
            String[] tblHrOrg = ((String)entry.getValue()).split("~");
            String horTableName = tblHrOrg[0];
            String hrOrgId = tblHrOrg[1];
            String sql = "";
            SqlSelect select = (SqlSelect)sourceSelect.clone();
            ArrayList orderedSelectors = this.buildSelectItemList(ctx, lstCmpItem, horTableName, select, infoEntityView, language);
            select.selectList = null;
            select.selectList = orderedSelectors;
            SqlTableSource tableSource = new SqlTableSource(horTableName);
            SqlBinaryOpExpr newExpr = null;
            try {
                newExpr = new SqlBinaryOpExpr(new SqlExprParser("\"PERSON\".FID").expr(), 10, new SqlExprParser(horTableName + ".FPersonID").expr());
            }
            catch (ParserException e1) {
                throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
            }
            select.tableSource = new SqlJoinedTableSource(select.tableSource, (SqlTableSourceBase)tableSource, 1, (SqlExpr)newExpr);
            String nameFixedCmpSchemePersonTable = "T_HR_FIXEDCMPSCHEMEPERSON";
            tableSource = new SqlTableSource(nameFixedCmpSchemePersonTable);
            try {
                newExpr = new SqlBinaryOpExpr(new SqlExprParser("\"PERSON\".FID").expr(), 10, new SqlExprParser(nameFixedCmpSchemePersonTable + ".FPersonID").expr());
            }
            catch (ParserException e1) {
                throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
            }
            select.tableSource = new SqlJoinedTableSource(select.tableSource, (SqlTableSourceBase)tableSource, 1, (SqlExpr)newExpr);
            StringBuffer sb = new StringBuffer();
            try {
                DrSQLFormater formater = new DrSQLFormater(sb);
                formater.formatSelect(select);
            }
            catch (FormaterException e2) {
                throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
            }
            sql = sb.toString() + " AND T_HR_FIXEDCMPSCHEMEPERSON.FFixedCmpSchemeID = '" + fixedSchmId + "' AND T_HR_FIXEDCMPSCHEMEPERSON.FEnable=1 ";
            sql = HRSchemeUtils.getReplaceQuerySQL(ctx, sql, hrOrgId, false);
            String oldJoinStr = "\"PERSON\".FID = \"POSITIONMEMBER\".FPersonID";
            String newJoinStr = "(\"PERSON\".FID = \"POSITIONMEMBER\".FPersonID and \"POSITIONMEMBER\".FPositionID = \"PERSONPOSIT\".FPrimaryPositionID)";
            sql = StringUtils.replace((String)sql, (String)oldJoinStr, (String)newJoinStr);
            List adminOrgList = (List)paramsMap.get("adminOrgList");
            boolean isShowSealUp = (Boolean)paramsMap.get("isShowSealUp");
            String adminTmpTblName = HRUtils.getAdminOrgTmpTbl(ctx, adminOrgList, isShowSealUp);
            StringBuffer adminIdSql = new StringBuffer();
            adminIdSql.append("select fAdOrgUnitId from ").append(adminTmpTblName);
            sql = sql.replaceAll("'#'", adminIdSql.toString());
            if (i == 0) {
                querySql.append(sql);
            } else {
                querySql.append(" union all ");
                querySql.append(sql);
            }
            ++i;
        }
        StringBuffer optSql = querySql;
        String finalSql = this.doWithSortByCase(optSql, infoEntityView, countByOrg);
        if ((finalSql = PersonInfoUtils.getOptimizeSql(finalSql)) != null && !"".equals(finalSql)) {
            IRowSet rs = HRUtils.executeQuery(ctx, finalSql);
            result.put("dataResult", rs);
        }
        return result;
    }

    private String doWithSortByCase(StringBuffer optSql, EntityViewInfo infoEntityView, boolean countByOrg) {
        String finalSql = "";
        String orderByString = "";
        if (infoEntityView != null) {
            SorterItemCollection sorts = infoEntityView.getSorter();
            orderByString = this.getSQLSort(sorts, countByOrg);
        }
        if (countByOrg) {
            if (!"".equals(optSql.toString())) {
                optSql.insert(0, " select * from ( ");
                optSql.append(" ) tbl order by HROrgUnitID ");
                optSql.append(orderByString);
                finalSql = optSql.toString();
            }
        } else if (!"".equals(optSql.toString())) {
            optSql.insert(0, " select * from ( ");
            optSql.append(" ) tbl order by ");
            optSql.append(" indexOf ASC ");
            finalSql = optSql.toString();
        }
        return finalSql;
    }

    private String getSQLSort(SorterItemCollection sorts, boolean countByOrg) {
        StringBuffer orderByString = new StringBuffer();
        if (countByOrg) {
            int n = sorts.size();
            for (int j = 0; j < n; ++j) {
                SorterItemInfo selectItem = sorts.get(j);
                orderByString.append(",").append(selectItem.toString());
            }
        } else {
            int n = sorts.size();
            for (int j = 0; j < n; ++j) {
                SorterItemInfo selectItem = sorts.get(j);
                if (selectItem.toString().indexOf("FPER002") >= 0) continue;
                orderByString.append(",").append(selectItem.toString());
            }
        }
        return orderByString.toString();
    }

    private ArrayList buildSelectItemList(Context ctx, List lstCmpItem, String horTableName, SqlSelect select, EntityViewInfo infoEntityView, String language) throws BOSException, EASBizException {
        List selectors = select.selectList;
        ArrayList<SqlSelectItem> orderedSelectors = new ArrayList<SqlSelectItem>();
        String itemNumber = "";
        SqlExprParser parser = null;
        SqlSelectItem item = null;
        ArrayList columnNameList = HRTableTools.getTableColumnNames(ctx, horTableName);
        int size = lstCmpItem.size();
        for (int i = 0; i < size; ++i) {
            itemNumber = ((CmpItemInfo)lstCmpItem.get(i)).getNumber();
            item = null;
            int jsize = selectors.size();
            for (int j = 0; j < jsize; ++j) {
                if (!((SqlSelectItem)selectors.get((int)j)).alias.replaceAll("\"", "").trim().equals(itemNumber.replaceAll("\"", "").trim())) continue;
                item = (SqlSelectItem)selectors.get(j);
                break;
            }
            if (item == null) {
                try {
                    item = new SqlSelectItem();
                    if (itemNumber.equalsIgnoreCase("FOTHERTOTAL")) {
                        String temp = this.getTotalExpr(lstCmpItem, horTableName);
                        parser = new SqlExprParser(temp);
                    } else {
                        parser = itemNumber.equalsIgnoreCase("FPersonID") ? new SqlExprParser("\"PERSON\".FID") : (columnNameList.contains(itemNumber) ? new SqlExprParser(horTableName + "." + itemNumber) : new SqlExprParser("NULL"));
                    }
                    item.expr = parser.expr();
                    item.alias = itemNumber;
                    orderedSelectors.add(item);
                    continue;
                }
                catch (ParserException e1) {
                    throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
                }
            }
            orderedSelectors.add(item);
        }
        SorterItemCollection itemCollection = infoEntityView.getSorter();
        int size2 = itemCollection.size();
        for (int i = 0; i < size2; ++i) {
            itemNumber = itemCollection.get(i).getPropertyName();
            item = null;
            int jsize = selectors.size();
            for (int j = 0; j < jsize; ++j) {
                if (!((SqlSelectItem)selectors.get((int)j)).alias.replaceAll("\"", "").trim().equalsIgnoreCase(itemNumber.replaceAll("\"", "").trim())) continue;
                item = (SqlSelectItem)selectors.get(j);
                break;
            }
            if (orderedSelectors.contains(item) || item == null) continue;
            orderedSelectors.add(item);
        }
        try {
            itemNumber = "INDEXOF";
            item = new SqlSelectItem();
            parser = new SqlExprParser("\"PERSON\".FIndex");
            item.expr = parser.expr();
            item.alias = itemNumber;
            boolean exist = false;
            int size3 = orderedSelectors.size();
            for (int ii = 0; ii < size3; ++ii) {
                if (!itemNumber.replaceAll("\"", "").trim().equals(((SqlSelectItem)orderedSelectors.get((int)ii)).alias.replaceAll("\"", "").trim())) continue;
                exist = true;
                break;
            }
            if (!exist) {
                orderedSelectors.add(item);
            }
            itemNumber = "FID";
            item = new SqlSelectItem();
            parser = new SqlExprParser("\"PERSON\".FID");
            item.expr = parser.expr();
            item.alias = itemNumber;
            orderedSelectors.add(item);
            itemNumber = "HROrgUnitID";
            item = new SqlSelectItem();
            parser = new SqlExprParser("\"ATTACHTOUNIT\".FID");
            item.expr = parser.expr();
            item.alias = itemNumber;
            orderedSelectors.add(item);
            itemNumber = "HROrgUnitName";
            item = new SqlSelectItem();
            parser = new SqlExprParser("\"ATTACHTOUNIT\".FName_" + language);
            item.expr = parser.expr();
            item.alias = itemNumber;
            orderedSelectors.add(item);
        }
        catch (ParserException e1) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        int jsize = selectors.size();
        for (int j = 0; j < jsize; ++j) {
            if (!((SqlSelectItem)selectors.get((int)j)).alias.replaceAll("\"", "").trim().equalsIgnoreCase("FPER003")) continue;
            if (orderedSelectors.contains((SqlSelectItem)selectors.get(j))) break;
            orderedSelectors.add((SqlSelectItem)selectors.get(j));
            break;
        }
        return orderedSelectors;
    }

    @Override
    protected Object _getFunValueHrFixedCmp(Context ctx, Map params) throws BOSException, EASBizException {
        String hrOrgUnitNumber = params.get("hrOrgUnit").toString();
        String cmpItemNumber = params.get("hrCmpItemNumber").toString();
        String empFilterString = params.get("hrEmpFilter").toString();
        if (StringUtils.isEmpty((String)hrOrgUnitNumber)) {
            hrOrgUnitNumber = HRSchemeUtils.getServerHROrgUnitInfo(ctx).getNumber();
        }
        String oql = " select id,horTableName,hrOrgUnit.id where enable=1 and hrOrgUnit.number='" + hrOrgUnitNumber + "'";
        IFixedCmpScheme iFixedCmpScheme = FixedCmpSchemeFactory.getLocalInstance(ctx);
        FixedCmpSchemeInfo schemeInfo = iFixedCmpScheme.getFixedCmpSchemeInfo(oql);
        String tableName = schemeInfo.getHorTableName();
        StringBuffer sql = new StringBuffer();
        sql.append(" select sum(isnull(tableName.").append(cmpItemNumber).append(",0)) as cmpItemNumber");
        sql.append(" from ").append(tableName).append(" as tableName ").append(" inner join t_hr_fixedcmpschemeperson p on p.fpersonid = tableName.fpersonid ");
        if (!StringUtils.isEmpty((String)empFilterString)) {
            empFilterString = " select FPERSONID where " + empFilterString;
            sql.append(" inner join (").append(this.getSql(ctx, empFilterString)).append(") Temp ").append(" on Temp.fpersonid = tableName.fpersonid ");
        }
        sql.append(" inner join t_hr_personposition pp on pp.fpersonid = p.fpersonid ").append(" inner join t_org_admin t1 on t1.fid = pp.FPersonDep ").append(" inner join t_org_unitrelation t2 on t1.fid = t2.Ffromunitid").append(" where t2.Ftyperelationid = '00000000-0000-0000-0000-0000000000100FE9F8B5'").append(" and t2.Ftounitid='").append(schemeInfo.getHrOrgUnit().getId()).append("'");
        sql.append(" and p.fenable=1 and p.ffixedCmpSchemeid = '").append(schemeInfo.getId()).append("'");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        Object obj = null;
        try {
            while (result.next()) {
                obj = result.getObject("cmpItemNumber");
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage());
        }
        if (obj == null) {
            return " ";
        }
        return obj;
    }

    private String getSql(Context ctx, String empFilterString) throws EASBizException, BOSException {
        IQueryExecutor exec = null;
        MetaDataPK metaDataPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.HRPersonInfoQuery");
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metaDataPK);
        EntityViewInfo evi = null;
        try {
            evi = new EntityViewInfo(empFilterString);
            exec.setObjectView(evi);
        }
        catch (ParserException e) {
            this.logger.error((Object)e.getMessage());
        }
        String sql = exec.getSQL();
        if (sql.indexOf("ORDER") > 0) {
            sql = sql.substring(0, sql.indexOf("ORDER"));
        }
        return PersonInfoUtils.getOptimizeSql(sql);
    }

    @Override
    protected IObjectPK _initFixedCmpScheme(Context ctx, FixedCmpSchemeInfo fixedSchemeInfo) throws BOSException, EASBizException {
        IObjectPK fixedCmpSchemePK = null;
        IFixedCmpScheme iFixedCmpScheme = FixedCmpSchemeFactory.getLocalInstance(ctx);
        String horTableName = null;
        horTableName = this.getNewHorTableName(ctx);
        fixedSchemeInfo.setHorTableName(horTableName);
        fixedSchemeInfo.setHrOrgUnit(HRSchemeUtils.getServerHROrgUnitInfo(ctx));
        fixedCmpSchemePK = iFixedCmpScheme.addnew((CoreBaseInfo)fixedSchemeInfo);
        fixedCmpSchemePK = new ObjectUuidPK(fixedSchemeInfo.getId());
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)fixedSchemeInfo.getBOSType(), (IObjectPK)fixedCmpSchemePK, (String)fixedSchemeInfo.getName(), (String)"fixedCmpScheme_add");
        ICmpItem iCmpItem = CmpItemFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)10));
        filterInfo.getFilterItems().add(new FilterItemInfo("dataType", (Object)60));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItemCatalog.number", (Object)"FPER", CompareType.NOTEQUALS));
        filterInfo.setMaskString("#0  and #1 and #2 and #3");
        evi.setFilter(filterInfo);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("defaultOrder");
        sorterOrderItem.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterOrderItem);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("cmpItemCatalog.*"));
        CmpItemCollection cmpItemCollection = iCmpItem.getCmpItemCollection(evi);
        if (fixedSchemeInfo.getSalariatScheme() != null && fixedSchemeInfo.getSalariatScheme().getId() != null) {
            cmpItemCollection.addObject(0, (IObjectValue)this.getSalPointCmpItem(ctx));
        }
        IFixedCmpSchemeItem iFixedCmpSchemeItem = FixedCmpSchemeItemFactory.getLocalInstance(ctx);
        FixedCmpSchemeItemInfo infoItem = null;
        CmpItemInfo infoCmpItem = null;
        CoreBaseCollection coll = new CoreBaseCollection();
        int size = cmpItemCollection.size();
        for (int i = 0; i < size; ++i) {
            infoCmpItem = (CmpItemInfo)cmpItemCollection.getObject(i);
            if (HRCmpItemUtils.isExcludeFixedCmpItem(infoCmpItem.getNumber())) continue;
            infoItem = new FixedCmpSchemeItemInfo();
            infoItem.setCmpItem(infoCmpItem);
            infoItem.setFixedCmpScheme(fixedSchemeInfo);
            infoItem.setSortOrder(i);
            if (infoCmpItem.getNumber().equalsIgnoreCase("FSAL000")) {
                infoItem.setVisible(1);
            }
            coll.add((CoreBaseInfo)infoItem);
        }
        if (coll.size() > 0) {
            iFixedCmpSchemeItem.addnew(coll);
        }
        CmpItemInfo temp = new CmpItemInfo();
        temp.setName("FOTHERENABLEDATE");
        temp.setNumber("FOTHERENABLEDATE");
        temp.setDataType(ItemDataTypeEnum.DATE);
        temp.setDecDigital(2);
        temp.setLength(8);
        cmpItemCollection.addObject((IObjectValue)temp);
        AdapterDynamicDBTable iDynamicDBTable = new AdapterDynamicDBTable(ctx, horTableName, this.getHorTableInfosItem(cmpItemCollection));
        try {
            iDynamicDBTable.create();
            String id = HRCmpIndexUtils.getDateString();
            String idxNameSuffix = id.substring(id.length() - 8, id.length() - 1);
            String indexSql = " CREATE INDEX idx_HRFCS" + idxNameSuffix + " ON " + horTableName + "(" + "FPersonID" + ") ";
            DbUtil.execute((Context)ctx, (String)indexSql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return fixedCmpSchemePK;
    }

    @Override
    protected Map _getCmpPersonCatalogEnum(Context ctx, String fixedCmpSchemeID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct p.fpersonid,p.fenable,p.faudited ").append(" from t_hr_fixedCmpScheme f").append(" inner join t_hr_fixedCmpSchemePerson p on p.ffixedCmpSchemeid = f.fid ").append(" where f.fid = ? ");
        HashMap<String, FixedCmpSchemeCatalogEnum> map = new HashMap<String, FixedCmpSchemeCatalogEnum>();
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{fixedCmpSchemeID});
        try {
            boolean audite = false;
            boolean enable = false;
            String personID = null;
            while (iRowSet.next()) {
                personID = iRowSet.getString("fpersonid");
                audite = iRowSet.getBoolean("faudited");
                enable = iRowSet.getBoolean("fenable");
                if (enable) {
                    map.put(personID, FixedCmpSchemeCatalogEnum.ENABLE);
                    continue;
                }
                if (!audite) continue;
                map.put(personID, FixedCmpSchemeCatalogEnum.UNENABLE);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage());
        }
        return map;
    }

    @Override
    protected boolean _checkReasonRef(Context ctx, String cmpAdjustiveID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FHorTableName from T_HR_FixedCmpScheme ");
        sql.append(" where FHRORGUNITID = '").append(HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString()).append("'");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String tableName = null;
        StringBuffer buffer = null;
        IRowSet rowSet = null;
        HashMap<String, String> columnMap = null;
        try {
            while (iRowSet.next()) {
                tableName = iRowSet.getString("FHorTableName");
                if (tableName == null) continue;
                buffer = new StringBuffer();
                buffer.append("select * from ");
                buffer.append(tableName);
                buffer.append(" where 1 = 2");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
                ResultSetMetaData metaData = rowSet.getMetaData();
                columnMap = new HashMap<String, String>();
                int size = metaData.getColumnCount();
                for (int i = 1; i <= size; ++i) {
                    columnMap.put(metaData.getColumnName(i).toUpperCase(), "true");
                }
                if (!columnMap.containsKey("FADJUSTCAUSE")) continue;
                buffer = new StringBuffer();
                buffer.append("select FADJUSTCAUSE from ");
                buffer.append(tableName);
                buffer.append(" WHERE FADJUSTCAUSE = '");
                buffer.append(cmpAdjustiveID);
                buffer.append("'");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
                if (rowSet.size() <= 0) continue;
                return false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    @Override
    protected Map _synchFixCmpData(Context ctx, IObjectPK fixedCmpSchemePK, List lstIDs) throws BOSException, EASBizException {
        HashMap synData = new HashMap();
        StringBuffer sql = new StringBuffer();
        sql.append("select T.fadjempid fadjempid,T2.fnumber fnumber,T.FNewValue FNewValue ").append(" from t_hr_adjschitem T ").append(" left outer JOIN t_hr_adjscheme T1 ON T1.fid = T.fadjschemeid ").append(" inner join t_hr_cmpitem T2 on T2.fid = T.fadjcmpitemid ").append(" inner join (select tt.fadjempid fpersonID,tt2.fnumber fcmpItemNumber,max(tt.feffectdate) feffectdate ").append(" from t_hr_adjschitem tt ").append(" left outer join t_hr_adjscheme tt1 on tt1.fid = tt.fadjschemeid ").append(" left outer join t_hr_cmpitem tt2 on tt2.fid = tt.fadjcmpitemid ").append(" where tt1.fadjschemestate = 30 ").append(" group by tt.fadjempid,tt2.fnumber ) T3 on T3.fpersonID = T.fadjempid and T3.feffectdate = T.feffectdate and T3.fcmpItemNumber = T2.fnumber").append(" WHERE T1.fadjschemestate = 30 ").append(" and (T1.FIsHistoryData = 0 or T1.FIsHistoryData is null) ").append(" and T.fadjempid in (");
        String personTempTable = null;
        String personID = null;
        if (lstIDs.size() > 2000) {
            personTempTable = HRTableTools.createPersonTempTable(ctx, lstIDs);
        }
        if (StringUtils.isEmpty(personTempTable)) {
            int size = lstIDs.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    sql.append(",");
                }
                sql.append("'");
                personID = lstIDs.get(i).toString();
                sql.append(personID);
                sql.append("'");
            }
        } else {
            sql.append("select fpersonID from ").append(personTempTable);
        }
        sql.append(" ) ");
        sql.append(" order by T.fadjempid, T.feffectdate desc ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs == null) {
            if (!StringUtils.isEmpty((String)personTempTable)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(personTempTable);
            }
            return synData;
        }
        try {
            HashMap<String, BigDecimal> hspPersonData = null;
            Object bdTemp = null;
            personID = null;
            while (rs.next()) {
                if (personID == null) {
                    hspPersonData = new HashMap<String, BigDecimal>();
                    personID = rs.getString("FADJEMPID");
                    hspPersonData.put(rs.getString("FNUMBER"), rs.getBigDecimal("FNEWVALUE"));
                    continue;
                }
                if (personID.equals(rs.getString("FADJEMPID"))) {
                    hspPersonData.put(rs.getString("FNUMBER"), rs.getBigDecimal("FNEWVALUE"));
                    continue;
                }
                if (!personID.equals(rs.getString("FADJEMPID"))) {
                    synData.put(personID, hspPersonData);
                    hspPersonData = new HashMap();
                    personID = rs.getString("FADJEMPID");
                    hspPersonData.put(rs.getString("FNUMBER"), rs.getBigDecimal("FNEWVALUE"));
                    continue;
                }
                synData.put(personID, hspPersonData);
            }
            if (personID != null) {
                synData.put(personID, hspPersonData);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!StringUtils.isEmpty((String)personTempTable)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(personTempTable);
        }
        return synData;
    }

    @Override
    protected HashMap _checkAdjDateByAdjSch(Context ctx, String adjSchemeID) throws BOSException, EASBizException {
        String RESC = "com.kingdee.eas.hr.compensation.client.AdjSchListUIResource.";
        if (adjSchemeID == null || adjSchemeID.equals("")) {
            return null;
        }
        CmpAdjSchItemCollection casiCollection = CmpAdjSchItemFactory.getLocalInstance(ctx).getCmpAdjSchItemCollection("select id,adjEmp.id,adjCmpItem.name,adjEmp.name,adjEmp.number,effectDate where adjScheme='" + adjSchemeID + "'");
        if (casiCollection == null || casiCollection.size() < 1) {
            return null;
        }
        HashMap<String, Date> adjPerMap = new HashMap<String, Date>();
        HashMap<String, Date> adjPerItemMap = new HashMap<String, Date>();
        HashMap<String, String> adjPerIndexMap = new HashMap<String, String>();
        ArrayList<String> adjPerIdList = new ArrayList<String>();
        ArrayList<String> adjItemList = new ArrayList<String>();
        ArrayList<String> invalidList = new ArrayList<String>();
        CmpAdjSchItemInfo casiInfo = null;
        String perId = null;
        String perNum = null;
        String perName = null;
        Date effectDate = null;
        for (int i = 0; i < casiCollection.size(); ++i) {
            casiInfo = casiCollection.get(i);
            effectDate = casiInfo.getEffectDate();
            if (effectDate == null) {
                throw new AdjSchemeException(AdjSchemeException.EFFECTDATE_NOT_NULL);
            }
            perId = casiInfo.getAdjEmp().getId().toString();
            perNum = casiInfo.getAdjEmp().getNumber();
            perName = casiInfo.getAdjEmp().getName();
            adjPerMap.put(perId, effectDate);
            adjPerItemMap.put(perId + "&" + casiInfo.getAdjCmpItem().getId(), effectDate);
            adjPerIndexMap.put(perId, i + 1 + "&&" + perNum + "&&" + perName);
            adjPerIdList.add(perId);
            adjItemList.add(casiInfo.getAdjCmpItem().getId().toString());
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select fadjempid,fadjcmpitemid,Max(feffectdate) as feffectdate from T_HR_ADJSCHITEM ");
        sql.append(" where fadjempid in ").append(CompUtils.getStrFromList(adjPerIdList));
        sql.append(" and fadjcmpitemid in ").append(CompUtils.getStrFromList(adjItemList));
        sql.append(" and FADJSCHEMEID <> '").append(adjSchemeID).append("' ");
        sql.append(" group by fadjempid,fadjcmpitemid ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        java.sql.Date effectOldDate = null;
        String personID = "";
        try {
            while (rowSet.next()) {
                effectDate = (Date)adjPerItemMap.get(rowSet.getString("fadjempid") + "&" + rowSet.getString("fadjcmpitemid"));
                effectOldDate = rowSet.getDate("feffectdate");
                if (effectOldDate == null || !DateTimeUtils.dayBefore((Date)effectDate, (Date)effectOldDate) && !DateTimeUtils.dayEquals((Date)effectDate, (Date)effectOldDate) || rowSet.getString("fadjempid") == null || personID.equals(rowSet.getString("fadjempid"))) continue;
                invalidList.add(rowSet.getString("fadjempid"));
                personID = rowSet.getString("fadjempid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (invalidList != null && invalidList.size() > 0) {
            HashMap<String, Cloneable> errorMap = new HashMap<String, Cloneable>();
            errorMap.put("invalidList", invalidList);
            errorMap.put("adjPerIndexMap", adjPerIndexMap);
            return errorMap;
        }
        return null;
    }
}

